<?php

// Script para verificar compatibilidade com PHP 8.1
echo "Verificando compatibilidade com PHP 8.1...\n\n";

// Verificar se todas as extensões necessárias estão ativas
$extensoes_necessarias = ['mysqli', 'mbstring', 'gd', 'openssl', 'curl'];
$extensoes_faltando = [];

foreach ($extensoes_necessarias as $ext) {
    if (!extension_loaded($ext)) {
        $extensoes_faltando[] = $ext;
    }
}

if (!empty($extensoes_faltando)) {
    echo "ERRO: Extensões faltando: " . implode(', ', $extensoes_faltando) . "\n";
} else {
    echo "✓ Todas as extensões necessárias estão ativas\n";
}

// Verificar configurações do PHP
echo "\nConfigurações importantes do PHP:\n";
echo "- short_open_tag: " . (ini_get('short_open_tag') ? 'Ativado (Recomendado: Desativado para PHP 8.1)' : 'Desativado ✓') . "\n";
echo "- display_errors: " . (ini_get('display_errors') ? 'Ativado' : 'Desativado') . "\n";
echo "- error_reporting: " . ini_get('error_reporting') . "\n";
echo "- memory_limit: " . ini_get('memory_limit') . "\n";
echo "- max_execution_time: " . ini_get('max_execution_time') . "\n";

// Verificar se existe algum código que pode dar problema
function verificar_arquivo_problemas($arquivo) {
    $conteudo = file_get_contents($arquivo);
    $problemas = [];
    
    // Verificar uso de mysql_ (deprecated)
    if (preg_match('/mysql_[a-z_]+\(/i', $conteudo)) {
        $problemas[] = "Uso de funções mysql_ depreciadas";
    }
    
    // Verificar uso de each() (removed in PHP 8.0) - mais específico
    if (preg_match('/\beach\s*\(\s*\$/', $conteudo)) {
        $problemas[] = "Uso da função each() removida no PHP 8.0";
    }
    
    // Verificar uso de create_function (deprecated)
    if (preg_match('/create_function\s*\(/i', $conteudo)) {
        $problemas[] = "Uso de create_function() depreciada";
    }
    
    // Verificar uso de __autoload (removed in PHP 8.0)
    if (preg_match('/function\s+__autoload\s*\(/i', $conteudo)) {
        $problemas[] = "Uso da função __autoload() removida no PHP 8.0";
    }
    
    return $problemas;
}

// Verificar alguns arquivos principais
$arquivos_para_verificar = [
    'e:/wamp64/www/kubonet/dbconfig.php',
    'e:/wamp64/www/kubonet/index.php',
    'e:/wamp64/www/kubonet/contato.php',
    'e:/wamp64/www/kubonet/admin/index.php'
];

echo "\nVerificando arquivos por problemas de compatibilidade:\n";
foreach ($arquivos_para_verificar as $arquivo) {
    if (file_exists($arquivo)) {
        $problemas = verificar_arquivo_problemas($arquivo);
        if (empty($problemas)) {
            echo "✓ " . basename($arquivo) . " - OK\n";
        } else {
            echo "⚠ " . basename($arquivo) . " - Problemas: " . implode(', ', $problemas) . "\n";
        }
    } else {
        echo "- " . basename($arquivo) . " - Arquivo não encontrado\n";
    }
}

// Teste de conexão básica com o banco
echo "\nTestando conexão com banco de dados...\n";
try {
    include 'db.php';
    $conn = mysqli_connect($host, $user, $pass, $base);
    
    if ($conn->connect_error) {
        echo "✗ Erro na conexão: " . $conn->connect_error . "\n";
    } else {
        echo "✓ Conexão com banco de dados: OK\n";
        mysqli_close($conn);
    }
} catch (Exception $e) {
    echo "✗ Erro ao conectar: " . $e->getMessage() . "\n";
}

echo "\nVerificação concluída!\n";
?>