<!DOCTYPE html>
<html lang="pt-br">

<head>
    <title>${config_site_title}<?php if (isset($data['config']->config_site_slogan) && !empty($data['config']->config_site_slogan)) : ?> - ${config_site_slogan}<?php endif; ?>
    </title>
    @(tema.loja.partials.meta_tags)
    @(tema.loja.partials.og_tags)
    <link rel="icon" type="image/png" sizes="32x32" href="${baseUri}/media/site/${config_site_favicon}">
    @(tema.loja.partials.css-padrao)
    <meta name="keywords" content="${produto_keywords}">
</head>

<body>
    @(tema.loja.partials.google_analytics)
    @(tema.loja.partials.google_tag_manager)
    <input type="hidden" id="produto_id" value="${produto_id}">
    @(tema.loja.partials.menu-superior)
    <div id="vm">
        <div class="${config_site_layout_custom} pb-5" v-if="produto != null">
            <div class="row pt-5">
                <div class="col-lg-7 mt-5">
                    <div class="d-lg-none pb-2">
                        <h1 class="page-title pt-1 produtoNome custom_loja_texto" style="font-size: 28px;">{{ produto.produto_titulo }}</h1>
                        <!--BOTÃO DE FAVORITAR NO MOBILE-->
                        <?php if (Browser::agent('mobile')) : ?>
                            <!--NÃO LOGADO-->
                            <a v-if="produto_favoritado == -1" :href="'${baseUri}/login-cliente/produto/'+produto.produto_id" id="favoritar_produto" class="btn btn-primary hide-on-vitrine hide-on-orcamento"><i class="fa fa-heart-o"></i></a>
                            <!--NÃO FAVORITADO-->
                            <button v-if="produto_favoritado == 0" v-on:click="gravar_favorito()" id="favoritar_produto" class="btn btn-primary hide-on-vitrine hide-on-orcamento"><i class="fa fa-heart-o"></i></button>
                            <!--FAVORITADO-->
                            <button v-if="produto_favoritado == 1" v-on:click="remover_favorito()" id="favoritar_produto" class="btn btn-primary hide-on-vitrine hide-on-orcamento"><i class="fa fa-heart"></i></button>
                        <?php endif; ?>
                        <!--BOTÃO DE FAVORITAR NO MOBILE-->
                        <div class="hide-on-vitrine" v-if="produto.produto_estoque > 0">
                            <div v-if="produto.produto_desconto > 0">
                                <h4 class="h5 text-danger font-weight-light pt-3 produtoPreco hide-on-vitrine hide-on-orcamento custom_loja_texto" style="text-decoration: line-through; color: red !important;">
                                    {{ Number(produto.produto_preco_original).toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' }) }}
                                </h4>
                                <h2 class="h1 text-primary font-weight-light pb-2 produtoPreco hide-on-vitrine hide-on-orcamento custom_loja_texto">
                                    <span style="font-size: 30px;">
                                        {{ Number(produto.produto_preco).toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' }) }}
                                    </span>
                                    <br>
                                    <span style="font-size: 20px !important;" v-if="produto.desc_boleto > 0">
                                        à vista <span class="text-success">R$ {{ produto.produto_preco_desc_boleto }}</span>
                                        <br><small>({{ produto.desc_boleto }}% de desconto)</small>
                                        <br>
                                    </span>
                                    <span style="font-size: 20px !important;" v-if="produto.qtd_parcelas > 0">
                                        <span class="text-success">{{ produto.qtd_parcelas }}X</span> de <span class="text-success">R$ {{ produto.produto_preco_parc }}</span> ${config_card_text_parc}
                                    </span>
                                </h2>
                            </div>
                            <div v-else>
                                <h2 class="h1 text-primary font-weight-light pt-3 pb-2 produtoPreco hide-on-vitrine hide-on-orcamento custom_loja_texto">{{ Number(produto.produto_preco).toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' }) }}</h2>
                            </div>
                        </div>
                    </div>
                    <!-- Product gallery-->
                    <div class="product-gallery">
                        <ul class="product-thumbnails">
                            <li v-if="produto != null" v-for="foto in produto.produto_imagens">
                                <a :href="'${baseUri}/produto/'+ produto.produto_url +'#foto-' + foto.foto_produto_id">
                                    <img :src="'${baseUri}/thumb/resize/?w=50&h=100&f=' + foto.foto_produto_img" alt="foto produto" sstyle="height: 50px; object-fit: cover">
                                </a>
                            </li>
                        </ul>
                        <div class="product-carousel owl-carousel" id="carousel-produto" v-if="produto != null">
                            <a v-for="foto in produto.produto_imagens" :href="'${baseUri}/media/produto/' + foto.foto_produto_img" data-fancybox="prod-gallery" :data-hash="'foto-' + foto.foto_produto_id">
                                <img :src="'${baseUri}/thumb/resize/?w=1000&h=1200&f=' + foto.foto_produto_img" alt="foto produto" classd="img-responsive img-fluid" <?php if (Browser::agent('mobile')) : ?> style="max-height: 360px;" <?php endif; ?>>
                            </a>
                        </div>
                        <?php if (Browser::agent('mobile')) : ?>
                            <ul class="product-thumbnails2">
                                <li v-if="produto != null" v-for="foto in produto.produto_imagens">
                                    <a :href="'${baseUri}/produto/'+ produto.produto_url +'#foto-' + foto.foto_produto_id">
                                        <img :src="'${baseUri}/thumb/resize/?w=50&h=100&f=' + foto.foto_produto_img" alt="foto produto" style="height: 50px; object-fit: cover">
                                    </a>
                                </li>
                            </ul>
                        <?php endif; ?>
                    </div>

                </div>
                <!-- Product details column   -->
                <div class="col-lg-5 pt-4 pt-lg-0">
                    <!-- Product title and price (visible lg and up) ############ DESKTOP ##############3 -->
                    <div class="d-none d-lg-block">
                        <h1 class="page-title pt-3 produtoNome custom_loja_texto" style="font-size: 30px !important;">{{produto.produto_titulo}}</h1>
                        <!--BOTÃO DE FAVORITAR-->

                        <!--NÃO LOGADO-->
                        <a v-if="produto_favoritado == -1" :href="'${baseUri}/login-cliente/produto/'+produto.produto_id" id="favoritar_produto" class="btn btn-primary hide-on-vitrine hide-on-orcamento"><i class="fa fa-heart-o"></i></a>

                        <!--NÃO FAVORITADO-->
                        <button v-if="produto_favoritado == 0" v-on:click="gravar_favorito()" id="favoritar_produto" class="btn btn-primary hide-on-vitrine hide-on-orcamento"><i class="fa fa-heart-o"></i></button>

                        <!--FAVORITADO-->
                        <button v-if="produto_favoritado == 1" v-on:click="remover_favorito()" id="favoritar_produto" class="btn btn-primary hide-on-vitrine hide-on-orcamento"><i class="fa fa-heart"></i></button>

                        <!--FIM BOTÃO DE FAVORITAR-->
                        <div v-if="produto.produto_estoque > 0 || atributos_view">
                            <div>
                                <h4 v-if="produto.produto_desconto > 0" class="h5 text-danger font-weight-light pt-3 produtoPreco hide-on-vitrine hide-on-orcamento custom_loja_texto" style="text-decoration: line-through; color: red !important;">{{ Number(produto.produto_preco_original).toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' }) }}</h4>
                                <h2 class=" text-primary font-weight-light pb-2 produtoPreco hide-on-vitrine hide-on-orcamento custom_loja_texto" style="font-size: 25px;">
                                    {{ Number(produto.produto_preco).toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' }) }}
                                    <br>
                                    <span style="font-size: 20px !important;" v-if="produto.desc_boleto > 0">
                                        à vista <span class="text-success">R$ {{ produto.produto_preco_desc_boleto }}</span>
                                        <br><small>({{ produto.desc_boleto }}% de desconto)</small>
                                        <br>
                                    </span>
                                    <span style="font-size: 20px !important;" v-if="produto.qtd_parcelas > 0">
                                        <span class="text-success">{{ produto.qtd_parcelas }}X</span> de <span class="text-success">R$ {{ produto.produto_preco_parc }}</span> ${config_card_text_parc}
                                    </span>
                                </h2>
                            </div>

                        </div>
                        <div v-else>
                            <h2 class="h1 text-danger font-weight-light pt-3 pb-2 hide-on-vitrine custom_loja_texto">Indisponível</h2>
                        </div>

                    </div>

                    <div class="pb-4 hide-on-vitrine" id="formCarrinho" v-if="produto.qtd_atributos_atrelados > 0">
                        <div v-if="atributos_sem_estoque">
                            <h4>Indisponível</h4>
                        </div>
                        <div v-else>
                            <div id="n-attributos"></div>
                            <div id="atributos">
                                <!-- ATRIBUTOS -->
                                <div class="row">
                                    <div class="col-sm-12">
                                        <hr>
                                        <h4>Selecione os atributos </h4>
                                    </div>
                                </div>
                                <!-- Loop dos atributos -->
                                <div class="row" v-if="atributos_view != null" v-for="(atributo, indexAtributos) in atributos_view">
                                    <div class="col-sm-12">
                                        <h5> {{ atributo.atributo_nome }} </h5>
                                    </div>
                                    <div class="col-sm-12">
                                        <span v-if="atributo.itens != null && atributo.itens.length > 0" v-for="(item, indexItens) in atributo.itens" :data-id="item.item_atributo_id" data-att="atributo.atributo_id">
                                            <a v-if="atributo_atual_indice >= indexAtributos && atributos_selecionados.indexOf(item.item_atributo_id) != -1" class="btn btn-primary btn-sm text-white mr-2 mb-4" style="cursor: pointer;">
                                                {{item.item_atributo_nome}}
                                            </a>
                                            <a v-if="atributo_atual_indice >= indexAtributos && atributos_selecionados.indexOf(item.item_atributo_id) == -1 && atributos_com_estoque[indexAtributos] != undefined && atributos_com_estoque[indexAtributos].indexOf(item.item_atributo_id) != -1" class="btn btn-secondary btn-sm text-white mr-2  mb-4" style="cursor: pointer;" v-on:click="SelecionaAtributo(item.item_atributo_id, indexAtributos)">
                                                {{item.item_atributo_nome}}
                                            </a>
                                            <a v-if="atributo_atual_indice >= indexAtributos && atributos_selecionados.indexOf(item.item_atributo_id) == -1 && atributos_com_estoque[indexAtributos] != undefined && atributos_com_estoque[indexAtributos].indexOf(item.item_atributo_id) == -1" class="btn btn-sm text-muted mr-2  mb-4" style="display:none; cursor: not-allowed;">
                                                {{item.item_atributo_nome}}
                                            </a>

                                            <a v-if="atributo_atual_indice < indexAtributos" class="btn btn-secondary btn-sm text-white mr-2  mb-4" style="display:none; cursor: not-allowed;">
                                                {{item.item_atributo_nome}}
                                            </a>
                                        </span>
                                        <br><br>
                                    </div>
                                </div>
                                <!-- Loop dos atributos -->
                            </div>
                            <br>
                            <div class="row align-items-center pt-1 hide-on-vitrine" v-if="atributos_validate">
                                <div class="col-sm-12" v-if="valor_adicional_atributo != null && valor_adicional_atributo > 0">
                                    <span><i class="fa fa-info-circle"></i> Este atributo possui um adicional de {{ valor_adicional_atributo.toLocaleString("pt-BR", { style: "currency", currency: "BRL" }) }} </span>
                                    <br><br>
                                </div>
                                <div class="col-sm-12" v-if="max_qtd_atributo != null && max_qtd_atributo < produto.produto_min_estoque">
                                    <span class="text-warning"><i class="fa fa-info-circle"></i> Restam apenas {{ max_qtd_atributo }} unidade(s) deste produto! </span>
                                    <br><br>
                                </div>

                                <div class="col-3 col-sm-3 col-xs-3 col-md-3 col-lg-3">
                                    <button class="btn btn-secondary btn-block" onclick="Number($('#qtd_produto').val()) > 1 ? $('#qtd_produto').val(Number($('#qtd_produto').val()) - 1) : false">-</button>
                                </div>
                                <div class="col-6 col-sm-6 col-xs-6 col-md-6 col-lg-6">
                                    <input class="px-2 form-control w-100" type="number" id="qtd_produto" value="1" min="1" :max="max_qtd_atributo">
                                </div>
                                <div class="col-3 col-sm-3 col-xs-3 col-md-3 col-lg-3">
                                    <button class="btn btn-secondary btn-block" onclick="Number($('#qtd_produto').val()) < Number($('#qtd_produto').attr('max')) ? $('#qtd_produto').val(Number($('#qtd_produto').val()) + 1) : false"><b>+</b></button>
                                </div>
                                <div class="col-12 col-sm-12 col-xs-12 col-md-12 col-lg-12 mt-2">
                                    <button class="btn btn-primary w-100 font_smooth" v-on:click="setProdutoInCarrinho()"><i class="mr-2" data-feather="shopping-cart"></i>Adicionar a sacola</button>
                                </div>

                            </div>
                            <div class="row align-items-center pt-1 hide-on-vitrine" v-if="!atributos_validate">
                                <div class="col-sm-12 text-center">
                                    <span><i class="fa fa-exclamation-circle" aria-hidden="true"></i> Selecione todos os atributos para continuar com a compra</span>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="pb-4 hide-on-vitrine" id="formCarrinho" v-if="produto.qtd_atributos_atrelados == 0 && produto.produto_estoque > 0">
                        <div class="row">
                            <div class="col-3 col-sm-3 col-xs-3 col-md-3 col-lg-3">
                                <button class="btn btn-secondary btn-block" onclick="Number($('#qtd_produto').val()) > 1 ? $('#qtd_produto').val(Number($('#qtd_produto').val()) - 1) : false">-</button>
                            </div>
                            <div class="col-6 col-sm-6 col-xs-6 col-md-6 col-lg-6">
                                <input class="px-2 form-control w-100" type="number" id="qtd_produto" value="1" min="1" :max="produto.produto_estoque">
                            </div>
                            <div class="col-3 col-sm-3 col-xs-3 col-md-3 col-lg-3">
                                <button class="btn btn-secondary btn-block" onclick="Number($('#qtd_produto').val()) < Number($('#qtd_produto').attr('max')) ? $('#qtd_produto').val(Number($('#qtd_produto').val()) + 1) : false"><b>+</b></button>
                            </div>
                            <div class="col-12 col-sm-12 col-xs-12 col-md-12 col-lg-12 mt-2">
                                <button class="btn btn-primary w-100 font_smooth" v-on:click="setProdutoInCarrinho()"><i class="mr-2" data-feather="shopping-bag"></i>Adicionar a sacola</button>
                            </div>
                        </div>
                    </div>
                    <!-- Product panels-->
                    <div class="accordion" id="productPanels">
                        <div class="card custom_loja_fundo" v-if="produto.produto_desc != null">
                            <div class="card-header">
                                <h3 class="accordion-heading font_smooth">
                                    <a class="custom_loja_texto " role="button" data-toggle="collapse" aria-expanded="true" aria-controls="productInfo">
                                        <span class="d-inline-block pr-2 mr-2 align-middle mt-n1 ">
                                            <i class="fa fa-align-left"></i>
                                        </span>Descrição do produto
                                    </a>
                                </h3>
                            </div>
                            <div class="collapse show custom_loja_texto" id="productInfo" data-parent="#productPanels">
                                <div class="card-body custom_loja_texto" id="descricao" style="padding: 50px;">

                                </div>
                            </div>
                        </div>

                        <div class="card hide-on-vitrine  hide-on-orcamento custom_loja_fundo">
                            <div class="card-header">
                                <h3 class="accordion-heading font_smooth">
                                    <a class="custom_loja_texto font_smooth">
                                        <span class="d-inline-block pr-2 mr-2 align-middle mt-n1">
                                            <i class="fa fa-truck"></i>
                                        </span>Opções de frete
                                    </a>
                                </h3>
                            </div>
                            <div class="collapse show" id="productFrete" data-parent="#productPanels">
                                <div class="card-body" id="frete" style="padding: 50px;">
                                    <div class="row" v-if="produto != null && produto.produto_calcula_frete == '0'">
                                        <div class="col-sm-12 col-md-12">
                                            <h3 class="text-success text-center custom_loja_texto">Frete Grátis</h3>
                                        </div>
                                    </div>
                                    <div class="row" v-else>
                                        <div class="col-sm-12 col-md-9">
                                            <label for="cep" class="custom_loja_texto">Digite seu CEP</label>
                                            <input type="text" class="form-control cep" id="cepVal" value="${cep}">
                                        </div>
                                        <div class="col-sm-12 col-md-3 align-self-end">
                                            <button class="btn btn-primary btn-block" v-on:click="getFrete()"><i class="fa fa-search"></i></button>
                                        </div>
                                    </div>
                                    <div class="row pt-4">
                                        <div class="col-sm-12 text-center" v-if="loadingFrete">
                                            <h4>Calculando Frete</h4>
                                            <div class="spinner-border" role="status">
                                                <span class="sr-only">carregando...</span>
                                            </div>

                                        </div>
                                        <div class="col-sm-12" v-if="!loadingFrete && opcoesFrete != null">
                                            <h4>Valores de Frete</h4>
                                            <div class="table-responsive">
                                                <table class="table table-hover">
                                                    <thead>
                                                        <tr>
                                                            <th class="align-middle">Valor</th>
                                                            <th class="align-middle">Serviço</th>
                                                            <th class="align-middle">Entrega</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr v-for="opc of opcoesFrete">
                                                            <td class="align-middle">
                                                                <span class="text-dark" v-if="Number(opc.price) > 0">{{ Number(opc.price).toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' }) }}</span>
                                                                <span class="text-dark" v-if="Number(opc.price) == 0"> {{ opc.name }}</span>
                                                            </td>
                                                            <td class="align-middle">
                                                                <span class="text-dark" v-if="Number(opc.price) > 0">
                                                                    {{ opc.name }}
                                                                </span>
                                                            </td>
                                                            <td class="align-middle"><span class="text-dark">{{ opc.deadline }} dias úteis</span></td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <!-- PŔODUTOS RELACIONADOS  -->
            <?php if (isset($data['produtosRelacionados'][0])) : ?>
                <div class="mt-4">
                    <h2>Leve Junto</h2>
                    <div class="custom-carousel">
                        <div class="owl-carousel" id="carousel-relacionados">
                            <?php foreach ($data['produtosRelacionados'] as $prod) : ?>
                                <div class="mt-4">
                                    <div class="product-card tips-top" title="${config_card_tooltip_text}">
                                        <a href="${baseUri}/produto/<?= $prod->produto_url ?>">
                                            <div class="product-thumb">
                                                <?php if ($prod->produto_oferta == 1) : ?>
                                                    <span class="badge badge-danger rounded-0">Oferta</span>
                                                <?php endif; ?>
                                                <img src="${baseUri}/thumb/resize/?w=400&h=<?= $data['card']->config_card_img_height ?>&f=<?= $prod->produto_foto ?>" alt="foto ">
                                                <?php if ($prod->produto_foto_hover != "") : ?>
                                                    <span>
                                                        <img src="${baseUri}/thumb/resize/?w=400&h=<?= $data['card']->config_card_img_height ?>&f=<?= $prod->produto_foto_hover ?>" class="foto-hover" />
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                            <div class="product-card-body">
                                                <span class="product-title"><?= (($prod->produto_titulo)) ?></span>
                                                <?php if ($prod->produto_estoque <= 0) : ?>
                                                    <p class="hide-on-vitrine product-title-indisponivel">Indisponível</p>
                                                <?php else : ?>
                                                    <?php if ($prod->produto_desconto > 0) : ?>
                                                        <span class="hide-on-vitrine hide-on-orcamento product-card-text-line">
                                                            R$ <?= $prod->produto_preco_original ?>
                                                        </span>
                                                    <?php endif; ?>
                                                    <span class="hide-on-vitrine hide-on-orcamento product-card-text-price">
                                                        R$ <?= $prod->produto_preco ?>
                                                    </span>
                                                    <?php if ($prod->qtd_parcelas > 1) : ?>
                                                        <span class="hide-on-vitrine hide-on-orcamento  product-card-parc">
                                                            <?= $prod->qtd_parcelas ?>X
                                                            R$ <?= $prod->produto_preco_parc ?> ${config_card_text_parc}
                                                        </span>
                                                    <?php endif; ?>
                                                    <?php if ($prod->desc_boleto > 0) : ?>
                                                        <span class="hide-on-vitrine hide-on-orcamento product-card-disc">
                                                            ${config_card_text_desconto} R$ <?= $prod->produto_preco_desc_boleto ?>
                                                        </span>
                                                        <small class="hide-on-vitrine hide-on-orcamento product-card-percent">
                                                            <?= $prod->desc_boleto ?>${config_card_text_percent}
                                                        </small>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <div v-else class="text-center">
            <div class="spinner-border load" role="status">
                <span class="sr-only">Loading...</span>
            </div>
        </div>
    </div>


    @(tema.loja.partials.blog-insta)
    @(tema.loja.partials.toasts)
    @(tema.loja.partials.footer)
    <script>
        const baseUri = "${baseUri}";
    </script>
    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/js/vendor.min.js"></script>
    <script src="assets/js/theme.min.js"></script>
    <script src="assets/js/toasts.js"></script>
    <script src="assets/js/template.js"></script>
    <script src="assets/js/vue.min.js"></script>
    <script src="assets/js/carrinho.js"></script>
    <script src="assets/js/main.js"></script>
    <script src="assets/js/jquery.mask.min.js"></script>
    <script src="produto/index-vue.js?v=${rand}"></script>
</body>

</html>