var vm = new Vue({
    el: "#vm",
    data: {
        produto: null,
        produtosRelacionados: null,
        opcoesFrete: null,
        loadingFrete: false,

        produto_favoritado: null,

        // Lógica de atributos
        atributos_nome: null,
        atributos: null,
        atributo_atual_indice: 0,
        qtd_atributos: null,
        atributos_selecionados: [], // salva os atributos que o cliente já selecionou
        nomes_atributos_selecionados: [], // salva os nomes atributos que o cliente já selecionou
        atributos_validate: false, // salva se o cliente selecionou todos os atributos
        valor_adicional_atributo: null,
        atributos_sem_estoque: false,
        max_qtd_atributo: 10,

        // Nova exibição de atributos
        atributos_view: null,
        atributos_com_estoque: [[]], // irá salvar todos os atributos que tenha estoque para que seja possível selecionar apenas atributos com estoque no front
        atributo_selecionado_final: null, // atributo mandante selecionado. Este vai ser enviado pro carrinho
    },
    methods: {
        // Nova exibição de atributos
        lista_atributos_e_itens_produto: () => {
            let url =
                baseUri + "/ProdutosFront/lista_atributos_e_itens_produto";
            $.post(url, { id: $("#produto_id").val() }).then((res) => {
                res = JSON.parse(res);
                if (res.status != undefined && res.status == 200) {
                    vm.atributos_view = res.atributos;
                    if (res.atributos != null) {
                        vm.qtd_atributos = vm.atributos_view.length;
                    }
                } else {
                    vm.atributos_view = true;
                }
            });
        },
        // FIm nova exibição de atributos
        // Métodos de popular inicialmente
        lista_atributos_inicialmente: () => {
            let url = baseUri + "/ProdutosFront/lista_atributos_inicialmente";
            $.post(url, { id: $("#produto_id").val() }).then((res) => {
                res = JSON.parse(res);
                if (res.status != undefined && res.status == 200) {
                    vm.atributos = res.atributos;
                    if (vm.atributos.length > 0) {
                        vm.atributos.map((att) => {
                            vm.atributos_com_estoque[0].push(
                                att.item_atributo_id
                            );
                        });
                    }
                } else if (res.status != undefined && res.status == 404) {
                    // vm.atributos_sem_estoque = true;
                }
            });
        },
        get_nome_atributos_vinculados: () => {
            let url = baseUri + "/ProdutosFront/get_nome_atributos_vinculados";
            $.post(url, { id: $("#produto_id").val() }).then((res) => {
                if (res) {
                    res = JSON.parse(res);
                    if (res.status != undefined && res.status == 200) {
                        vm.atributos_nome = res.atributos_nome;
                        vm.qtd_atributos = vm.atributos_nome.length;
                    }
                }
            });
        },
        // Fim metodos de popular inicialmente
        // Métodos de buscar atributos
        lista_atributos_por_id: () => {
            if (vm.atributos_selecionados.length > 0) {
                let url = baseUri + "/ProdutosFront/lista_atributos_por_id";
                if (vm.atributos_selecionados.length + 1 == vm.qtd_atributos) {
                    // Ultimo nó de itens do atributo
                    url =
                        baseUri + "/ProdutosFront/lista_atributos_por_id_last";
                }

                $.post(url, {
                    produto_id: $("#produto_id").val(),
                    itens: vm.atributos_selecionados,
                    indice: vm.atributo_atual_indice,
                }).then((res) => {
                    // console.log(res);
                    res = JSON.parse(res);
                    if (res.status != undefined && res.status == 200) {
                        vm.atributos = res.atributos;
                        // console.log(vm.atributos_com_estoque);return;
                        if (vm.atributos.length > 0) {
                            vm.atributos.map((att) => {
                                if (
                                    vm.atributos_com_estoque[
                                        vm.atributo_atual_indice
                                    ].indexOf(att.item_atributo_id) == -1
                                ) {
                                    vm.atributos_com_estoque[
                                        vm.atributo_atual_indice
                                    ].push(att.item_atributo_id);
                                }
                            });
                        }
                    }
                });
            } else {
                alert_error("Selecione um atributo!");
            }
        },
        // Fim métodos de buscar atributos
        // Metodos de handler
        SelecionaAtributo: (item_atributo_id, indiceEscolhido) => {
            if (item_atributo_id > 0) {
                if (indiceEscolhido + 1 == vm.qtd_atributos) {
                    vm.atributo_atual_indice = indiceEscolhido + 1;
                    vm.atributos_com_estoque.splice(
                        vm.atributo_atual_indice,
                        Number.MAX_VALUE,
                        []
                    );
                    vm.atributos_selecionados.splice(
                        indiceEscolhido,
                        Number.MAX_VALUE,
                        item_atributo_id
                    );
                    vm.atributos.map((att) => {
                        if (att.item_atributo_id == item_atributo_id) {
                            vm.atributo_selecionado_final = att;
                            vm.max_qtd_atributo = att.relacao_item_qtd;
                            vm.valor_adicional_atributo = Number(
                                att.relacao_item_preco
                            );
                            if ($("#qtd_produto").val() > vm.max_qtd_atributo) {
                                $("#qtd_produto").val(vm.max_qtd_atributo);
                            }
                            vm.atributos_validate = true;
                        }
                    });
                } else {
                    vm.atributo_atual_indice = indiceEscolhido + 1;
                    vm.atributos_selecionados.splice(
                        indiceEscolhido,
                        Number.MAX_VALUE,
                        item_atributo_id
                    );
                    vm.atributos_com_estoque.splice(
                        vm.atributo_atual_indice,
                        Number.MAX_VALUE,
                        []
                    );
                    vm.atributos_validate = false;
                    vm.atributo_selecionado_final = null;
                    vm.max_qtd_atributo = null;
                    vm.valor_adicional_atributo = null;
                    vm.lista_atributos_por_id();
                }
            } else {
                alert_error("Selecione um atributo!");
            }
            vm.$forceUpdate();
        },
        // Fim metodos de handler

        mudaFotoActive: function (id) {
            $(".menuFoto").removeClass("active");
            $("#menuFoto-" + id).addClass("active");
        },
        listar: function () {
            let url = baseUri + "/ProdutosFront/getProdutoInfo";
            $.post(url, { id: $("#produto_id").val() }).then((res) => {
                let prod = JSON.parse(res);
                vm.produto = prod;
                //vm.produto.produto_preco_original = vm.produto.produto_preco_original.toFixed(2);
                //vm.produto.produto_preco = vm.produto.produto_preco.toFixed(2);
                if (prod.produto_id != undefined) {
                    if (prod.produto_desc != null) {
                        setTimeout(
                            () => $("#descricao").html(prod.produto_desc),
                            200
                        );
                    }
                    setTimeout(
                        () => $(".menuFoto:first-child").addClass("active"),
                        200
                    );

                    setTimeout(() => {
                        //vm.setAttr();
                    }, 500);
                    // lista os atributos iniciais
                    // vm.get_nome_atributos_vinculados();
                    vm.lista_atributos_inicialmente();
                    vm.lista_atributos_e_itens_produto();
                }
            });
        },
        setAttr: () => {
            $("#n-attributos").html("");
            var prod = vm.produto;
            if (prod.atributos != null) {
                prod.atributos.map((att) => {
                    if (att.atributo_tipo == 1) {
                        //normal (select)
                        $("#n-attributos").append(`
                            <div class="form-group">
                                <label class="d-block">${att.atributo_nome}</label>
                                <select class="form-control custom-select" id="normal-${att.atributo_id}" name="normal-${att.atributo_id}" required> </select>
                            </div>
                            `);
                        // Loop dos itens do atributo

                        att.item.map((item) => {
                            if (item.item_atributo_qtd != "") {
                                $(`#normal-${att.atributo_id}`).append(`
                                    <option value="${item.item_atributo_id}">${item.item_atributo_nome}</option>
                                    `);
                            }
                        });

                        // Fim Loop dos itens do atributo
                    } else if (att.atributo_tipo == 2) {
                        // Hexadecimal
                        $("#n-attributos").append(`
                            <div class="form-group">
                                <label class="d-block">${att.atributo_nome}</label>
                            `);
                        // Loop dos itens do atributo
                        att.item.map((item) => {
                            if (
                                item.item_atributo_valor != "" &&
                                item.item_atributo_qtd != ""
                            ) {
                                $("#n-attributos").append(`
                                        <div class="custom-control custom-option custom-control-inline mb-2">
                                            <input class="custom-control-input" type="radio" name="color" id="hexa-${item.item_atributo_id}" required>
                                            <label class="custom-option-label" for="hexa-${item.item_atributo_id}"><span class="custom-option-color" style="background-color: ${item.item_atributo_valor};"></span></label>
                                        </div>
                                        `);
                            }
                        });
                        // Fim Loop dos itens do atributo
                        $("#n-attributos").append(`
                            </div>
                            `);
                    } else if (att.atributo_tipo == 3) {
                        // Foto

                        $("#n-attributos").append(`
                            <div class="form-group">
                                <label class="d-block">${att.atributo_nome}</label>
                                <div class="media">
                                            <a class="featured-entry-thumb">
                            `);
                        // Loop dos itens do atributo
                        att.item.map((item) => {
                            if (
                                item.item_atributo_qtd != "" &&
                                item.item_atributo_valor
                            ) {
                                $("#n-attributos").append(`
                                                <img src="${baseUri}/media/atributos/${item.item_atributo_valor}" 
                                                onclick="vm.SelecionaAtributo(${item.item_atributo_id},${item.item_atributo_qtd})"
                                                width="64" alt="produto" class="mb-3" style="cursor:pointer">
                                        `);
                            }
                        });
                        // Fim Loop dos itens do atributo
                        $("#n-attributos").append(`
                            </a>                    
                                        </div>
                            </div>
                            `);
                    } else if (att.atributo_tipo == 4) {
                        // botão

                        $("#n-attributos").append(`
                            <div class="form-group">
                                <label class="d-block">${att.atributo_nome}</label>
                            `);
                        // Loop dos itens do atributo
                        att.item.map((item) => {
                            if (item.item_atributo_qtd != "") {
                                $("#n-attributos").append(`
                                        <button type="button" class="btn btn-primary btn-circle">${item.item_atributo_nome}
                                        </button>
                                        `);
                            }
                        });
                        // Fim Loop dos itens do atributo
                        $("#n-attributos").append(`
                            </div>
                            `);
                    }
                });
            }
        },
        setProdutoInCarrinho: () => {
            if ($("#qtd_produto").val() <= 0) {
                alert_warning("Selecione uma quantidade válida");
            } else {
                let url = baseUri + "/carrinho/insereProdutoCarrinho";
                vm.produto.qtd = $("#qtd_produto").val();
                if (vm.qtd_atributos != null && vm.qtd_atributos > 0) {
                    vm.produto.valor_adicional =
                        vm.valor_adicional_atributo != null
                            ? vm.valor_adicional_atributo
                            : 0;
                    vm.produto.atributos_selecionados =
                        vm.atributos_selecionados;
                }
                $.post(url, { produto: vm.produto }).then((res) => {
                    vmCarrinho.listarCarrinho();
                    if (res.trim() == "1") {
                        window.location.href = baseUri + "/carrinho";
                    } else if (res.trim() == "0") {
                        alert_error(
                            "Erro ao adicionar produto na sacola!",
                            "CÓD: 0"
                        );
                    } else if (res.trim() == "-1") {
                        alert_warning(
                            "Produto indisponível, verifique se já não está no seu carrinho."
                        );
                    }
                });
            }
        },
        getFrete: () => {
            let cep = $("#cepVal").val().trim();
            if (cep == "") {
                alert_warning("CEP Vazio!");
                $("#cepVal").focus();
            } else {
                vm.produto.qtd = $("#qtd_produto").val();
                let url = baseUri + "/FreteFront/get_frete";
                vm.loadingFrete = true;
                //console.log(vm.produto);
                $.post(url, { cep: cep, produto: vm.produto }).then((res) => {
                    //console.log(res);
                    if (res != null) {
                        let result = JSON.parse(res);
                        if (result.error != undefined) {
                            alert_warning(result.error);
                            vm.loadingFrete = false;
                        } else {
                            result.map((r, i) => {
                                result[i].price = result[i].price;
                            });
                            vm.opcoesFrete = result[0];
                            vm.loadingFrete = false;
                        }
                    }
                });
            }
        },

        gravar_favorito: function () {
            let produto_id = $("#produto_id").val();
            let url = baseUri + "/favorito/gravar/";
            $.post(url, { produto_id: produto_id }).then((res) => {
                vm.produto_favoritado = res;
                alert_success(
                    "Ação realizada com sucesso",
                    "Produto foi adicionado a lista de desejos"
                );
                //Função em assets/js/main.js
                listarCarrinho();
            });
        },

        //Checar se o produto está favoritado ou não
        get_favoritado: function () {
            let produto_id = $("#produto_id").val();
            let url = baseUri + "/favorito/is_favoritado/";
            $.post(url, { produto_id: produto_id }).then((res) => {
                vm.produto_favoritado = res;
            });
        },

        remover_favorito: function () {
            let produto_id = $("#produto_id").val();
            let url = baseUri + "/favorito/remover/";
            $.post(url, { produto_id: produto_id }).then((res) => {
                if (res == 1) {
                    vm.produto_favoritado = 0;
                    alert_success(
                        "Ação realizada com sucesso",
                        "Produto foi removido da lista de desejos"
                    );
                    //Função em assets/js/main.js
                    listarCarrinho();
                }
            });
        },
        setProdutoInCarrinho_prod_relacionado: function (prod = null) {
            //console.log(prod);
            if (prod != null) {
                let produto = prod;
                produto.produto_imagens = [
                    {
                        foto_produto_id: 0,
                        foto_produto_img: produto.produto_foto,
                    },
                ];
                let url = baseUri + "/carrinho/insereProdutoCarrinho";
                produto.qtd = 1;
                $.post(url, { produto: produto }).then((res) => {
                    vmCarrinho.listarCarrinho();
                    if (res.trim() == "1") {
                        alert_success("Produto adicionado na sacola!");
                    } else if (res.trim() == "0") {
                        alert_error(
                            "Erro ao adicionar produto no carrinho!",
                            "CÓD: 0"
                        );
                    } else if (res.trim() == "-1") {
                        alert_warning("Produto indisponível");
                    }
                });
            }
        },
    },
    created: function () {
        this.listar();
        this.get_favoritado();
        setTimeout(() => {
            /*
            $(".owl-carousel").owlCarousel({
                nav: true,
                dots: false,
                loop: true,
                margin: 5,
                item: 1,
                 responsive: {
                        0:{items: 1},
                        480:{items: 3},
                        769:{items: 4}
                    }
            });
            */

            $("#carousel-produto").owlCarousel({
                nav: false,
                dots: false,
                loop: true,
                margin: 5,
                responsive: {
                    0: { items: 1 },
                    480: { items: 1 },
                    769: { items: 1 },
                },
            });

            let qtd_rel = $("#carousel-relacionados").find(
                ".product-thumb"
            ).length;
            if (qtd_rel >= 4) {
                qtd_rel = 4;
            }
            $("#carousel-relacionados").owlCarousel({
                nav: true,
                dots: true,
                loop: true,
                margin: 10,
                items: 1,
                responsive: {
                    0: { items: 1 },
                    480: { items: 1 },
                    769: { items: qtd_rel },
                },
            });
            $("#cepVal").mask("99999-999");
            $(".tips-top").tooltip({
                placement: "top",
            });
        }, 1000);
    },
});
