var vm = new Vue({
    el: "#vm",
    data: {
        pedido: null,
        pedido_id: $("#pedido_id").val(),
    },
    methods: {
        listaPedido: () => {
            let id = $("#pedido_id").val();

            let url = baseUri + "/PedidoFront/getPedidoDetalhes";
            $.post(url, { id: id }).then((res) => {
                res = JSON.parse(res);
                if (res.error) {
                    // tratativa de erro
                } else {
                    console.log(res);
                    vm.pedido = res;
                    if (!isNaN(vm.pedido.pedido_total_parcelado)) {
                        vm.pedido.pedido_total_parcelado = Number(
                            vm.pedido.pedido_total_parcelado
                        ).toLocaleString("pt-BR", {
                            style: "currency",
                            currency: "BRL",
                        });
                    } else {
                        vm.pedido.pedido_total_parcelado =
                            "R$ " + vm.pedido.pedido_total_parcelado;
                    }

                    if (!isNaN(vm.pedido.pedido_total_produto)) {
                        vm.pedido.pedido_total_produto = Number(
                            vm.pedido.pedido_total_produto
                        ).toLocaleString("pt-BR", {
                            style: "currency",
                            currency: "BRL",
                        });
                    } else {
                        vm.pedido.pedido_total_produto =
                            "R$ " + vm.pedido.pedido_total_produto;
                    }

                    if (!isNaN(vm.pedido.pedido_total_frete)) {
                        vm.pedido.pedido_total_frete = Number(
                            vm.pedido.pedido_total_frete
                        ).toLocaleString("pt-BR", {
                            style: "currency",
                            currency: "BRL",
                        });
                    } else {
                        vm.pedido.pedido_total_frete =
                            "R$ " + vm.pedido.pedido_total_frete;
                    }
                }

                setTimeout(function () {
                    // window.print();
                }, 500);
            });
        },
    },
    created: function () {
        this.listaPedido();
    },
});
