<!DOCTYPE html>
<html lang="pt-br">

<head>
    <title>${config_site_title}
        <?php if (isset($data['config']->config_site_slogan) && !empty($data['config']->config_site_slogan)) : ?>
            - ${config_site_slogan}
        <?php endif; ?>
    </title>
    <!-- SEO -->
    @(tema.loja.partials.meta_tags)
    @(tema.loja.partials.og_tags)
    <!-- SEO -->
    <link rel="icon" type="image/png" sizes="32x32" href="${baseUri}/media/site/${config_site_favicon}">
    @(tema.loja.partials.css-padrao)
</head>

<body>
    <!-- SEO -->
    @(tema.loja.partials.google_analytics)
    @(tema.loja.partials.google_tag_manager)
    <!-- SEO -->

    @(tema.loja.partials.menu-superior)

    <div class="hide-on-desk" style="position: relative; margin-top: 100px !important"></div>
    <div class="${config_site_layout_custom}" id="vm">
        <input type="hidden" id="pedido_id" value="<?= isset($data['pedido_id']) ? $data['pedido_id'] : '' ?>">
        <div class="row">
            <div class="col-sm-12">
                <div class="page-title-wrapper mt-3" aria-label="Page title">
                    <div class="container">
                        <div class="row justify-content-between">
                            <div class="col-sm-12 col-md-8 align-self-center">
                                <nav aria-label="breadcrumb">
                                    <ol class="breadcrumb">
                                        <li class="mt-n1 mr-1"><i data-feather="home"></i></li>
                                        <li class="breadcrumb-item"><a class="custom_loja_texto" href="${baseUri}">Home</a></li>
                                        <li class="breadcrumb-item"><a class="custom_loja_texto" href="${baseUri}/area-cliente">Pedidos</a></li>
                                        <li class="breadcrumb-item">
                                            <a class="custom_loja_texto" href="${baseUri}/pedido-detalhes/${pedido_id}">
                                                Pedido #${pedido_id}
                                            </a>
                                        </li>
                                        <li class="breadcrumb-item"><a class="custom_loja_texto">Pagamento via Pix</a></li>
                                    </ol>
                                </nav>
                            </div>
                            <div class="col-sm-12 col-md-4">
                                <a href="${baseUri}/pedido-detalhes/${pedido_id}" class="btn btn-primary btn-sm pull-right"> <i class="fa fa-arrow-left"></i> Detalhes do Pedido </a>
                            </div>
                        </div>
                        <hr class="mt-4">
                        <br>
                        <div class="col-md-12 text-center">
                            <h4>Para pagar, escolha uma destas opções:</h4>
                            <div style="width: 300px;display: inline-block;">
                                <h5>Código QR</h5>
                                <img src="https://qrcode.tec-it.com/API/QRCode?dpi=200&quietzone=2&size=small&data==${pedido_pix_qr}">
                            </div>
                            <br>
                            <br>
                            <h5>Código "Copia e Cola" para pagamento</h5>
                            <div class="input-group pt-3">
                                <input class="form-control" type="text" id="pix_copia_cola" aria-describedby="search-icon" value="${pedido_pix_qr}" readonly>
                                <div class="input-group-prepend">
                                    <button class="input-group-button btn btn-primary" id="search-icon" onclick="mycopy('${pedido_pix_qr}')">
                                        <i class="fa fa-clipboard"></i>
                                    </button>
                                </div>
                            </div>
                            <br><br>
                            <span>Caso QRCode ou "Copia e Cola" não sejam exibidos,</span> <a href="${pedido_pay_url}" target="_blank"><strong>clique aqui</strong></a>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!-- view pedido -->
    @(tema.loja.partials.toasts)
    @(tema.loja.partials.footer)
    <script>
        const baseUri = "${baseUri}";
        var pedido_id = parseInt("${pedido_id}");
    </script>
    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/js/vendor.min.js"></script>
    <script src="assets/js/theme.min.js"></script>
    <script src="assets/js/toasts.js"></script>
    <script src="assets/js/template.js"></script>
    <script src="assets/js/vue.min.js"></script>
    <script src="assets/js/carrinho.js"></script>
    <script src="assets/js/clipboard.js"></script>
    <script src="assets/js/main.js?v=<?= rand(); ?>"></script>
    <script src="pedido/index.js?v=<?= rand(); ?>"></script>
    <script>
        setInterval(() => {
            vm.pedido_status()
        }, 2000)
    </script>
</body>

</html>