var vm = new Vue({
    el: "#vm",
    data: {
        pedido: null,
        respostas: null,
    },
    methods: {
        listaPedido: () => {
            let id = pedido_id;
            let url = baseUri + "/PedidoFront/getPedidoDetalhes";
            $.post(url, { id: id }).then((res) => {
                res = JSON.parse(res);
                if (res.error) {
                    window.location.href = baseUri + "/pedido-detalhes/";
                } else {
                    vm.pedido = res;
                    if (!isNaN(vm.pedido.pedido_total_parcelado)) {
                        vm.pedido.pedido_total_parcelado = Number(
                            vm.pedido.pedido_total_parcelado
                        ).toLocaleString("pt-BR", {
                            style: "currency",
                            currency: "BRL",
                        });
                    } else {
                        vm.pedido.pedido_total_parcelado =
                            "R$ " + vm.pedido.pedido_total_parcelado;
                        let split = vm.pedido.pedido_total_parcelado.split(",");
                        if (Number(split[1].trim()) < 10) {
                            vm.pedido.pedido_total_parcelado =
                                vm.pedido.pedido_total_parcelado + "0";
                        }
                    }
                    if (!isNaN(vm.pedido.pedido_total_produto)) {
                        vm.pedido.pedido_total_produto = Number(
                            vm.pedido.pedido_total_produto
                        ).toLocaleString("pt-BR", {
                            style: "currency",
                            currency: "BRL",
                        });
                    } else {
                        vm.pedido.pedido_total_produto =
                            "R$ " + vm.pedido.pedido_total_produto;
                    }
                }
            });
        },

        lista_questionario: () => {
            let id = pedido_id;
            let url = baseUri + "/CamposExtras/lista_questionario";
            $.post(url, { pedido_id: id }).then((res) => {
                res = JSON.parse(res);
                if (res.status == 200) {
                    vm.respostas = res.respostas;
                } else {
                    vm.respostas = null;
                }
            });
        },
        pedido_status: () => {
            let url = baseUri + "/PedidoFront/get_pedido_status/";
            let data = {
                id: pedido_id,
            };
            $.post(url, data).then((res) => {
                if (res > 2) {
                    window.location =
                        baseUri +
                        "/pedido-detalhes/" +
                        pedido_id +
                        "/?atualizado";
                }
            });
        },
    },
    created: function () {
        let url = window.location.href;
        if (url.indexOf("success") != -1) {
            alert_success("Procedimento realizado com sucesso!");
        } else if (url.indexOf("error") != -1) {
            alert_warning("Não foi possível realizar o procedimento!");
        }
        this.listaPedido();
        this.lista_questionario();
    },
});
