<!-- Div Carrinho -->
<div class="offcanvas offcanvas-reverse hide-on-vitrine divs-menu" id="offcanvas-cart">
    <div class="offcanvas-header d-flex justify-content-between align-items-center">
        <h3 class="offcanvas-title">Sua Sacola</h3>
        <button class="close" type="button" data-dismiss="offcanvas" aria-label="Close"><span aria-hidden="true">&times;</span></button>
    </div>
    <div class="offcanvas-body">
        <div class="offcanvas-body-inner" v-if="carrinho != null">
            <div class="widget widget-featured-entries pt-3">
                <!-- carrinho -->
                <div v-for="cart in carrinho" class="mb-2">
                    <div class="media">
                        <div class="featured-entry-thumb mr-3">
                            <a :href="'${baseUri}/produto/' + cart.produto.produto_url">
                                <img :src="'${baseUri}/thumb/resize/?w=100&h=100&f=' + cart.produto.produto_imagens[0].foto_produto_img" width="64" alt="produto">
                            </a>
                            <span class="item-remove-btn" v-on:click="removeItemCarrinho(cart.carrinho_id)">x</span>
                        </div>

                        <div class="media-body">
                            <h6 class="featured-entry-title">
                                <a :href="'${baseUri}/produto/' + cart.produto.produto_url">{{ cart.produto.produto_titulo }}</a>
                            </h6>
                            <p class="featured-entry-meta"> {{ cart.produto.qtd }} <span class='text-muted'>x</span> <span class='hide-on-orcamento'>R$ {{ cart.produto.produto_preco }}</span></p>
                        </div>
                    </div>
                    <!-- atributos -->
                    <div class="row" v-if="cart.produto.atributos_selecionados != undefined">
                        <div class="col-sm-6" v-for="(att, index) in cart.produto.nomes_atributos">
                            <span class="text-muted mr-2 custom_loja_texto">{{ att.atributo_nome }}:</span>{{ cart.produto.nomes_atributos_selecionados[index] }}
                        </div>
                        <hr>
                    </div>
                    <!-- atributos -->
                </div>
                <!-- fim carrinho -->
                <hr>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="font-size-sm hide-on-orcamento" v-if="subtotal != null">
                            <span class="mr-2">Subtotal:</span>
                            <span class="font-weight-semibold text-dark valorSubtotal">{{ subtotal.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' }) }}</span>
                        </div>
                    </div>
                    <div class="col-sm-12 mt-2">
                        <a class="btn btn-secondary btn-sm btn-block" href="${baseUri}/carrinho">Detalhes da sacola<i class="mr-n2" data-feather="chevron-right"></i></a>
                    </div>
                    <div class="col-sm-12 mt-2">
                        <a class="btn btn-primary btn-sm btn-block" href="${baseUri}/checkout"><i class="mr-1" data-feather="credit-card"></i>Finalizar <span v-if="${config_site_modo} === 1">Pedido</span> <span v-if="${config_site_modo} === 2">Orçamento</span></a>
                    </div>
                </div>
            </div>
        </div>
        <div v-else>
            <br>
            <h5 class="text-black text-center">Nenhum produto na sacola</h5>
        </div>
    </div>
</div>
<!-- Fim Div Carrinho -->