// Start functions
// Functions
function showSearch() {
    $("#offcanvas-search").toggle("slow");
}

function showQuickView(id) {
    $("#quickViewProdutoFotos").owlCarousel("destroy");
    $("#detalheProduto").hide();
    $("#loading").show();

    let url = baseUri + "/ProdutosFront/getProdutoInfo";
    $.post(url, { id: id }).then((res) => {
        let prod = JSON.parse(res);
        console.log(prod);

        if (prod.produto_id != undefined) {
            $("#quickViewProdutoNome").html(prod.produto_titulo);
            $("#quickViewProdutoPreco").html("");
            if (prod.produto_estoque <= 0) {
                $("#quickViewProdutoPreco").html("Indisponível");
                $("#formCarrinho").hide();
            } else {
                $("#formCarrinho").show();
                if (prod.produto_desconto > 0) {
                    $("#quickViewProdutoPreco").html(`
                            <span style="color: red !important; text-decoration: line-through;">R$ ${prod.produto_preco_original}</span>
                            R$ ${prod.produto_preco}
                        `);
                } else {
                    $("#quickViewProdutoPreco").html(
                        "R$ " + prod.produto_preco
                    );
                }
            }

            $("#btnVisitar").attr(
                "href",
                baseUri + "/produto/" + prod.produto_url
            );

            if (prod.produto_desc != null) {
                $("#quickViewProdutoDesc").html(prod.produto_desc);
                $("#quickViewProdutoFotos").html("");
                $("#divQuickViewProdutoDesc").show();
            } else {
                $("#divQuickViewProdutoDesc").hide();
                $("#quickViewProdutoFotos").html("");
            }

            prod.produto_imagens.map((foto) => {
                $("#quickViewProdutoFotos").append(`
                        <img class="img-produto-quick-view" src="${baseUri}/media/produto/${foto.foto_produto_img}" alt="Product">
                    `);
            });

            $("#quickViewProdutoFotos").owlCarousel({
                nav: true,
                dots: true,
                loop: true,
                margin: 15,
                item: 1,
                responsive: {
                    0: {
                        items: 1,
                    },
                    768: {
                        items: 1,
                    },
                    1000: {
                        items: 1,
                    },
                },
            });

            // Atributos
            $("#atributos").html("");
            if (prod.atributos != null) {
                prod.atributos.map((att) => {
                    if (att.atributo_tipo == 1) {
                        //normal (select)
                        $("#atributos").append(`
                            <div class="form-group">
                                <label class="d-block">${att.atributo_nome}</label>
                                <select class="form-control custom-select" id="normal-${att.atributo_id}" name="normal-${att.atributo_id}" required> </select>
                            </div>
                            `);
                        // Loop dos itens do atributo

                        att.item.map((item) => {
                            if (item.item_atributo_qtd != "") {
                                $(`#normal-${att.atributo_id}`).append(`
                                    <option value="${item.item_atributo_id}">${item.item_atributo_nome}</option>
                                    `);
                            }
                        });

                        // Fim Loop dos itens do atributo
                    } else if (att.atributo_tipo == 2) {
                        // Hexadecimal
                        $("#atributos").append(`
                            <div class="form-group">
                                <label class="d-block">${att.atributo_nome}</label>
                            `);
                        // Loop dos itens do atributo
                        att.item.map((item) => {
                            if (
                                item.item_atributo_valor != "" &&
                                item.item_atributo_qtd != ""
                            ) {
                                $("#atributos").append(`
                                        <div class="custom-control custom-option custom-control-inline mb-2">
                                            <input class="custom-control-input" type="radio" name="color" id="hexa-${item.item_atributo_id}" required>
                                            <label class="custom-option-label" for="hexa-${item.item_atributo_id}"><span class="custom-option-color" style="background-color: ${item.item_atributo_valor};"></span></label>
                                        </div>
                                        `);
                            }
                        });
                        // Fim Loop dos itens do atributo
                        $("#atributos").append(`
                            </div>
                            `);
                    } else if (att.atributo_tipo == 3) {
                        // Foto

                        $("#atributos").append(`
                            <div class="form-group">
                                <label class="d-block">${att.atributo_nome}</label>
                                <div class="media">
                                            <a class="featured-entry-thumb">
                            `);
                        // Loop dos itens do atributo
                        att.item.map((item) => {
                            if (
                                item.item_atributo_qtd != "" &&
                                item.item_atributo_valor
                            ) {
                                $("#atributos").append(`
                                        
                                                <img src="${baseUri}/media/atributos/${item.item_atributo_valor}" width="64" alt="produto" class="mb-3">
                                            
                                        `);
                            }
                        });
                        // Fim Loop dos itens do atributo
                        $("#atributos").append(`
                            </a>                    
                                        </div>
                            </div>
                            `);
                    } else if (att.atributo_tipo == 4) {
                        // botão

                        $("#atributos").append(`
                            <div class="form-group">
                                <label class="d-block">${att.atributo_nome}</label>
                            `);
                        // Loop dos itens do atributo
                        att.item.map((item) => {
                            if (item.item_atributo_qtd != "") {
                                $("#atributos").append(`
                                        <button type="button" class="btn btn-primary btn-circle">${item.item_atributo_nome}
                                        </button>
                                        `);
                            }
                        });
                        // Fim Loop dos itens do atributo
                        $("#atributos").append(`
                            </div>
                            `);
                    }
                });
            }

            $("#loading").hide();
            $("#detalheProduto").show();
        } else {
            $("#detalheProduto").hide();
        }
    });
}
