<!DOCTYPE html>
<html lang="pt-br">

<head>
    <title>${config_site_title} <?= (!empty($data['config']->config_site_slogan)) ? ' - ' . $data['config']->config_site_slogan : ''; ?></title>
    <!-- SEO -->
    @(tema.loja.partials.meta_tags)
    @(tema.loja.partials.og_tags)
    <!-- SEO -->
    <link rel="icon" type="image/png" sizes="32x32" href="${baseUri}/media/site/${config_site_favicon}">
    @(tema.loja.partials.css-padrao)
</head>

<body>
    <!-- SEO -->
    @(tema.loja.partials.google_analytics)
    @(tema.loja.partials.google_tag_manager)
    <!-- SEO -->
    @(tema.loja.partials.menu-superior)

    <?php if(Browser::agent('mobile')): ?>
        <br><br><br><br>
    <?php endif; ?>

    <?php if (isset($data['fullFaq'][0])) : ?>
        <section class="${config_site_layout_custom} mt-5">
            <h2 class="h3 text-center pb-4 custom_loja_texto font_smooth">Perguntas Frequentes</h2>

            <div class="row">
                <div class="col-sm-12">
                    <div id="accordion">
                        <div class="row">
                            <?php foreach ($data['fullFaq'] as $faq) : ?>
                                <div class="col-sm-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <h5 class="mb-0">
                                                <a style="box-shadow: none !important;text-align: left; width: 100%;" data-toggle="collapse" data-target="#card-content-<?= $faq->faq_id ?>" aria-expanded="true" aria-controls="card-content-<?= $faq->faq_id ?>">
                                                    <i class="fa fa-chevron-right"></i> <?= $faq->faq_titulo ?>
                                                </a>
                                            </h5>
                                        </div>

                                        <div id="card-content-<?= $faq->faq_id ?>" class="collapse" aria-labelledby="headingOne" data-parent="#accordion">
                                            <div class="card-body">
                                                <?= $faq->faq_texto ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>


    @(tema.loja.partials.toasts)
    @(tema.loja.partials.footer)

    <script>
        const baseUri = "${baseUri}";
    </script>
    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/js/vendor.min.js"></script>
    <script src="assets/js/theme.min.js"></script>
    <script src="assets/js/toasts.js"></script>
    <script src="assets/js/template.js"></script>
    <script src="assets/js/vue.min.js"></script>
    <script src="assets/js/carrinho.js"></script>
    <script src="assets/js/jquery.mask.min.js"></script>
    <script src="assets/js/main.js?v=<?= rand(); ?>"></script>
    <script>
        setMasks();
    </script>
</body>

</html>