<!-- Page Content-->
<div class="${config_site_layout_custom}  pb-5 mb-sm-3 mt-mobile">
    <div class="row ">
        <!-- Main content-->
        <div class="col-lg-12">
            <!-- Customer details-->
            <div class="container-fluid">
                <div class="d-flex flex-wrap justify-content-between pb-4">
                    <div class=" mr-3">
                        <h3 class="mb-0 custom_loja_texto">Olá <?= Session::client_node('unome') ?>, Bem-vindo(a)!</h3><span class="font-size-sm custom_loja_texto"><i class="mr-2" data-feather="mail"></i><?= Session::client_node('umail') ?></span>
                    </div>

                </div>
                <!-- Navigation (visible sm-up)-->
                <nav>
                    <ul class="nav nav-tabs d-none d-sm-flex" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active custom_loja_texto" data-toggle="tab" href="#pedidos" role="tab">
                                <i data-feather="shopping-bag"></i>&nbsp;Meus
                                <span class="hide-on-orcamento">Pedidos</span>
                                <span class="hide-on-loja">Orçamentos</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link custom_loja_texto" data-toggle="tab" href="#enderecos" role="tab">
                                <i data-feather="map-pin"></i>&nbsp;Meus Endereços</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link custom_loja_texto" data-toggle="tab" href="#dados" role="tab">
                                <i data-feather="user"></i>&nbsp;Meus Dados</a>
                        </li>
                    </ul>
                </nav>
            </div>


            <!-- Navigation (visible sm-down)-->
            <div class="d-sm-none pb-4">
                <button class="btn btn-primary btn-block mb-2" type="button" data-toggle="collapse" data-target="#account-menu"><i class="mr-2" data-feather="menu"></i>Menu</button>
                <div class="collapse" id="account-menu">
                    <div class="list-group">
                        <a class="list-group-item list-group-item-action nav-item nav-link active" data-toggle="tab" href="#pedidos" role="tab">
                            <i class="mr-2" data-feather="shopping-bag" style="width: 1rem; height: 1rem;"></i>Meus Pedidos
                            <!-- <span class="badge badge-pill badge-secondary bg-0 border ml-2">
                                <span class="text-primary">1</span>
                            </span> -->
                        </a>
                        <a class="list-group-item list-group-item-action nav-item nav-link" data-toggle="tab" href="#enderecos" role="tab">
                            <i class="mr-2" data-feather="map-pin" style="width: 1rem; height: 1rem;"></i>Meus Endereços

                        </a>
                        <a class="list-group-item list-group-item-action nav-item nav-link" data-toggle="tab" href="#dados" role="tab">
                            <i class="mr-2" data-feather="user" style="width: 1rem; height: 1rem;"></i>Meus Dados
                        </a>
                    </div>
                </div>
            </div>
            <div class="tab-content" id="vm">
                <div class="tab-pane fade show active" id="pedidos">
                    <div class="table-responsive font-size-sm">
                        <table class="table mb-0 datatable" id="tabelaPedidos">
                            <thead>
                                <tr>
                                    <th class="custom_loja_texto">Foto</th>
                                    <th class="custom_loja_texto">Produto</th>
                                    <th class="custom_loja_texto">Data</th>
                                    <th class="hide-on-orcamento custom_loja_texto">Status</th>
                                    <th class="custom_loja_texto">Total</th>
                                    <th class="custom_loja_texto" width="30">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="ped of pedidos" :id="'pedidos-' + ped.pedido_id">
                                    <td width="100"><img :src="baseUri + '/media/produto/' + ped.lista_pedido_foto" style="object-fit: content; width: 70%;height: 60px;"></td>
                                    <td class="custom_loja_texto">{{ ped.lista_pedido_produto_titulo }}</td>
                                    <td class="custom_loja_texto">{{ ped.pedido_data }}</td>
                                    <td class="hide-on-orcamento"><span :class="'badge badge-' + ped.pedido_status_badge + ' m-0'">{{ ped.pedido_status }}</span></td>
                                    <td class="custom_loja_texto">{{ ped.pedido_total_parcelado}}</td>
                                    <td>
                                        <a v-if="ped.pedido_entrega == 1 && ped.pedido_codigo_rastreio" class="btn btn-success btn-sm mb-2" target="_blank" :href="'${baseUri}/frete-rastreio/'+ped.pedido_codigo_rastreio"> <i class="fa fa-truck" aria-hidden="true"></i> Rastrear </a>
                                        <a class="btn btn-info btn-sm" :href="'${baseUri}/pedido-detalhes/' + ped.pedido_id"><i class="fa fa-search"></i> Detalhes</a>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="tab-pane fade" id="enderecos">
                    <div class="table-responsive font-size-sm">
                        <div class="container">
                            <a href="${baseUri}/adicionar-endereco" class="btn btn-success btn-sm customButtonAdd pull-right ml-3"> <i class="fa fa-plus"></i> Adicionar </a>
                            <div class="d-lg-none">
                                <br><br>
                            </div>
                        </div>

                        <table class="table mb-0 datatable" id="tabelaEnderecos">
                            <thead>
                                <tr>
                                    <th class="custom_loja_texto">Título</th>
                                    <th class="custom_loja_texto">Rua</th>
                                    <th class="custom_loja_texto">CEP</th>
                                    <th class="custom_loja_texto">Cidade/UF</th>

                                    <th width="100">Ações</th>
                                </tr>
                            </thead>
                            <tbody v-if="enderecos != null">
                                <tr v-for="end of enderecos" :id="'endereco-' + end.endereco_cliente_id">
                                    <td class="custom_loja_texto">{{ end.endereco_cliente_titulo }}</td>
                                    <td class="custom_loja_texto">{{ end.endereco_cliente_rua }}</td>
                                    <td class="custom_loja_texto">{{ end.endereco_cliente_cep }}</td>
                                    <td class="custom_loja_texto">{{ end.endereco_cliente_cidade }} / {{ end.endereco_cliente_uf }}</td>
                                    <td>
                                        <a class="btn btn-info btn-sm" :href="'${baseUri}/editar-endereco/id/' + end.endereco_cliente_id"><i class="fa fa-edit"></i></a>
                                        <a class="btn btn-danger btn-sm" v-if="end.endereco_cliente_tipo != 1" v-on:click="prepareRemoveEndereco(end.endereco_cliente_id)"><i class="fa fa-trash"></i></a>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="tab-pane fade container" id="dados">

                    <form class="row" method="post" id="formDados" action="${baseUri}/ClienteFront/gravar" autocomplete="off" v-if="cliente != null">
                        <input type="hidden" id="cliente_id" name="cliente_id" value="<?= Session::client_node('uid') ?>">
                        <div class="col-sm-12 col-md-12 mb-3">
                            <h3 class="mb-4 pt-sm-3 custom_loja_texto">Dados Cadastrais</h3>
                            <hr>
                        </div>
                        <div class="col-sm-12 col-md-6">
                            <div class="form-group">
                                <label for="cliente_nome" class="custom_loja_texto">
                                    <span v-if="cliente.cliente_tipo == 1">Nome Completo</span>
                                    <span v-if="cliente.cliente_tipo == 2">Razão Social</span>
                                    <span class="text-danger">*</span></label>
                                <input class="form-control" required type="text" name="cliente_nome" id="cliente_nome" :value="cliente.cliente_nome">
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3" v-if="cliente.cliente_tipo == 1">
                            <div class="form-group">
                                <label for="cliente_cpf" class="custom_loja_texto">CPF <span class="text-danger">*</span></label>
                                <input class="form-control cpfCnpj" required type="text" name="cliente_cpf" id="cliente_cpf" :value="cliente.cliente_cpf">
                            </div>
                        </div>

                        <div class="col-sm-12 col-md-3" v-if="cliente.cliente_tipo == 2">
                            <div class="form-group">
                                <label for="cliente_contato" class="custom_loja_texto">Contato <span class="text-danger">*</span></label>
                                <input class="form-control" required type="text" name="cliente_contato" id="cliente_contato" :value="cliente.cliente_contato">
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3" v-if="cliente.cliente_tipo == 2">
                            <div class="form-group">
                                <label for="cliente_cnpj" class="custom_loja_texto">CNPJ <span class="text-danger">*</span></label>
                                <input class="form-control" required type="text" name="cliente_cnpj" id="cliente_cnpj" :value="cliente.cliente_cnpj">
                            </div>
                        </div>

                        <div class="col-sm-12 col-md-3" v-if="cliente.cliente_tipo == 1">
                            <div class="form-group">
                                <label for="cliente_nascimento" class="custom_loja_texto">Data de Nascimento <span class="text-danger">*</span></label>
                                <input class="form-control" required type="date" name="cliente_nascimento" id="cliente_nascimento" :value="cliente.cliente_nascimento">
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-12 mb-3">
                            <h3 class="mb-4 pt-sm-3 custom_loja_texto">Dados De Contato e Login</h3>
                            <hr>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="cliente_telefone" class="custom_loja_texto">Telefone Preferencial / WhatsApp <span class="text-danger">*</span></label>
                                <input class="form-control celular" required type="text" name="cliente_telefone" id="cliente_telefone" :value="cliente.cliente_telefone">
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="cliente_celular" class="custom_loja_texto">Telefone Contato</label>
                                <input class="form-control celular" type="text" name="cliente_celular" id="cliente_celular" :value="cliente.cliente_celular">
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3 d-none">
                            <div class="form-group">
                                <label for="cliente_whats" class="custom_loja_texto">WhatsApp</label>
                                <input class="form-control celular" type="text" name="cliente_whats" id="cliente_whats" :value="cliente.cliente_whats">
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3 d-none">
                            <div class="form-group">
                                <label for="cliente_email2" class="custom_loja_texto">Email Secundário</label>
                                <input class="form-control" type="email" name="cliente_email2" id="cliente_email2" :value="cliente.cliente_email2" autocomplete="off">
                            </div>
                        </div>

                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="cliente_email" class="custom_loja_texto">Email Principal (Login) <span class="text-danger">*</span></label>
                                <input class="form-control" required type="email" name="cliente_email" id="cliente_email" :value="cliente.cliente_email" autocomplete="off">
                            </div>
                        </div>

                        <div class="col-sm-12 col-md-2">
                            <div class="form-group">
                                <label for="cliente_senha" class="custom_loja_texto">Senha</label>
                                <input class="form-control" :type="typeSenha" name="cliente_password" id="cliente_senha" value="" autocomplete="off">
                            </div>
                        </div>

                        <div class="col-sm-12 col-md-1 align-self-end">
                            <div class="form-group">
                                <a class="btn btn-info" v-on:click="viewSenha()"> <i :class="iconSenha"></i></a>
                            </div>
                        </div>

                        <div class="col-sm-12 text-center mt-3">
                            <button class="btn btn-primary" type="submit">Atualizar dados</button>
                        </div>

                    </form>
                </div>


                <div class="modal fade" id="modalRemoveEndereco" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Remover Endereço</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body text-center">
                                Tem certeza de que deseja remover este endereço? Essa ação não poderá ser desfeita.
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                                <button type="button" class="btn btn-danger" v-on:click="removeEndereco()">Remover</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>