var datatable_ptbr = {
    sEmptyTable: "Nenhum registro encontrado",
    sInfo: "<small>Mostrando de _START_ até _END_ de _TOTAL_ registros</small>",
    sInfoEmpty: "Mostrando 0 até 0 de 0 registros",
    sInfoFiltered: "(Filtrados de _MAX_ registros)",
    sInfoPostFix: "",
    sInfoThousands: ".",
    sLengthMenu: "MENU resultados por página",
    sLengthMenu: "",
    sLoadingRecords: "Carregando...",
    sProcessing: "Processando...",
    sZeroRecords: "Nenhum registro encontrado",
    sSearch: "Pesquisar",
    oPaginate: {
        sNext: "Próx.",
        sPrevious: "Ant.",
        sFirst: "Primeiro",
        sLast: "Último",
    },
    oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
    },
};

var vm = new Vue({
    el: "#vm",
    data: {
        cliente: null,
        enderecos: null,
        pedidos: null,
        verSenha: false,
        iconSenha: "fa fa-eye",
        typeSenha: "password",
        enderecoRemove: null,
    },
    methods: {
        listarCliente: function () {
            let url = baseUri + "/ClienteFront/getCliente";
            $.post(url).then((res) => {
                vm.cliente = JSON.parse(res);
                if (vm.cliente.cliente_email2 == null)
                    vm.cliente.cliente_email2 = vm.cliente.cliente_email;

                setTimeout(() => setMasks(), 500);
            });
        },
        viewSenha: () => {
            vm.verSenha = !vm.verSenha;

            vm.iconSenha = vm.verSenha ? "fa fa-eye-slash" : "fa fa-eye";
            vm.typeSenha = vm.verSenha ? "text" : "password";
        },

        // Endereços
        listarEndereco: () => {
            let url = baseUri + "/ClienteFront/listarEndereco";
            $.post(url).then((res) => {
                if (res != null) {
                    vm.enderecos = JSON.parse(res);
                } else {
                    vm.enderecos = null;
                }
                setTimeout(() => {
                    $("#tabelaEnderecos").DataTable({
                        language: datatable_ptbr,
                    });
                }, 500);
            });
        },
        prepareRemoveEndereco: (id) => {
            vm.enderecoRemove = id;
            $("#modalRemoveEndereco").modal("show");
        },
        removeEndereco: () => {
            if (vm.enderecoRemove != null) {
                let url = baseUri + "/ClienteFront/removerEndereco";
                $.post(url, { id: vm.enderecoRemove }).then((res) => {
                    if (res.trim() == "1") {
                        alert_success("Endereço removido com sucesso");
                        vm.listarEndereco();
                        $("#modalRemoveEndereco").modal("hide");
                    } else {
                        alert_error("Erro ao remover endereço");
                    }
                });
            }
        },
        listaPedidos: () => {
            let url = baseUri + "/ClienteFront/listaPedidos";
            $.post(url).then((res) => {
                if (res != null) {
                    vm.pedidos = JSON.parse(res);
                    if (vm.pedidos != null) {
                        vm.pedidos.map((ped, i) => {
                            if (
                                vm.pedidos[i].lista_pedido_produto_titulo
                                    .length > 30
                            ) {
                                vm.pedidos[i].lista_pedido_produto_titulo =
                                    vm.pedidos[
                                        i
                                    ].lista_pedido_produto_titulo.slice(0, 30) +
                                    "...";
                            }

                            if (!isNaN(vm.pedidos[i].pedido_total_parcelado)) {
                                vm.pedidos[i].pedido_total_parcelado = Number(
                                    vm.pedidos[i].pedido_total_parcelado
                                ).toLocaleString("pt-BR", {
                                    style: "currency",
                                    currency: "BRL",
                                });
                            } else {
                                vm.pedidos[i].pedido_total_parcelado =
                                    "R$ " +
                                    vm.pedidos[i].pedido_total_parcelado;
                                let split =
                                    vm.pedidos[i].pedido_total_parcelado.split(
                                        ","
                                    );
                                if (Number(split[1].trim()) < 10) {
                                    vm.pedidos[i].pedido_total_parcelado =
                                        vm.pedidos[i].pedido_total_parcelado +
                                        "0";
                                }
                            }
                        });
                    }
                } else {
                    vm.pedidos = null;
                }

                setTimeout(() => {
                    $("#tabelaPedidos").DataTable({
                        language: datatable_ptbr,
                    });
                }, 500);
            });
        },
    },
    created: function () {
        this.listarCliente();
        this.listarEndereco();
        this.listaPedidos();

        var cpfCnpj = function (val) {
                return val.replace(/\D/g, "").length > 11
                    ? "00.000.000/0000-00"
                    : "000.000.000-009";
            },
            cpfOptions = {
                onKeyPress: function (val, e, field, options) {
                    field.mask(cpfCnpj.apply({}, arguments), options);
                },
            };
        setTimeout(() => {
            $(".cpfCnpj").mask(cpfCnpj, cpfOptions);
        }, 200);

        let url = window.location.href;
        if (url.indexOf("success") != -1) {
            alert_success("Procedimento realizado com sucesso!");
        } else if (url.indexOf("error") != -1) {
            alert_error("Não foi possível realizar o procedimento.");
        }
    },
});
