var table;
var vm = new Vue({
    el: '#vm',
    data: {
        categoria: null,
        rm: null,
        url: null,
        subcategoria: null
    },
    methods: {
        listarSubcategorias: function() {
            splash_dt();
            reload_dt_vue();
            var url = baseUri + '/ProdutosAdmin/lista_subcategoria/';
            var self = this;
            $.getJSON(url, {}, function(dados) {
                splash_dt();
            }).then(function(dados) {
                if (dados != null) {
                    self.subcategoria = dados;
                    setTimeout(function() {
                        $('#tbl-splash').hide().promise().done($('#tbl-div').show());
                        table = $('#datatable').DataTable({
                            language: datatable_ptbr,
                            aaSorting: [],
                            retrieve: true,
                            responsive: true,
                            rowReorder: true,
                            "displayLength": 100,
                            "pageLength": 100,
                        });
                        reload_dt_vue();
                    }, 500);
                } else {
                    self.subcategoria = null;
                }
                reload_dt_vue();
            });
        },
        listarCategorias: function() {
            var url = baseUri + '/ProdutosAdmin/lista_categoria/';
            var self = this;
            $.getJSON(url, {}, function(dados) {
                self.categoria = dados;
            })
        },
        editar: function(cat) {
            this.limpar();
            $('.categoria-acao').html('Alterar');
            $('#modal-categoria').modal('show');
            $('#subcategoria_produto_nome').val(cat.subcategoria_produto_nome);
            $('#subcategoria_produto_id').val(cat.subcategoria_produto_id);
            $("#subcategoria_produto_apelido").val(cat.subcategoria_produto_apelido);
            $("#subcategoria_produto_ordem_destaque").val(cat.subcategoria_produto_ordem_destaque).trigger('change');
            $('#subcategoria_produto_categoria').val(cat.subcategoria_produto_categoria).trigger('change');
            $("#subcategoria_produto_pos").val(cat.subcategoria_produto_pos).trigger('change');
        },
        limpar: function() {
            $('.categoria-acao').html('Incluir');
            $('#subcategoria_produto_nome').val('');
            $('#subcategoria_produto_id').val('');
        },
        remover: function(dt) {
            vm.$data.rm = dt.subcategoria_produto_id;
            $('#modal-remove').modal('show');
        },
        remove: function(id) {
            var url_remove = baseUri + '/ProdutosAdmin/remover_subcategoria/';
            $.post(url_remove, { id: id }).then(function(rs) {
                if (rs == 1) {
                    alert_success('Ação realizada com sucesso!', 'Item removido');
                    vm.listarSubcategorias();
                } else {
                    alert_error('Ação não pode ser realizada!');
                }
            });
            $('#modal-remove').modal('hide');
        }
    },
    created: function() {
        $('#tbl-div').hide().promise().done($('#tbl-splash').show());
        this.listarSubcategorias();
        this.listarCategorias();
    }
});
// click do modal
$('#btn-remove').on('click', function() {
    if (vm.$data.rm !== null) {
        vm.remove(vm.$data.rm, vm.$data.url);
    }
});
$('#nova-categoria').on('click', function() {
    vm.limpar();
    $('#modal-categoria').modal('show');
});

$(document).ready(function() {
    // setTimeout(function() {
    //     table.on('row-reorder', function(e, diff, edit, ) {
    //         var url = baseUri + '/produtosAdmin/ordenar/';
    //         if (diff.length > 0) {
    //             $.post(url, { diff: JSON.stringify(diff) }).then(function(rs) {
    //                 vm.listar();
    //             });
    //         }
    //     });

    // }, 1200);
    // vm.listar();
    // vm.listar();

})