<div class="row">


    <div class="col-sm-12 col-md-4">
        <label for="produto_gtin">GTIN/EAN</label>
        <input type="text" class="form-control" name="produto_gtin" id="produto_gtin" value="${produto_gtin}" placeholder="Código GTIN do Produto"><br><br>
    </div>
    <div class="col-sm-12 col-md-4">
        <label for="produto_gtint">GTIN/EAN Tributário</label>
        <input type="text" class="form-control" name="produto_gtint" id="produto_gtint" value="${produto_gtint}" placeholder="Código GTIN da menor unidade do Produto"><br><br>
    </div>

    <div class="col-sm-12 col-md-4">
        <label for="produto_tipo_unidade">Tipo de Unidade</label>
        <select name="produto_tipo_unidade" id="produto_tipo_unidade" class="form-control">
            <option value selected>Selecione o tipo de unidade</option>
            <option value="UN">UN</option>
            <option value="CX">CX</option>
            <option value="PC">PC</option>
        </select>
    </div>


    <div class="col-sm-12 col-md-3">
        <label for="produto_estoque">Quantidade em estoque <span class="text-danger">*</span> </label>
        <input type="number" class="form-control" name="produto_estoque" id="produto_estoque" value="${produto_estoque}" placeholder="Quantidade total" required>
        <input type="hidden" id="produto_estoque_hidden" value="${produto_estoque}">
    </div>
    <div class="col-sm-12 col-md-3">
        <label for="produto_min_estoque">Quantidade min em estoque <span class="text-danger">*</span> </label>
        <input type="number" class="form-control" name="produto_min_estoque" id="produto_min_estoque" value="${produto_min_estoque}" placeholder="Quantidade mínima" required>
    </div>
    <div class="col-sm-10 col-md-5">
        <label for="atributoAdd">Adicionar atributo ao produto</label>
        <select id="atributoAdd" class="form-control">
            <option v-if="!atributos">Nenhum atributo cadastrado</option>
            <option v-else v-for="att in atributos" :value="att.atributo_id">{{ att.atributo_nome }}</option>
        </select>
    </div>
    <div class="col-sm-2 col-md-1 align-self-end">
        <a class="btn btn-primary botoesAdd" id="btnAddAtributo" v-on:click="addAtributo()" style="cursor: pointer;" title="Adicionar atributo"><i class="fa fa-plus text-white"></i></a>
    </div>
</div>
<br>
<hr>
<div class="row">
    <div class="col-md-6 col-sm-6">
        <h4>Atributos</h4>
    </div>
    <div class="col-md-6 col-sm-6 text-right">
        <a v-on:click="show_modal_help_atributos()" style="cursor: pointer;">
            <i class="fa fa-info-circle"></i> Precisa de ajuda?
        </a>
    </div>

    <div class="col-sm-12" v-if="atributoAtual">
        <div id="breadcrumb_atributo">


        </div>
        <br>
        <div class="card">
            <div class="card-header text-white font-20">
                <a style="cursor: pointer;" v-if="breadcrumb.length > 0">
                    <span v-for="bread of breadcrumb">
                        {{ bread }} >
                    </span>
                </a>
                {{ atributoAtual.atributo_nome }}
                <a class="btn btn-danger btn-sm pull-right" v-if="atributoAtualPredominante" style="cursor: pointer;" v-on:click="prepareRemoveAtributo(atributoAtual.atributo_id)"><i class="fa fa-trash"></i></a>
                <a class="btn btn-info btn-sm text-white pull-right" style="cursor: pointer; margin-right: 10px;" v-if="atributoAtualIndice > 0" v-on:click="prevAtributo()">
                    <i class="fa fa-arrow-left" aria-hidden="true"></i> Voltar
                </a>
            </div>
            <div class="card-body">

                <!-- Loop por item do atributo -->
                <div v-if="atributoAtual.item.length > 0" v-for="(item, index) in atributoAtual.item" class="row" :data-id="item.item_atributo_id" data-att="item.item_atributo_atributo">
                    <div class="row w-100">
                        <div class="col-sm-12 col-md-12">
                            <h4>{{ item.item_atributo_nome }}</h4>

                        </div>
                    </div>

                    <!-- atributo de hexadecimal -->
                    <div v-if="atributoAtual.atributo_tipo == 2" class="w-100">
                        <div class="row">
                            <div class="col-sm-12 col-md-12">
                                <label for="">Hexadecimal</label>
                                <input type="color" class="form-control" onchange="changeAttr($(this).data('id'))" :id="'valor-' + item.item_atributo_id" :data-id="item.item_atributo_id + '|' + item.item_atributo_atributo + '|' + atributoAtual.relacao_atributo_id" data-att="item.item_atributo_atributo" :value="item.item_atributo_valor">
                            </div>
                        </div>

                    </div>
                    <!-- atributo de hexadecimal -->

                    <!-- atributo de imagem -->
                    <div v-if="atributoAtual.atributo_tipo == 3" class="w-100">
                        <div class="row">
                            <div class="col-sm-12 col-md-12">
                                <input type="file" :id="'valor-' + item.item_atributo_id" :name="'foto-attr-' + item.item_atributo_id + '|' + atributoAtual.atributo_id" data-allowed-file-extensions="png jpeg jpg" class="dropify" :data-default-file="'${baseUri}/media/atributos/' + item.relacao_atributo_valor" data-height="50" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12 col-md-12">
                                <button class="btn btn-primary btn-block btnSubmitFoto" :id="'foto-' + item.item_atributo_id"><i class="fas fa-check-circle"></i> Salvar foto
                                </button>
                            </div>
                        </div>
                    </div>
                    <!-- atributo de imagem -->

                    <div class="row" v-if="vm.atributoAtualPredominante">
                        <div class="col-sm-12 col-md-6">
                            <label for="">Quantidade em estoque</label>
                            <input type="number" class="form-control" onchange="changeAttr($(this).data('id'))" :id="'qtde-' + item.item_atributo_id" :data-id="item.item_atributo_id + '|' + item.item_atributo_atributo + '|' + atributoAtual.relacao_atributo_id" data-att="item.item_atributo_atributo" min="0" :value="item.item_atributo_qtd"> <br><br>
                        </div>
                        <div class="col-sm-12 col-md-6">
                            <label for="">Valor Adicional</label>
                            <input type="text" class="form-control moeda" onchange="changeAttr($(this).data('id'))" :id="'preco-' + item.item_atributo_id" :data-id="item.item_atributo_id + '|' + item.item_atributo_atributo + '|' + atributoAtual.relacao_atributo_id" data-att="item.item_atributo_atributo" placeholder="0.00" min="0" :value="item.item_atributo_preco"> <br><br>
                        </div>
                    </div>

                    <div class="w-100">
                        <div class="row">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <br>
                            <a class="btn btn-primary text-white" style="cursor: pointer;" v-if="atributoAtualIndice < qtdAtributos - 1" v-on:click="nextAtributo(index)">
                                <i class="fa fa-arrow-right" aria-hidden="true"></i> Próximo
                            </a>
                        </div>
                    </div>

                    <div class="col-sm-12">
                        <hr>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

<div id="modalHelpAtributos" class="modal fade" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="mySmallModalLabel">Dicas para usar os Atributos</h4>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body">
                <div class="col-md-12 text-center">
                    <h3>O que são os atributos?</h3>
                    <p>
                        Atributos são características avulsas que cada produto pode possuir. Você pode combinar diferentes atributos em seu produto, como por exemplo, <strong style="color: black;">Voltagem e Cores</strong> (um exemplo dessa aplicação seria a venda de um <strong style="color: black;">Liquidificador</strong> cuja voltagem é 110v e possui a cor Vermelha).
                    </p>
                    <p>
                        Antes de vincular os atributos em seu produto, é necessário que o mesmo tenha sido cadastrado previamente, junto de seus itens. Para cadastrar um atributo e gerenciar seus itens, basta <a href="${baseUri}/produtos-atributos" class="text-primary" target="_blank">clicar aqui.</a>
                    </p>

                    <h3>Como usar o sistema de atributos?</h3>
                    <p>
                        Existem 2 possíveis situações: <br>
                        <strong style="color: black;">1 - Produto com apenas 1 atributo</strong> <br>
                        Quando o produto tem apenas 1 atributo, toda lógica de estoque se aplica apenas a ele. Se desejavel, o atributo poderá ter um valor adicional mediante cadastro nessa mesma tela. <br>

                        <strong style="color: black;">2 - Produto com 2 ou mais atributos</strong> <br>
                        Quando se tem combinações de atributos, seja com 2 ou mais, a lógica de estoque se encontrará no último atributo da hierarquia. Por exemplo, caso tenha vinculado <strong style="color: black;">Voltagem</strong> e depois <strong style="color: black;">Cores</strong>, a lógica de estoque será encontrada em cores, mediante a escolha dos atributos anteriores primeiro (nesse caso, escolha uma voltagem para em seguida escolher uma cor).
                    </p>

                    <h3>Como funciona o sistema de estoque?</h3>
                    <p>
                        Quando o produto tem vínculo com algum atributo, a quantidade em estoque muda para ser as dos atributos. Caso o produto não tenha atributos, a quantidade em estoque passa a ser a comum, cadastrada no primeiro campo dessa tela.
                    </p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary waves-effect" data-dismiss="modal"><i class="fa fa-times-circle"></i> Fechar</button>

            </div>
        </div>
    </div>
</div>