<!DOCTYPE html>
<html lang="pt-br">

<head>
    <base href="${baseUri}/view/admin/">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="${config_site_description}">
    <meta name="author" content="${config_site_author}">
    <meta name="keywords" content="${config_site_keywords}">
    <meta name="author" content="${config_seo_author}">
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="${baseUri}/media/site/${config_site_favicon}">

    <title>${config_site_title} - Configurações da loja</title>
    <!-- Bootstrap Core CSS -->
    <link href="assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/plugins/toast-master/css/jquery.toast.css">
    <link href="assets/plugins/bootstrap-select/bootstrap-select.min.css" rel="stylesheet" />
    <link href="assets/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.css" rel="stylesheet" />
    <link href="assets/css/style.css" rel="stylesheet">
    <!-- You can change the theme colors from here -->
    <link href="assets/css/colors/${config_tema_color}.css" id="theme" rel="stylesheet">
    <!--[if lt IE 9]>
    <script src="assets/plugins/html5shiv.js"></script>
    <script src="assets/plugins/respond.min.js"></script>
    <![endif]-->
</head>

<body class="fix-header card-no-border logo-center">
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" />
        </svg>
    </div>

    <div id="main-wrapper">
        <!-- TOPO import -->
        @(admin.layout.topo)
        <!-- MENU import -->
        @(admin.layout.topo-menu)
        <!-- Page wrapper  -->
        <div class="page-wrapper">
            <!-- Container fluid  -->
            <div class="container-fluid">
                <!-- Bread crumb and right sidebar toggle -->
                <div class="row page-titles">
                    <div class="col-md-5 col-8 align-self-center">
                        <h3 class="text-themecolor m-b-0 m-t-0">Configurações da Loja</h3>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Configurações</a></li>
                            <li class="breadcrumb-item active">Configurações da Loja</li>
                        </ol>
                    </div>
                    <!-- Top Right Info -->
                    @(admin.layout.topo-info)
                </div>

                <!-- Start Page Content -->
                <div class="row">
                    <div class="col-12">
                        <div class="card card-outline-primary">
                            <div class="card-header">
                                <div class="row">
                                    <div class="col-sm-4 align-self-center">
                                        <i class="text-white fas fa-globe"></i>
                                    </div>
                                </div>

                            </div>
                            <div class="card-body">
                                <form method="post" action="${baseUri}/configuracao/gravar_modo/">
                                    <input type="hidden" name="config_id" value="1">
                                    <section class="container-fluid">
                                        <div class="row">
                                            <div class="col-sm-12">


                                                <br>
                                                <h4 class="separator-line">Tipo de Loja</h4>
                                                <hr>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="form-check2">
                                                    <input class="form-check-input" type="radio" name="config_site_modo" id="config_site_modo1" value="1" checked>
                                                    <label class="form-check-label" for="config_site_modo1">
                                                        Loja Padrão (Loja virtual padrão com todas as funcionalidades de compra)
                                                    </label>
                                                </div>
                                                <br>
                                                <div class="form-check2">
                                                    <input class="form-check-input" type="radio" name="config_site_modo" id="config_site_modo2" value="2">
                                                    <label class="form-check-label" for="config_site_modo2">
                                                        Carrinho de Orçamento (Exibe os produtos para criar um orçamento de preços e taxas)
                                                    </label>
                                                </div>
                                                <br>
                                                <div class="form-check2">
                                                    <input class="form-check-input" type="radio" name="config_site_modo" id="config_site_modo3" value="3">
                                                    <label class="form-check-label" for="config_site_modo3">
                                                        Vitrine (Exibe os produtos apenas para mostruário)
                                                    </label>
                                                </div>
                                            </div>

                                            <div class="col-12 text-center">
                                                <div class="form-group">
                                                    <br>
                                                    <button type="submit" id="btn-send" class="btn btn-primary"><i class="fas fa-check-circle"></i> Atualizar Dados
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </section>

                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End Page Content -->

            </div>
            <!-- Footer import-->
            @(admin.layout.footer)
            <!-- End Footer -->
        </div>
        <!-- End Page wrapper  -->
    </div>
    <!-- All Jquery -->
    
    <script src="assets/plugins/jquery/jquery.min.js"></script>
    <script src="assets/plugins/popper/popper.min.js"></script>
    <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.slimscroll.js"></script>
    <script src="assets/js/waves.js"></script>
    <script src="assets/js/sidebarmenu.js"></script>
    <script src="assets/plugins/sticky-kit-master/dist/sticky-kit.min.js"></script>
    <script src="assets/plugins/sparkline/jquery.sparkline.min.js"></script>
    <script src="assets/js/custom.min.js"></script>
    <script src="assets/plugins/toast-master/js/jquery.toast.js"></script>
    <script src="assets/plugins/styleswitcher/jQuery.style.switcher.js"></script>
    <script src="assets/plugins/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="assets/plugins/datatables.net/js/dataTables.rowReorder.min.js"></script>
    <script src="assets/plugins/bootstrap-select/bootstrap-select.min.js" type="text/javascript"></script>
    <script src="assets/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js" type="text/javascript"></script>
    <script src="assets/plugins/jquery.mask.min.js"></script>
    <script src="assets/js/jquery.cookie.js"></script>

    <script src="assets/plugins/summernote/dist/summernote-lite.min.js"></script>
    <script src="assets/plugins/summernote/dist/lang/summernote-pt-BR.js"></script>

    <script src="assets/js/vue.min.js"></script>
    <!-- FILE UPLOAD -->
    <script src="assets/plugins/dropzone-master/dist/dropzone.js"></script>
    <script src="assets/plugins/lightbox/js/lightbox.js"></script>
    <script src="assets/plugins/sortable/Sortable.js"></script>
    <script src="assets/plugins/dropify/dist/js/dropify.min.js"></script>

    <script src="${baseUri}/view/admin/app-js/datatable.js"></script>
    <script src="assets/plugins/datatables-button/dataTables.buttons.min.js"></script>
    <script src="assets/plugins/datatables-button/buttons.flash.min.js"></script>
    <script src="assets/plugins/datatables-button/jszip.min.js"></script>
    <script src="assets/plugins/datatables-button/pdfmake.min.js"></script>
    <script src="assets/plugins/datatables-button/vfs_fonts.js"></script>
    <script src="assets/plugins/datatables-button/buttons.html5.min.js"></script>
    <script src="assets/plugins/datatables-button/buttons.print.min.js"></script>
    <script src="${baseUri}/view/admin/app-js/endereco.js"></script>
    <script src="${baseUri}/view/admin/app-js/main.js"></script>
    <script type="text/javascript">
         $('.menu-configuracao').addClass('active');
         //$('.menu-layout').addClass('active');
        document.getElementById("config_site_modo${config_site_modo}").checked = true;
    </script>
</body>

</html>