<?php 
/*  
* Autor: rafael@clares.com.br - 2023
*  Usar  PNG-24
* $watermark = new Watermark('midias/fotos/a.jpg', 'midias/marca/marca.png');
* $watermark->setResize(200, 200)
*            ->setSize(200, 50)
*            ->addWatermark();    

* SUGESTAOOOOOOOOO
* $watermark = new Watermark('midias/fotos/a.jpg', 'midias/marca/marca.png');
* $watermark->resize(200, 200)
*            ->markersize(200, 50)
*            ->addWatermark();    
*/   
namespace PHPImager;

class Watermarker{
    private  $jpegFilePath;
    private  $pngFilePath;
    private  $saveAs;
    private  $resizeWidth = null;
    private  $resizeHeight = null;
    private  $watermarkWidth = null;
    private  $watermarkHeight = null;
    
    public function __construct( $jpegFilePath,  $pngFilePath, $saveAs = null)
    {
        $this->jpegFilePath = $jpegFilePath;
        $this->pngFilePath = $pngFilePath;
        $this->saveAs = $saveAs;
    }
    
    public function setResize( $width,  $height)
    {
        $this->resizeWidth = intval($width);
        $this->resizeHeight = intval($height);
        return $this;
    }
    
    public function setSize( $width,  $height)
    {
        $this->watermarkWidth = intval($width);
        $this->watermarkHeight = intval($height);
        return $this;
    }
    
    public function addWatermark( )
    {

/* APLICAR do ImageResizer pega o tipo auto, trocar var de jpegFilePath para  imagePath  na hora de exibir tbm copiar do imageResizer
        // Obtém as dimensões da imagem original
        $dimensions = getimagesize($this->imagePath);
        $originalWidth = $dimensions[0];
        $originalHeight = $dimensions[1];

            // Carrega a imagem original
            switch ($dimensions[2]) {
                case IMAGETYPE_JPEG:
                    $originalImage = imagecreatefromjpeg($this->imagePath);
                    break;
                case IMAGETYPE_PNG:
                    $originalImage = imagecreatefrompng($this->imagePath);
                    break;
                case IMAGETYPE_GIF:
                    $originalImage = imagecreatefromgif($this->imagePath);
                    break;
                default:
                    throw new Exception('tipo não suportado');
            }

            */

        // Carrega imagem JPG ou PNG
        $ext = explode(".",$this->jpegFilePath);
        $ext = strtolower(end($ext));
        if($ext == 'png'){
            $jpegImage = imagecreatefrompng($this->jpegFilePath);
        }else{
            $jpegImage = imagecreatefromjpeg($this->jpegFilePath);
        }
        
        // Redimensiona se especificado
        if ($this->resizeWidth !== null || $this->resizeHeight !== null) {
            $imageWidth = imagesx($jpegImage);
            $imageHeight = imagesy($jpegImage);
            
            if ($this->resizeWidth !== null && $this->resizeHeight !== null) {
                $ratioWidth = $imageWidth / $this->resizeWidth;
                $ratioHeight = $imageHeight / $this->resizeHeight;
                $ratio = max($ratioWidth, $ratioHeight);
                
                $newWidth = $imageWidth / $ratio;
                $newHeight = $imageHeight / $ratio;
            } else if ($this->resizeWidth !== null) {
                $newWidth = $this->resizeWidth;
                $newHeight = $imageHeight * intval($newWidth / $imageWidth);
            } else {
                $newHeight = $this->resizeHeight;
                $newWidth =  $imageWidth *  intval ($newHeight / $imageHeight);
            }            
            $resizedImage = imagecreatetruecolor(intval($newWidth), intval($newHeight));
            imagecopyresampled($resizedImage, $jpegImage, 0, 0, 0, 0, intval($newWidth), intval($newHeight), intval($imageWidth), intval($imageHeight));
            imagedestroy($jpegImage);
            $jpegImage = $resizedImage;
        }        
        $pngWatermark = imagecreatefrompng($this->pngFilePath);
        // Calcula posicao do centro 
        $imageWidth = imagesx($jpegImage);
        $imageHeight = imagesy($jpegImage);
        $watermarkWidth = $this->watermarkWidth ?? imagesx($pngWatermark);
        $watermarkHeight = $this->watermarkHeight ?? imagesy($pngWatermark);
        $watermarkPosX = ($imageWidth / 2) - ($watermarkWidth / 2);
        $watermarkPosY = ($imageHeight / 2) - ($watermarkHeight / 2);

        //redimensiona o tamanho da marca
        if ($watermarkWidth !== imagesx($pngWatermark) || $watermarkHeight !== imagesy($pngWatermark)) {
            $pngWatermark = imagescale($pngWatermark, $watermarkWidth, $watermarkHeight);
        }        
      
        // aplica marca
        imagecopy($jpegImage, $pngWatermark, intval($watermarkPosX), intval($watermarkPosY), 0, 0, imagesx($pngWatermark), imagesy($pngWatermark));
                
        // Salva no local especificado
        if ($this->saveAs !== null) {
            imagejpeg($jpegImage, $this->saveAs);
        } else {
            header('Content-Type: image/jpeg');
            imagejpeg($jpegImage);
        }
        // Destroy images
        imagedestroy($pngWatermark);
        imagedestroy($jpegImage);
    }  
}