<?php 
/*  
* Autor: rafael@clares.com.br - 2023
* $resizer = new ImageResizer('imagem_original.jpg', 800, 600, 'saveOrShow');
*/
namespace PHPImager;

class ImageResizer
{
    private  $imagePath;
    private  $maxWidth;
    private  $maxHeight;
    private  $saveToDisk;
    
    public function __construct( $imagePath,  $maxWidth,  $maxHeight, $saveToDisk = true)
    {
        $this->imagePath = $imagePath;
        $this->saveToDisk = $saveToDisk;
        $this->maxWidth = intval($maxWidth);
        $this->maxHeight = intval($maxHeight);
        $this->resize();
    }
    
    public function resize()
    {
        // Obtém as dimensões da imagem original
        $dimensions = getimagesize($this->imagePath);
        $originalWidth = $dimensions[0];
        $originalHeight = $dimensions[1];
        
        // Verifica se as dimensões originais são maiores que as informadas
        
        if ($originalWidth > $this->maxWidth || $originalHeight > $this->maxHeight) {
            // Calcula a proporção para manter a qualidade da imagem
            $ratio = min($this->maxWidth / $originalWidth, $this->maxHeight / $originalHeight);
            
            // Calcula as novas dimensões da imagem
            $newWidth = round($originalWidth * $ratio);
            $newHeight = round($originalHeight * $ratio);
        }else{
            $ratio = min($originalWidth / $originalWidth, $originalHeight / $originalHeight);
            $newWidth = round($originalWidth * $ratio);
            $newHeight = round($originalHeight * $ratio);
        }
        
        
        // Cria uma nova imagem com as dimensões redimensionadas
        $newImage = imagecreatetruecolor($newWidth, $newHeight);
        
        // Carrega a imagem original
        switch ($dimensions[2]) {
            case IMAGETYPE_JPEG:
                $originalImage = imagecreatefromjpeg($this->imagePath);
                break;
            case IMAGETYPE_PNG:
                $originalImage = imagecreatefrompng($this->imagePath);
             break;
            case IMAGETYPE_GIF:
                 $originalImage = imagecreatefromgif($this->imagePath);
            break;
            default:
            throw new \Exception('tipo não suportado');
        }
                    
                    // Redimensiona a imagem original para a nova imagem
                    imagecopyresampled($newImage, $originalImage, 0, 0, 0, 0, $newWidth, $newHeight, $originalWidth, $originalHeight);
                    
                    if ($this->saveToDisk) {
                        // Salva a nova imagem com o mesmo formato da imagem original
                        switch ($dimensions[2]) {
                            case IMAGETYPE_JPEG:
                                imagejpeg($newImage, $this->imagePath);
                                break;
                                case IMAGETYPE_PNG:
                                    imagepng($newImage, $this->imagePath);
                                    break;
                                    case IMAGETYPE_GIF:
                                        imagegif($newImage, $this->imagePath);
                                        break;
                                        default:
                                        throw new \Exception('Tipo não suportado');
                                    }
                                } else {
                                    // Exibe a nova imagem redimensionada na tela
                                    header('Content-type: ' . image_type_to_mime_type($dimensions[2]));
                                    switch ($dimensions[2]) {
                                        case IMAGETYPE_JPEG:
                                            imagejpeg($newImage);
                                            break;
                                            case IMAGETYPE_PNG:
                                                imagepng($newImage);
                                                break;
                                                case IMAGETYPE_GIF:
                                                    imagegif($newImage);
                                                    break;
                                                    default:
                                                    throw new \Exception('Tipo não suportado');
                                                }
                                            }
                                            // Libera a memória das imagens
                                            imagedestroy($originalImage);
                                            imagedestroy($newImage);
                                            
                                        }
                                    }
                                    