<?php

namespace Frete;

class MelhorEnvio
{

    /*
		    SERVICOS:
		    1 - PAC    - correios
		    2 - SEDEX  - correios
		    3 - .Package - jadlog
		    4 - .Com -  jadlog
		    9 -  Rodoviario - Via Brasil
		    12 - efacil - Latam
		    15 - amanha - azul
		    16 - ecommerce - azul
		    17 - mini envios - correios
		    22 - rodoviario - buslog
		    27 - .package centralizado - jadolog
		    28 - pac centralizado - correios
		    29 - sedex centralizado - correios
		    30  - mini envio centralizado - correios
	*/
    public $services = [1, 2, 3, 4, 9, 15, 16, 17, 22, 27, 28, 29, 30];

    public function __construct()
    {
    }

    public function indexAction()
    {
    }

    public function get_frete($conf, $produtos)
    {
        $refresh = self::atualizar_token();
        $conf = (object) $conf;
        $produtos = (object) $produtos;
        $cb = "";
        $url_me = "https://melhorenvio.com.br";
        // $this->url_me = "https://sandbox.melhorenvio.com.br";
        if ($refresh) {
            $conf->melhorenvio_token = $refresh;
        }
        $access_token = $conf->melhorenvio_token;
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url_me . "/api/v2/me/shipment/calculate");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        $itens = [];
        $conf->cep_origem = str_replace("-", "", $conf->cep_origem);
        $conf->cep_destino = str_replace("-", "", $conf->cep_destino);

        foreach ($produtos as $k) {
            $k = (object) $k;
            if ($k->produto_calcula_frete > 0) {
                $itens[] = [
                    "id" => $k->produto_id,
                    "height" => str_replace(",", ".", $k->altura),
                    "length" => str_replace(",", ".", $k->comprimento),
                    "quantity" => $k->quantidade,
                    "weight" => str_replace(",", ".", $k->peso),
                    "width" => str_replace(",", ".", $k->largura),
                    "insurance_value" => $k->produto_preco,
                ];
            }
        }
        $body = [
            "from" => [
                "postal_code" => $conf->cep_origem,
            ],
            "to" => [
                "postal_code" => $conf->cep_destino,
            ],
            "products" => $itens,
            "services" => $conf->melhorenvio_servicos,
        ];
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($body));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Accept: application/json",
            "Content-Type: application/json",
            "Authorization: Bearer $access_token",
        ]);
        $response = curl_exec($ch);
        curl_close($ch);
        $res = json_decode($response);
        $result = [];

        if (is_array($res) && count($res) > 0) {
            $prices = [];
            $dvtime = [];
            $ordem = [];
            foreach ($res as $serv) {
                if (!isset($serv->error) && empty($serv->error)) {
                    $ordem["$serv->price"] = $serv;
                }
            }
            ksort($ordem);
            $res = $ordem;
            if (sizeof($res) > 5) {
                $res = array_slice($res, 0, 5);
            }
            foreach ($res as $serv) {
                //if (!isset($serv->error) && empty($serv->error)) {
                $result[] = [
                    "code" => $serv->name,
                    "price" => $serv->price,
                    "name" => $serv->company->name . " - " . $serv->name,
                    "deadline" => $serv->delivery_time,
                    "rastreio" => 1
                ];
                // if(!in_array($serv->price, $prices) && !in_array($serv->delivery_time, $dvtime) ){
                /*
					                    if (intval($serv->price) > 0) {
											$prices["$serv->price"] = $serv->price;
											$dvtime["$serv->delivery_time"] = $serv->delivery_time;
											$cb .= '<tr>';
											$cb .= '<td width=20>';
											$cb .= '<input type="radio" class="btn-update-frete" name="tipo_frete[]" id="' . $serv->id . '"  t="' . $serv->company->name . ' ' . $serv->name . '" value="' . $serv->price . '|' . $serv->delivery_time . '" v="' . $this->double($serv->price) . '" p="' . $serv->delivery_time . '"  melhorEnvioId="' . $serv->id . '"
					                    l="' . $serv->packages[0]->dimensions->length . '"
					                    w="' . $serv->packages[0]->dimensions->width . '"
					                    h="' . $serv->packages[0]->dimensions->height . '"
					                    we="' . $serv->packages[0]->weight . '"
					                    e="' . $serv->packages[0]->insurance_value . '"

					                    />';
											$cb .= '</td>';
											$cb .= '<td>';
											$cb .= '<label for="' . $serv->id . '"><b>';
											if ($serv->price == "") {
												$cb .= 'Frete Grátis';
											} else {
												$cb .= "R$ " . str_replace(".", ",", $serv->price);
											}
											$cb .= '&nbsp;&nbsp;&nbsp;&nbsp;' . $serv->company->name . ' - ' . $serv->name . ' - ' . $serv->delivery_time . ' dia(s)</b>';
											$cb .= '</label>';
											$cb .= '</td>';
											$cb .= '</tr>';
										}
				*/
                //}
            }
        }
        return $result;
    }

    public function autorizacao_callback()
    {
        $frete = (new \Factory('frete'))->find(1);
        $config = (new \Config)->get();

        if (isset($_GET['code']) && !empty($_GET['code']) && !empty($frete->frete_melhorenvio_secret)) {
            $api = [
                "grant_type" => "authorization_code",
                "client_id" => intval($frete->frete_melhorenvio_client_id),
                "client_secret" => $frete->frete_melhorenvio_secret,
                "redirect_uri" => \Frete::get_melhorenvio_callback_url($frete),
                "code" => $_GET['code'],
            ];

            $curl = curl_init();

            curl_setopt_array($curl, [
                CURLOPT_URL => "https://melhorenvio.com.br/oauth/token",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => json_encode($api),
                CURLOPT_HTTPHEADER => [
                    "Accept: application/json",
                    "Content-Type: application/json",
                    "User-Agent: $config->config_site_title ($config->config_site_email)",
                ],
            ]);

            $response = curl_exec($curl);
            $err = curl_error($curl);

            curl_close($curl);

            if ($err) {
                \Http::redirect_to('/frete?error&curl_error');
            } else {
                $response = json_decode($response);
                if (isset($response->access_token) && !empty($response->access_token) && isset($response->refresh_token) && !empty($response->refresh_token)) {
                    $add = [
                        'frete_id' => 1,
                        'frete_melhorenvio_token' => $response->access_token,
                        'frete_melhorenvio_refresh_token' => $response->refresh_token,
                        'frete_melhorenvio_data_refresh_token' => date('Y-m-d'),
                    ];
                    (new \Factory('frete'))->with($add)->save();
                    \Http::redirect_to('/frete?success');
                } else {
                    \Http::redirect_to('/frete?error');
                }
            }
        }
    }

    public function atualizar_token()
    {
        $config = (new \Config)->get();
        $data_atual = date('Y-m-d');

        $frete = (new \Factory('frete'))
            ->select('frete_melhorenvio_client_id, frete_melhorenvio_secret, frete_melhorenvio_refresh_token, frete_melhorenvio_data_refresh_token')
            ->where("frete_id = 1 AND DATEDIFF('$data_atual',frete_melhorenvio_data_refresh_token) = 21")
            ->get();

        $frete = (isset($frete[0]) && is_array($frete)) ? $frete[0] : null;

        if ($frete && !empty($frete->frete_melhorenvio_client_id) && !empty($frete->frete_melhorenvio_secret)) {

            $api = [
                "grant_type" => "refresh_token",
                "client_id" => intval($frete->frete_melhorenvio_client_id),
                "client_secret" => $frete->frete_melhorenvio_secret,
                "redirect_uri" => \Frete::get_melhorenvio_callback_url($frete),
                "refresh_token" => $frete->frete_melhorenvio_refresh_token,
            ];

            $curl = curl_init();

            curl_setopt_array($curl, [
                CURLOPT_URL => "https://melhorenvio.com.br/oauth/token",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => json_encode($api),
                CURLOPT_HTTPHEADER => [
                    "Accept: application/json",
                    "Content-Type: application/json",
                    "User-Agent: $config->config_site_title ($config->config_site_email)",
                ],
            ]);

            $response = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);

            if (!$err) {
                $response = json_decode($response);
                if (isset($response->access_token) && !empty($response->access_token) && isset($response->refresh_token) && !empty($response->refresh_token)) {
                    $add = [
                        'frete_id' => 1,
                        'frete_melhorenvio_token' => $response->access_token,
                        'frete_melhorenvio_refresh_token' => $response->refresh_token,
                        'frete_melhorenvio_data_refresh_token' => date('Y-m-d'),
                    ];
                    (new \Factory('frete'))->with($add)->save();
                    return $response->access_token;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
}
