<!DOCTYPE html>
<html lang="pt-br">

<head>
    <title>${config_site_title}
        <?php if (isset($data['config']->config_site_slogan) && !empty($data['config']->config_site_slogan)) : ?>- ${config_site_slogan} <?php endif; ?></title>
    <!-- SEO -->
    @(tema.loja.partials.meta_tags)
    @(tema.loja.partials.og_tags)
    <!-- SEO -->
    <link rel="icon" type="image/png" sizes="32x32" href="${baseUri}/media/site/${config_site_favicon}">
    @(tema.loja.partials.css-padrao)
    <style>
        .card-body {
            min-height: 150px;
        }

        .card-body h4 {
            font-weight: bold;
        }
    </style>
</head>

<body>
    <!-- SEO -->
    @(tema.loja.partials.google_analytics)
    @(tema.loja.partials.google_tag_manager)
    <!-- SEO -->

    @(tema.loja.partials.menu-superior)

    <div class="hide-on-desk" style="position: relative; margin-top: 100px !important"></div>
    <div class="${config_site_layout_custom}" id="vm">

        <div class="row" v-if="pedido != null">
            <div class="col-sm-12">
                <div class="page-title-wrapper mt-3" aria-label="Page">
                    <div class="container">
                        <div class="row justify-content-between">
                            <div class="col-sm-12 col-md-8 align-self-center">
                                <nav aria-label="breadcrumb">
                                    <ol class="breadcrumb">
                                        <li class="mt-n1 mr-1"><i data-feather="home"></i></li>
                                        <li class="breadcrumb-item"><a class="custom_loja_texto" href="${baseUri}">Home</a></li>
                                        <li class="breadcrumb-item"><a class="custom_loja_texto" href="${baseUri}/area-cliente">Pedidos</a></li>
                                        <li class="breadcrumb-item"><a class="custom_loja_texto">Detalhes do <span v-if="pedido.pedido_tipo == 1">Pedido</span> <span v-if="pedido.pedido_tipo == 2">Orçamento</span></a></li>
                                    </ol>
                                </nav>
                            </div>
                            <div class="col-sm-12 col-md-4">
                                <a href="${baseUri}/area-cliente" class="btn btn-primary btn-sm pull-right"> <i class="fa fa-arrow-left"></i> Voltar </a>
                            </div>
                            <div class="col-sm-12 col-md-8">
                                <h1 class="pt-4 custom_loja_texto">
                                    <i class="fa fa-shopping-cart" aria-hidden="true"></i> Detalhes do <span v-if="pedido.pedido_tipo == 1">Pedido</span> <span v-if="pedido.pedido_tipo == 2">Orçamento</span><span class="h3 font-weight-semibold custom_loja_texto"> # {{ pedido_id }}</span>
                                </h1>
                                <h3 class="pt-4"> <span class="text-muted custom_loja_texto">Status do <span v-if="pedido.pedido_tipo == 1">Pedido</span> <span v-if="pedido.pedido_tipo == 2">Orçamento</span>:</span> <span v-if="pedido != null" :class="'badge badge-' + pedido.pedido_status_badge + ' m-0'">{{ pedido.pedido_status_nome }}</span></h3>
                                <h5 v-if="pedido != null" class="custom_loja_texto">Última atualização em {{pedido.pedido_atualizacao}}</h5>
                                <div class="custom_loja_texto" v-if="pedido != null && pedido.pedido_info == 'deposito' && pedido.pedido_tipo == 1">
                                    <br>
                                    <h4 class="mt-2 custom_loja_texto">Dados Pix / Transf.</h4>
                                    <?= $data['deposito_texto']; ?>
                                </div>
                                <div v-if="pedido.pedido_tipo == 1">
                                    <a class="btn btn-primary btn-sm mt-4 mb-3" target="_blank" href="${baseUri}/pedido-imprimir/<?= isset($data['pedido_id']) ? $data['pedido_id'] : '' ?>"> <i class="fa fa-print" aria-hidden="true"></i> Imprimir Pedido </a>
                                    <a v-if="pedido != null && pedido.pedido_info == 'boleto'" class="btn btn-primary btn-sm mt-4 mb-3" target="_blank" :href="pedido.pedido_pay_url"> <i class="fa fa-print" aria-hidden="true"></i> Imprimir Boleto </a>

                                    <a v-if="pedido != null && pedido.pedido_info.toLowerCase() == 'pix' && pedido.pedido_status == 1" id="btn-pix" class="btn btn-success btn-sm mt-4 mb-3" href="${baseUri}/pedido-pagar-pix/${pedido_id}" target="_blank">
                                        Pagar com pix
                                    </a>

                                    <a v-if="pedido != null && pedido.pedido_comprovante != null" class="btn btn-primary btn-sm mt-4 mb-3" :href="'${baseUri}/Common/download_comprovante/' + pedido.pedido_comprovante" target="_blank"> <i class="fa fa-eye"></i> Visualizar Comprovante</a>
                                    <label v-if="pedido != null && pedido.pedido_info == 'deposito' && pedido.pedido_comprovante == null" class="btn btn-warning btn-sm mt-4 mb-3" style="cursor: pointer;" for="fileComprovante"> <i class="fa fa-file"></i> Anexar Comprovante</label>
                                    <label v-if="pedido != null && pedido.pedido_info == 'deposito' && pedido.pedido_comprovante != null" class="btn btn-warning btn-sm mt-4 mb-3" style="cursor: pointer;" for="fileComprovante"> <i class="fa fa-file"></i> Alterar Comprovante</label>
                                    <br>

                                    <!-- anexar comprovante -->
                                    <form v-if="pedido != null && pedido.pedido_info == 'deposito'" action="${baseUri}/anexar-comprovante" method="post" id="formComprovante" enctype="multipart/form-data">
                                        <input type="hidden" name="pedido_id" value="<?= isset($data['pedido_id']) ? $data['pedido_id'] : '' ?>">
                                        <input type="file" onchange="$('#formComprovante').submit()" name="fileComprovante" id="fileComprovante" style="display: none;" accept=".pdf,image/*">
                                    </form>
                                    <br>
                                    <label v-if="pedido != null && pedido.pedido_barcode != null" class="custom_loja_texto"> <i class="fa fa-barcode mr-2"></i> Linha Digitável do boleto <br> {{ pedido.pedido_barcode }}</label>

                                </div>
                            </div>

                            <!-- Caso de entrega -->
                            <div class="col-sm-12 col-md-4" v-if="pedido != null && pedido.pedido_endereco_cliente != null">
                                <h2 class="pt-4 custom_loja_texto">
                                    <i class="fa fa-map-marker" aria-hidden="true"></i> Endereço de Entrega
                                </h2>
                                <p class="text-muted">
                                    <span class="custom_loja_texto" v-if="pedido.pedido_endereco_cliente.endereco_cliente_rua != null">{{ pedido.pedido_endereco_cliente.endereco_cliente_rua }}</span>
                                    <span class="custom_loja_texto" v-if="pedido.pedido_endereco_cliente.endereco_cliente_num != null"><br>Nº {{ pedido.pedido_endereco_cliente.endereco_cliente_num }}</span>
                                    <span class="custom_loja_texto" v-if="pedido.pedido_endereco_cliente.endereco_cliente_complemento != null"> - {{ pedido.pedido_endereco_cliente.endereco_cliente_complemento }}</span>
                                    <span class="custom_loja_texto" v-if="pedido.pedido_endereco_cliente.endereco_cliente_bairro != null"><br> {{ pedido.pedido_endereco_cliente.endereco_cliente_bairro }}</span>
                                    <span class="custom_loja_texto" v-if="pedido.pedido_endereco_cliente.endereco_cliente_cidade != null"> - {{ pedido.pedido_endereco_cliente.endereco_cliente_cidade }}</span>
                                    <span class="custom_loja_texto" v-if="pedido.pedido_endereco_cliente.endereco_cliente_uf != null">, {{ pedido.pedido_endereco_cliente.endereco_cliente_uf }}</span>
                                    <span class="custom_loja_texto" v-if="pedido.pedido_endereco_cliente.endereco_cliente_cep != null"><br>CEP: {{ pedido.pedido_endereco_cliente.endereco_cliente_cep }}</span>
                                </p>
                                <h5 class="custom_loja_texto" v-if="pedido.pedido_tipo == 1">Entrega prevista para {{ pedido.pedido_data_entrega }}</h5>

                                <div v-if="respostas != null">
                                    <h4 class="pt-4 custom_loja_texto">
                                        <i class="fa fa-list" aria-hidden="true"></i> Informações preenchidas
                                    </h4>

                                    <div v-for="res in respostas">
                                        <h5 class="custom_loja_texto">
                                            {{ res.campo_checkout_respostas_pergunta }}
                                            <br>
                                            <span class="text-muted custom_loja_texto">

                                                - {{ res.campo_checkout_respostas_resposta }}
                                            </span>
                                        </h5>

                                    </div>
                                </div>
                            </div>

                            <!-- Caso de retirada -->
                            <div class="col-sm-12 col-md-4" v-if="pedido != null && pedido.retirada != null">
                                <h2 class="pt-4 custom_loja_texto">
                                    <i class="fa fa-map-marker" aria-hidden="true"></i> Endereço de Retirada
                                </h2>
                                <p class="text-muted custom_loja_texto">
                                    <span class="custom_loja_texto" v-if="pedido.retirada.retirada_rua != null">{{ pedido.retirada.retirada_rua }}</span>
                                    <span class="custom_loja_texto" v-if="pedido.retirada.retirada_num != null"><br>Nº {{ pedido.retirada.retirada_num }}</span>
                                    <span class="custom_loja_texto" v-if="pedido.retirada.retirada_complemento != null"> - {{ pedido.retirada.retirada_complemento }}</span>
                                    <span class="custom_loja_texto" v-if="pedido.retirada.retirada_bairro != null"><br> {{ pedido.retirada.retirada_bairro }}</span>
                                    <span class="custom_loja_texto" v-if="pedido.retirada.retirada_cidade != null"> - {{ pedido.retirada.retirada_cidade }}</span>
                                    <span class="custom_loja_texto" v-if="pedido.retirada.retirada_uf != null">, {{ pedido.retirada.retirada_uf }}</span>
                                    <span class="custom_loja_texto" v-if="pedido.retirada.retirada_cep != null"><br>CEP: {{ pedido.retirada.retirada_cep }}</span>

                                    <span v-if="pedido.retirada.retirada_telefone != null && pedido.retirada.retirada_horario != null">
                                        <h4 class="custom_loja_texto">Atendimento</h4>
                                        <span class="custom_loja_texto"><i class="fa fa-clock" aria-hidden="true"></i> {{ pedido.retirada.retirada_horario }} </span> <br>
                                        <span class="custom_loja_texto"><i class="fa fa-phone" aria-hidden="true"></i> {{ pedido.retirada.retirada_telefone }} </span> <br>
                                    </span>
                                </p>

                                <div v-if="respostas != null">
                                    <h4 class="pt-4 custom_loja_texto">
                                        <i class="fa fa-list" aria-hidden="true"></i> Informações preenchidas
                                    </h4>

                                    <div v-for="res in respostas">
                                        <h5 class="custom_loja_texto">
                                            {{ res.campo_checkout_respostas_pergunta }}
                                            <br>
                                            <span class="text-muted custom_loja_texto">

                                                - {{ res.campo_checkout_respostas_resposta }}
                                            </span>
                                        </h5>

                                    </div>
                                </div>
                            </div>


                            <div class="col-sm-12 col-md-3 mt-2">
                                <div class="card  mt-2">
                                    <div class="card-body text-center custom_botoesPrincipais_fundo custom_botoesPrincipais_texto" v-if="pedido != null">
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <i class="fa fa-shopping-cart fa-3x custom_botoesPrincipais_texto" aria-hidden="true"></i>
                                            </div>
                                            <div class="col-sm-9 custom_botoesPrincipais_texto">
                                                <h4 class="custom_botoesPrincipais_texto">
                                                    Produtos
                                                </h4>
                                                {{ pedido.pedido_total_produto }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12 col-md-3 mt-2">
                                <div class="card  mt-2">
                                    <div class="card-body text-center custom_botoesPrincipais_fundo custom_botoesPrincipais_texto" v-if="pedido != null">
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <i class="fa fa-truck fa-3x" aria-hidden="true"></i>
                                            </div>
                                            <div class="col-sm-9">
                                                <h4 class="custom_botoesPrincipais_texto">
                                                    Frete
                                                </h4>
                                                <span class="" v-if="Number(pedido.pedido_frete) > 0">
                                                    {{ Number(pedido.pedido_frete).toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' }) }}
                                                </span>
                                                <span class="" v-if="Number(pedido.pedido_frete) == 0">Grátis</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12 col-md-3 mt-2" v-if="pedido.pedido_cupom_desconto != null || pedido.pedido_cupom_info != null">
                                <div class="card  mt-2">
                                    <div class="card-body text-center custom_botoesPrincipais_fundo custom_botoesPrincipais_texto">
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <i class="fa fa-percent fa-3x" aria-hidden="true"></i>
                                            </div>
                                            <div class="col-sm-9">
                                                <h4 class="custom_botoesPrincipais_texto">
                                                    Descontos
                                                </h4>
                                                {{ (pedido.pedido_desconto) ? 
                                                                Number(pedido.pedido_desconto).toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' }) : '--'  }}
                                                <span v-html="pedido.pedido_cupom_info"></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12 col-md-3 mt-2">
                                <div class="card  mt-2">
                                    <div class="card-body text-center custom_botoesPrincipais_fundo custom_botoesPrincipais_texto" v-if="pedido != null">
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <i class="fa fa-money fa-3x" aria-hidden="true"></i>
                                            </div>
                                            <div class="col-sm-9">
                                                <h4 class="custom_botoesPrincipais_texto">
                                                    Total
                                                    <small v-if="pedido.pedido_total_parcelado_ori > pedido.pedido_total_ori ">
                                                        parcelado {{ pedido.pedido_parcelas }}x
                                                    </small>
                                                </h4>
                                                <span v-if="pedido.pedido_total_parcelado_ori <= pedido.pedido_total">
                                                    {{ Number(pedido.pedido_total).toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' }) }}
                                                </span>
                                                <span v-else>
                                                    {{ pedido.pedido_total_parcelado }} <br>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr class="mt-4">
                    </div>
                </div>
            </div>

        </div>
        <div class="">
            <div class="col-sm-12" v-if="pedido != null">
                <!-- Item-->
                <div class="d-sm-flex mb-4 pb-4 border-bottom" v-for="item of pedido.lista">
                    <div class="media d-block d-sm-flex text-center text-sm-left  col-sm-12 col-md-6">
                        <a class="cart-item-thumb mx-auto mr-sm-4">
                            <img :src="'${baseUri}/thumb/resize/?w=100&h=100&f=' + item.lista_pedido_foto" alt="Produto" style="width:60px !important">
                        </a>
                        <div class="media-body pt-3">
                            <p class="font-weight-semibold border-0 pb-0 custom_loja_texto">
                                <a>{{ item.lista_pedido_produto_titulo }}</a>
                            </p>
                            <div v-if="item.atributos != undefined">
                                <div class="font-size-sm" v-for="att of item.atributos">
                                    <span class="text-muted mr-2">{{ att.lista_pedido_atributo_attnome }}:</span>{{ att.lista_pedido_atributo_itemnome }}
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="pt-2 pt-sm-3 pl-sm-3 mx-auto mx-sm-0 text-center col-sm-12 col-md-3">
                        <div class="text-muted mb-sm-2 custom_loja_texto">Quantidade:</div>
                        <div class="font-weight-semibold custom_loja_texto">{{ item.lista_pedido_qtde }}</div>
                    </div>
                    <div class="pt-2 pt-sm-3 pl-sm-3 mx-auto mx-sm-0 text-center col-sm-12 col-md-3">
                        <div class="text-muted mb-sm-2 custom_loja_texto">Valor:</div>
                        <div class="font-weight-semibold custom_loja_texto">R$ {{ item.lista_pedido_preco }}</div>
                    </div>
                </div>
                <!-- Item-->

            </div>
        </div>
    </div>
    @(tema.loja.partials.toasts)
    @(tema.loja.partials.footer)
    <script>
        const baseUri = "${baseUri}";
        var pedido_id = <?= $data['pedido_id']; ?>;
    </script>
    <script src="assets/js/jquery.min.js"></script>

    <script src="assets/js/vendor.min.js"></script>
    <script src="assets/js/theme.min.js"></script>
    <script src="assets/js/toasts.js"></script>
    <script src="assets/js/template.js"></script>
    <script src="assets/js/vue.min.js"></script>
    <script src="assets/js/carrinho.js"></script>
    <script src="assets/js/clipboard.js"></script>
    <script src="assets/js/main.js?v=<?= rand(); ?>"></script>
    <script src="pedido/index.js" defer></script>
</body>

</html>