// Start functions
$(document).ready(function () {
    $(".carousel").carousel();

    $("#slideVertical").owlCarousel({
        autoplay: true,
        nav: false,
        dots: true,
        loop: true,
        margin: 15,
        item: 1,
        responsive: {
            0: {
                items: 1,
            },
            768: {
                items: 1,
            },
            1000: {
                items: 1,
            },
        },
    });

    $("#slideTop").owlCarousel({
        nav: false,
        dots: true,
        loop: true,
        margin: 15,
        item: 1,
        responsive: {
            0: {
                items: 1,
            },
            768: {
                items: 1,
            },
            1000: {
                items: 1,
            },
        },
    });

    $("#div-slide-marcas .owl-carousel").owlCarousel({
        autoplay: true,
        nav: false,
        dots: true,
        loop: true,
        margin: 10,
        item: 4,
        responsive: {
            0: {
                items: 1,
            },
            768: {
                items: 4,
            },
            1000: {
                items: 4,
            },
        },
    });

    let parcs = parseInt($("#div-slide-parceiros .owl-carousel IMG").length);
    if (parcs >= 4) parcs = 4;

    $("#div-slide-parceiros .owl-carousel").owlCarousel({
        autoplay: true,
        nav: false,
        dots: true,
        loop: true,
        margin: 10,
        item: 4,
        responsive: {
            0: {
                items: 1,
            },
            768: {
                items: parcs,
            },
            1000: {
                items: parcs,
            },
        },
    });

    let width = window.innerWidth;

    if (width < 799) {
        $(".add_div_carousel").addClass("custom-carousel");
        $("#produtosDestaque,#produtosOferta, #produtosNovo")
            .attr("class", "owl-carousel")
            .owlCarousel({
                nav: true,
                dots: false,
                loop: true,
                margin: 15,
                item: 1,
                responsive: {
                    0: {
                        items: 1,
                    },
                    768: {
                        items: 1,
                    },
                    1000: {
                        items: 1,
                    },
                },
            });
    }

    if (window.location.href.indexOf("success") != -1) {
        alert_success("Ação realizada com sucesso!");
    }
});

// Functions
function showSearch() {
    $("#offcanvas-search").toggle("slow");
}

function showQuickView(id) {
    vm.getProduto(id);
}

function setProdutoInCarrinho(prod = null) {
    if (prod != null) {
        let produto = JSON.parse(prod);
        produto.produto_imagens = [
            {
                foto_produto_id: 0,
                foto_produto_img: produto.produto_foto,
            },
        ];
        let url = baseUri + "/carrinho/insereProdutoCarrinho";
        produto.qtd = 1;
        $.post(url, { produto: produto }).then((res) => {
            vmCarrinho.listarCarrinho();
            if (res.trim() == "1") {
                alert_success("Produto adicionado ao carrinho!");
            } else if (res.trim() == "0") {
                alert_error("Erro ao adicionar produto no carrinho!", "CÓD: 0");
            } else if (res.trim() == "-1") {
                alert_warning("Produto indisponível");
            }
        });
    }
}
