var vm = new Vue({
    el: "#vm",
    data: {
        cupom: null,
        cupom_desconto: 0,
        desconto_total: 0,
        frete: null,
        totalProdutos: null,
        totalCompra: null,
        totalCompraSemFormatacao: null,
        cardIsValid: false,
        loadingPage: true, // pode ser usado para uma splash screen
        validandoCartao: false,
        descontoBoleto: false,
        valorDescontoBoleto: null,
        totalBoleto: null,
        // selects e opções adicionais
        anos: [],
        campos_extras: null,
        produtos_carrinho: null,
        carrinho: null,
        valorFrete: null,
        totalDescontoFrete: null,
        totalSemDescontoFrete: null,
        descontoReal: 0,
        parcelas: 0,
    },
    methods: {
        get_produtos_carrinho: () => {
            let url = baseUri + "/carrinho/getCarrinho";
            $.post(url).then((res) => {
                if (res) {
                    res = JSON.parse(res);
                    vm.carrinho = res;
                    vm.produtos_carrinho = res.carrinho;
                } else {
                    vm.produtos_carrinho = null;
                }
            });
        },
        get_campos_extras: () => {
            let url = baseUri + "/CamposExtras/get_campos_extras";
            $.post(url).then((res) => {
                res = JSON.parse(res);
                if (res.status != undefined && res.status == 200) {
                    vm.campos_extras = res.campos;
                } else {
                    // Redirect para tela de carrinho, pois não tem nenhum item no carrinho
                }
            });
        },
        get_respostas_campos_extras: () => {
            if (vm.campos_extras != null) {
                let respostas = [];
                $(".campos_checkout").each((i, el) => {
                    let id = $(el).data("id");
                    let pergunta = $(el).data("pergunta");
                    let resposta = $(el).val();
                    if (resposta.trim() == "") {
                        alert_error(
                            "Responda todas as perguntas para prosseguir"
                        );
                        $(el).focus();
                        return false;
                    }
                    respostas.push({
                        campo_checkout_id: id,
                        pergunta: pergunta,
                        resposta: resposta,
                    });
                });

                return respostas;
            }
        },

        // -- verifica se existe um cupom com os valores digitados pelo usuário
        verifyCupom: () => {
            var self = this;
            $("#msgCupom").html("");
            let cupom = $("#cupomValue").val().trim();
            let url = baseUri + "/CupomFront/getCupom";
            $.post(url, { cupom: cupom }).then((res) => {
                res = JSON.parse(res);
                if (res.error == null) {
                    vm.cupom = res.cupom;
                    if (vm.cupom.cupom_desconto > 0) {
                        window.location.reload();
                    }
                } else {
                    $("#cupomValue")
                        .attr("placeholder", res.error)
                        .val("")
                        .attr("style", "border: 1px solid red");
                    setTimeout(() => {
                        window.location.reload();
                    }, 700);
                }
            });
        },
        // Verifica se existe um cupom já setado para aplicar desconto
        getCupom: () => {
            let url = baseUri + "/FreteFront/getValorCupom";
            $.post(url).then((res) => {
                if (res != null && res != "") {
                    res = JSON.parse(res);
                    if (res.cupom != undefined) {
                        vm.cupom = res.cupom;
                        $("#cupomValue").val(vm.cupom.cupom_alfa);
                    }
                }
            });
        },

        // --frete
        getFrete: () => {
            let url = baseUri + "/FreteFront/getValorFrete";
            $.post(url).then((res) => {
                if (res != null && res != "") {
                    res = JSON.parse(res);
                    if (res.frete != undefined) {
                        vm.frete = res.frete;
                        $(".valorFrete").html(
                            `${Number(vm.frete.price).toLocaleString("pt-BR", {
                                style: "currency",
                                currency: "BRL",
                            })}`
                        );
                    }
                }
            });
        },

        goToFrete: () => {
            let url = baseUri + "/FreteFront/clearFrete";
            $.post(url).then((res) => {
                if (res.trim() == "1") {
                    window.location.href = baseUri + "/checkout";
                }
            });
        },
        paymentBoleto: () => {
            if (vm.campos_extras != null) {
                let respostas = vm.get_respostas_campos_extras();

                if (respostas.length == vm.campos_extras.length) {
                    let data = {
                        cupom: vm.cupom,
                        frete: vm.frete,
                        metodo: "boleto",
                        respostas: respostas,
                    };
                    let url = baseUri + "/PagamentoFront/payment";
                    $("#modalProcessandoPagamento").modal("show");
                    $.post(url, data).then((res) => {
                        if (res != null) {
                            res = JSON.parse(res);
                            if (res.redirect != null) {
                                window.location.href = res.redirect;
                            } else if (res.error) {
                                $("#modalProcessandoPagamento").modal("hide");
                                alert_warning(res.error);
                            } else if (res.pedido_id != undefined) {
                                window.location.href =
                                    baseUri +
                                    "/pedido-detalhes/" +
                                    res.pedido_id;
                            }
                        }
                    });
                }
            } else {
                let data = {
                    cupom: vm.cupom,
                    frete: vm.frete,
                    metodo: "boleto",
                };
                let url = baseUri + "/PagamentoFront/payment";
                $("#modalProcessandoPagamento").modal("show");
                $.post(url, data).then((res) => {
                    if (res != null) {
                        res = JSON.parse(res);
                        if (res.redirect != null) {
                            window.location.href = res.redirect;
                        } else if (res.error) {
                            $("#modalProcessandoPagamento").modal("hide");
                            alert_warning(res.error);
                        } else if (res.pedido_id != undefined) {
                            window.location.href =
                                baseUri + "/pedido-detalhes/" + res.pedido_id;
                        }
                    }
                });
            }
        },
        paymentDeposito: () => {
            if (vm.campos_extras != null) {
                let respostas = vm.get_respostas_campos_extras();

                if (respostas.length == vm.campos_extras.length) {
                    let data = {
                        cupom: vm.cupom,
                        frete: vm.frete,
                        metodo: "deposito",
                        respostas: respostas,
                    };
                    let url = baseUri + "/PagamentoFront/payment";
                    $("#modalProcessandoPagamento").modal("show");
                    $.post(url, data).then((res) => {
                        if (res != null) {
                            res = JSON.parse(res);
                            if (res.redirect != null) {
                                window.location.href = res.redirect;
                            } else if (res.error) {
                                $("#modalProcessandoPagamento").modal("hide");
                                alert_warning(res.error);
                            } else if (res.pedido_id != undefined) {
                                window.location.href =
                                    baseUri +
                                    "/pedido-detalhes/" +
                                    res.pedido_id;
                            }
                        }
                    });
                }
            } else {
                let data = {
                    cupom: vm.cupom,
                    frete: vm.frete,
                    metodo: "deposito",
                };
                let url = baseUri + "/PagamentoFront/payment";
                $("#modalProcessandoPagamento").modal("show");
                $.post(url, data).then((res) => {
                    if (res != null) {
                        res = JSON.parse(res);
                        if (res.redirect != null) {
                            window.location.href = res.redirect;
                        } else if (res.error) {
                            $("#modalProcessandoPagamento").modal("hide");
                            alert_warning(res.error);
                        } else if (res.pedido_id != undefined) {
                            window.location.href =
                                baseUri + "/pedido-detalhes/" + res.pedido_id;
                        }
                    }
                });
            }
        },
        paymentPix: () => {
            if (vm.campos_extras != null) {
                let respostas = vm.get_respostas_campos_extras();

                if (respostas.length == vm.campos_extras.length) {
                    let data = {
                        cupom: vm.cupom,
                        frete: vm.frete,
                        metodo: "pix",
                        respostas: respostas,
                    };
                    let url = baseUri + "/PagamentoFront/payment";
                    $("#modalProcessandoPagamento").modal("show");
                    $.post(url, data).then((res) => {
                        if (res != null) {
                            try {
                                res = JSON.parse(res);
                                if (res.redirect != null) {
                                    window.location.href = res.redirect;
                                } else if (res.error) {
                                    $("#modalProcessandoPagamento").modal(
                                        "hide"
                                    );
                                    alert_warning(res.error);
                                } else if (res.pedido_id != undefined) {
                                    window.location.href =
                                        baseUri +
                                        "/pedido-pagar-pix/" +
                                        res.pedido_id;
                                }
                            } catch (err) {
                                console.log(err);
                            }
                        }
                    });
                }
            } else {
                let data = {
                    cupom: vm.cupom,
                    frete: vm.frete,
                    metodo: "pix",
                };
                let url = baseUri + "/PagamentoFront/payment";
                $("#modalProcessandoPagamento").modal("show");
                $.post(url, data).then((res) => {
                    if (res != null) {
                        try {
                            res = JSON.parse(res);
                            if (res.redirect != null) {
                                window.location.href = res.redirect;
                            } else if (res.error) {
                                $("#modalProcessandoPagamento").modal("hide");
                                alert_warning(res.error);
                            } else if (res.pedido_id != undefined) {
                                window.location.href =
                                    baseUri +
                                    "/pedido-pagar-pix/" +
                                    res.pedido_id;
                            }
                        } catch (err) {
                            console.log(err);
                        }
                    }
                });
            }
        },
        payment: () => {
            if (vm.campos_extras != null) {
                let respostas = vm.get_respostas_campos_extras();

                if (respostas.length == vm.campos_extras.length) {
                    $("#modalProcessandoPagamento").modal("show");
                    let cardToken = $("#card_token").val();
                    let parcelas = $("#card_parcela").val();
                    let cardholderName = $("#cardholderName").val();
                    let doc = $("#docNumber").val();
                    let paymentMethodId = $("#paymentMethodId").val();

                    // variavel enviada para o php
                    let data = {
                        card_token: cardToken,
                        cardholderName: cardholderName,
                        docNumberFake: doc,
                        card_parcela: parcelas,
                        paymentMethodId: paymentMethodId,
                        cupom: vm.cupom,
                        frete: vm.frete,
                        metodo: "cartao",
                        respostas: respostas,
                    };

                    // request para salvar o pedido, efetuar o pagamento no mp e redireciona para o detalhes do pedido
                    let url = baseUri + "/PagamentoFront/payment";
                    $.post(url, data).then((res) => {
                        if (res != null) {
                            res = JSON.parse(res);
                            if (res.redirect != null) {
                                window.location.href = res.redirect;
                            } else if (res.error) {
                                $("#modalProcessandoPagamento").modal("hide");
                                alert_warning(res.error);
                            } else if (res.pedido_id != undefined) {
                                window.location.href =
                                    baseUri +
                                    "/pedido-detalhes/" +
                                    res.pedido_id;
                            }
                        }
                    });
                }
            } else {
                $("#modalProcessandoPagamento").modal("show");
                let cardToken = $("#card_token").val();
                let parcelas = $("#card_parcela").val();
                let cardholderName = $("#cardholderName").val();
                let doc = $("#docNumber").val();
                let paymentMethodId = $("#paymentMethodId").val();

                // variavel enviada para o php
                let data = {
                    card_token: cardToken,
                    cardholderName: cardholderName,
                    docNumberFake: doc,
                    card_parcela: parcelas,
                    paymentMethodId: paymentMethodId,
                    cupom: vm.cupom,
                    frete: vm.frete,
                    metodo: "cartao",
                };

                // request para salvar o pedido, efetuar o pagamento no mp e redireciona para o detalhes do pedido
                let url = baseUri + "/PagamentoFront/payment";
                $.post(url, data).then((res) => {
                    if (res != null) {
                        res = JSON.parse(res);
                        if (res.redirect != null) {
                            window.location.href = res.redirect;
                        } else if (res.error) {
                            $("#modalProcessandoPagamento").modal("hide");
                            alert_warning(res.error);
                        } else if (res.pedido_id != undefined) {
                            window.location.href =
                                baseUri + "/pedido-detalhes/" + res.pedido_id;
                        }
                    }
                });
            }
        },
        inicializaMercadoPago: (reload = false) => {
            var public_key = $("#pay_key").val();
            if (vm.frete == null) {
                vm.frete = { price: 0 };
            }
            vm.totalCompraSemFormatacao = vm.carrinho.info.total_desconto;
            vm.totalCompra = vm.carrinho.info.total_desconto;
            vm.totalCompras = Number(vm.totalCompra).toLocaleString("pt-BR", {
                style: "currency",
                currency: "BRL",
            });

            //console.log(vm.carrinho.info);
            vm.valorFrete = Number(vm.carrinho.info.frete);
            vm.totalBoleto = vm.carrinho.info.subtotal_desconto;
            vm.totalDescontoFrete = vm.carrinho.info.total_desconto_frete;
            vm.totalSemDescontoFrete =
                vm.carrinho.info.total_sem_desconto_frete;
            vm.totalProdutos = vm.carrinho.info.total;
            vm.descontoReal =
                vm.carrinho.info.total.replace(".", "").replace(",", ".") -
                vm.carrinho.info.subtotal_desconto
                    .replace(".", "")
                    .replace(",", ".");

            let descontoPix = Number(vm.descontoReal);
            vm.descontoReal = Number(vm.descontoReal).toLocaleString("pt-BR", {
                style: "currency",
                currency: "BRL",
            });
            vm.parcelas = vm.carrinho.info.parcelas;
            vm.cupom_desconto = Number(vm.carrinho.info.cupom.desconto);
            vm.cupom = vm.carrinho.info.cupom;

            vm.valorDescontoBoleto = Number($("#desconto_boleto").val());
            $("#transactionAmount").val(vm.carrinho.info.total);

            vm.desconto_total = vm.carrinho.info.desconto_total;

            vm.desconto_total = Number(vm.desconto_total).toLocaleString(
                "pt-BR",
                {
                    style: "currency",
                    currency: "BRL",
                }
            );

            $(".updateCardTotal").on("click", function () {
                console.clear();
                let produtos = $(this).data("produtos");
                let total = $(this).data("total");
                let frete = $(this).data("frete");
                let desconto = $(this).data("desconto");

                $(".valorTotal").text(total);
                $(".valorFrete").text(frete);
                $(".valorCupom").text(desconto);

                console.log("Produtos: " + produtos);
                console.log("Total: " + total);
                console.log("Frete: " + frete);
                console.log("Cupom: " + vm.carrinho.info.cupom.desconto);
                console.log("Desconto Pix: " + desconto);
                console.log(
                    "Desconto Total: " + vm.carrinho.info.desconto_total
                );
            });
            $("#transactionAmount").val(vm.carrinho.info.total);

            //console.log(vm.carrinho.info.total_cartao);
            //=console.log(vm.carrinho.info);

            var cpfCnpj = function (val) {
                    return val.replace(/\D/g, "").length > 11
                        ? "00.000.000/0000-00"
                        : "000.000.000-009";
                },
                cpfOptions = {
                    onKeyPress: function (val, e, field, options) {
                        field.mask(cpfCnpj.apply({}, arguments), options);
                    },
                };
            $(".cpfCnpj").mask(cpfCnpj, cpfOptions);
            if (reload) {
                var bin = $("#cardNumber").val();
                bin = bin.replace(/\s/g, "");
                // var bin = bin.substring(0,3);
                getPaymentMethod(bin);
                return true;
            }
            Mercadopago.setPublishableKey(public_key);
            Mercadopago.getIdentificationTypes();

            $("#docNumber2").blur(function () {
                let documento = $("#docNumber2").val();

                documento = documento
                    .split(".")
                    .join("")
                    .split("-")
                    .join("")
                    .split("/")
                    .join("");
                $("#docNumber").val(documento);
            });
            $("#cardNumber").on("change", function () {
                var bin = $("#cardNumber").val();
                bin = bin.replace(/\s/g, "");
                // var bin = bin.substring(0,3);
                getPaymentMethod(bin);
            });

            $(".cardField").on("change", function () {
                vm.cardIsValid = false;
            });

            function getPaymentMethod(bin) {
                Mercadopago.getPaymentMethod(
                    {
                        bin: bin,
                    },
                    setPaymentMethodInfo
                );
                var val_total = vm.carrinho.info.total_cartao;
                // parcelas
                Mercadopago.getInstallments(
                    {
                        bin: bin,
                        amount: val_total,
                    },
                    setInstallmentInfo
                );
            }

            $("#docNumberFake").on("keyup", function () {
                var number = $("#docNumberFake").val();
                var desired = number.replace(/[^a-z0-9 -]/g, "");
                desired = desired.replace(/-/g, "");
                desired = desired.replace(/\s+/g, "");
                $("#docNumber").val(desired);
            });

            function setPaymentMethodInfo(status, response) {
                if (status == 200) {
                    $("#paymentMethodId").val(response[0].id);
                }
            }

            function setInstallmentInfo(status, response) {
                if (status == 200) {
                    var issuer_id = response[0].issuer.id;
                    $("#issuer_id").val(issuer_id);
                    var parcelas = response[0].payer_costs;
                    fill_parcelas(parcelas);
                }
            }

            function fill_parcelas(parcelamento) {
                $("#card_parcela option").remove();
                let maxInstallments = $("#maxInstallments").val();
                $.each(parcelamento, function (k, v) {
                    if (k < maxInstallments) {
                        $("<option />")
                            .attr(
                                "data-amount",
                                parseFloat(v.total_amount).toFixed(2)
                            )
                            .val(v.installments)
                            .text(v.recommended_message)
                            .appendTo($("#card_parcela"));
                    }

                    $("#card_parcela").trigger("change");
                });
            }

            $("#verificar-dados").on("click", function (event) {
                vm.validandoCartao = true;
                var $form = document.querySelector("#pay");
                Mercadopago.createToken($form, sdkResponseHandler); // The function "sdkResponseHandler" is defined below
            });

            function sdkResponseHandler(status, response) {
                $(".error-signal-secury").addClass("hide");
                $(".error-signal-cardN").addClass("hide");
                $(".error-signal-ano").addClass("hide");
                $(".error-signal-mes").addClass("hide");
                $(".error-signal-cardName").addClass("hide");
                $(".error-signal-doc").addClass("hide");
                if (status != 200 && status != 201) {
                    var error = response.cause;
                    //console.log(error);
                    $("#msg-error").removeClass("hide");
                    $.each(error, function (key, item) {
                        var code = item.code;
                        switch (code) {
                            case "325":
                                $("#cardExpirationMonth").val("");
                                $(".error-signal-mes").removeClass("hide");
                                alert_warning("Mês de validade inválido");
                                break;
                            case "326":
                                $("#cardExpirationYear").val("");
                                $(".error-signal-ano").removeClass("hide");
                                alert_warning("Ano de validade inválido");
                                break;
                            case "E301":
                                $("#cardNumber").val("");
                                $(".error-signal-cardN").removeClass("hide");
                                alert_warning("Número do cartão inválido");
                                break;
                            case "E302":
                                $("#securityCode").val("");
                                $(".error-signal-secury").removeClass("hide");
                                alert_warning("Código de segurança inválido");
                                break;
                            case "316":
                                $("#cardholderName").val("");
                                $(".error-signal-cardName").removeClass("hide");
                                alert_warning("Titular do cartão inválido");
                                break;
                            case "324":
                                $("#docNumber").val("");
                                $("#docNumberFake").val("");
                                $(".error-signal-doc").removeClass("hide");
                                alert_warning("CPF/CNPJ inválido");
                                break;
                            default:
                                alert_warning("Dados de cartão inválidos!");
                                break;
                        }
                    });

                    vm.cardIsValid = false;
                } else {
                    vm.cardIsValid = true;
                    $("#card_token").val(response.id);
                    $("#msg-error").addClass("hide");
                    $("#verificar-dados").toggleClass("hide");
                    $("#comprar-creditos-true").toggleClass("hide");
                }
                vm.validandoCartao = false;
            }

            new Card({
                form: document.getElementById("pay"),
                formSelectors: {
                    numberInput: 'input[name="cardNumber"]',
                    expiryInput: 'input[name=""]',
                    cvcInput: 'input[name="securityCode"]',
                    nameInput: 'input[name="cardholderName"]',
                },
                placeholders: {
                    number: "•••• •••• •••• ••••",
                    name: "Nome do Titular",
                    expiry: "••/••",
                    cvc: "•••",
                },
                container: ".card-wrapper",
            });
            // $('#docNumberFake').mask('999.999.999-99 000');
            // $("#cardNumber").mask('9999 9999 9999 9999');
            // $('#documento').mask('999.999.999-99 000');
            if (!reload) {
                vm.loadingPage = false;
            }
        },
    },
    created: function () {
        this.get_campos_extras();
        this.get_produtos_carrinho();
        setTimeout(() => {
            this.getFrete();
            this.getCupom();
        }, 1500);

        setTimeout(() => {
            $("#cep").mask("99999-999");
            $(".two-numbers").mask("99");
            $(".numbers").mask("999999");
            this.totalProdutos = vmCarrinho.total;
            this.totalCompra = Number(vmCarrinho.total_desconto);
            this.inicializaMercadoPago();
        }, 2000);

        let anoAtual = new Date().getFullYear();
        for (let i = anoAtual; i < anoAtual + 10; i++) {
            this.anos.push(i);
        }
    },
});
