<!DOCTYPE html>
<html lang="pt-br">

<head>
    <title>${config_site_title}
        <?php if (isset($data['config']->config_site_slogan) && !empty($data['config']->config_site_slogan)) : ?>
            - ${config_site_slogan}
        <?php endif; ?>
    </title>
    <!-- SEO -->
    @(tema.loja.partials.meta_tags)
    @(tema.loja.partials.og_tags)
    <!-- SEO -->
    <link rel="icon" type="image/png" sizes="32x32" href="${baseUri}/media/site/${config_site_favicon}">
    @(tema.loja.partials.css-padrao)
    <style>
        .ipt-error {
            border: 1px solid red !important;
        }

        .ipt-success {
            border: 1px solid green !important;
        }
    </style>
</head>

<body>
    <!-- SEO -->
    @(tema.loja.partials.google_analytics)
    @(tema.loja.partials.google_tag_manager)
    <!-- SEO -->

    @(tema.loja.partials.menu-superior)
    <div class="hide-on-desk" style="position: relative; margin-top: 100px !important"></div>
    <!-- Page Content-->
    <div class="${config_site_layout_custom} pt-4 pb-4" id="vm">
        <div class="page-title-wrapper" aria-label="Page title">
            <div class="container">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="mt-n1 mr-1"><i data-feather="home" class="custom_loja_texto"></i></li>
                        <li class="breadcrumb-item"><a class="custom_loja_texto" href="${baseUri}">Home</a>
                        </li>
                        <li class="breadcrumb-item active"><a class="custom_loja_texto" href="#">Checkout</a>
                        </li>
                    </ol>
                </nav>
            </div>
        </div>
        <!-- Steps (wizard)-->
        <div class="steps">
            <div class="steps-body">
                <a class="step step-completed custom_loja_texto" href="${baseUri}/carrinho">
                    <span class="step-indicator"><i data-feather="check"></i></span>
                    <span class="step-icon "><i data-feather="shopping-bag" class="custom_loja_texto"></i></span>1. Carrinho
                </a>
                <a class="step step-completed custom_loja_texto" href="#" v-on:click="goToFrete()">
                    <span class="step-indicator"><i data-feather="check"></i></span>
                    <span class="step-icon"><i data-feather="truck" class="custom_loja_texto"></i></span>2. Frete
                </a>
                <a class="step step-active custom_loja_texto">
                    <span class="step-icon"><i data-feather="credit-card" class="custom_loja_texto"></i></span>3. Pagamento
                </a>
                <a class="step custom_loja_texto" href="#" style="cursor: not-allowed   ;"><span class="step-icon custom_loja_texto"><i data-feather="check-circle"></i></span>4. Detalhes do pedido</a>
            </div>
        </div>
        <div class="row pt-4 mt-2">
            <!-- Content-->
            <input type="hidden" id="pay_user" value="">
            <input type="hidden" id="maxInstallments" value="<?= $data['maxInstallments'] ?>">

            <div class="col-xl-9 col-md-8">
                <!-- Possíveis campos extras -->
                <div v-if="campos_extras != null">
                    <h2 class="h6 px-4 py-3 bg-secondary mb-4 custom_menu_texto_no_hover">
                        Preencha o formulário abaixo antes de realizar o pagamento</h2>
                    <div class="row" v-for="campo in campos_extras">
                        <div class="col-sm-12">
                            <label class="custom_loja_texto" :for="'campo-extra-' + campo.campo_checkout_id">{{ campo.campo_checkout_nome }} <span class="text-danger">*</span> </label>
                            <input type="text" class="form-control campos_checkout" :data-id="campo.campo_checkout_id" :data-pergunta="campo.campo_checkout_nome">
                            <br>
                        </div>
                    </div>

                </div>
                <!-- Possíveis campos extras -->
                <h2 class="h6 px-4 py-3 bg-secondary mb-4 custom_menu_fundo custom_menu_texto_no_hover font_smooth">Pague com PIX</h2>
                <div class="mb-4" id="payment-method">


                    <!-- Card de Boleto -->
                    <input type="hidden" id="desconto_boleto" value="<?= $data['desconto_boleto'] ?>">

                    <!-- Card de depósito -->

                    <div class="">

                        <div class="" id="deposito" data-parent="#payment-method" role="tabpanel">
                            <div class="card-body custom_loja_fundo">
                                <div class="row">
                                    <div class="col-sm-12 text-center">
                                        <h3 v-if="totalCompraSemFormatacao != null" class="custom_loja_texto">Total:
                                            {{ Number(totalCompraSemFormatacao).toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' }) }}
                                        </h3>
                                        <h3 v-else>
                                            Total: {{totalCompra}}
                                    </div>
                                    <div class="col-sm-12 text-center">
                                        <button class="btn btn-success" v-on:click="paymentDeposito()">Concluir Compra</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <!-- Sidebar-->
            <div class="col-xl-3 col-md-4 pt-4 mt-3 pt-md-0 mt-md-0">
                <h2 class="h6 px-4 py-3 bg-secondary text-center custom_menu_fundo custom_menu_texto_no_hover font_smooth"><i class="fa fa-shopping-cart pull-left"></i> Carrinho</h2>
                <!-- Loop carrinho -->
                <div v-for="cart in produtos_carrinho" class="mb-2">
                    <div class="media">
                        <div class="featured-entry-thumb mr-3">
                            <a :href="'${baseUri}/produto/' + cart.produto.produto_url">
                                <img :src="'${baseUri}/thumb/resize/?w=100&h=100&f=' + cart.produto.produto_imagens[0].foto_produto_img" width="64" alt="Produto">
                            </a>
                        </div>
                        <div class="media-body">
                            <h6 class="featured-entry-title">
                                <a class="custom_loja_texto" :href="'${baseUri}/produto/' + cart.produto.produto_url">{{ cart.produto.produto_titulo }}</a>
                            </h6>
                            <p class="featured-entry-meta custom_loja_texto"> {{ cart.produto.qtd }} <span class='text-muted'>x</span> R$ {{ cart.produto.produto_preco }}</p>
                        </div>
                    </div>
                    <!-- atributos -->
                    <div class="row" v-if="cart.produto.atributos_selecionados != null">
                        <div v-for="(att, index) in cart.produto.nomes_atributos" class="font-size-sm col-sm-6" style="font-size: .775rem !important;">
                            <span class="text-muted mr-2 custom_loja_texto">{{ att.atributo_nome }}:</span>{{ cart.produto.nomes_atributos_selecionados[index] }}
                        </div>
                        <hr>
                    </div>
                    <!-- atributos -->
                </div>
                <!-- Loop carrinho -->
                <br>
                <hr><br>
                <h2 class="h6 px-4 py-3 bg-secondary text-center custom_menu_fundo custom_menu_texto_no_hover font_smooth"><i class="fa fa-info-circle pull-left"></i> Detalhes da compra</h2>
                <div class="font-size-sm border-bottom pt-2 pb-3">
                    <div class="d-flex justify-content-between mb-2 custom_loja_texto"><span>Produtos:</span><span class="valorSubtotal"></span></div>
                    <div class="d-flex justify-content-between custom_loja_texto"><span>Descontos:</span><span class="valorCupom">&mdash;</span></div>
                    <div class="d-flex justify-content-between mb-2 custom_loja_texto"><span>Frete:</span><span class="valorFrete">&mdash;</span></div>
                </div>
                <div class="h3 font-weight-semibold text-center py-3 custom_loja_texto"> R$ <span class="valorTotal">{{ totalSemDescontoFrete }}</span></div>
                <br>
                <hr><br>
                <h2 class="h6 px-4 py-3 bg-secondary text-center custom_menu_fundo custom_menu_texto_no_hover font_smooth"><i class="fa fa-ticket pull-left"></i> Cupom de desconto</h2>
                <div class="form-group">
                    <input class="form-control" type="text" id="cupomValue" placeholder="Cupom" required>
                    <div id="msgCupom" class="text-success">

                    </div>
                </div>
                <button class="btn btn-outline-primary btn-block" id="btn-add-cupom" v-on:click="verifyCupom()">Aplicar cupom</button>
            </div>
        </div>
    </div>
    <!-- Modal realizando pagamento -->
    <div class="modal fade" id="modalProcessandoPagamento" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <br>
                    <div class="text-center">
                        <h4>Aguarde, pagamento sendo processado...</h4>
                        &nbsp;
                        <img src="${baseUri}/media/default/loading.svg" alt="" width="80">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Fim modal realizando pagamento -->
    @(tema.loja.partials.footer-checkout)
    <script>
        const baseUri = "${baseUri}";
    </script>
    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/js/vendor.min.js"></script>
    <script src="assets/js/theme.min.js"></script>
    <script src="assets/js/toasts.js"></script>
    <script src="assets/js/template.js"></script>
    <script src="assets/js/vue.min.js"></script>
    <script src="assets/js/carrinho.js?v=${rand}"></script>
    <script src="assets/js/validacoes.js"></script>
    <script src="assets/js/main.js?v=${rand}"></script>
    <script src="assets/js/jquery.mask.min.js"></script>
    <script src="assets/js/card.min.js"></script>

    <script src="checkout/pagamento/deposito/index.js?v=${rand}" defer></script>

</body>

</html>