var vm = new Vue({
    el: "#vm",
    data: {
        carrinho: null,
        qtdItens: null,
        subtotal: null,
        subtotal_desconto: null,
        total: 0,
        opcoesFrete: null,
        loadingFrete: false,
        lastItem: null,
    },
    methods: {
        listar: function () {
            let url = baseUri + "/carrinho/getCarrinho";
            $.post(url).then((res) => {
                if (res) {
                    res = JSON.parse(res);
                    vm.carrinho = res.carrinho;
                    vm.qtdItens = res.info.qtd_itens;
                    vm.subtotal = res.info.subtotal;
                    vm.total = res.info.total;
                    vm.subtotal_desconto = Number(res.info.subtotal_desconto);
                    if (loja_modo == 1) {
                        setTimeout(() => {
                            if (res.info.compra_min.compra_min_check == false) {
                                $(".btn-fin-compra").text(
                                    "Faltam R$ " +
                                        res.info.compra_min.compra_min_rest +
                                        " para concluir a compra"
                                );
                                $(".btn-fin-compra").attr(
                                    "href",
                                    "javascript:void(0);"
                                );
                            } else {
                                $(".btn-fin-compra").text("Concluir Compra");
                                $(".btn-fin-compra").attr(
                                    "href",
                                    baseUri + "/checkout"
                                );
                            }
                            $(".qtd-ipt-cart").on("change", function () {
                                vm.atualizaItemCarrinho($(this).data("cart"));
                            });
                        }, 500);
                    }
                } else {
                    vm.carrinho = null;
                }
            });
        },
        removeItemCarrinho: (id) => {
            let url = baseUri + "/carrinho/removeProduto";
            $.post(url, { carrinho_id: id }).then((res) => {
                if (res.trim() == "1") {
                    vm.listar();
                    vmCarrinho.listarCarrinho();
                    alert_success("Produto removido do carrinho");
                } else {
                    alert_warning(
                        "Não foi possível remover o item do carrinho"
                    );
                }
            });
        },
        atualizaItemCarrinho: (id) => {
            let qtd = $("#qtd-" + id).val();
            if (qtd <= 0) {
                qtd = 1;
            }
            vm.lastItem = id;
            let max = $("#qtd-" + id).attr("max");
            if (qtd > max) {
                $("#qtd-" + id).val(max);
                return false;
            }
            let url = baseUri + "/carrinho/atualizaProduto";
            $.post(url, { carrinho_id: id, qtd: qtd }).then((res) => {
                if (res.trim() == "1") {
                    vm.listar();
                    vmCarrinho.listarCarrinho();
                    alert_success("Carrinho atualizado com sucesso!");
                } else if (res.trim() == "-1") {
                    alert_warning("Quantidade indisponível");
                    vm.rollBackItemCarrinho();
                } else {
                    alert_warning("Não foi possível atualizar o carrinho!");
                }
            });
        },
        rollBackItemCarrinho: () => {
            $("#qtd-" + vm.lastItem).val($("#qtd-" + vm.lastItem).attr("max"));
            vm.lastItem = null;
        },
        getFrete: () => {
            let cep = $("#cepVal").val().trim();

            if (cep == "") {
                alert_warning("CEP Vazio!");
                $("#cepVal").focus();
            } else {
                let url = baseUri + "/freteFront/get_frete/?cep=" + cep;
                vm.loadingFrete = true;
                $.post(url, { cep: cep }).then((res) => {
                    if (res != null) {
                        let result = JSON.parse(res);
                        if (result.error != undefined) {
                            alert_warning(result.error);
                            vm.loadingFrete = false;
                        } else {
                            vm.opcoesFrete = result[0];
                            vm.loadingFrete = false;
                        }
                    }
                });
            }
        },
        upload_arquivo: (carrinho_id) => {
            $("#form-arquivo-" + carrinho_id).submit();
            // let arquivo = $("#btn-arquivo-" + carrinho_id).get(0).files[0];
            // var fd = new FormData();

            // fd.append('arquivo', arquivo, arquivo.name);

            // let url = baseUri + "/carrinho/salva_arquivo/" + carrinho_id;
            // fetch(url, { method: 'post', body: fd })
            //     .then(res => {
            //         res.json()
            //     })
            //     .then(res => {
            //         console.log("Sucesso");
            //         console.log(res)
            //         // if(res.status == 200) {
            //         //     alert_success("Arquivo anexado com sucesso!");
            //         //     vm.listar();
            //         // }
            //     }).catch(e => {
            //         console.log("Erro");
            //         console.log(e)
            //         alert_error("Não foi possível anexar o arquivo!");
            //     })
        },
    },
    created: function () {
        this.listar();

        setTimeout(function () {
            $("#cepVal").mask("99999-999");
        }, 1000);
    },
});

if (window.location.href.indexOf("?error") != -1) {
    alert_error(
        "Ocorreu um erro ao salvar seu pedido. Por favor, tente novamente"
    );
}

if (window.location.href.indexOf("?erro-arquivo") != -1) {
    alert_error("Anexe um arquivo nos produtos com essa opção!");
}
