<!DOCTYPE html>
<html lang="pt-br">

<head>
    <base href="${baseUri}/view/admin/">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="${config_site_description}">
    <meta name="author" content="${config_site_author}">
    <meta name="keywords" content="${config_site_keywords}">
    <meta name="author" content="${config_seo_author}">
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="${baseUri}/media/site/${config_site_favicon}">
    <title>Relatório de Visitas | ${config_site_title}</title>
    <!-- Bootstrap Core CSS -->
    <link href="assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="assets/plugins/toast-master/css/jquery.toast.css">

    <!-- chartist CSS -->
    <link href="assets/plugins/chartist-js/dist/chartist.min.css" rel="stylesheet">
    <link href="assets/plugins/chartist-js/dist/chartist-init.css" rel="stylesheet">
    <link href="assets/plugins/chartist-plugin-tooltip-master/dist/chartist-plugin-tooltip.css" rel="stylesheet">
    <!--This page css - Morris CSS -->
    <link href="assets/plugins/c3-master/c3.min.css" rel="stylesheet">


    <link href="assets/css/style.css" rel="stylesheet">
    <!-- You can change the theme colors from here -->
    <link href="assets/css/colors/${config_tema_color}.css" id="theme" rel="stylesheet">
    <!--[if lt IE 9]>
    <script src="assets/plugins/html5shiv.js"></script>
    <script src="assets/plugins/respond.min.js"></script>
    <![endif]-->
</head>

<body class="fix-header card-no-border logo-center">
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" />
        </svg>
    </div>

    <div id="main-wrapper">
        <!-- TOPO import -->
        @(admin.layout.topo)
        <!-- MENU import -->
        @(admin.layout.topo-menu)
        <!-- Page wrapper  -->
        <div class="page-wrapper">
            <!-- Container fluid  -->
            <div class="container-fluid">
                <!-- Bread crumb and right sidebar toggle -->
                <div class="row page-titles">
                    <div class="col-md-5 col-8 align-self-center">
                        <h3 class="text-themecolor m-b-0 m-t-0">Produtos</h3>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0)">Loja</a></li>
                            <li class="breadcrumb-item"><a href="javascript:void(0)">Relatórios</a></li>
                            <li class="breadcrumb-item active">Pedidos por Cupom</li>
                        </ol>
                    </div>
                    <!-- Top Right Info -->
                    @(admin.layout.topo-info)
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card card-outline-primary">
                            <div class="card-header"><i class="text-white fas fa-chart-bar"></i> </div>

                            <div class="card-body" id="vm">
                                <div class="content">

                                    <div id="tbl-div" class="m-ts-40">
                                        <table id="datatable" class="datatable display nowrap table table-hover table-striped table-bordered"
                                            cellspacing="0" width="100%">
                                            <thead>
                                                <tr>
                                                    <th>Pedido <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                    <th>Data <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                    <th>Cliente <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                    <th>Método <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                    <th>Valor <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                    <th>Cupom <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                    <th>Desconto <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                    <th class="d-print-none text-right" width="120">Ações</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr v-for="post in pedidos" :class="'pedido-editar-' + post.pedido_id" :id="'pedido-id-' + post.pedido_id">
                                                    <td>{{post.pedido_id}}</td>
                                                    <td>{{post.pedido_data}}</td>
                                                    <td class="text-capitalize">{{post.cliente_nome}}</td>
                                                    <td class="text-capitalize">{{post.pedido_info}}</td>
                                                    <td>
                                                        <span v-if="post.pedido_tipo == 1">{{post.pedido_total_frete}}</span>
                                                        <span v-if="post.pedido_tipo == 2">{{post.pedido_total_produto}}</span>
                                                    </td>
                                                    <td>{{post.pedido_cupom_alfa}}</td>
                                                    <td v-if="post.cupom_tipo == 2">{{post.cupom_desconto}} %</td>
                                                    <td v-if="post.cupom_tipo == 1">R$ {{post.cupom_real}} </td>
                                                    <td v-if="post.cupom_tipo <= 0"> &nbsp;</td>
                                                    <td class="d-print-none text-right">
                                                        <a class="btn btn-sm text-white btn-primary waves-effect waves-light  menu-acces" title="Ver pedido" data-toggle="tooltip" data-id="ProdutosAdmin:G"
                                                            target="_blank"
                                                            :href="'${baseUri}/ver-pedido/id/' + post.pedido_id">
                                                            <i class="fas fa-search"></i>
                                                        </a>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <!-- End Page Content -->
            <!-- Config Tema botão float import -->

        </div>
        <!-- Footer import-->
        @(admin.layout.footer)
        <!-- End Footer -->
    </div>
    <!-- End Page wrapper  -->
    </div>
    <!-- All Jquery -->
    <script src="assets/plugins/jquery/jquery.min.js"></script>
    <script src="assets/plugins/jquery.mask.min.js"></script>
    <!-- Bootstrap tether Core JavaScript -->
    <script src="assets/plugins/popper/popper.min.js"></script>
    <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
    <!-- slimscrollbar scrollbar JavaScript -->
    <script src="assets/js/jquery.slimscroll.js"></script>
    <!--Wave Effects -->
    <script src="assets/js/waves.js"></script>
    <!--Menu sidebar -->
    <script src="assets/js/sidebarmenu.js"></script>

    <script src="assets/plugins/toast-master/js/jquery.toast.js"></script>
    <!--stickey kit -->
    <script src="assets/plugins/sticky-kit-master/dist/sticky-kit.min.js"></script>
    <script src="assets/plugins/sparkline/jquery.sparkline.min.js"></script>
    <!--Custom JavaScript -->
    <script src="assets/js/custom.min.js"></script>
    <!-- This is data table -->
    <script src="assets/plugins/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="assets/plugins/bootstrap-select/bootstrap-select.min.js" type="text/javascript"></script>
    <!-- start - This is for export functionality only -->
    <script src="assets/plugins/datatables-button/dataTables.buttons.min.js"></script>
    <script src="assets/plugins/datatables-button/buttons.flash.min.js"></script>
    <script src="assets/plugins/datatables-button/jszip.min.js"></script>
    <script src="assets/plugins/datatables-button/pdfmake.min.js"></script>
    <script src="assets/plugins/datatables-button/vfs_fonts.js"></script>
    <script src="assets/plugins/datatables-button/buttons.html5.min.js"></script>
    <script src="assets/plugins/datatables-button/buttons.print.min.js"></script>
    <script src="assets/plugins/jquery.mask.min.js"></script>
    <script src="assets/js/jquery.cookie.js"></script>
    <!-- Style switcher -->
    <script src="assets/plugins/styleswitcher/jQuery.style.switcher.js"></script>
    <!-- PRINCIPAL JS -->
    <script src="assets/js/vue.min.js"></script>
    <script src="${baseUri}/view/admin/app-js/datatable.js?v=2"></script>
    <script src="${baseUri}/view/admin/app-js/main.js"></script>

    <script>
        var filtros = '${filtro}';
    </script>
    <script src="${baseUri}/view/admin/relatorios/produtos/cupom.js?v=0"></script>
</body>

</html>