<!DOCTYPE html>
<html lang="pt-br">

<head>
    <base href="${baseUri}/view/admin/">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="${config_site_description}">
    <meta name="author" content="${config_site_author}">
    <meta name="keywords" content="${config_site_keywords}">
    <link rel="icon" type="image/png" sizes="16x16" href="${baseUri}/media/site/${config_site_favicon}">
    <title>${config_site_title} - Pedidos</title>
    <link href="assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/plugins/toast-master/css/jquery.toast.css">
    <link href="assets/plugins/bootstrap-select/bootstrap-select.min.css" rel="stylesheet" />
    <link href="assets/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.css" rel="stylesheet" />
    <link href="assets/css/style.css" rel="stylesheet">
    <!-- You can change the theme colors from here -->
    <link href="assets/css/colors/${config_tema_color}.css" id="theme" rel="stylesheet">
    <!--[if lt IE 9]>
    <script src="assets/plugins/html5shiv.js"></script>
    <script src="assets/plugins/respond.min.js"></script>
    <![endif]-->
    <style>
        .card-body {
            min-height: 150px;
        }

        .card-body p {

            font-size: 20px;
        }
    </style>
</head>

<body class="fix-header card-no-border logo-center">
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" />
        </svg>
    </div>

    <div id="main-wrapper">
        @(admin.layout.topo)
        @(admin.layout.topo-menu)
        <div class="page-wrapper">
            <div class="container-fluid" id="vm">
                <div class="row page-titles">
                    <div class="col-md-5 col-8 align-self-center" v-if="pedido != null">
                        <h3 class="text-themecolor m-b-0 m-t-0">Detalhes do <span v-if="pedido.pedido_tipo == 1">Pedido</span> <span v-if="pedido.pedido_tipo == 2">Orçamento</span></h3>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="${baseUri}/pedidos">Pedido</a></li>
                            <li class="breadcrumb-item active">Detalhes do <span v-if="pedido.pedido_tipo == 1">Pedido</span> <span v-if="pedido.pedido_tipo == 2">Orçamento</span></li>
                        </ol>
                    </div>
                    <div class="col-md-7 col-4 align-self-center">
                        <h6 class="float-right" style="padding-top: 20px">
                            <a href="${baseUri}/pedidos/" data-id="PedidosAdmin:L" class="btn btn-primary waves-effect waves-light text-white menu-access">
                                <i class="fa fa-arrow-circle-left"></i> Voltar
                            </a>
                        </h6>
                    </div>

                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="card card-outline-primary">
                            <div class="card-header"><i class="text-white fas fa-th-list"></i>

                            </div>
                            <div class="card-body">

                                <input type="hidden" id="pedido_id" value="${pedido_id}">

                                <div class="row justify-content-between">


                                    <div class="col-sm-12 col-md-8">
                                        <h4 class="pt-4" v-if="pedido != null">
                                            Detalhes do <span v-if="pedido.pedido_tipo == 1">Pedido</span> <span v-if="pedido.pedido_tipo == 2">Orçamento</span> <span class="h3 font-weight-semibold"># {{ pedido_id }}</span>
                                        </h4>
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="">Status do pedido </label>
                                                    <select id="status_pedido" class="form-control">
                                                        <option value="1">Aguardando pagamento</option>
                                                        <option value="2">Em análise</option>
                                                        <option value="3">Aprovado</option>
                                                        <option value="4">Disponível</option>
                                                        <option value="5">Em disputa</option>
                                                        <option value="6">Devolvido</option>
                                                        <option value="7">Cancelado</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 align-self-center pt-1">
                                                <button class="btn btn-primary" id="btn_chance_status" v-on:click="alteraStatus()">Atualizar</button>
                                            </div>

                                            <div v-if="pedido != null && pedido.pedido_entrega == 1" class="col-6">
                                                <div class="form-group">
                                                    <label for="pedido_codigo_rastreio">Código de rastreio transportadora</label>
                                                    <input type="text" class="form-control" name="pedido_codigo_rastreio" id="pedido_codigo_rastreio" :value="pedido.pedido_codigo_rastreio" placeholder="Caso tenha postado o produto pela transportadora">
                                                </div>
                                            </div>
                                            <div v-if="pedido != null && pedido.pedido_entrega == 1" class="col-6 btn-block align-self-center pt-1">
                                                <button id="btn_grava_codigo_rastreio" class="btn btn-primary" v-on:click="alteraCodigoRastreio()">Atualizar</button>

                                                <button v-if="(pedido.pedido_codigo_rastreio == null || pedido.pedido_codigo_rastreio == '') && melhorEnvio == 1" class="btn btn-success" v-on:click="comprarFrete(pedido.pedido_id)" data-toggle="tooltip" title="Comprar Frete Melhor Envio">
                                                    <i class="fa fa-truck" aria-hidden="true"></i> Comprar Frete
                                                </button>
                                            </div>


                                            <div v-if="pedido != null" class="col-6">
                                                <div class="form-group">
                                                    <label for="pedido_nf_chave">Chave Nota Fiscal Eletrônica</label>
                                                    <input type="text" class="form-control" name="pedido_nf_chave" id="pedido_nf_chave" :value="pedido.pedido_nf_chave" placeholder="Chave da NFe">
                                                </div>
                                            </div>
                                            <div v-if="pedido != null " class="col-6 btn-block align-self-center pt-1">
                                                <button id="btn_grava_chave_nf" class="btn btn-primary" v-on:click="alteraChaveNF()">Atualizar</button>
                                            </div>

                                        </div>
                                        <div v-if=" pedido !=null">
                                            <h5>Última atualização em {{pedido.pedido_atualizacao}}
                                                <br>
                                                <small>{{pedido.pedido_obs_sys}}</small>
                                            </h5>
                                            <a v-if="pedido.pedido_entrega == 1 && pedido.pedido_codigo_rastreio" class="btn btn-success btn-sm mt-4 mb-3" v-if="pedido.pedido_tipo == 1" target="_blank" :href="'${baseUri}/frete-rastreio/'+pedido.pedido_codigo_rastreio"> <i class="fa fa-truck" aria-hidden="true"></i> Rastrear </a>
                                            <a class="btn btn-info btn-sm mt-4 mb-3" v-if="pedido.pedido_tipo == 1" target="_blank" href="${baseUri}/pedido-imprimir-admin/${pedido_id}"> <i class="fa fa-print" aria-hidden="true"></i> Imprimir pedido </a>
                                            <a v-if="pedido != null && pedido.pedido_comprovante != null" class="btn btn-primary btn-sm mt-4 mb-3" :href="'${baseUri}/Common/download_comprovante/' + pedido.pedido_comprovante" target="_blank"> <i class="fa fa-eye"></i> Visualizar Comprovante</a>
                                        </div>
                                        <div v-if="pedido && pedido.pedido_nf_num_id" class="mb-4 mt-3">
                                            <h5>Detalhes da nota fiscal</h5>
                                            <span>ID da NF: <strong>{{pedido.pedido_nf_num_id}}</strong></span><br>
                                            <span>Nº de série da NF: <strong>{{pedido.pedido_nf_serie}}</strong></span><br>
                                            <span>Nº da NF: <strong>{{pedido.pedido_nf_num}}</strong></span><br>
                                            <span v-if="pedido.pedido_nf_chave">Chave NF: <strong>{{pedido.pedido_nf_chave}}</strong></span><br>
                                        </div>
                                    </div>

                                    <!-- Caso de entrega -->
                                    <div class="col-sm-12 col-md-4" v-if="pedido != null">

                                        <h4 class="pt-4">
                                            <i class="fa fa-user" aria-hidden="true"></i>
                                            <span class="text-capitalize">{{pedido.pedido_cliente_info.cliente_nome}}</span>

                                            <br>
                                            <i class="fa fa-envelope" aria-hidden="true"></i>
                                            <span>{{pedido.pedido_cliente_info.cliente_email}}</span>

                                            <span v-if="pedido.pedido_cliente_info.cliente_whatsapp">
                                                <br>
                                                <i class="fa fa-whatsapp" aria-hidden="true"></i>
                                                {{pedido.pedido_cliente_info.cliente_whatsapp}}
                                            </span>

                                            <span v-if="pedido.pedido_cliente_info.cliente_celular">
                                                <br>
                                                <i class="fa fa-phone" aria-hidden="true"></i>
                                                {{pedido.pedido_cliente_info.cliente_celular}}
                                            </span>

                                            <span v-if="pedido.pedido_cliente_info.cliente_telefone">
                                                <br>
                                                <i class="fa fa-phone" aria-hidden="true"></i>
                                                {{pedido.pedido_cliente_info.cliente_telefone}}
                                            </span>

                                            <span v-if="pedido.pedido_ip != null">
                                                <br> <br>
                                                <i class="fa fa-map-marker" aria-hidden="true"></i>

                                                <small> Localização do IP de origem do pedido</small> <br>
                                                <small class="text-danger"> [{{pedido.pedido_ip}} - {{pedido.pedido_ip_city}}]</small>
                                            </span>
                                            <br><br>
                                            <a :href="'${baseUri}/cliente/editar/id/'+pedido.pedido_cliente"
                                                target="_blank"
                                                class="btn btn-primary btn-sm">
                                                <i class="fa fa-user" aria-hidden="true"></i> Ver cadastro do cliente
                                            </a>

                                            <a :href="'${baseUri}/pedidos/?cliente='+pedido.pedido_cliente"
                                                target="_blank"
                                                class="btn btn-primary btn-sm">
                                                <i class="fa fa-user" aria-hidden="true"></i> Todos os pedidos do cliente
                                            </a>

                                        </h4>
                                        <div v-if="pedido != null && pedido.pedido_endereco_cliente != null">
                                            <h5 class="pt-4">
                                                <i class="fa fa-map-marker" aria-hidden="true"></i> Endereço de Entrega
                                            </h5>
                                            <p class="text-muteds">
                                                <span v-if="pedido.pedido_endereco_cliente.endereco_cliente_rua != null">{{ pedido.pedido_endereco_cliente.endereco_cliente_rua }}</span>
                                                <span v-if="pedido.pedido_endereco_cliente.endereco_cliente_num != null"><br>Nº {{ pedido.pedido_endereco_cliente.endereco_cliente_num }}</span>
                                                <span v-if="pedido.pedido_endereco_cliente.endereco_cliente_complemento != null"> - {{ pedido.pedido_endereco_cliente.endereco_cliente_complemento }}</span>
                                                <span v-if="pedido.pedido_endereco_cliente.endereco_cliente_bairro != null"><br> {{ pedido.pedido_endereco_cliente.endereco_cliente_bairro }}</span>
                                                <span v-if="pedido.pedido_endereco_cliente.endereco_cliente_cidade != null"> - {{ pedido.pedido_endereco_cliente.endereco_cliente_cidade }}</span>
                                                <span v-if="pedido.pedido_endereco_cliente.endereco_cliente_uf != null">, {{ pedido.pedido_endereco_cliente.endereco_cliente_uf }}</span>
                                                <span v-if="pedido.pedido_endereco_cliente.endereco_cliente_cep != null"><br>CEP: {{ pedido.pedido_endereco_cliente.endereco_cliente_cep }}</span>
                                            </p>
                                        </div>
                                        <h6 v-if="pedido.pedido_tipo == 1 && pedido.pedido_endereco_cliente != null">Entrega prevista para {{ pedido.pedido_data_entrega }}</h6>


                                        <div v-if="pedido != null && pedido.retirada != null">
                                            <h5 class="pt-4">
                                                <i class="fa fa-map-marker" aria-hidden="true"></i> Endereço de Retirada
                                            </h5>
                                            <p class="text-muted">
                                                <span v-if="pedido.retirada.retirada_rua != null">{{ pedido.retirada.retirada_rua }}</span>
                                                <span v-if="pedido.retirada.retirada_num != null"><br>Nº {{ pedido.retirada.retirada_num }}</span>
                                                <span v-if="pedido.retirada.retirada_complemento != null"> - {{ pedido.retirada.retirada_complemento }}</span>
                                                <span v-if="pedido.retirada.retirada_bairro != null"><br> {{ pedido.retirada.retirada_bairro }}</span>
                                                <span v-if="pedido.retirada.retirada_cidade != null"> - {{ pedido.retirada.retirada_cidade }}</span>
                                                <span v-if="pedido.retirada.retirada_uf != null">, {{ pedido.retirada.retirada_uf }}</span>
                                                <span v-if="pedido.retirada.retirada_cep != null"><br>CEP: {{ pedido.retirada.retirada_cep }}</span>
                                            </p>
                                        </div>

                                        <div v-if="respostas != null">
                                            <h4 class="pt-4">
                                                <i class="fa fa-list" aria-hidden="true"></i> Informações preenchidas
                                            </h4>
                                            <div v-for="res in respostas">
                                                <h5>
                                                    {{ res.campo_checkout_respostas_pergunta }}
                                                    <br>
                                                    <span class="text-muted">
                                                        - {{ res.campo_checkout_respostas_resposta }}
                                                    </span>
                                                </h5>
                                            </div>
                                        </div>

                                        <div v-if="pedido.pedido_obs != ''">
                                            <h4 class="pt-4">
                                                <i class="fa fa-exclamation" aria-hidden="true"></i> Observações de pagamento
                                            </h4>
                                            <div v-for="res in respostas">
                                                <p>{{ pedido.pedido_obs }}</p>
                                            </div>
                                        </div>

                                    </div>



                                    <div v-if="pedido != null && pedido.pedido_tipo == 2" class="col-sm-12 col-md-5 mt-2">
                                        <div class="card  mt-2">
                                            <div class="card-body text-center bg-primary text-white" v-if="pedido != null">
                                                <div class="row">
                                                    <div class="col-sm-12">
                                                        <h4 class="text-white">
                                                            <i class="fa fa-user" aria-hidden="true"></i> {{ pedido.pedido_cliente_info.cliente_nome }}
                                                        </h4>
                                                        <a :href="'mailto:'+ pedido.pedido_cliente_info.cliente_email " class="text-white">
                                                            <h6 class="text-white">
                                                                <i class="fa fa-envelope" aria-hidden="true"></i> {{ pedido.pedido_cliente_info.cliente_email }}
                                                            </h6>
                                                        </a>

                                                        <?php if (Browser::agent('mobile')) : ?>
                                                            <a :href="'https://api.whatsapp.com/send/?phone='+pedido.pedido_cliente_info.cliente_whatsapp" target="_blank" class="text-white">
                                                                <i class="fa fa-whatsapp" aria-hidden="true"></i> {{ pedido.pedido_cliente_info.cliente_celular }}
                                                            </a>
                                                        <?php else : ?>
                                                            <a :href="'https://web.whatsapp.com/send/?phone='+pedido.pedido_cliente_info.cliente_whatsapp" target="_blank" class="text-white">
                                                                <i class="fa fa-whatsapp" aria-hidden="true"></i> {{ pedido.pedido_cliente_info.cliente_celular }}
                                                            </a>
                                                        <?php endif ?>
                                                        <br>
                                                        <a :href="'${baseUri}/cliente/editar/id/' +pedido.pedido_cliente_info.cliente_id">
                                                            <i class="fa fa-user" aria-hidden="true"></i> Ver perfil
                                                        </a>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>

                                    <div v-if="pedido != null && pedido.pedido_tipo == 1" class="col mt-2">
                                        <div class="card  mt-2">
                                            <div class="card-body text-center bg-primary text-white" v-if="pedido != null">
                                                <div class="row">
                                                    <div class="col-sm-3">
                                                        <i class="fa fa-shopping-cart fa-3x" aria-hidden="true"></i>
                                                    </div>
                                                    <div class="col-sm-9">
                                                        <h4 class="text-white">
                                                            Produtos
                                                        </h4>
                                                        <p> {{ pedido.pedido_total_produto }} </p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div v-if="pedido != null && pedido.pedido_tipo == 1" class="col mt-2" v-if="pedido != null && pedido.pedido_cupom_desconto != null">
                                        <div class="card  mt-2">
                                            <div class="card-body text-center bg-primary text-white">
                                                <div class="row">
                                                    <div class="col-sm-3">
                                                        <i class="fa fa-percent fa-3x" aria-hidden="true"></i>
                                                    </div>
                                                    <div class="col-sm-9">
                                                        <h4 class="text-white">
                                                            Descontos
                                                        </h4>
                                                        <span data-toggle="tooltip" data-bs-toggle='tooltip' data-bs-html="true" data-html="true" :title="pedido.pedido_cupom_info">
                                                            <p>
                                                                {{ (pedido.pedido_desconto) ? 
                                                                Number(pedido.pedido_desconto).toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' }) : '--'  }}
                                                            </p>
                                                        </span>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div v-if="pedido != null && pedido.pedido_tipo == 1" class="col mt-2">
                                        <div class="card  mt-2">
                                            <div class="card-body text-center bg-primary text-white" v-if="pedido != null">
                                                <div class="row">
                                                    <div class="col-sm-3">
                                                        <i class="fa fa-truck fa-3x" aria-hidden="true"></i>
                                                    </div>
                                                    <div class="col-sm-9">
                                                        <h4 class="text-white" v-if="pedido.retirada == null">
                                                            <small>{{pedido.pedido_servico_frete}}</small>
                                                        </h4>
                                                        <h4 class="text-white" v-if="pedido.retirada != null">Retirada</h4>
                                                        <span v-if="pedido.retirada != null">
                                                            --
                                                        </span>
                                                        <span v-if="pedido.retirada == null">
                                                            <p> R$ {{ pedido.pedido_frete}} </p>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div v-if="pedido != null && pedido.pedido_tipo == 1" class="col mt-2">
                                        <div class="card  mt-2">
                                            <div class="card-body text-center bg-primary text-white" v-if="pedido != null">
                                                <div class="row">
                                                    <div class="col-sm-3">
                                                        <i class="fa fa-money fa-3x" aria-hidden="true"></i>
                                                    </div>
                                                    <div class="col-sm-9">
                                                        <h4 class="text-white">
                                                            Total
                                                            <small v-if="pedido.pedido_parcelas > 0">
                                                                Parcelado {{pedido.pedido_parcelas}}x
                                                            </small>
                                                        </h4>

                                                        <p v-if="pedido.pedido_total_parcelado != ''">
                                                            {{ pedido.pedido_total_parcelado }} <br>
                                                        </p>

                                                        <p v-if="pedido.pedido_total_parcelado == ''"> {{ pedido.pedido_total_frete }} </p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>


                                    <div v-if="pedido != null && pedido.pedido_tipo == 1" class="col mt-2">
                                        <div class="card  mt-2">
                                            <div class="card-body text-center bg-primary text-white" v-if="pedido != null">
                                                <div class="row">
                                                    <div class="col-sm-3">
                                                        <i class="fa fa-money fa-3x" aria-hidden="true"></i>
                                                    </div>
                                                    <div class="col-sm-9">
                                                        <h4 class="text-white">
                                                            Total Liquido
                                                        </h4>
                                                        <p> R$ {{ pedido.pedido_total_liquido}}</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div id="tbl-splash" class="spinner-border" style="width: 5rem; height: 5rem; margin-top: 5%; margin-left: 50%" role="status"></div>
                                        <div id="tbl-div" class="table-responsive m-ts-40">
                                            <table id="datatable" class="datatable display nowrap table table-hover table-striped table-bordered" cellspacing="0" width="100%">
                                                <thead>
                                                    <tr>
                                                        <th class="">Foto <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                        <th class="">Produto <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                        <th class="">Quantidade <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                        <th v-if="pedido != null && pedido.pedido_tipo == 1" class="">Valor <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                        <th class="text-center">Arquivo <i class="fa fa-sort" aria-hidden="true" style="cursor: pointer"></i></th>
                                                    </tr>
                                                </thead>
                                                <tbody v-if="pedido != null">
                                                    <tr v-for="item in pedido.lista" :class="'item-' + item.lista_pedido_id" :id="'item-' + item.lista_pedido_id">
                                                        <td width="100" style="vertical-align: middle;"><img :src="'${baseUri}/media/produto/' + item.lista_pedido_foto" style="object-fit: content; width: 100%;height: 60px;"></td>
                                                        <td style="vertical-align: middle;">{{item.lista_pedido_produto_titulo}}

                                                            <div v-if="item.atributos != undefined">
                                                                <div class="font-size-sm" v-for="att of item.atributos">
                                                                    <span class="mr-2">{{ att.lista_pedido_atributo_attnome }}:</span>{{ att.lista_pedido_atributo_itemnome }}
                                                                </div>
                                                            </div>

                                                        </td>
                                                        <td style="vertical-align: middle;">{{item.lista_pedido_qtde}}</td>
                                                        <td style="vertical-align: middle;" v-if="pedido != null && pedido.pedido_tipo == 1">R$ {{ item.lista_pedido_preco }}</td>
                                                        <td style="vertical-align: middle;"> <a target="_blank" :href="'${baseUri}/common/download_arquivo/' + item.lista_pedido_arquivo" class="btn btn-primary btn-sm btn-block" v-if="item.lista_pedido_arquivo != null"><i class="fa fa-download"></i></a></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="row" v-if="pedido != null" id="mob-tbl">
                                            <div class="col-sm-12">
                                                <h4>Itens do pedido</h4>
                                                <hr>
                                            </div>
                                            <div v-if="pedido.pedido_tipo == 1" v-for="item in pedido.lista">
                                                <div class="col-12">
                                                    <h3>{{item.lista_pedido_produto_titulo}}
                                                        <div v-if="item.atributos != undefined">
                                                            <br>
                                                            <div class="font-size-sm" v-for="att of item.atributos">
                                                                <span class="mr-2">{{ att.lista_pedido_atributo_attnome }}:</span>{{ att.lista_pedido_atributo_itemnome }}
                                                            </div>
                                                        </div>
                                                    </h3>
                                                    <br>
                                                    <label>{{item.lista_pedido_qtde}} x R$ {{ item.lista_pedido_preco }}</label>
                                                    <br>
                                                    <hr>
                                                </div>
                                            </div>
                                            <div v-if="pedido.pedido_tipo == 2" v-for="item in pedido.lista">
                                                <div class="col-12">
                                                    <h3>{{item.lista_pedido_produto_titulo}}
                                                        <div v-if="item.atributos != undefined">
                                                            <br>
                                                            <div class="font-size-sm" v-for="att of item.atributos">
                                                                <span class="mr-2">{{ att.lista_pedido_atributo_attnome }}:</span>{{ att.lista_pedido_atributo_itemnome }}
                                                            </div>
                                                        </div>
                                                    </h3>
                                                    <label>Quantidade: {{item.lista_pedido_qtde}}</label>
                                                    <br>
                                                    <hr>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @(admin.layout.footer)

        </div>
        @(admin.produto.modal-novo)
        @(admin.layout.modal-remove)
    </div>
    <script src="assets/plugins/jquery/jquery.min.js"></script>
    <!-- Bootstrap tether Core JavaScript -->
    <script src="assets/plugins/popper/popper.min.js"></script>
    <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
    <!-- slimscrollbar scrollbar JavaScript -->
    <script src="assets/js/jquery.slimscroll.js"></script>
    <!--Wave Effects -->
    <script src="assets/js/waves.js"></script>
    <!--Menu sidebar -->
    <script src="assets/js/sidebarmenu.js"></script>
    <!--stickey kit -->
    <script src="assets/plugins/sticky-kit-master/dist/sticky-kit.min.js"></script>
    <script src="assets/plugins/sparkline/jquery.sparkline.min.js"></script>
    <!--Custom JavaScript -->
    <script src="assets/js/custom.min.js"></script>
    <script src="assets/plugins/toast-master/js/jquery.toast.js"></script>
    <!-- Style switcher -->
    <script src="assets/plugins/styleswitcher/jQuery.style.switcher.js"></script>
    <!-- This is data table -->
    <script src="assets/plugins/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="assets/plugins/bootstrap-select/bootstrap-select.min.js" type="text/javascript"></script>
    <!-- start - This is for export functionality only -->
    <script src="assets/plugins/datatables-button/dataTables.buttons.min.js"></script>
    <script src="assets/plugins/datatables-button/buttons.flash.min.js"></script>
    <script src="assets/plugins/datatables-button/jszip.min.js"></script>
    <script src="assets/plugins/datatables-button/pdfmake.min.js"></script>
    <script src="assets/plugins/datatables-button/vfs_fonts.js"></script>
    <script src="assets/plugins/datatables-button/buttons.html5.min.js"></script>
    <script src="assets/plugins/datatables-button/buttons.print.min.js"></script>
    <script src="assets/plugins/jquery.mask.min.js"></script>
    <script src="assets/js/jquery.cookie.js"></script>
    <!-- PRINCIPAL JS -->
    <script src="assets/js/vue.min.js"></script>
    <script src="assets/plugins/dropify/dist/js/dropify.min.js"></script>
    <script src="${baseUri}/view/admin/app-js/datatable.js"></script>
    <script src="${baseUri}/view/admin/app-js/main.js"></script>
    <script src="pedido/visualizar.js?v=${rand}"></script>

    <script>
        setTimeout(() => {
            vm.melhorEnvio = parseInt('${melhorEnvio}');
            //console.log(vm.pedido)
            if (vm.pedido && vm.pedido.pedido_status > 5) {
                $('#status_pedido').attr('disabled', true);
                $('#btn_chance_status').attr('disabled', true);
            }
        }, 500);
    </script>

</body>

</html>