var table;
var vm = new Vue({
    el: "#vm",
    data: {
        pedido: null,
        rm: null,
        url: null,
        pedido_id: null,
        respostas: null,
        melhorEnvio: 0,
    },
    methods: {
        lista_questionario: () => {
            let id = $("#pedido_id").val();
            let url = baseUri + "/CamposExtras/lista_questionario";
            $.post(url, { pedido_id: id }).then((res) => {
                res = JSON.parse(res);
                if (res.status == 200) {
                    vm.respostas = res.respostas;
                } else {
                    vm.respostas = null;
                }
            });
        },
        listar: function () {
            var url = baseUri + "/Pedido/getPedido";
            $.post(url, { id: this.pedido_id }, function (dados) {
                splash_dt();
            }).then(function (dados) {
                if (dados != null) {
                    vm.pedido = JSON.parse(dados);
                    console.log(vm.pedido);
                    $("#status_pedido")
                        .val(vm.pedido.pedido_status)
                        .trigger("change");

                    if (!isNaN(vm.pedido.pedido_total_parcelado)) {
                        vm.pedido.pedido_total_parcelado = Number(
                            vm.pedido.pedido_total_parcelado
                        ).toLocaleString("pt-BR", {
                            style: "currency",
                            currency: "BRL",
                        });
                    } else {
                        vm.pedido.pedido_total_parcelado =
                            "R$ " + vm.pedido.pedido_total_parcelado;
                    }
                    if (!isNaN(vm.pedido.pedido_total_frete)) {
                        vm.pedido.pedido_total_frete = Number(
                            vm.pedido.pedido_total_frete
                        ).toLocaleString("pt-BR", {
                            style: "currency",
                            currency: "BRL",
                        });
                    } else {
                        vm.pedido.pedido_total_frete =
                            "R$ " + vm.pedido_total_frete;
                    }
                    if (!isNaN(vm.pedido.pedido_total_produto)) {
                        vm.pedido.pedido_total_produto = Number(
                            vm.pedido.pedido_total_produto
                        ).toLocaleString("pt-BR", {
                            style: "currency",
                            currency: "BRL",
                        });
                    } else {
                        vm.pedido.pedido_total_produto =
                            "R$ " + vm.pedido.pedido_total_produto;
                    }
                } else {
                    window.location.href = baseUri + "/pedidos/?error";
                }

                reload_dt_vue();
                setTimeout(() => $(".buttons-print").hide(), 500);
            });
        },
        comprarFrete: (id) => {
            $("#btn_compra_frete").attr("disabled", true);
            let url = baseUri + "/pedido/freteCartMelhorEnvio";
            $.post(url, { pedido: id }).then((res) => {
                console.log(res);
                res = JSON.parse(res);
                if (res.error != undefined || res.error != null) {
                    //let res = JSON.parse(res.response);
                    //console.log(res.response.erro);
                    alert_error(res.response.erro);
                } else {
                    alert_success(res.msg);
                    //vm.pedido.pedido_codigo_rastreio = "";
                    vm.listar();
                }
                $("#btn_compra_frete").removeAttr("disabled");
            });
        },
        alteraStatus: () => {
            let status = Number($("#status_pedido").val());
            if (status > 0) {
                let url = baseUri + "/Pedido/alteraStatus";
                $.post(url, { id: vm.pedido_id, status: status }).then(
                    (res) => {
                        res = JSON.parse(res);
                        if (res.error != undefined || res.error != null) {
                            alert_error(res.error);
                        } else {
                            alert_success(res.msg);
                            //vm.listar();
                        }
                    }
                );
            }
        },
        alteraCodigoRastreio: () => {
            $("#btn_grava_codigo_rastreio").attr("disabled", true);
            let pedido_codigo_rastreio = $("#pedido_codigo_rastreio").val();
            let url = baseUri + "/Pedido/inserir_codigo_rastreio";
            $.post(url, {
                id: vm.pedido_id,
                pedido_codigo_rastreio: pedido_codigo_rastreio,
            }).then((res) => {
                res = JSON.parse(res);
                if (res.error != undefined || res.error != null) {
                    alert_error(res.error);
                } else {
                    alert_success(res.msg);
                    vm.listar();
                }
                $("#btn_grava_codigo_rastreio").removeAttr("disabled");
            });
        },
        alteraChaveNF: () => {
            $("#btn_grava_chave_nf").attr("disabled", true);
            let pedido_nf_chave = $("#pedido_nf_chave").val();
            let url = baseUri + "/Pedido/inserir_chave_nf";
            $.post(url, {
                id: vm.pedido_id,
                pedido_nf_chave: pedido_nf_chave,
            }).then((res) => {
                res = JSON.parse(res);
                if (res.error != undefined || res.error != null) {
                    alert_error(res.error);
                } else {
                    alert_success(res.msg);
                    vm.listar();
                }
                $("#btn_grava_chave_nf").removeAttr("disabled");
            });
        },
        remover: function (dt) {
            vm.$data.rm = dt.pedido_id;
            $("#modal-remove").modal("show");
        },
        remove: function (id) {
            var url_remove = baseUri + "/Pedido/remover/";
            $.post(url_remove, { id: id }).then(function (rs) {
                if (rs == 1) {
                    alert_success(
                        "Ação realizada com sucesso!",
                        "Item removido"
                    );
                    vm.listar();
                } else {
                    alert_error("Ação não pode ser realizada!");
                }
            });
            $("#modal-remove").modal("hide");
        },
    },
    created: function () {
        this.lista_questionario();
        this.pedido_id =
            Number($("#pedido_id").val()) > 0 ? $("#pedido_id").val() : null;
        $("#tbl-div").hide().promise().done($("#tbl-splash").show());
        if (this.pedido_id != null) this.listar();
        else window.location.href = baseUri + "/pedidos/?error";
    },
});
// click do modal
$("#btn-remove").on("click", function () {
    if (vm.$data.rm !== null) {
        vm.remove(vm.$data.rm);
    }
});

$(".menu-pedidos").addClass("active");
