<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="utf-8">
    <title>${config_site_title}
        <?php if (isset($data['config']->config_site_slogan) && !empty($data['config']->config_site_slogan)) : ?>
            - ${config_site_slogan}
        <?php endif; ?>
    </title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/png" sizes="32x32" href="${baseUri}/media/site/${config_site_favicon}">
    <link href="${baseUri}/view/admin/assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" media='all' href="${baseUri}/view/admin/assets/css/vendor.min.css">
    <link rel="stylesheet" media='all' id="main-styles" href="${baseUri}/view/admin/assets/css/theme.min.css">
    <link rel="stylesheet" media='all' href="${baseUri}/view/admin/assets/css/customizer.min.css">
    <link rel="stylesheet" media='all' href="${baseUri}/view/admin/assets/css/template2.css">
    <link rel="stylesheet" media='all' href="${baseUri}/view/admin/assets/css/jquery.toast.css">
    <link rel="stylesheet" media='all' href="${baseUri}/view/admin/assets/css/index.css">

</head>

<body>
    <input type="hidden" id="pedido_id" value="<?= isset($data['pedido_id']) ? $data['pedido_id'] : '' ?>">
    <div class="container mt-3" id="vm" v-if="pedido != null">
        <div class="row">
            <div class="col-sm-12 col-xs-12">
                <h5>
                    Pedido #{{ pedido_id }}
                    <span class="float-right">
                        Status do pedido: {{ pedido.pedido_status_nome }}
                    </span>
                </h5>
            </div>
            <div class="col-sm-12 col-xs-12">
                <p>Data do Pedido: {{ pedido.pedido_data }}</p>
                <hr>
            </div>
        </div>
        <div class="row">
            <div class="col-6">
                <!-- Caso de entrega -->
                <div v-if="pedido.pedido_endereco_cliente != null">
                    <h5 class="pt-4">
                        <i class="fa fa-map-marker" aria-hidden="true"></i> Endereço de Entrega
                    </h5>
                    <p class="text-muted">
                        <span v-if="pedido.pedido_endereco_cliente.endereco_cliente_rua != null">{{ pedido.pedido_endereco_cliente.endereco_cliente_rua }}</span>
                        <span v-if="pedido.pedido_endereco_cliente.endereco_cliente_num != null"><br>Nº {{ pedido.pedido_endereco_cliente.endereco_cliente_num }}</span>
                        <span v-if="pedido.pedido_endereco_cliente.endereco_cliente_complemento != null"> - {{ pedido.pedido_endereco_cliente.endereco_cliente_complemento }}</span>
                        <span v-if="pedido.pedido_endereco_cliente.endereco_cliente_bairro != null"><br> {{ pedido.pedido_endereco_cliente.endereco_cliente_bairro }}</span>
                        <span v-if="pedido.pedido_endereco_cliente.endereco_cliente_cidade != null"> - {{ pedido.pedido_endereco_cliente.endereco_cliente_cidade }}</span>
                        <span v-if="pedido.pedido_endereco_cliente.endereco_cliente_uf != null">, {{ pedido.pedido_endereco_cliente.endereco_cliente_uf }}</span>
                        <span v-if="pedido.pedido_endereco_cliente.endereco_cliente_cep != null"><br>CEP: {{ pedido.pedido_endereco_cliente.endereco_cliente_cep }}</span>
                    </p>
                </div>

                <!-- Caso de retirada -->
                <div v-if="pedido != null && pedido.retirada != null">
                    <h5 class="pt-4">
                        <i class="fa fa-map-marker" aria-hidden="true"></i> Endereço de Retirada
                    </h5>
                    <p class="text-muted">
                        <span v-if="pedido.retirada.retirada_rua != null">{{ pedido.retirada.retirada_rua }}</span>
                        <span v-if="pedido.retirada.retirada_num != null"><br>Nº {{ pedido.retirada.retirada_num }}</span>
                        <span v-if="pedido.retirada.retirada_complemento != null"> - {{ pedido.retirada.retirada_complemento }}</span>
                        <span v-if="pedido.retirada.retirada_bairro != null"><br> {{ pedido.retirada.retirada_bairro }}</span>
                        <span v-if="pedido.retirada.retirada_cidade != null"> - {{ pedido.retirada.retirada_cidade }}</span>
                        <span v-if="pedido.retirada.retirada_uf != null">, {{ pedido.retirada.retirada_uf }}</span>
                        <span v-if="pedido.retirada.retirada_cep != null"><br>CEP: {{ pedido.retirada.retirada_cep }}</span>

                        <span v-if="pedido.retirada.retirada_telefone != null && pedido.retirada.retirada_horario != null">
                            <h5>Atendimento</h5>
                            <span><i class="fa fa-clock" aria-hidden="true"></i> {{ pedido.retirada.retirada_horario }} </span> <br>
                            <span><i class="fa fa-phone" aria-hidden="true"></i> {{ pedido.retirada.retirada_telefone }} </span> <br>
                        </span>
                    </p>
                </div>
            </div>
            <div class="col-6">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <h5 class="pt-4">Dados do Cliente</h5>
                        <p class="text-muted">
                            <i v-if="pedido.cliente_nome != null" class="fa fa-user"></i> {{ pedido.cliente_nome }}
                            <br>
                            <i v-if="pedido.cliente_email != null" class="fa fa-envelope"></i> {{ pedido.cliente_email }}
                            <br>
                            <i v-if="pedido.cliente_telefone != null" class="fa fa-phone"></i> {{ pedido.cliente_telefone }}
                        </p>
                    </div>

                </div>

                <br>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-sm-12 col-xs-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Itens do pedido</h5>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th scope="col">Item</th>
                                    <th scope="col">Quantidade</th>
                                    <th scope="col">Preço</th>
                                    <th scope="col">Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="item of pedido.lista">
                                    <td>{{ item.lista_pedido_produto_titulo }}
                                        <div v-if="item.atributos != undefined">
                                            <br>
                                            <div class="font-size-sm" v-for="att of item.atributos">
                                                <span class="mr-2">{{ att.lista_pedido_atributo_attnome }}:</span>{{ att.lista_pedido_atributo_itemnome }}
                                            </div>
                                        </div>
                                    </td>
                                    <td>{{ item.lista_pedido_qtde }}</td>
                                    <td>R$ {{ item.lista_pedido_preco}}</td>
                                    <td>{{ parseFloat( item.lista_pedido_preco.replace(',','.') * parseInt(item.lista_pedido_qtde)).toLocaleString("pt-BR", {
                            style: "currency",
                            currency: "BRL",
                        })   }}</td>
                                </tr>
                            </tbody>
                        </table>

                    </div>
                </div>

            </div>

        </div>
        <hr>
        <div class="row">
            <div class="col-sm-12 col-xs-12">
                <table class="table">
                    <thead>
                        <tr>
                            <th scope="col">Subtotal</th>
                            <th scope="col">Descontos</th>
                            <th scope="col">Frete</th>
                            <th scope="col">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>{{ pedido.pedido_total_produto }}</td>
                            <td>
                                <span v-if="pedido.pedido_cupom_desconto != null || pedido.pedido_cupom_info != null">R$ {{ pedido.pedido_cupom_desconto }} {{ pedido.pedido_cupom_info.replace('br>','').replace('<',' - ') }}</span>
                            </td>
                            <td>{{ pedido.pedido_frete }}</td>
                            <th>{{ pedido.pedido_total_parcelado }}</th>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
        const baseUri = "${baseUri}";
        const site_modo = '${config_site_modo}';
    </script>
    <script src="${baseUri}/view/tema/loja/assets/js/jquery.min.js"></script>
    <script src="${baseUri}/view/tema/loja/assets/js/vue.min.js"></script>
    <script src="${baseUri}/view/admin/assets/plugins/printArea/jquery.PrintArea.js"></script>
    <script src="${baseUri}/view/admin/pedido/print.js?v=<?= rand(); ?>"></script>
</body>

</html>