<!DOCTYPE html>
<html lang="pt-br">

<head>
    <base href="${baseUri}/view/admin/">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="${config_site_description}">
    <meta name="author" content="${config_site_author}">
    <meta name="keywords" content="${config_site_keywords}">
    <meta name="author" content="${config_seo_author}">
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="${baseUri}/media/site/${config_site_favicon}">

    <title>${config_site_title} - Informações da loja</title>
    <!-- Bootstrap Core CSS -->
    <link href="assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/plugins/toast-master/css/jquery.toast.css">
    <link href="assets/plugins/bootstrap-select/bootstrap-select.min.css" rel="stylesheet" />
    <link href="assets/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.css" rel="stylesheet" />
    <link href="assets/css/style.css" rel="stylesheet">
    <!-- You can change the theme colors from here -->
    <link href="assets/css/colors/${config_tema_color}.css" id="theme" rel="stylesheet">
    <link rel="stylesheet" href="assets/plugins/dropify/dist/css/dropify.min.css">
    <!--[if lt IE 9]>
    <script src="assets/plugins/html5shiv.js"></script>
    <script src="assets/plugins/respond.min.js"></script>
    <![endif]-->
</head>
<style>
    form .dropify-wrapper .dropify-preview .dropify-render img {
        object-fit: cover;
    }

    form .dropify-wrapper {
        display: block;
        position: relative;
        cursor: pointer;
        border-radius: 10px;
        object-fit: cover;
        height: 200px;
        overflow: hidden;
        max-width: 100%;
        font-size: 14px;
        line-height: 22px;
        color: #777;
        background-color: #FFF;
        border: 2px solid #E5E5E5;
        -webkit-transition: border-color .15s linear;
        transition: border-color .15s linear
    }
</style>

<body class="fix-header card-no-border logo-center">
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" />
        </svg>
    </div>

    <div id="main-wrapper">
        <!-- TOPO import -->
        @(admin.layout.topo)
        <!-- MENU import -->
        @(admin.layout.topo-menu)
        <!-- Page wrapper  -->
        <div class="page-wrapper">
            <!-- Container fluid  -->
            <div class="container-fluid">
                <!-- Bread crumb and right sidebar toggle -->
                <div class="row page-titles">
                    <div class="col-md-5 col-8 align-self-center">
                        <h3 class="text-themecolor m-b-0 m-t-0">Informações da Loja</h3>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Configurações</a></li>
                            <li class="breadcrumb-item active">Informações da Loja</li>
                        </ol>
                    </div>
                    <!-- Top Right Info -->
                    @(admin.layout.topo-info)
                </div>

                <!-- Start Page Content -->
                <div class="row">
                    <div class="col-12">
                        <div class="card card-outline-primary">
                            <div class="card-header">
                                <div class="row">
                                    <div class="col-sm-4 align-self-center">
                                        <i class="text-white fas fa-globe"></i>
                                    </div>
                                    <div class="col-sm-8">
                                        @(admin.layout.seo)
                                    </div>
                                </div>

                            </div>
                            <div class="card-body">
                                <form method="post" action="${baseUri}/configuracao/gravar/return/loja/" enctype="multipart/form-data">
                                    <input type="hidden" name="config_id" value="1">
                                    <section class="container-fluid">
                                        <div>
                                            <br>
                                            <h4 class="separator-line">Informações da Loja</h4>
                                            <hr>
                                        </div>



                                        <div class="row">

                                            <div class="col-md-4 col-xs-6 col-sm-12">
                                                <div class="form-group">
                                                    <label for="config_site_title">Título do Site <span class="text-danger">*</span> </label>
                                                    <input type="text" name="config_site_title" id="config_site_title" class="form-control" placeholder="informe um título para o site" required value="${config_site_title}" />
                                                </div>
                                            </div>
                                            <input type="hidden" name="config_site_description" id="config_site_description" class="form-control" placeholder="ex: prestamos serviços de .... " value="${config_site_description}">
                                            <input type="hidden" name="config_site_keywords" id="config_site_keywords" class="form-control" placeholder="serviços prestatos ou produtos oferecidos" value="${config_site_keywords}" />


                                            <div class="col-md-4 col-xs-12 col-sm-12">
                                                <div class="form-group">
                                                    <label for="config_site_slogan">Slogan</label>
                                                    <input type="text" name="config_site_slogan" onchange="changeSeo('#config_site_slogan', 'titulo')" id="config_site_slogan" class="form-control" placeholder="um slogan" value="${config_site_slogan}" />
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12 col-sm-12">
                                                <div class="form-group">
                                                    <label for="config_site_author">Meta Author</label>
                                                    <input type="text" name="config_site_author" id="config_site_author" class="form-control" placeholder="informe o meta author" value="${config_site_author}" />
                                                </div>
                                            </div>

                                            <div class="col-md-6 col-xs-12 col-sm-12">
                                                <div class="form-group">
                                                    <label for="config_site_ga_code">Código Google Analytics</label>
                                                    <input type="text" name="config_site_ga_code" id="config_site_ga_code" class="form-control" placeholder="informe o código do Google Analytics" value="${config_site_ga_code}" />
                                                </div>
                                            </div>

                                            <div class="col-md-6 col-xs-12 col-sm-12">
                                                <div class="form-group">
                                                    <label for="config_site_tm_code">Código Google Tag Manager</label>
                                                    <input type="text" name="config_site_tm_code" id="config_site_tm_code" class="form-control" placeholder="Informe o código do Google Tag Manager" value="${config_site_tm_code}" />
                                                </div>
                                            </div>
                                            <div class="col-md-12 col-xs-12 col-sm-12">
                                                <div class="form-group">
                                                    <label for="config_site_about">Descrição da Loja</label>
                                                    <textarea name="config_site_about" id="config_site_about" rows="4" class="form-control" placeholder="Sobre">${config_site_about}</textarea>
                                                </div>
                                            </div>

                                            <div class="col-md-12 col-xs-12 col-sm-12">
                                                <div class="form-group">
                                                    <label for="sitemap">Link para seu Sitemap.xml</label>
                                                    <input type="text" id="sitemap" disabled class="form-control" value="${baseUri}/sitemap" />
                                                </div>
                                            </div>

                                            <!-- INFORMAÇÕES DE PRIVACIDADE -->

                                            <div class="col-sm-12">
                                                <br>
                                                <h4 class="separator-line">Informações referentes à LGPD</h4>
                                                <hr>
                                            </div>

                                            <div class="col-md-6 col-xs-12 col-sm-12">
                                                <div class="form-group">
                                                    <label for="config_lgpd_texto">Mensagem para Modal de Privacidade</label>
                                                    <input type="text" name="config_lgpd_texto" id="config_lgpd_texto" class="form-control" placeholder="Informe a mensagem para o modal de privacidade" value="${config_lgpd_texto}" />
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-xs-12 col-sm-12">
                                                <div class="form-group">
                                                    <label for="config_lgpd_link">Link para políticas de segurança da loja</label>
                                                    <input type="text" name="config_lgpd_link" id="config_lgpd_link" class="form-control" placeholder="Ex: https://linkdepoliticadeseguranca.com" value="${config_lgpd_link}" />
                                                </div>
                                            </div>
                                            <!-- INFORMAÇÕES DE PRIVACIDADE -->

                                            <div class="col-sm-12">
                                                <br>
                                                <h4 class="separator-line">Informações de Contato</h4>
                                                <hr>
                                            </div>


                                            <div class="col-sm-12 col-md-3">
                                                <label for="config_site_cep">CEP </label>
                                                <input type="text" class="form-control cep" name="config_site_cep" value="${config_site_cep}" placeholder="Ex: 99999-999"><br><br>
                                            </div>
                                            <div class="col-sm-12 col-md-9">
                                                <label for="config_site_rua">Endereço </label>
                                                <input type="text" class="form-control rua" name="config_site_rua" value="${config_site_rua}" placeholder="Ex: Rua João da Silva"><br><br>
                                            </div>
                                            <div class="col-sm-12 col-md-3">
                                                <label for="config_site_num">Número </label>
                                                <input type="text" class="form-control numero" name="config_site_num" value="${config_site_num}" placeholder="Ex: 123"><br><br>
                                            </div>

                                            <div class="col-sm-12 col-md-3">
                                                <label for="config_site_bairro">Bairro </label>
                                                <input type="text" class="form-control bairro" name="config_site_bairro" value="${config_site_bairro}" placeholder="Ex: Morumbi"><br><br>
                                            </div>
                                            <div class="col-sm-12 col-md-3">
                                                <label for="config_site_cidade">Cidade </label>
                                                <input type="text" class="form-control cidade" name="config_site_cidade" value="${config_site_cidade}" placeholder="Ex: São Paulo"><br><br>
                                            </div>
                                            <div class="col-sm-12 col-md-3">
                                                <label for="config_site_uf">UF </label>
                                                <input type="text" class="form-control uf" name="config_site_uf" value="${config_site_uf}" placeholder="Ex: SP"><br><br>
                                            </div>



                                            <div class="col-sm-12 col-md-3">
                                                <label for="config_site_telefone">Telefone da Loja </label>
                                                <input type="text" class="form-control fone" name="config_site_tel1" value="${config_site_tel1}" placeholder="Ex: (11) 9999-9999"><br><br>
                                            </div>
                                            <div class="col-sm-12 col-md-3">
                                                <label for="config_site_telefone">Whatsapp </label>
                                                <input type="text" class="form-control celular" name="config_site_tel2" value="${config_site_tel2}" placeholder="Ex: (11) 91919-1919"><br><br>
                                            </div>

                                            <div class="col-sm-12 col-md-3">
                                                <label for="config_site_funcionamento">Horário </label>
                                                <input type="text" class="form-control" name="config_site_funcionamento" value="${config_site_funcionamento}" placeholder="Ex: das 09:00 às 17:00"><br><br>
                                            </div>

                                            <div class="col-sm-12 col-md-3">
                                                <label for="config_site_cnpj">CNPJ da Empresa</label>
                                                <input type="text" class="form-control cnpj" name="config_site_cnpj" value="${config_site_cnpj}" placeholder="99.999.999/9999-99"><br><br>
                                            </div>


                                            <div class="col-sm-12 col-md-6">
                                                <label for="config_site_email">Email </label>
                                                <input type="text" class="form-control" name="config_site_email" value="${config_site_email}" placeholder="Ex: email@email.com"><br><br>
                                            </div>

                                            <div class="col-md-6 col-sm-12">
                                                <div class="form-group">
                                                    <label for="contato_email">Emails extras (cópia oculta)</label>
                                                    <label class="float-right"><i class="fa fa-info-circle"></i> Emails separados por espaço</label>

                                                    <input type="text" name="config_site_email_bcc" id="emails" class="form-control"
                                                        placeholder="Informe um email" value="${config_site_email_bcc}" />
                                                </div>
                                            </div>



                                            <div class="col-md-12 col-xs-12 col-sm-12">
                                                <div class="form-group">
                                                    <label for="config_script_chat">Código de chat externo</label>
                                                    <span class="float-right pt-1"><i class="fa fa-info-circle"></i> Copiar aqui o script de chat externo, como o <a href="https://www.jivochat.com/" target="_blank">Jivochat</a> ou <a target="_blank" href="https://www.zendesk.com/chat/?from=zp">zopim</a></span>
                                                    <textarea type="text" name="config_script_chat" id="config_script_chat" class="form-control" rows="5">
                                                        ${config_script_chat}
                                                    </textarea>
                                                </div>
                                            </div>

                                            <div class="col-12 align-self-center mb-4">
                                                <div class="row ">
                                                    <div class="col-lg-12 col-md-12 col-sm-12 text-center">
                                                        <label for="input-file-now-custom-1">Selecione uma foto para o botão flutuante do WhatsApp</label>
                                                        <input type="file" id="input-file-now-custom-1" name="icon_whats" data-allowed-file-extensions="png jpeg jpg" class="dropify " data-default-file="${baseUri}/media/site/${config_site_icon_whats}" />
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-12 text-center">
                                                <div class="form-group ">

                                                    <button type="submit" id="btn-send" class="btn btn-primary"><i class="fas fa-check-circle"></i> Atualizar Dados
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </section>

                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End Page Content -->
                <!-- Config Tema botão float import -->

            </div>
            <!-- Footer import-->
            @(admin.layout.footer)
            <!-- End Footer -->
        </div>
        <!-- End Page wrapper  -->
    </div>
    <!-- All Jquery -->
    <script src="assets/plugins/jquery/jquery.min.js"></script>
    <script src="assets/plugins/popper/popper.min.js"></script>
    <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.slimscroll.js"></script>
    <script src="assets/js/waves.js"></script>
    <script src="assets/js/sidebarmenu.js"></script>
    <script src="assets/plugins/sticky-kit-master/dist/sticky-kit.min.js"></script>
    <script src="assets/plugins/sparkline/jquery.sparkline.min.js"></script>
    <script src="assets/js/custom.min.js"></script>
    <script src="assets/plugins/toast-master/js/jquery.toast.js"></script>
    <script src="assets/plugins/styleswitcher/jQuery.style.switcher.js"></script>
    <script src="assets/plugins/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="assets/plugins/datatables.net/js/dataTables.rowReorder.min.js"></script>
    <script src="assets/plugins/bootstrap-select/bootstrap-select.min.js" type="text/javascript"></script>
    <script src="assets/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js" type="text/javascript"></script>
    <script src="assets/plugins/jquery.mask.min.js"></script>
    <script src="assets/js/jquery.cookie.js"></script>

    <script src="assets/plugins/summernote/dist/summernote-lite.min.js"></script>
    <script src="assets/plugins/summernote/dist/lang/summernote-pt-BR.js"></script>

    <script src="assets/js/vue.min.js"></script>
    <!-- FILE UPLOAD -->
    <script src="assets/plugins/dropzone-master/dist/dropzone.js"></script>
    <script src="assets/plugins/lightbox/js/lightbox.js"></script>
    <script src="assets/plugins/sortable/Sortable.js"></script>
    <script src="assets/plugins/dropify/dist/js/dropify.min.js"></script>

    <script src="${baseUri}/view/admin/app-js/datatable.js"></script>
    <script src="assets/plugins/datatables-button/dataTables.buttons.min.js"></script>
    <script src="assets/plugins/datatables-button/buttons.flash.min.js"></script>
    <script src="assets/plugins/datatables-button/jszip.min.js"></script>
    <script src="assets/plugins/datatables-button/pdfmake.min.js"></script>
    <script src="assets/plugins/datatables-button/vfs_fonts.js"></script>
    <script src="assets/plugins/datatables-button/buttons.html5.min.js"></script>
    <script src="assets/plugins/datatables-button/buttons.print.min.js"></script>
    <script src="${baseUri}/view/admin/app-js/endereco.js"></script>
    <script src="${baseUri}/view/admin/app-js/main.js"></script>
    <script src="assets/plugins/dropify/dist/js/dropify.min.js"></script>
    <script type="text/javascript">
        $('.dropify').dropify({
            messages: {
                default: 'Clique aqui para selecionar uma imagem',
                replace: 'Clique em remover para selecionar uma nova imagem',
                remove: 'Remover',
                error: 'Ocorreu um erro ao alterar a imagem'
            },
            error: {
                'fileSize': 'O tamanho máximo permitido é de: ({{ value }}).',
                'minWidth': 'The image width is too small ({{ value }}}px min).',
                'maxWidth': 'The image width is too big ({{ value }}}px max).',
                'minHeight': 'The image height is too small ({{ value }}}px min).',
                'maxHeight': 'The image height is too big ({{ value }}px max).',
                'imageFormat': 'Os formatos de imagem permitidos são: ({{ value }}).',
                'fileExtension': 'As extensões permitidas são: ({{ value }}).'
            }
        });
    </script>
    <script type="text/javascript">
        $('.menu-informacoes').addClass('active');
    </script>

    <script>
        let updated = '${config_updated}'.split(' ');
        let hora = updated[1];
        updated = updated[0].split('-');

        updated = updated[2] + '/' + updated[1] + '/' + updated[0] + ' ' + hora;
        var app = new Vue({
            el: '#seo',
            data: {
                titulo: '${config_site_slogan}',
                desc: '${config_site_description}',
                categorias: null,
                cat_url: '${categoria_pagina_url}',
                pagina_url: '${pagina_url}',
                pagina_updated: updated,
                pagina_nome: null,
                img: '',
                link: null,
                categoria_nome: null
            },
            created: function() {

            }
        });

        setTimeout(() => {

            image = `
            <img src="${baseUri}/media/site/${config_site_logo}">
            `;
            $("#img_facebook").html(image);
            $("#img_facebook").find('img').addClass('card-img-top');
            $("#img_facebook").find('img').css({
                "width": "100%",
                "height": "200px",
                "object-fit": "cover"
            });

        }, 500);

        $(document).ready(function() {
            $("#keywords_seo").attr('name', 'produto_keywords');
            $("#pagina_desc").attr('name', 'produto_desc');

            $('#keywords_seo').tagsinput({
                confirmKeys: [32],
                delimiter: ',',
            });

            $("#labelDesc").html('Descrição da Loja');

            $('#config_site_cnpj').mask('00.000.000/0000-00');
        });


        $("#descSeo").html('- ${config_site_author}');

        $("#keywords_seo").val("${config_site_keywords}");
        $("#pagina_desc").val("${config_site_description}");

        function changeSeo(id, campo) {
            if (campo == 'titulo') {
                app.titulo = $(id).val();
            }
        }
        $("#pagina_desc").change(() => {
            $("#config_site_description").val($("#pagina_desc").val());
        });
        $("#keywords_seo").change(() => {
            $("#config_site_keywords").val($("#keywords_seo").val());
        });

        $('#emails').tagsinput({
            confirmKeys: [32],
            delimiter: ',',
        });
    </script>
</body>

</html>