<style>
    <?php echo $data['color']; ?>
</style>
<?php foreach ($data['prod'] as $prod): ?>
    <div class="mt-3">
        <div class="product-card">
            <a href="javascript:void(0)">
                <div class="product-thumb">
                    <?php if ($prod->produto_oferta == 1) : ?>
                        <span class="badge badge-danger rounded-0">Oferta</span>
                    <?php endif; ?>
                    <img src="${baseUri}/media/produto/thumb_<?= $prod->produto_foto ?>" alt="foto ">
                    <?php if ($prod->produto_foto_hover != "") : ?>
                        <span>
                            <img src="${baseUri}/media/produto/thumb_<?= $prod->produto_foto_hover ?>" class="foto-hover" />
                        </span>
                    <?php endif; ?>
                </div>
                <div class="product-card-body">
                    <span class="product-title"><?= (($prod->produto_titulo)) ?></span>
                    <?php if ($prod->produto_estoque <= 0): ?>
                        <p class="hide-on-vitrine product-title-indisponivel">Indisponível</p>
                    <?php else: ?>
                        <?php if ($prod->produto_desconto > 0): ?>
                            <span class="product-card-text-line">
                                R$ <?= $prod->produto_preco_original ?>
                            </span>
                        <?php endif; ?>
                        <span class="product-card-text-price">
                            R$ <?= $prod->produto_preco ?>
                        </span>
                        <?php if ($prod->qtd_parcelas > 1): ?>
                            <span class="product-card-parc">
                                <?= $prod->produto_text_parc ?>
                            </span>
                        <?php endif; ?>
                        <?php if ($prod->desc_boleto > 0): ?>
                            <span class="product-card-disc">
                                ${config_card_text_desconto} R$ <?= $prod->produto_preco_desc_boleto ?>
                            </span>
                            <small class="product-card-percent">
                                <?= $prod->desc_boleto ?>${config_card_text_percent}
                            </small>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
                <button class="btn btn-primary btn-block btn-sm hide-on-vitrine" type="button">
                    <i class="fa fa-shopping-cart"></i>
                    ${config_card_tooltip_text}
                </button>
            </a>
        </div>
    </div>
<?php endforeach; ?>