<?php

namespace Payment;

class PagarMe
{

    static public function indexAction($gw)
    {
        $sk = $gw->token;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://api.pagar.me/core/v5/orders?page=1&size=10');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
        $headers = [];
        $headers[] = 'Accept: application/json';
        $headers[] = 'Authorization: Basic ' . base64_encode("$sk:");
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        echo $result;
        curl_close($ch);
    }

    static public function payment($payload)
    {
        $sk = $payload['token'];
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://api.pagar.me/core/v5/orders');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

        $headers = [];
        $headers[] = 'Accept: application/json';
        //$headers[] = 'Authorization: Basic ' . base64_encode("$skt:$pkt");
        $headers[] = 'Authorization: Basic ' . base64_encode("$sk:");
        $headers[] = 'Content-Type: application/json';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error: ' . curl_error($ch);
            $pay = [
                'erro' => ['msg' => curl_error($ch), 'result' => $result],
            ];
        } else {
            $res = json_decode($result);
            if (isset($res->errors)) {
                //notificar_erro_admin_dev
                //\Filter::pre($res->errors);
                $pay = [
                    'erro' => 1,
                    'error_obj' => $res->errors,
                    //'code' => $res->code,
                    //'status' => $res->status,
                    //'metodo' => $res->charges[0]->payment_method,
                    'json' => $result
                ];
            } else {
                $pay = [
                    'erro' => 0,
                    'id' => $res->id,
                    //'success' => $res->success,
                    'code' => $res->code,
                    'status' => $res->status,
                    'metodo' => $res->charges[0]->payment_method,
                    'transactions' => $res->charges[0]->last_transaction,
                    'json' => $result
                ];
            }
        }
        curl_close($ch);
        return (object) $pay;
    }

    static public function doPayload($payer, $pedido, $payType = 'cartao')
    {
        $customer = [
            "name" => "$payer->name",
            "email" => "$payer->email",
            "type" => ($payer->document_type == 'CPF') ? "individual" : "company",
            "document" => self::onlyNumbers($payer->document),
            "phones" => [
                "home_phone" => [
                    "country_code" => $payer->phone->country_code,
                    "number" => $payer->phone->number,
                    "area_code" => $payer->phone->area_code
                ],
            ],
        ];

        $billing_address = [
            "line_1" => $payer->address->street . ", " . $payer->address->number . ", " . $payer->address->neighborhood,
            "line_2" => ($payer->address->complement != "") ?  $payer->address->complement : "",
            "zip_code" => $payer->address->zip_code,
            "city" => $payer->address->city,
            "state" => $payer->address->state,
            "country" => $payer->address->country
        ];


        $items = [];
        /*
        if (isset($pedido->itens)) {
        $item = $pedido->itens;
        if (!empty($item)) {
        foreach ($item as $p) {
        $items[] = [
        "amount" => $p->unit_price,
        "description" => $p->title,
        "quantity" => $p->quantity,
        "code" => $p->id
        ];
        }
        }
        }
        */
        /* harcode item unico para aplicar desconto pagarme */
        if (isset($pedido->pedido_total_parcelado) && $pedido->pedido_total_parcelado > 0) {
            $vtotal = $pedido->pedido_total_parcelado;
        } else {
            $vtotal = $pedido->pedido_total_frete;
        }
        $items[] = [
            "amount" => self::onlyNumbers($vtotal),
            "description" => "COMPRA " . $pedido->pedido_id,
            "quantity" => 1,
            "code" => $pedido->pedido_id
        ];

        $pix = [
            "items" => $items,
            "customer" => $customer,
            "payments" => [
                [
                    "payment_method" => "pix",
                    "pix" => ["expires_in" => "52134613"]
                ],
            ],
        ];

        $boleto = [
            "items" => $items,
            "customer" => $customer,
            "antifraud_enabled" => false,
            "payments" => [
                [
                    "boleto" => [
                        "nosso_numero" => "1222",
                        "instructions" => "receber",
                        "bank" => "001"
                    ],
                    "payment_method" => "boleto"
                ],
            ],
        ];

        if (!isset($payer->card)) {
            $payer->card = new \stdClass;
            $payer->card->number = "";
            $payer->card->installments = 1;
            $payer->card->holder_name = "";
            $payer->card->exp_month = "";
            $payer->card->exp_year = "";
            $payer->card->cvc = "";
        }
        $cartao = [
            "items" => $items,
            "customer" => $customer,
            "antifraud_enabled" => false,
            "payments" => [
                [
                    "payment_method" => "credit_card",
                    "credit_card" => [
                        "recurrence" => false,
                        "installments" => $payer->card->installments,
                        "statement_descriptor" => "COMPRA " . $pedido->pedido_id,
                        "card" => [
                            "number" => $payer->card->number,
                            "holder_name" => $payer->card->holder_name,
                            "exp_month" => $payer->card->exp_month,
                            "exp_year" => $payer->card->exp_year,
                            "cvv" => $payer->card->cvc,
                            "billing_address" => $billing_address
                        ],
                    ],
                ],
            ],
        ];

        $payload = match ($payType) {
            "boleto" => $boleto,
            "cartao" => $cartao,
            "pix" => $pix,
            default => $pix
        };
        return $payload;
    }

    static public function installments($amount, $maxInstallments = 12, $MaxInstallmentsFee = 1)
    {
        $amount = \Math::money2Decimal($amount);
        $fees = self::fees();
        $fees = array_slice($fees, 0, $maxInstallments);
        $parcelas = [];
        foreach ($fees as $key => $value) {

            if ($key + 1 <= $MaxInstallmentsFee) {
                $v_parcela = $amount  / ($key + 1);
                $v_total = $amount;
            } else {
                $v_parcela = ($amount + ($value / 100) * $amount) / ($key + 1);
                $v_total = ($amount + ($value / 100) * $amount);
            }
            $parcelas[$key + 1] = (object) [
                'installment_amount'  =>  number_format($v_parcela, 2, ',', '.'),
                'amount' => number_format($v_total, 2, ',', '.')
            ];
        }
        return  $parcelas;
    }

    static  public function fees()
    {
        $juros = [];
        $juros[1] = 4.49;
        $juros[2] = 6.47;
        $juros[3] = 7.46;
        $juros[4] = 8.45;
        $juros[5] = 9.44;
        $juros[6] = 10.43;
        $juros[7] = 11.42;
        $juros[8] = 12.41;
        $juros[9] = 13.40;
        $juros[10] = 14.39;
        $juros[11] = 15.38;
        $juros[12] = 16.37;
        return $juros;
    }


    static public function onlyNumbers($value)
    {
        return (preg_replace('/[^0-9]/D', '', "$value"));
    }


    public function status($token, $order_id)
    {
        $url = "https://api.pagar.me/core/v5/orders/{$order_id}";
        $headers = [
            'Accept: application/json',
            'Authorization: Basic ' . $token
        ];
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $response = curl_exec($ch);
        curl_close($ch);
        $data = json_decode($response, true);
        return $data;
    }


    static public function status_code($status_txt)
    {
        $status_n = 1;
        if ($status_txt == 'pending' || $status_txt == 'in_process') {
            $status_txt_n = 1;
        }
        if ($status_txt == 'rejected' || $status_txt == 'cancelled' || $status_txt == 'refunded' || $status_txt == 'failed') {
            $status_txt_n = 7;
        }
        if ($status_txt == 'paid') {
            $status_n = 3;
        }
        return $status_n;
    }

    static public function transaction_type($type)
    {
        $type = match ($type) {
            "boleto" => 'Boleto',
            "credit_card" => 'Crédito',
            "pix" => 'Pix',
            "debit_card" => 'Débito',
            default => 'Pix'
        };
        return $type;
    }
}
