<?php

namespace Frete;

class MelhorEnvio
{

    /*
    SERVICOS:
    1 - PAC    - correios
    2 - SEDEX  - correios
    3 - .Package - jadlog
    4 - .Com -  jadlog
    9 -  Rodoviario - Via Brasil
    12 - efacil - Latam
    15 - amanha - azul
    16 - ecommerce - azul
    17 - mini envios - correios
    22 - rodoviario - buslog
    27 - .package centralizado - jadolog
    28 - pac centralizado - correios
    29 - sedex centralizado - correios
    30  - mini envio centralizado - correios
    */
    public $services = [1, 2, 3, 4, 9, 15, 16, 17, 22, 27, 28, 29, 30];

    public function __construct() {}

    public function indexAction() {}

    public function get_frete($conf, $produtos)
    {
        $refresh = self::atualizar_token();
        $conf = (object) $conf;
        $produtos = (object) $produtos;
        $url_me = "https://melhorenvio.com.br";
        if ($refresh) {
            $conf->melhorenvio_token = $refresh;
        }
        $access_token = $conf->melhorenvio_token;
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url_me . "/api/v2/me/shipment/calculate");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        $itens = [];
        $conf->cep_origem = str_replace("-", "", $conf->cep_origem);
        $conf->cep_destino = str_replace("-", "", $conf->cep_destino);
        $adicional = (isset($conf->adicional)) ? $conf->adicional : 0;

        foreach ($produtos as $k) {
            $k = (object) $k;
            if (isset($k->produto_calcula_frete) && intval($k->produto_calcula_frete) > 0) {
                $itens[] = [
                    "id" => $k->produto_id,
                    "height" => str_replace(",", ".", $k->altura),
                    "length" => str_replace(",", ".", $k->comprimento),
                    "quantity" => $k->quantidade,
                    "weight" => str_replace(",", ".", $k->peso),
                    "width" => str_replace(",", ".", $k->largura),
                    "insurance_value" => $k->produto_preco,
                ];
            }
        }
        $body = [
            "from" => [
                "postal_code" => $conf->cep_origem,
            ],
            "to" => [
                "postal_code" => $conf->cep_destino,
            ],
            "products" => $itens,
            "services" => $conf->melhorenvio_servicos,
        ];
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($body));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Accept: application/json",
            "Content-Type: application/json",
            "Authorization: Bearer $access_token",
        ]);
        $response = curl_exec($ch);
        curl_close($ch);
        $res = json_decode($response);
        //\Filter::pre($res);        exit;
        $result = [];

        if (is_array($res) && count($res) > 0) {
            $prices = [];
            $dvtime = [];
            $ordem = [];
            foreach ($res as $serv) {
                if (!isset($serv->error) && empty($serv->error)) {
                    $ordem["$serv->price"] = $serv;
                }
            }
            ksort($ordem);
            $res = $ordem;
            if (sizeof($res) > 5) {
                $res = array_slice($res, 0, 5);
            }
            foreach ($res as $serv) {
                //if (!isset($serv->error) && empty($serv->error)) {
                $pack = [
                    'l' => $serv->packages[0]->dimensions->length,
                    'w' => $serv->packages[0]->dimensions->width,
                    'h' => $serv->packages[0]->dimensions->height,
                    'we' => $serv->packages[0]->weight,
                    'e' => $serv->packages[0]->insurance_value
                ];
                $result[] = [
                    "code" => $serv->name,
                    "price" => $serv->price + $adicional,
                    "name" => $serv->company->name . " - " . $serv->name,
                    "company" => $serv->company->id,
                    "deadline" => $serv->delivery_time + 1,
                    "rastreio" => 1,
                    "id" => $serv->id,
                    "pack" => $pack
                ];
                // if(!in_array($serv->price, $prices) && !in_array($serv->delivery_time, $dvtime) ){
                /*
                if (intval($serv->price) > 0) {
                $prices["$serv->price"] = $serv->price;
                $dvtime["$serv->delivery_time"] = $serv->delivery_time;
                $cb .= '<tr>';
                $cb .= '<td width=20>';
                $cb .= '<input type="radio" class="btn-update-frete" name="tipo_frete[]" id="' . $serv->id . '"  t="' . $serv->company->name . ' ' . $serv->name . '" value="' . $serv->price . '|' . $serv->delivery_time . '" v="' . $this->double($serv->price) . '" p="' . $serv->delivery_time . '"  melhorEnvioId="' . $serv->id . '"
                l="' . $serv->packages[0]->dimensions->length . '"
                w="' . $serv->packages[0]->dimensions->width . '"
                h="' . $serv->packages[0]->dimensions->height . '"
                we="' . $serv->packages[0]->weight . '"
                e="' . $serv->packages[0]->insurance_value . '"
                
                />';
                $cb .= '</td>';
                $cb .= '<td>';
                $cb .= '<label for="' . $serv->id . '"><b>';
                if ($serv->price == "") {
                $cb .= 'Frete Grátis';
                } else {
                $cb .= "R$ " . str_replace(".", ",", $serv->price);
                }
                $cb .= '&nbsp;&nbsp;&nbsp;&nbsp;' . $serv->company->name . ' - ' . $serv->name . ' - ' . $serv->delivery_time . ' dia(s)</b>';
                $cb .= '</label>';
                $cb .= '</td>';
                $cb .= '</tr>';
                }
                */
                //}
            }
        }
        return $result;
    }

    public function cart_add($p, $config_frete)
    {
        if (!isset($p->pedido_frete_id) || empty($p->pedido_frete_id)) {
            return (object) ['status' => 0, 'erro' => 'pedido_frete_id nao informado.'];
            exit;
        }
        $conf = $config_frete;
        $refresh = self::atualizar_token();
        if ($refresh) {
            $token = $refresh;
        }
        $token = $conf->frete_melhorenvio_token;
        $u = self::get_info_usuario($token);

        $dados = [
            'service' => $p->pedido_frete_id,
        ];

        if (intval($conf->frete_melhorenvio_ponto) > 0) {
            $dados['agency'] = $conf->frete_melhorenvio_ponto;
        }
        $dados['from'] = [
            'name' => $u->firstname . ' ' . $u->lastname,
            'phone' => $u->phone->phone,
            'email' => $u->email,
            'document' => $u->document,
            'company_document' => ($conf->frete_melhorenvio_cnpj ?? ""),
            'address' => $u->address->address,
            'complement' => $u->address->complement,
            'number' => $u->address->number,
            'district' => $u->address->district,
            'city' => $u->address->city->city,
            'state_abbr' => $u->address->city->state->state_abbr,
            'country_id' => 'BR',
            'postal_code' => $u->address->postal_code,
            'note' => '',
        ];
        if (isset($p->config_frete->mehorenvio_cnae) && strlen($p->config_frete->mehorenvio_cnae) > 1) {
            $dados['from']['economic_activity_code'] = $p->config_frete->mehorenvio_cnae;
        }

        if (strlen($p->address->endereco_cliente_complemento) > 63) {
            $p->address->endereco_cliente_complemento = substr($p->address->endereco_cliente_complemento, 0, 63);
        }
        $dados['to'] = [
            'name' => "{$p->cliente_nome}",
            'phone' => $p->cliente_telefone,
            'email' => $p->cliente_email,
            //'document' => $p->cliente_cpf,
            'address' => "{$p->address->endereco_cliente_rua}",
            'complement' => "{$p->address->endereco_cliente_complemento}",
            'number' => "{$p->address->endereco_cliente_num}",
            'district' => "{$p->address->endereco_cliente_bairro}",
            'city' => $p->address->endereco_cliente_cidade,
            'state_abbr' => $p->address->endereco_cliente_uf,
            'country_id' => 'BR',
            'postal_code' => $p->address->endereco_cliente_cep,
            'note' => "{$p->address->endereco_cliente_titulo}",
        ];
        if ($p->cliente_tipo == 1) {
            $dados['to']['document'] = $p->cliente_cpf;
        } else {
            $dados['to']['company_document'] = $p->cliente_cnpj;
        }

        $produtos = [];
        foreach ($p->lista as $i) {
            $produtos[] = [
                'name' => $i->lista_pedido_produto_titulo,
                'quantity' => $i->lista_pedido_qtde,
                'unitary_value' => $i->produto_preco,
            ];
        }
        $dados['products'] = $produtos;
        $dados['volumes'] = [
            'height' => $p->pedido_frete_height,
            'width' =>  $p->pedido_frete_width,
            'length' => $p->pedido_frete_length,
            'weight' => $p->pedido_frete_weight,
        ];

        $dados['options'] = [
            'insurance_value' => $p->pedido_total_produto,
            'receipt' => 0,
            'own_hand' => 0,
            'reverse' => 0,
            'non_commercial' => false,
            'invoice' => ['key' => "{$p->pedido_nf_chave}"],
            'platform' => "FluxShop",
            'tags' => [
                'tag' => $p->pedido_id,
                //'url' => $this->baseUri . '/cliente/pedido/' . $pedido_id . '/',
            ],
        ];


        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => "https://www.melhorenvio.com.br/api/v2/me/cart",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HEADER => FALSE,
            //CURLOPT_MAXREDIRS => 10,
            //CURLOPT_TIMEOUT => 0,
            //CURLOPT_FOLLOWLOCATION => true,
            //CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            //CURLOPT_POST => 1,
            CURLOPT_POSTFIELDS => json_encode($dados),
            CURLOPT_HTTPHEADER => [
                "Accept: application/json",
                "Content-Type: application/json",
                "Authorization: Bearer $token",
            ],
        ]);
        $response = curl_exec($curl);
        $resp = json_decode($response);
        $error = curl_error($curl);
        curl_close($curl);

        if (!isset($resp->error) && !isset($resp->id)) {
            return (object) ['status' => 0, 'erro' => $error, 'resp' => $response];
        }
        if (isset($resp->error) && $resp->error != "") {
            return (object) ['status' => 0, 'erro' => $resp->error, 'resp' => $response];
        }
        if (isset($resp->id) && !empty($resp->id)) {
            return (object) ['status' => 1, 'ok' => 'true', 'resp' => $resp];
        }
    }
    public function autorizacao_callback()
    {
        $frete = (new \Factory('frete'))->find(1);
        $config = (new \Config)->get();

        if (isset($_GET['code']) && !empty($_GET['code']) && !empty($frete->frete_melhorenvio_secret)) {
            $api = [
                "grant_type" => "authorization_code",
                "client_id" => intval($frete->frete_melhorenvio_client_id),
                "client_secret" => $frete->frete_melhorenvio_secret,
                "redirect_uri" => \Frete::get_melhorenvio_callback_url($frete),
                "code" => $_GET['code'],
            ];

            $curl = curl_init();

            curl_setopt_array($curl, [
                CURLOPT_URL => "https://melhorenvio.com.br/oauth/token",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => json_encode($api),
                CURLOPT_HTTPHEADER => [
                    "Accept: application/json",
                    "Content-Type: application/json",
                    "User-Agent: $config->config_site_title ($config->config_site_email)",
                ],
            ]);

            $response = curl_exec($curl);
            $err = curl_error($curl);

            curl_close($curl);

            if ($err) {
                \Http::redirect_to('/frete?error&curl_error');
            } else {
                $response = json_decode($response);
                if (isset($response->access_token) && !empty($response->access_token) && isset($response->refresh_token) && !empty($response->refresh_token)) {
                    $add = [
                        'frete_id' => 1,
                        'frete_melhorenvio_token' => $response->access_token,
                        'frete_melhorenvio_refresh_token' => $response->refresh_token,
                        'frete_melhorenvio_data_refresh_token' => date('Y-m-d'),
                    ];
                    (new \Factory('frete'))->with($add)->save();
                    \Http::redirect_to('/frete?success');
                } else {
                    \Http::redirect_to('/frete?error');
                }
            }
        }
    }

    public function atualizar_token()
    {
        $config = (new \Config)->get();
        $data_atual = date('Y-m-d');

        $frete = (new \Factory('frete'))
            ->select('frete_melhorenvio_client_id, frete_melhorenvio_secret, frete_melhorenvio_refresh_token, frete_melhorenvio_data_refresh_token')
            ->where("frete_id = 1 AND DATEDIFF('$data_atual',frete_melhorenvio_data_refresh_token) = 21")
            ->get();

        $frete = (isset($frete[0]) && is_array($frete)) ? $frete[0] : null;

        if ($frete && !empty($frete->frete_melhorenvio_client_id) && !empty($frete->frete_melhorenvio_secret)) {

            $api = [
                "grant_type" => "refresh_token",
                "client_id" => intval($frete->frete_melhorenvio_client_id),
                "client_secret" => $frete->frete_melhorenvio_secret,
                "redirect_uri" => \Frete::get_melhorenvio_callback_url($frete),
                "refresh_token" => $frete->frete_melhorenvio_refresh_token,
            ];

            $curl = curl_init();

            curl_setopt_array($curl, [
                CURLOPT_URL => "https://melhorenvio.com.br/oauth/token",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => json_encode($api),
                CURLOPT_HTTPHEADER => [
                    "Accept: application/json",
                    "Content-Type: application/json",
                    "User-Agent: $config->config_site_title ($config->config_site_email)",
                ],
            ]);

            $response = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);

            if (!$err) {
                $response = json_decode($response);
                if (isset($response->access_token) && !empty($response->access_token) && isset($response->refresh_token) && !empty($response->refresh_token)) {
                    $add = [
                        'frete_id' => 1,
                        'frete_melhorenvio_token' => $response->access_token,
                        'frete_melhorenvio_refresh_token' => $response->refresh_token,
                        'frete_melhorenvio_data_refresh_token' => date('Y-m-d'),
                    ];
                    (new \Factory('frete'))->with($add)->save();
                    return $response->access_token;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function get_info_usuario($token)
    {
        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => "https://melhorenvio.com.br/api/v2/me",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            //CURLOPT_FOLLOWLOCATION => true,
            //CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => [
                "Accept: application/json",
                "Authorization: Bearer $token",
            ],
        ]);
        $response = curl_exec($curl);
        curl_close($curl);
        if ($response) {
            return json_decode($response);
        }
    }

    static public function pontos($uf = 'SP', $city = 'São Paulo')
    {
        //$company = 2;
        $country = 'BR';
        $url = 'https://melhorenvio.com.br/api/v2/me/shipment/agencies';
        $params = [
            //'company' => $company,
            'country' => $country,
            'state' => $uf,
            'city' => $city
        ];
        $url .=  '?' . http_build_query($params, "", "&", PHP_QUERY_RFC3986);
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, false);
        curl_setopt($ch, CURLOPT_USERAGENT, 'FLUXSHOP (suporte@phpstaff.com.br)');
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['accept: application/json']);
        $response = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Erro ao fazer requisição cURL: ' . curl_error($ch);
        }
        curl_close($ch);
        return $response;
    }

    public function get_carrinho($token)
    {
        //$access_token = (new Melhorenvio)->atualizaAccessTokenMelhorEnvio();
        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => "https://melhorenvio.com.br/api/v2/me/cart",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => [
                "Accept: application/json",
                "Authorization: Bearer $token",
            ],
        ]);
        $response = curl_exec($curl);
        curl_close($curl);
        echo $response;
    }
}
