<?php

use Erp\BlingApi;
use PHPImager\Watermarker;
use PHPImager\ImageResizer;

class ProdutosAdmin
{

    public function __construct()
    {
        Sessao::check();
        (new Install)->check_tabelas_principais();
    }

    public function upgrade()
    {
        $columns = [
            ['name' => 'gtin', 'type' => 'varchar(255)'],
            ['name' => 'gtint', 'type' => 'varchar(255)'],
            ['name' => 'class_tipoprod', 'type' => 'varchar(255)'],
            ['name' => 'class_oriprod', 'type' => 'varchar(255)'],
            ['name' => 'sku', 'type' => 'varchar(255)'],
        ];
        (new DB)->add_columns('produto', $columns);
    }

    public function indexAction()
    {
        $data = [
            'config' => (new Config)->get(),
            'integracao' => ['integracao' =>  Bling::modulo_status()],
            'mapper' => ['config', 'integracao']
        ];
        Tpl::view('admin.produto.index', $data, 1);
    }

    public function send_error()
    {
        echo json_encode(['status' => 401, 'msg' => 'Dados inválidos']);
    }

    public function categoria()
    {
        $data = [
            'config' => (new Config)->get(),
            'mapper' => ['config']
        ];
        Tpl::view('admin.produto.categoria', $data, 1);
    }
    public function subcategoria()
    {
        $data = [
            'config' => (new Config)->get(),
            'mapper' => ['config']
        ];
        Tpl::view('admin.produto.subcategoria', $data);
    }

    public function cadastroCategoria()
    {
        Sessao::perms('G');
        $dados = [
            'categoria_produto_url' => Filter::slug($_POST['categoria_produto_nome']),
            'categoria_produto_nome' => Req::post('categoria_produto_nome', 'string'),
        ];

        // if (Req::post('is_exclusiva', 'string') == "true") {
        //     $dados['categoria_produto_is_exclusiva_produto'] = Req::post('produto_id', 'int');
        //     $dados['categoria_produto_is_exclusiva'] = 1;
        // }

        (new Factory('categoria_produto'))->with($dados)->save();
        echo json_encode(['status' => 200]);
    }

    public function cadastroSubcategoria()
    {
        Sessao::perms('G');
        $dados = [
            'subcategoria_produto_url' => Filter::slug(Req::post('subcategoria_produto_nome', 'string')),
            'subcategoria_produto_nome' => Req::post('subcategoria_produto_nome', 'string'),
            'subcategoria_produto_pos' => Req::post('subcategoria_produto_nome', 'int'),
            'subcategoria_produto_ordem_destaque' => Req::post('subcategoria_produto_nome', 'int'),
            'subcategoria_produto_apelido' => Req::post('subcategoria_produto_nome', 'string'),
            'subcategoria_produto_categoria' => Req::post('subcategoria_produto_categoria', 'int'),
        ];

        // if (Req::post('is_exclusiva', 'string') == "true") {
        //     $dados['subcategoria_produto_is_exclusiva_produto'] = Req::post('produto_id', 'int');
        //     $dados['subcategoria_produto_is_exclusiva'] = 1;
        // }

        (new Factory('subcategoria_produto'))->with($dados)->save();

        echo json_encode(['status' => 200]);
    }

    public function getVinculoCategorias()
    {
        $produto_id = Req::post('produto_id', 'int');

        if ($produto_id > 0) {
            $categorias = (new Factory('vinculo_categoria_produto'))
                ->select("vinculo_categoria_produto_categoria AS categoria_produto_id")
                ->where("vinculo_categoria_produto_produto = $produto_id")
                ->group_by("vinculo_categoria_produto_categoria")
                ->get();
            if (!isset($categorias[0])) {
                $categorias = [];
            } else {
                $arr = [];
                foreach ($categorias as $k) {
                    array_push($arr, $k->categoria_produto_id);
                }
                $categorias = $arr;
            }
            $subcategorias = (new Factory('vinculo_categoria_produto'))
                ->select("vinculo_categoria_produto_subcategoria AS subcategoria_produto_id")
                ->where("vinculo_categoria_produto_produto = $produto_id")
                ->group_by("vinculo_categoria_produto_subcategoria")
                ->get();
            if (!isset($subcategorias[0])) {
                $subcategorias = [];
            } else {
                $arr = [];
                foreach ($subcategorias as $k) {
                    array_push($arr, $k->subcategoria_produto_id);
                }
                $subcategorias = $arr;
            }
            echo json_encode(['status' => 200, 'categorias' => $categorias, 'subcategorias' => $subcategorias]);
        } else {
            echo json_encode(['status' => 401]);
        }
    }

    public function vinculaCategoria()
    {
        $categoria_id = Req::post('categoria_id', 'int');
        $produto_id = Req::post('produto_id', 'int');

        if ($produto_id > 0 && $categoria_id > 0) {
            $with = [
                'categoria' => $categoria_id,
                'produto' => $produto_id
            ];
            (new Factory('vinculo_categoria_produto'))
                ->with($with)
                ->save();
            echo json_encode(['status' => 200]);
        } else {
            echo json_encode(['status' => 401]);
        }
    }
    public function desvinculaCategoria()
    {
        $categoria_id = Req::post('categoria_id', 'int');
        $produto_id = Req::post('produto_id', 'int');

        if ($produto_id > 0 && $categoria_id > 0) {
            (new Factory('vinculo_categoria_produto'))
                ->where("vinculo_categoria_produto_categoria = $categoria_id AND vinculo_categoria_produto_produto = $produto_id")
                ->drop();
            echo json_encode(['status' => 200]);
        } else {
            echo json_encode(['status' => 401]);
        }
    }

    public function vinculaSubcategoria()
    {
        $categoria_id = Req::post('categoria_id', 'int');
        $subcategoria_id = Req::post('subcategoria_id', 'int');
        $produto_id = Req::post('produto_id', 'int');

        if ($produto_id > 0 && $categoria_id > 0 && $subcategoria_id > 0) {
            $with = [
                'categoria' => $categoria_id,
                'subcategoria' => $subcategoria_id,
                'produto' => $produto_id
            ];
            (new Factory('vinculo_categoria_produto'))
                ->with($with)
                ->save();
            echo json_encode(['status' => 200]);
        } else {
            echo json_encode(['status' => 401]);
        }
    }
    public function desvinculaSubcategoria()
    {
        $categoria_id = Req::post('categoria_id', 'int');
        $produto_id = Req::post('produto_id', 'int');
        $subcategoria_id = Req::post('subcategoria_id', 'int');

        if ($produto_id > 0 && $categoria_id > 0 && $subcategoria_id > 0) {
            (new Factory('vinculo_categoria_produto'))
                ->where("vinculo_categoria_produto_categoria = $categoria_id AND vinculo_categoria_produto_produto = $produto_id AND vinculo_categoria_produto_subcategoria = $subcategoria_id")
                ->drop();
            echo json_encode(['status' => 200]);
        } else {
            echo json_encode(['status' => 401]);
        }
    }


    public function lista()
    {
        $p = (new Factory('produto'))
            ->select(" IF(produto_status = 1, 'Ativo', 'Inativo') AS produto_status_nome, produto_status, IF(produto_min_estoque > 0, produto_min_estoque, 0) AS produto_min_estoque,  produto_estoque, DATE_FORMAT(produto_created, '%d/%m/%Y') as produto_data,  produto_id, (SELECT COUNT(*) FROM relacao_atributo WHERE relacao_atributo_produto = produto_id) AS produto_qtd_atributos,
                produto_oferta, produto_url, produto_estoque, produto_titulo, produto_preco AS produto_preco_original, produto_desconto,
                (SELECT foto_produto_img FROM foto_produto WHERE foto_produto_produto = produto_id ORDER BY foto_produto_pos ASC LIMIT 1) as produto_foto,  DATE_FORMAT(produto_estoque_dt_sync, '%d/%m/%Y %H:%i') as produto_dt_estoque,
                produto_largura, produto_altura, produto_comprimento, produto_tamanho, produto_peso, produto_calcula_frete, produto_arquivo,
             (SELECT SUM(relacao_item_qtd) FROM relacao_item WHERE relacao_item_produto = produto.produto_id) AS produto_estoque_rel,

                    foto1.foto_produto_img as produto_foto, ifnull(nullif(foto1.foto_produto_img, ''), 'nopic.png') AS foto_produto_img            
                    ")
            ->join('foto_produto as foto1', 'foto1.foto_produto_produto = produto_id AND foto1.foto_produto_pos = 1', 'LEFT')
            ->order('produto.produto_status DESC,produto.produto_titulo ASC, produto.produto_id DESC')
            ->group_by('produto_id')
            ->get();
        if (isset($p[0]->produto_preco_original)) {
            foreach ($p as $k => $v) {
                // (foto, item_atributo, atributo, factory)
                $p[$k]->produto_preco_original = Filter::moeda($p[$k]->produto_preco_original);
            }
        }
        echo json_encode($p);
    }

    public function lista_por_id()
    {
        $id = intval(Http::get_in_params('lista_por_id')->value);
        if ($id > 0)
            echo (new Factory('produto'))
                ->select("*, DATE_FORMAT(produto_updated, '%d/%m/%Y - %h:%i:%s') as produto_updated")
                ->where('produto_id = ' . $id)
                ->order('produto_id DESC')
                ->get(1);
    }

    public function removerAtributo()
    {
        $atributo = Req::post('atributo_id', 'int');
        $produto = Req::post('produto_id', 'int');

        (new Factory('relacao_atributo'))
            ->where('relacao_atributo_produto = ' . $produto . ' AND relacao_atributo_atributo = ' . $atributo)
            ->drop();
        (new Factory('relacao_item'))
            ->where("relacao_item_produto = $produto")
            ->drop();
        echo trim('1');
    }

    // Lista os atributos disponiveis para cadastro de um produto
    public function lista_atributos()
    {
        $produto = Req::post('produto_id', 'int');
        if ($produto > 0) {
            (new Factory('atributo'))
                ->where('atributo_id NOT IN (SELECT relacao_atributo_atributo FROM relacao_atributo WHERE relacao_atributo_produto = ' . $produto . ')')
                ->order('atributo_id ASC')
                ->get(1);
        } else {
            $this->send_error();
        }
    }

    // Lista os atributos e os itens de um determinado produto
    public function lista_atributos_full()
    {
        $id = Req::post('produto_id', 'int');
        if ($id > 0) {
            // Captura todos os atributos pais do produto
            $atributo = (new Factory('atributo'))
                ->join('relacao_atributo', 'relacao_atributo_atributo = atributo_id')
                ->where('relacao_atributo_produto = ' . $id)
                ->group_by('atributo_id')
                ->order('relacao_atributo_id asc')
                ->get();
            if (is_array($atributo) && sizeof($atributo) > 0) {

                foreach ($atributo as $k => $v) {
                    // Captura todos os itens do atributo
                    $iattr = (new Factory('item_atributo'))
                        ->where('item_atributo_atributo = ' . $atributo[$k]->atributo_id)
                        ->order('item_atributo_nome asc')
                        ->get();
                    $atributo[$k]->item = $iattr;
                }

                // Captura o total em estoque com base nos atributos
                $qtd_estoque = (new Factory('relacao_item'))
                    ->select("SUM(relacao_item_qtd) AS estoque")
                    ->where("relacao_item_produto = $id")
                    ->get();
                if (isset($qtd_estoque[0])) {
                    $qtd_estoque = $qtd_estoque[0]->estoque;
                } else {
                    $qtd_estoque = 0;
                }
                $atributo = $this->preparaFilhosAtributos($atributo, $id);
                echo json_encode(["atributo" => $atributo[0], 'qtdAtributos' => $atributo[1], 'qtdEstoque' => $qtd_estoque]);
            } else {
                echo json_encode([]);
            }
        }
    }

    function preparaFilhosAtributos($atributos, $produto)
    {
        $qtd_atributos = sizeof($atributos);
        if ($qtd_atributos == 1) {
            // busca apenas pelos itens deste atributo            
            $atributos[0]->atributo_is_mandante = "1";
        } else {
            // iteração, começando do ultimo, subindo, do ultimo pro primeiro, inserindo os itens do ultimo no penultimo e por ai vai
            for ($i = $qtd_atributos - 1; $i > 0; $i--) {
                if ($i == $qtd_atributos - 1) {
                    $atributos[$i]->atributo_is_mandante = "1";
                } else {
                    $atributos[$i]->atributo_is_mandante = "0";
                }
                $atributoIteracao = $atributos[$i];
                $proxAtributo = $atributos[$i - 1];

                // insere o atributoInteracao em T O D O S  os itens do prox atributo                
                foreach ($proxAtributo->item as $k => $v) {
                    $proxAtributo->item[$k]->item_atributo_filhos = $atributoIteracao;
                }
                $atributos[$i - 1] = $proxAtributo;
            }
        }
        return [$atributos[0], $qtd_atributos];
    }

    public function getAtributoMandanteValores()
    {
        $itens_pai = Req::post('itens_pai');
        $atributo_atual = Req::post('atributo_atual');
        $produto_id = Req::post('produto_id', 'int');

        if (isset($atributo_atual) && !empty($atributo_atual)  && $produto_id > 0) {
            $cadeia_de_itens = isset($itens_pai) && !empty($itens_pai) ? implode('>', $itens_pai) : ''; // variavel usada para trazer o ramo certo dos atributos (avô > pai)

            foreach ($atributo_atual['item'] as $k => $v) {
                $res = (new Factory('relacao_item'))
                    ->where("relacao_item_item = " . $atributo_atual['item'][$k]['item_atributo_id'] . " AND relacao_item_produto = $produto_id AND relacao_item_relacao_pai = '$cadeia_de_itens'")
                    ->get();

                if ($res) {
                    $atributo_atual['item'][$k]['item_atributo_id_relacao'] = $res[0]->relacao_item_id; // salva o id da relacao
                    $atributo_atual['item'][$k]['item_atributo_preco'] = $res[0]->relacao_item_preco;
                    $atributo_atual['item'][$k]['item_atributo_qtd'] = $res[0]->relacao_item_qtd;
                    $atributo_atual['item'][$k]['item_atributo_valor'] = $res[0]->relacao_item_valor;
                } else {
                    $atributo_atual['item'][$k]['item_atributo_id_relacao'] = 0;
                    $atributo_atual['item'][$k]['item_atributo_preco'] = "";
                    $atributo_atual['item'][$k]['item_atributo_qtd'] = "";
                    $atributo_atual['item'][$k]['item_atributo_valor'] = "";
                }
            }
            echo json_encode(['status' => 200, 'atributo_atual' => $atributo_atual]);
        } else {
            echo json_encode(['status' => 401]);
        }
    }

    public function lista_categoria()
    {
        echo (new Factory('categoria_produto'))
            ->select("
                    categoria_produto_id, categoria_produto_nome, categoria_produto_pos,
                    (SELECT COUNT(*) FROM vinculo_categoria_produto WHERE vinculo_categoria_produto_categoria = categoria_produto_id) AS categoria_produto_qtd_produtos,
                    (SELECT COUNT(*) FROM subcategoria_produto WHERE subcategoria_produto_categoria = categoria_produto_id) AS categoria_produto_qtd_subcategorias                    
                    ")
            ->order('categoria_produto_pos ASC')
            ->get(1);
    }
    public function lista_subcategoria()
    {
        $id = intval(Http::get_in_params('lista_subcategoria')->value);
        if ($id > 0)
            echo (new Factory('subcategoria_produto'))
                ->select("subcategoria_produto_pos, subcategoria_produto_ordem_destaque, subcategoria_produto_apelido, IF(subcategoria_produto_pos = 1, 'Sim', 'Não') AS subcategoria_produto_pos_nome, subcategoria_produto_id, subcategoria_produto_nome, subcategoria_produto_categoria, categoria_produto_nome, (SELECT COUNT(*) FROM vinculo_categoria_produto WHERE vinculo_categoria_produto_subcategoria = subcategoria_produto_id) AS subcategoria_produto_qtd")
                ->join('categoria_produto', 'categoria_produto_id = subcategoria_produto_categoria')
                ->where('subcategoria_produto_categoria = ' . $id)
                ->get(1);
        else
            echo (new Factory('subcategoria_produto'))
                ->select("subcategoria_produto_pos, subcategoria_produto_ordem_destaque, subcategoria_produto_apelido, IF(subcategoria_produto_pos = 1, 'Sim', 'Não') AS subcategoria_produto_pos_nome, subcategoria_produto_id, subcategoria_produto_nome, subcategoria_produto_categoria, categoria_produto_nome, (SELECT COUNT(*) FROM vinculo_categoria_produto WHERE vinculo_categoria_produto_subcategoria = subcategoria_produto_id) AS subcategoria_produto_qtd")
                ->join('categoria_produto', 'categoria_produto_id = subcategoria_produto_categoria')
                ->get(1);
    }

    public function lista_categoria_full()
    {
        $categorias = (new Factory('categoria_produto'))
            //->select("categoria_produto_id, categoria_produto_nome, categoria_produto_url")
            ->order('categoria_produto_pos ASC')
            ->get();
        if (isset($categorias[0])) {
            foreach ($categorias as $cat) {
                $cat->subcategorias = (new Factory('subcategoria_produto'))
                    ->select("subcategoria_produto_id, subcategoria_produto_nome")
                    ->where("subcategoria_produto_categoria = $cat->categoria_produto_id")
                    ->get();
            }
        }
        echo json_encode(['status' => 200, 'categorias' => $categorias]);
    }

    public function gravar_categoria()
    {
        Sessao::perms('G');
        $_POST['categoria_produto_url'] = Filter::slug($_POST['categoria_produto_nome']);
        Req::drop_blank();
        $format = ['categoria_produto_nome' => 'text', 'categoria_produto_url' => 'text'];
        (new Factory('categoria_produto'))->with($_POST)->format($format)->save();
        if (Req::get('return')) {
            Http::redirect_to("/" . Req::get('return'));
        } else {
            Http::redirect_to("/produtos-categoria/?success");
        }
    }

    public function update_categoria_pos()
    {
        echo (new Factory('categoria_produto'))->with($_POST)->save();
    }

    public function gravar_subcategoria()
    {
        Sessao::perms('G');
        $_POST['subcategoria_produto_url'] = Filter::slug($_POST['subcategoria_produto_nome']);
        $_POST['subcategoria_produto_ordem_destaque'] = intval($_POST['subcategoria_produto_ordem_destaque']);

        (new Factory('subcategoria_produto'))->with($_POST)->save();
        if (Req::get('return')) {
            Http::redirect_to("/" . Req::get('return'));
        } else {
            Http::redirect_to("/produtos-subcategoria/?success");
        }
    }

    public function gravarAtributo()
    {
        $produto_id = Req::post('produto_id', 'int');
        $atributo_id = Req::post('atributo_id', 'int');

        if ($produto_id > 0 && $atributo_id > 0) {
            $with = [
                "produto" => $produto_id,
                "atributo" => $atributo_id
            ];
            // verifica se ja tem algum atributo cadastrado, caso tenha, o atributo que está sendo adicionado vira filho do adicionado
            $res = (new Factory('relacao_atributo'))
                ->select('relacao_atributo_id')
                ->where("relacao_atributo_produto = $produto_id")
                ->order('relacao_atributo_id DESC')
                ->limit(1)
                ->get();
            if ($res) {
                $with['relacao_pai'] = $res[0]->relacao_atributo_id;
            }

            $save = (new Factory('relacao_atributo'))->with($with)->save();

            (new Factory('relacao_item'))
                ->where("relacao_item_produto = $produto_id")
                ->drop();

            if ($save > 0) {
                echo 1;
            } else {
                echo 0;
            }
        } else {
            echo 0;
        }
    }

    public function gravarItemAtributo()
    {
        $produto = Req::post('produto', 'int');
        $atributo = Req::post('atributo_id', 'int');
        $item_preco = Req::post('iattr_preco');
        $item_valor = Req::post('iattr_valor');
        $item_qtd = Req::post('iattr_qtde', 'int');
        $item_id = Req::post('iattr_id', 'int');
        $relacao = Req::post('relacao', 'int');
        $itens = Req::post('itens');

        $item_preco = str_replace('.', '', $item_preco);
        $item_preco = str_replace(',', '.', $item_preco);
        if ($item_preco == '')
            $item_preco = '0.00';
        if ($item_qtd == '')
            $item_qtd = 0;

        if ($item_qtd < 0) {
            $item_id = 0;
        }
        $relacao_pai = (isset($itens) && is_array($itens) && sizeof($itens) > 0) ? implode('>', $itens) : '';

        $relatrr_id = (new Factory('relacao_item'))
            ->where("relacao_item_relacao_atributo = $relacao AND relacao_item_atributo = $atributo  AND relacao_item_item = $item_id AND relacao_item_produto = $produto AND relacao_item_relacao_pai = '$relacao_pai'")
            ->get();

        if ($relatrr_id) {
            $data = [
                'relacao_item_preco' => $item_preco,
                'relacao_item_qtd' => $item_qtd,
                'relacao_item_id' => $relatrr_id[0]->relacao_item_id,
            ];
            if (isset($item_valor) && !empty($item_valor))
                $data['relacao_item_valor'] = $item_valor;

            (new Factory('relacao_item'))
                ->with($data)
                ->save();
        } else {
            $data = [
                'relacao_item_preco' => $item_preco,
                'relacao_item_qtd' => $item_qtd,
                'relacao_item_produto' => $produto,
                'relacao_item_item' => $item_id,
                'relacao_item_atributo' => $atributo,
                'relacao_item_relacao_atributo' => $relacao,
                'relacao_item_relacao_pai' => $relacao_pai
            ];
            if (isset($item_valor) && !empty($item_valor))
                $data['relacao_item_valor'] = $item_valor;
            $res = (new Factory('relacao_item'))
                ->with($data)
                ->save();
        }

        // Captura o total em estoque com base nos atributos
        $qtd_estoque = (new Factory('relacao_item'))
            ->select("SUM(relacao_item_qtd) AS estoque")
            ->where("relacao_item_produto = $produto")
            ->get();
        if (isset($qtd_estoque[0])) {
            $qtd_estoque = $qtd_estoque[0]->estoque;
        } else {
            $qtd_estoque = 0;
        }
        echo json_encode(["status" => 200, 'qtdEstoque' => $qtd_estoque]);
    }

    public function insereFotoAtributo()
    {
        // Filter::pre($_FILES);
        // Filter::pre($_POST);
        // exit;

        $ids = [];
        $files = $_FILES;
        if (is_array($files) && sizeof($files) > 0) {
            // Limpa os form de foto de atributo que não foi submetido nenhuma foto
            foreach ($files as $k => $v) {
                if ($files[$k]['error'] > 0)
                    unset($files[$k]);
                else {
                    $split = str_replace('foto-attr-', '', $k);
                    $split = explode('|', $split);
                    $ids[] = $split;
                }
            }

            $i = 0;
            // Verificando novamente, pois caso nenhum form seja enviado com foto não tem que subir nada
            if (is_array($files) && sizeof($files) > 0) {
                $factory = new Factory('relacao_atributo');
                foreach ($files as $k => $v) {
                    // (foto, item_atributo, atributo, factory)
                    @$this->setFotoAttr($files[$k], $ids[$i][0], $ids[$i][1], $factory);
                    $i++;
                }
            }
        }
    }

    public function setFotoAttr($foto, $atributo, $atributoCat, $factory)
    {
        // tenta subir a foto
        $media = Media::img_upload($foto, 'atributos');
        if (isset($media) && !empty($media)) {

            /*
            $dados = [
            'relacao_item_produto' => Req::post('produto_id', 'int'),
            'relacao_item_valor' => $media->url,
            'relacao_item' => ""
            ];
            */

            $dados = [
                'relacao_atributo_produto' => Req::post('produto_id', 'int'),
                'relacao_atributo_atributo' => $atributoCat,
                'relacao_atributo_item_atributo' => $atributo,
                'relacao_atributo_valor' => $media->url
            ];


            /*
            $dados = [
            'relacao_atributo_produto' => Req::post('produto_id', 'int'),
            'relacao_atributo_atributo' => $atributoCat,
            'relacao_atributo_item_atributo' => $atributo,
            'relacao_atributo_valor' => $media->url
            ];
            
            
            // deleta a foto antiga
            $fotoAntiga = (new Factory('relacao_atributo'))
            ->select('relacao_atributo_valor, relacao_atributo_id')
            ->where('relacao_atributo_item_atributo = ' . $atributo . ' AND relacao_atributo_produto = ' . Req::post('produto_id', 'int'))
            ->get()[0];
            if (isset($fotoAntiga->relacao_atributo_id) && !empty($fotoAntiga->relacao_atributo_id)) {
            $dados['relacao_atributo_id'] = $fotoAntiga->relacao_atributo_id;
            if (isset($fotoAntiga->relacao_atributo_valor) && !empty($fotoAntiga->relacao_atributo_valor)) {
            $ds = DIRECTORY_SEPARATOR;
            $path = Path::base() . $ds . 'media' . $ds . 'atributos' . $ds . $fotoAntiga->relacao_atributo_valor;
            @unlink($path);
            }
            }
            */
            // salva a nova foto
            $factory->with($dados)->save();
            //Filter::pre($dados);            exit;
        }
    }

    public function gravar()
    {
        $redirect = '';
        if (isset($_POST['redirect'])) {
            $redirect = $_POST['redirect'];
            unset($_POST['redirect']);
        }
        $this->insereFotoAtributo();
        Sessao::perms('G');
        Req::drop('_wysihtml5_mode');
        //Req::drop_blank();
        $escope = [
            'produto_keywords' => 'text',
            'produto_titulo' => 'text',
            'produto_ref' => 'text',
            'produto_disp' => 'text',
            'produto_preco' => 'money',
            'produto_desconto' => 'money',
        ];
        if (isset($_POST['produto_titulo']) && !empty($_POST['produto_titulo'])) {
            $_POST['produto_url'] = Filter::slug($_POST['produto_titulo']);
        }

        if (isset($_POST['produto_id'])) {
            $_POST['produto_arquivo'] = isset($_POST['produto_arquivo']) && !empty($_POST['produto_arquivo']) ? $_POST['produto_arquivo'] : '0';
            $_POST['produto_status'] = isset($_POST['produto_status']) && !empty($_POST['produto_status']) ? $_POST['produto_status'] : '0';
            $_POST['produto_oferta'] = isset($_POST['produto_oferta']) && !empty($_POST['produto_oferta']) ? $_POST['produto_oferta'] : '0';
            $_POST['produto_destaque'] = isset($_POST['produto_destaque']) && !empty($_POST['produto_destaque']) ? $_POST['produto_destaque'] : '0';
            $_POST['produto_calcula_frete'] = isset($_POST['produto_calcula_frete']) && !empty($_POST['produto_calcula_frete']) ? $_POST['produto_calcula_frete'] : '0';
            $slugr = $_POST['produto_titulo'] . "-cod-" . $_POST['produto_id'];
            $_POST['produto_url'] = Filter::slug($slugr);
        }
        $_POST['produto_marca'] = isset($_POST['produto_marca']) && !empty($_POST['produto_marca']) ? $_POST['produto_marca'] : '0';



        $produto = (new Factory('produto'))->with($_POST)->format($escope)->save();
        if ($produto > 0) {
            if (Bling::modulo_status() == 1) {
                //atualizar produto na bling
                if (Bling::modulo_rec('rec2') == 1) {
                    $this->sync_produto($produto);
                }
            }
            Http::redirect_to('/produto-editar/id/' . $produto . '/?success/' . $redirect);
        } else {
            Http::redirect_to('/produtos-lista/?error');
        }
    }

    public function editar()
    {
        $id = intval(Http::get_in_params('id')->value);
        if ($id > 0) {
            $produto = (new Factory('produto'))
                ->where("produto_id = $id")
                ->get();
            if (!empty($produto)) {
                $produto[0]->produto_preco = number_format($produto[0]->produto_preco, 2, ',', ' ');
                $produto[0]->produto_desconto = number_format($produto[0]->produto_desconto, 2, ',', ' ');
                $data = [
                    'produto' => $produto[0],
                    'config' => (new Config)->get(),
                    'mapper' => ['config', 'produto']
                ];
                Tpl::view('admin.produto.form', $data);
            } else {
                Http::redirect_to('/produtos-lista/');
            }
        } else {
            Http::redirect_to('/produtos-lista/');
        }
    }
    public function novo()
    {
        $produto = (new Factory('produto'))->map();
        $data = [
            'produto' => $produto,
            'config' => (new Config)->get(),
            'mapper' => ['config', 'produto']
        ];
        $data['produto']->categoria_produto_url = '';
        Tpl::view('admin.produto.form', $data);
    }

    public function remover()
    {
        Sessao::perms('G');
        $id = intval(Req::post('id'));
        if ($id > 0) {
            (new Factory('produto'))->drop($id);
            (new Factory('foto_produto'))->where('foto_produto_produto = ' . $id)->drop();
            (new Factory('produtos_relacionados'))->where('produtos_relacionados_produto1 = ' . $id . ' OR produtos_relacionados_produto2 = ' . $id)->drop();
            echo 1;
        } else {
            echo -1;
        }
    }
    public function remover_categoria()
    {
        Sessao::perms('G');
        $id = intval(Req::post('id'));
        if ($id > 0) {
            (new Factory('categoria_produto'))->drop($id);
            echo 1;
        } else {
            echo -1;
        }
    }

    public function remover_subcategoria()
    {
        Sessao::perms('G');
        $id = intval(Req::post('id'));
        if ($id > 0) {
            (new Factory('subcategoria_produto'))->drop($id);
            echo 1;
        } else {
            echo -1;
        }
    }


    public function altera_status()
    {
        Sessao::perms('G', 1);
        if (isset($_POST['id'])) {
            $id = intval($_POST['id']);
            if ($id > 0) {
                $status = intval($_POST['produto_status']);
                $status == 1 ? $status = 0 : $status = 1;
                $data = [
                    'id' => $id,
                    'produto_status' => $status
                ];
                //add bling update
                (new Factory('produto'))->with($data)->save();
            }
        }
    }
    public function url()
    {
        if (isset($_POST['value'])) {
            $_POST['value'] = Filter::slug($_POST['value']);
        }
        echo $_POST['value'];
    }

    public function ordenar()
    {
        $produtos = json_decode(Req::post('diff'));
        $db_produto = (new Factory('categoria_produto'));
        foreach ($produtos as $produto) {
            $id = explode('-', $produto->node->_prevClass);
            if (intval($id[2]) > 0 && isset($id[2])) {
                $data = [
                    'id' => $id[2],
                    'pos' => $produto->newPosition,
                ];
                $db_produto->with($data)->save();
            }
        }
    }

    public function relaciona_produto()
    {
        $p1 = Req::post('produto1', 'int');
        $p2 = Req::post('produto2', 'int');
        $data = [
            'produto1' => $p1,
            'produto2' => $p2
        ];

        (new Factory('produtos_relacionados'))->with($data)->save();
        echo '1';
    }

    public function remove_relacao()
    {
        $p1 = Req::post('produto1', 'int');
        $p2 = Req::post('produto2', 'int');
        $where = "produtos_relacionados_produto1 = $p1 AND produtos_relacionados_produto2 = $p2";
        (new Factory('produtos_relacionados'))->where($where)->drop();
        echo '1';
    }

    public function lista_produtos_relacionados()
    {
        $id = intval(Http::get_in_params('id')->value);
        if ($id > 0) {
            (new Factory('produto'))
                ->select('produto_id, produto_titulo, (SELECT foto_produto_img FROM foto_produto WHERE foto_produto_produto = produto_id LIMIT 1) as produto_foto')
                ->where('produto_id IN (SELECT produtos_relacionados_produto2 FROM produtos_relacionados WHERE produtos_relacionados_produto1 = ' . $id . ') AND produto_id <> ' . $id)
                ->get(1);
        }
    }

    public function lista_produtos_nao_relacionados()
    {
        $id = intval(Http::get_in_params('id')->value);
        if ($id > 0) {
            (new Factory('produto'))
                ->select('produto_id, produto_titulo')
                ->where('produto_id NOT IN (SELECT produtos_relacionados_produto2 FROM produtos_relacionados WHERE produtos_relacionados_produto1 = ' . $id . ') AND produto_id <> ' . $id)
                ->get(1);
        }
        // produtos_relacionados
    }
    // Imagens
    public function enviar_img()
    {
        $id = intval(Http::get_in_params('id')->value);
        if ($id > 0) {
            if (isset($_FILES) && !empty($_FILES)) {
                $media = Media::img_upload($_FILES['file'], 'produto');
                if (isset($media) && !empty($media)) {
                    $ds = DIRECTORY_SEPARATOR;
                    $nome_arquivo_original = $media->url;
                    $thumb_nome = 'thumb_' . $nome_arquivo_original;
                    $path_original = Path::base() . $ds . 'media' . $ds . 'produto' . $ds . $nome_arquivo_original;
                    $path_copia =    Path::base() . $ds . 'media' . $ds . 'produto' . $ds . $thumb_nome;
                    if (is_file($path_original)) {
                        //@system("chmod -R 777 $path_original");
                        //@system("chmod -R 777 $path_copia");
                        @copy($path_original, $path_copia);
                        new ImageResizer($path_copia, 400, 400, $path_copia);
                    }
                    $max_pos = (new Factory('foto_produto'))
                        ->select('IFNULL(MAX(foto_produto_pos), -1) AS max_pos')
                        ->where("foto_produto_produto = '$id'")->get()[0]->max_pos;

                    $pos = intval($max_pos) + 1 == 0 ? 1 : intval($max_pos) + 1;
                    $data = [
                        'img' => $media->url,
                        'url' => $media->path,
                        'produto' => $id,
                        'tamanho' => $media->size,
                        'tipo' => 1,
                        'pos' => $pos,
                    ];
                    (new Factory('foto_produto'))->with($data)->save();
                    echo 0;
                    exit;
                } else {
                    echo -1;
                    exit;
                }
            }
        } else {
            echo -1;
            exit;
        }
    }
    public function lista_img_produto()
    {
        $id = intval(Http::get_in_params('id')->value);
        if ($id > 0) {
            (new Factory('foto_produto'))->select('foto_produto_id, foto_produto_pos, foto_produto_img, foto_produto_url')
                ->where("foto_produto_produto = '$id'")
                ->order('foto_produto_pos ASC')
                ->get('true');
        } else {
            echo -1;
            exit;
        }
    }

    public function ordena_img()
    {

        $produto_id = intval($_POST['produto_id']);
        if ($produto_id > 0 && isset($_POST['data']) && !empty($_POST['data'])) {
            $db_foto = (new Factory('foto_produto'));
            foreach ($_POST['data'] as $k) {
                $data = [
                    'id' => $k['foto_id'],
                    'pos' => $k['pos'],
                ];
                $db_foto->with($data)->save();
            }
            echo 0;
            exit;
        } else {
            echo -1;
        }
    }

    public function remove_all_img_produto()
    {
        $id = intval($_POST['produto_id']);
        if ($id > 0) {
            $fotos = (new Factory('foto_produto'))
                ->select("foto_produto_img as img")
                ->where("foto_produto_produto = $id")
                ->get();
            if (isset($fotos[0])) {
                $ds = DIRECTORY_SEPARATOR;
                $path_delete = Path::base() . $ds . 'media' . $ds . 'produto' . $ds;
                foreach ($fotos as $foto) {
                    if (file_exists($path_delete . $foto->img)) {
                        @unlink($path_delete . $foto->img);
                        @unlink($path_delete . 'thumb_' . $foto->img);
                    }
                }
            }
            (new Factory('foto_produto'))
                ->where("foto_produto_produto = $id")
                ->drop();
            echo 0;
            exit;
        } else {
            echo -1;
            exit;
        }
    }

    public function remove_img()
    {
        $id = intval($_POST['produto_id']);
        if ($id > 0) {
            if (isset($_POST['data'])) {
                foreach ($_POST['data'] as $k) {
                    $ids[] = $k['id'];
                }
                if (sizeof($ids) > 1) {
                    $ids = implode(',', $ids);
                    $where = "foto_produto_produto = '$id' AND foto_produto_id IN ($ids)";
                } else {
                    $ids = $ids[0];
                    $where = "foto_produto_produto = '$id' AND foto_produto_id = $ids";
                }
                $fotos_para_deletar = (new Factory('foto_produto'))
                    ->select("foto_produto_img as img")
                    ->where($where)
                    ->get();

                if (isset($fotos_para_deletar[0])) {
                    $ds = DIRECTORY_SEPARATOR;
                    $path_delete = Path::base() . $ds . 'media' . $ds . 'produto' . $ds;
                    foreach ($fotos_para_deletar as $foto) {
                        if (file_exists($path_delete . $foto->img)) {
                            @unlink($path_delete . $foto->img);
                            @unlink($path_delete . 'thumb_' . $foto->img);
                        }
                    }
                }
                (new Factory('foto_produto'))
                    ->where($where)
                    ->drop();
                echo 0;
                exit;
            } else {
                echo -1;
            }
        } else {
            echo -1;
            exit;
        }
    }

    public function acessos()
    {
        $data = [
            'config' => (new Config)->get(),
            'mapper' => ['config']
        ];
        Tpl::view('admin.produto.acessos.index', $data, 1);
    }

    public function acessos_lista()
    {
        echo (new Factory('produto'))
            ->select('produto_titulo, foto_produto_img AS produto_foto, (SELECT COUNT(*) FROM visualizacoes_produto WHERE visualizacoes_produto_produto = produto_id) AS produto_visitas')
            ->join('foto_produto', 'foto_produto_produto = produto_id', 'INNER')
            ->order('produto_visitas DESC')
            ->group_by('produto_id')
            ->get('json');
    }

    public function avaliacoes()
    {
        $data = [
            'config' => (new Config)->get(),
            'mapper' => ['config']
        ];
        Tpl::view('admin.produto.avaliacoes.index', $data, 1);
    }

    public function avaliacoes_lista()
    {
        echo (new Factory('produto'))
            ->join('avaliacoes_produto', 'avaliacoes_produto_produto = produto_id', 'INNER')
            ->join('cliente', 'cliente_id = avaliacoes_produto_cliente', 'INNER')
            ->get('json');
    }

    public function altera_status_avaliacao()
    {
        Sessao::perms('G', 1);
        if (isset($_POST['id'])) {
            $id = Req::post('id', null);
            if ($id > 0) {
                $status = Req::post('status', null);
                $status == 1 ? $status = 0 : $status = 1;
                $data = [
                    'id' => $id,
                    'status' => $status,
                ];
                (new Factory('avaliacoes_produto'))->with($data)->save();
            }
        } else {
            echo -1;
        }
    }

    public function importar()
    {
        $prods = self::importar_csv();

        if (isset($prods['values']) && sizeof($prods['values']) > 0) {
            $keys = $prods['keys'];
            foreach ($prods['values'] as $p) {
                $p = array_combine($keys, $p);
                $catsub = $p['produto_categoria_subcategoria'];
                unset($p['produto_categoria_subcategoria']);
                $p['produto_estoque'] = intval($p['produto_estoque']);
                $p['produto_min_estoque'] = intval($p['produto_min_estoque']);

                if (intval($p['produto_preco']) <= 0) {
                    $p['produto_preco'] = 0;
                }
                $p['produto_preco'] = str_replace(',', '.', $p['produto_preco']);

                if (intval($p['produto_desconto']) <= 0) {
                    //unset($p['produto_desconto']);
                    $p['produto_desconto'] = 0;
                }
                if (intval($p['produto_marca']) <= 0) {
                    unset($p['produto_marca']);
                }
                //insere novo produto se ID for 0 ou branco na planilha
                if (isset($p['produto_id']) && intval($p['produto_id']) <= 0) {
                    unset($p['produto_id']);
                }

                if (isset($p['produto_id'])) {
                    $p['produto_url'] = Filter::slug($p['produto_titulo']) . "-cod-" . intval($p['produto_id']);
                }
                $id =  (new Factory('produto'))->with($p)->save();

                if (!isset($p['produto_id']) || intval($p['produto_id']) <= 0) {
                    $p['produto_id'] = $id;
                    $p['produto_url'] = Filter::slug($p['produto_titulo']) . "-cod-" . intval($p['produto_id']);
                    (new Factory('produto'))->with($p)->save();
                }
                //atualiza categorias/subs 
                if (isset($catsub[0]) && $catsub[0] > 0 &&  intval($p['produto_id']) > 0) {
                    self::atualiza_catsubs($catsub, $p['produto_id']);
                }
                //desativado por demorar em muitos produtos, rodar via cronjob o Cron::sync_produtos_bling();
                if (Bling::modulo_status() == 1 &&  intval($p['produto_id']) > 0) {
                    //  $this->sync_produto($p['produto_id']);
                }
            }
            Http::redirect_to('/produtos-lista/?success');
        } else {
            Http::redirect_to('/produtos-lista/?error');
        }
    }

    static public function atualiza_catsubs($catsub, $pid)
    {
        $catsub = explode(',', $catsub); // 0 = categoria; 1 = subcategoria;

        (new Factory('vinculo_categoria_produto'))->where("vinculo_categoria_produto_produto = $pid")->drop();
        foreach ($catsub as $cs) {
            $cs = explode('-', $cs);
            if (isset($cs[0])) {
                $cat = intval($cs[0]);
                //$sub = isset($cs[1]) ? $cs[1] : null;
                $dados = [
                    'vinculo_categoria_produto_produto' => $pid,
                    'vinculo_categoria_produto_categoria' => $cat,
                ];
                if (isset($cs[1])) {
                    $dados['vinculo_categoria_produto_subcategoria'] = $cs[1];
                }
                (new Factory('vinculo_categoria_produto'))->with($dados)->save();
            }
        }
    }

    public function exportar_csv()
    {
        $produtos = (new Factory('produto'))->order('produto_status DESC')->get();
        $csv = "ID;Nome;Preço;Estoque Atual;Estoque Mínimo;GTIN;GTINT;Palavras-chave;Oferta (1 - Sim / 0 - Não);Largura (cm);Altura (cm);Comprimento (cm);Peso (kg ex: 0.5);Desconto;Calcula Frete (1 - Sim / 0 - Não);Destaque (1 - Sim / 0 - Não);Cód. Referência;ID da Marca;Disponibilidade (ex: Intermediata);Status (1 - Sim / 0 - Não);Classificação Fiscal;Tipo de Unidade (ex: UN, CAIXA);ID's Categoria/Sub\r";
        foreach ($produtos as $p) {
            $p->produto_categoria_subcategoria = "";

            $categorias = (new Factory('vinculo_categoria_produto'))
                ->where("vinculo_categoria_produto_produto = $p->produto_id")
                ->get();
            $cat_subs = [];

            if (isset($categorias[0])) {
                $cat_sub = "";
                foreach ($categorias as $k => $v) {
                    $cat_sub = "$v->vinculo_categoria_produto_categoria";
                    if ($v->vinculo_categoria_produto_subcategoria != "") {
                        $cat_sub .= "-$v->vinculo_categoria_produto_subcategoria";
                    }
                    $cat_subs[] = $cat_sub;
                }
                $p->produto_categoria_subcategoria = implode(',', $cat_subs);
            }
            $p->produto_desc = str_replace([';'], [''], "$p->produto_desc");
            if ($p->produto_marca == 0) {
                $p->produto_marca = "";
            }
            if ($p->produto_categoria_subcategoria == 0) {
                $p->produto_categoria_subcategoria = "";
            }
            $csv .= "$p->produto_id;";
            $csv .= "$p->produto_titulo;";
            $csv .= "$p->produto_preco;";
            $csv .= "$p->produto_estoque;";
            $csv .= "$p->produto_min_estoque;";
            $csv .= "$p->produto_gtin;";
            $csv .= "$p->produto_gtint;";
            $csv .= "$p->produto_keywords;";
            $csv .= "$p->produto_oferta;";
            $csv .= "$p->produto_largura;";
            $csv .= "$p->produto_altura;";
            $csv .= "$p->produto_comprimento;";
            $csv .= "$p->produto_peso;";
            $csv .= "$p->produto_desconto;";
            $csv .= "$p->produto_calcula_frete;";
            $csv .= "$p->produto_destaque;";
            $csv .= "$p->produto_ref;";
            $csv .= "$p->produto_marca;";
            $csv .= "$p->produto_disp;";
            $csv .= "$p->produto_status;";
            $csv .= "$p->produto_class_fiscal;";
            $csv .= "$p->produto_tipo_unidade;";
            $csv .= "$p->produto_categoria_subcategoria";
            //$csv .=  "$p->produto_desc";
            $csv .= "\r";
        }
        @header("Content-type: application/csv");
        @header("Content-Disposition: attachment; filename=produtos.txt");
        echo $csv;
    }

    static public function importar_csv()
    {
        $keys = [
            'produto_id',
            'produto_titulo',
            'produto_preco',
            'produto_estoque',
            'produto_min_estoque',
            'produto_gtin',
            'produto_gtint',
            'produto_keywords',
            'produto_oferta',
            'produto_largura',
            'produto_altura',
            'produto_comprimento',
            'produto_peso',
            'produto_desconto',
            'produto_calcula_frete',
            'produto_destaque',
            'produto_ref',
            'produto_marca',
            'produto_disp',
            'produto_status',
            'produto_class_fiscal',
            'produto_tipo_unidade',
            'produto_categoria_subcategoria',
            //'produto_desc',
        ];

        $final = ['keys' => '', 'values' => ''];
        if (isset($_FILES['csv']) && !empty($_FILES['csv'])) {
            $pathCsv = Media::upload($_FILES['csv'], 'csv', 'file', 'produtos');
            /*
            if (isset($pathCsv->path)) {
            $csv = $pathCsv->path;
            if (is_file($csv)) {
            $csv = file_get_contents($csv);
            $csv = explode("\n", $csv);
            unset($csv[0]);
            $csv = array_filter($csv);
            $csv = array_map(function ($v) {
            return str_getcsv($v, ";");
            }, $csv);
            $final = ['keys' => $keys, 'values' => $csv];
            }
            }
            */
            //ms-excel
            $csv = array_map(function ($v) {
                return str_getcsv($v, "\r");
            }, file($pathCsv->path));

            if (!isset($csv[1])) {
                $csv = $csv[0];
                unset($csv[0]);
            } else {
                $csv = array_map(function ($v) {
                    return $v[0];
                }, $csv);
            }
            unset($csv[0]);
            $csv = array_map(function ($v) {
                return str_getcsv($v, ";");
            }, $csv);

            $final = ['keys' => $keys, 'values' => $csv];
        }
        return $final;
    }

    public function sync_produto($pid = null)
    {
        if ($pid == null) {
            $pid = intval($_REQUEST['id']);
        }
        if (intval($pid) <= 0) {
            return false;
        }
        $p = (new Factory('produto'))->join('marca', 'marca_id = produto_marca')->where('produto_id = ' . $pid)->get()[0];
        if (isset($p->produto_id) && $p->produto_id > 0) {
            $estoque = intval($p->produto_estoque);
            $status = ($p->produto_status == 1) ? 'A' : 'I';
            $status = 'A';
            $foto = self::get_first_foto($pid);
            $p->marca_nome = ($p->marca_nome != '') ? $p->marca_nome : 'Marca';
            $link = Http::base() . "/produto/" . $p->produto_url;
            $p = [
                'nome'     => $p->produto_titulo,
                'preco'    => $p->produto_preco,
                'pesoLiquido'     => $p->produto_peso,
                'pesoBruto' => $p->produto_peso,
                'codigo'   => $p->produto_id,
                'marca'    => $p->marca_nome,
                'freteGratis' => ($p->produto_calcula_frete == 1) ? true : false,
                'gtin' => "{$p->produto_gtin}",
                'gtinEmbalagem' => "{$p->produto_gtint}",
                'tipoProducao' => ($p->produto_class_oriprod != '') ? $p->produto_class_oriprod : 'P',
                "dimensoes" => [
                    "largura" => $p->produto_largura,
                    "altura" => $p->produto_altura,
                    "profundidade" => $p->produto_comprimento,
                    "unidadeMedida" => 1
                ],
                'tributacao' => ['ncm' => "{$p->produto_class_fiscal}"],
                'tipo'     => 'P',
                'situacao' => $status,
                'linkExterno' => $link,
                'formato'  => 'S',
                'unidade'  => strtoupper($p->produto_tipo_unidade),
                //'imagemURL' => $foto,
                'midia' => [
                    /*'video' => [
                        'url' => '<string>'
                    ], */
                    'imagens' => [
                        'externas' => [
                            [
                                'link' => $foto
                            ]
                        ]
                    ]
                ]
            ];
            $pb = Bling::get_produto($pid);
            if (isset($pb->id)) {
                //echo 'sync<br>';
                $p['id'] = $pb->id;
                $p  = (object) $p;
                $res = Bling::sync_produto($p);
                //Filter::pre($res);
            } else {
                //echo 'add<br>';
                $p  = (object) $p;
                $res =  Bling::add_produto($p);
                //Filter::pre($res);
            }
            if (Bling::modulo_rec('rec3') == 1) {
                $rest = Bling::sync_estoque($pid, $estoque);
            }
        }
    }

    public function sync_all_produtos()
    {
        $prods = (new Factory('produto'))->get();
        foreach ($prods as $prod) {
            $this->sync_produto($prod->produto_id);
            sleep(5);
        }
    }

    static public function get_first_foto($pid)
    {
        $f = (new Factory('foto_produto'))->where("foto_produto_produto = $pid")->order('foto_produto_pos ASC')->limit(1)->get();
        $base = Http::base() . '/media/produto/';
        if (isset($f[0])) {
            return $base . $f[0]->foto_produto_img;
        } else {
            return $base . 'nopic.png';
        }
    }
}
