<?php

function faturaCielo($cielo, $pedido_id, $pedido_total)
{
    $card_parcela = Req::post('card_parcela', 'string');
    $valor_parcela = Req::post('valor_parcela', 'string');
    $cardNumber = Req::post('cardNumber', 'string');
    // captura os dados do cliente (endereço, nome e cpf sem caracteres (enviado no post))
    // capturar endereço
    $endereco = null;
    if (isset($_SESSION['frete']['endereco_id']) && !empty($_SESSION['frete']['endereco_id'])) {
        $endereco = (new Factory('endereco_cliente'))->find($_SESSION['frete']['endereco_id']);
    } else {
        // busca no banco
        $endereco = (new Factory('endereco_cliente'))->find_by('endereco_cliente_cliente', Session::client_node('uid'));
    }
    $cli_zip = str_replace('-', '', $endereco->endereco_cliente_cep);
    $cliente_email = Session::client_node('umail');
    $cli_rua = $endereco->endereco_cliente_rua;
    $cli_num = $endereco->endereco_cliente_num;

    $cliente = (new Factory('cliente'))->find(Session::client_node('uid'));
    $cliente_full = explode(' ', $cliente->cliente_nome);
    $cliente_nome = isset($cliente_full[0]) ? $cliente_full[0] : ' ';
    $cliente_sobrenome = isset($cliente_full[1]) ? $cliente_full[1] : ' ';
    $cliente->telefone = preg_replace('/\W/', '', $cliente->cliente_telefone);
    $cliente->ddd = substr($cliente->telefone, 0, 2);
    $cliente->telefone = substr($cliente->telefone, 2, -1);

    if (isset($_POST['cardholderName']) && !empty($_POST['cardholderName'])) {
        $cliente_full = explode(' ', $_POST['cardholderName']);
        if (isset($cliente_full[0]) && !empty($cliente_full[0])) {
            $cliente_nome = $cliente_full[0];
        } else {
            $cliente_nome = '';
        }
        if (isset($cliente_full[1]) && !empty($cliente_full[1])) {
            $cliente_sobrenome = $cliente_full[1];
        } else {
            $cliente_sobrenome = '';
        }
    }

    if (isset($_POST['docNumberFake']) && !empty($_POST['docNumberFake'])) {
        $cli_doc_num = $_POST['docNumberFake'];
        $cli_doc_num = str_replace('.', '', $cli_doc_num);
        $cli_doc_num = str_replace('-', '', $cli_doc_num);
        $cli_doc_num = str_replace('/', '', $cli_doc_num);
        $cli_tipo_doc = strlen($cli_doc_num) > 11 ? 'CNPJ' : 'CPF';
    } else {
        $cli_doc_num = '';
        $cli_tipo_doc = '';
    }
    $retorno = Http::base() . '/Notificacao/cielo';
    $urlCielo = $cielo->pay_pass == 1 ? "https://api.cieloecommerce.cielo.com.br/1/sales/" : "https://apisandbox.cieloecommerce.cielo.com.br/1/sales/";
    
    // Total da compra    

    // $totalCentavos = str_replace(",", "", $pedido_total);
    $totalCentavos = explode(",", $pedido_total);
    if ($totalCentavos[1] < 10) {
        $totalCentavos[1] = $totalCentavos[1] . "0";
    }
    $totalCentavos = ($totalCentavos[0] * 100) + $totalCentavos[1];
    
    $header = [
        "Content-Type: application/json",
        "MerchantId: $cielo->pay_user",
        "MerchantKey: $cielo->pay_key"
    ];

    // Filter::pre($_POST, 1);

    $body = '
    {  
        "MerchantOrderId":"' . $pedido_id . '",
        "Customer":
        {  
            "Name":"' . $cliente->cliente_nome . '",
            "Identity": "' . $cliente->cliente_cpf . '",
            "Address":
            {
                "Street": "' . $endereco->endereco_cliente_rua . '",
                "Number": "' . $endereco->endereco_cliente_num . '",    
                "Complement": "' . $endereco->endereco_cliente_complemento . '",
                "ZipCode" : "' . $endereco->endereco_cliente_cep . '",
                "District": "' . $endereco->endereco_cliente_bairro . '",
                "City": "' . $endereco->endereco_cliente_cidade . '",
                "State" : "' . $endereco->endereco_cliente_uf . '",
                "Country": "BRA"
            }
        },
        "Payment":
        {  
            "Type":"CreditCard",
            "Amount":"' . $totalCentavos . '",
            "Provider":"BRADESCO",
            "Address": "' . $endereco->endereco_cliente_rua . '",
            "Assignor": "Loja Virtual",
            "Demonstrative": "Compra online em Loja Virtual",

            "Installments":' . $card_parcela . ',
            "CreditCard":{
                "CardNumber":"' . $cardNumber . '",
                "ExpirationDate":"' . Req::post('expirationMonth', 'string') . '/' . Req::post('expirationYear', 'string') . '",
                "SecurityCode":"' . Req::post('cvv', 'string') . '",
                "Brand":"' . Req::post('brand', 'string') . '"                           
            },
            "IsCryptoCurrencyNegotiation": false
        }
    }
    ';

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $urlCielo);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_VERBOSE, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
    $res = curl_exec($ch);

    if (curl_errno($ch)) {
        print_r("Erro: " . curl_error($ch));
        exit;
    }
    curl_close($ch);
    return $res;
}

function faturaCieloBoleto($cielo, $pedido_id, $pedido_total)
{
    $config = (new Factory('config'))->find(1);
    // captura os dados do cliente (endereço, nome e cpf sem caracteres (enviado no post))
    // capturar endereço
    $endereco = null;
    if (isset($_SESSION['frete']['endereco_id']) && !empty($_SESSION['frete']['endereco_id'])) {
        $endereco = (new Factory('endereco_cliente'))->find($_SESSION['frete']['endereco_id']);
    } else {
        // busca no banco
        $endereco = (new Factory('endereco_cliente'))->find_by('endereco_cliente_cliente', Session::client_node('uid'));
    }
    $cli_zip = str_replace('-', '', $endereco->endereco_cliente_cep);
    $cliente_email = Session::client_node('umail');
    $cli_rua = $endereco->endereco_cliente_rua;
    $cli_num = $endereco->endereco_cliente_num;

    $cliente = (new Factory('cliente'))->find(Session::client_node('uid'));
    $cliente_full = explode(' ', $cliente->cliente_nome);
    $cliente_nome = isset($cliente_full[0]) ? $cliente_full[0] : ' ';
    $cliente_sobrenome = isset($cliente_full[1]) ? $cliente_full[1] : ' ';
    $cliente->telefone = preg_replace('/\W/', '', $cliente->cliente_telefone);
    $cliente->ddd = substr($cliente->telefone, 0, 2);
    $cliente->telefone = substr($cliente->telefone, 2, -1);

    if (isset($_POST['cardholderName']) && !empty($_POST['cardholderName'])) {
        $cliente_full = explode(' ', $_POST['cardholderName']);
        if (isset($cliente_full[0]) && !empty($cliente_full[0])) {
            $cliente_nome = $cliente_full[0];
        } else {
            $cliente_nome = '';
        }
        if (isset($cliente_full[1]) && !empty($cliente_full[1])) {
            $cliente_sobrenome = $cliente_full[1];
        } else {
            $cliente_sobrenome = '';
        }
    }

    if (isset($_POST['docNumberFake']) && !empty($_POST['docNumberFake'])) {
        $cli_doc_num = $_POST['docNumberFake'];
        $cli_doc_num = str_replace('.', '', $cli_doc_num);
        $cli_doc_num = str_replace('-', '', $cli_doc_num);
        $cli_doc_num = str_replace('/', '', $cli_doc_num);
        $cli_tipo_doc = strlen($cli_doc_num) > 11 ? 'CNPJ' : 'CPF';
    } else {
        $cli_doc_num = '';
        $cli_tipo_doc = '';
    }
    $retorno = Http::base() . '/Notificacao/cielo';
    $urlCielo = $cielo->pay_pass == 1 ? "https://api.cieloecommerce.cielo.com.br/1/sales/" : "https://apisandbox.cieloecommerce.cielo.com.br/1/sales/";
    
    // Total da compra    

    // $totalCentavos = str_replace(",", "", $pedido_total);
    $totalCentavos = explode(",", $pedido_total);
    if(is_array($totalCentavos) && sizeof($totalCentavos) > 1) {
        if ($totalCentavos[1] < 10) {
            $totalCentavos[1] = $totalCentavos[1] . "0";
        }
        $totalCentavos = ($totalCentavos[0] * 100) + $totalCentavos[1];
    } else {
        $totalCentavos = $pedido_total * 100;
    }
    
    
    $header = [
        "Content-Type: application/json",
        "MerchantId: $cielo->pay_user",
        "MerchantKey: $cielo->pay_key"
    ];

    $hoje = date('y-m-d');
    $pedido_vencimento = date('y-m-d', strtotime("+$cielo->pay_c7 days", strtotime($hoje)));

    // Filter::pre($_POST, 1);

    $body = '
    {  
        "MerchantOrderId":"' . $pedido_id . '",
        "Customer":
        {  
            "Name":"' . $cliente->cliente_nome . '",
            "Identity": "' . $cliente->cliente_cpf . '",
            "Address":
            {
                "Street": "' . $endereco->endereco_cliente_rua . '",
                "Number": "' . $endereco->endereco_cliente_num . '",    
                "Complement": "' . $endereco->endereco_cliente_complemento . '",
                "ZipCode" : "' . $endereco->endereco_cliente_cep . '",
                "District": "' . $endereco->endereco_cliente_bairro . '",
                "City": "' . $endereco->endereco_cliente_cidade . '",
                "State" : "' . $endereco->endereco_cliente_uf . '",
                "Country": "BRA"
            }
        },
        "Payment":
        {  
            "Type":"Boleto",
            "Amount":"' . $totalCentavos . '",
            "Provider":"BRADESCO",
            "Address": "' . $endereco->endereco_cliente_rua . '",
            "Assignor": "Loja Virtual",
            "Demonstrative": "Compra online em Loja Virtual",
            "Address": "' . $endereco->endereco_cliente_rua . '",
            "BoletoNumber": "' . $pedido_id . '",
            "Assignor": "' . $config->config_site_title . '",
            "Demonstrative": "Compra online na plataforma ' . $config->config_site_title . '",
            "ExpirationDate": "' . $pedido_vencimento . '",
            "Identification": "' . $config->config_site_cnpj . '",
            "Instructions": "Aceitar somente até a data de vencimento."
        }
    }
    ';

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $urlCielo);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_VERBOSE, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
    $res = curl_exec($ch);

    if (curl_errno($ch)) {
        print_r("Erro: " . curl_error($ch));
        exit;
    }
    curl_close($ch);
    return $res;
}
