<?php

use Payment\PagarMe;

@session_start();

class PagamentoFront
{
    public $config_pagamento = null;
    public $config = null;
    public $gateway = null;
    // atributos de compra
    public $cart = null;
    public $totalProdutos = 0;
    public $totalFrete = 0;
    public $totalComCupom = 0;
    public $totalCompra = 0;
    public $pedidoId = null;
    public $descontoBoleto = null;
    public $deposito = null;
    public $totalParcelado = 0;
    //public $configPayment = null;
    public $metodo = null;


    public function __construct()
    {
        (new Install)->check_tabelas_principais();
        $this->config = (new Config)->get();
        $this->config_pagamento = (new Factory('pay'))->where('pay_name = "Config"')->get()[0]; // recebe o gateway ativo  
        if ($this->config_pagamento->pay_key == 'mercadoPago') {
            $this->gateway = (new Factory('pay'))->find_by('pay_name', 'mercadoPago');
        }
        if ($this->config_pagamento->pay_key == 'pagarMe') {
            $this->gateway = (new Factory('pay'))->find_by('pay_name', 'pagarMe');
        }
        /*       
        if ($this->config_pagamento->pay_key == 'pagSeguro') {
            $this->gateway = (new Factory('pay'))->find_by('pay_name', 'pagSeguro');
        }
        if ($this->config_pagamento->pay_key == 'Cielo') {
           $this->gateway = (new Factory('pay'))->find_by('pay_name', 'Cielo');           
         }
        */
        $this->deposito = (new Factory('pay'))->find(3); // Informações de Depósito
        $this->descontoBoleto = intval($this->config_pagamento->pay_fator_juros);
        $this->cart = (new Carrinho)->getCarrinho(1);
        if (!isset($this->cart) && empty($this->cart)) {
            echo json_encode(['error' => 'Nenhum produto no carrinho', 'redirect' => Http::base() . '/carrinho']);
            exit;
        }
    }

    public function indexAction()
    {
        if ($this->config_pagamento->pay_key == 'mercadoPago') {
            $this->viewMercadoPago();
        }
        if ($this->config_pagamento->pay_key == 'pagarMe') {
            $this->viewPagarMe();
        }
        if ($this->config_pagamento->pay_key == 'pagSeguro') {
            $this->viewPagseguro();
        }
        if ($this->config_pagamento->pay_key == 'Cielo') {
            $this->viewCielo();
        }
        if ($this->config_pagamento->pay_key == 'Deposito') {
            $this->viewDeposito();
        }
    }

    public function viewData()
    {
        $data = [
            'categorias' => (new CategoriasProdutosFront())->listar(),
            'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
            'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
            'paginasTopo' => (new Pagina())->listarPaginasTopo(),
            'gateway' => $this->gateway,
            'boleto_ativo' => $this->gateway->pay_c3,
            'deposito_ativo' => $this->deposito->pay_status,
            'desconto_boleto' => $this->descontoBoleto,
            'maxInstallments' => $this->config_pagamento->pay_c6,
            'paginasFooter' => (new Pagina())->listarPaginasFooter(),
            'faq' => (new Faq())->listaFooter(),
            'config' => $this->config,
            'social' => (new Config)->getRedesSociais(),
            'mapper' => ['config', 'social'],
        ];
        return $data;
    }

    public function viewMercadoPago()
    {

        $gw = self::gw();
        $data = [
            'categorias' => (new CategoriasProdutosFront())->listar(),
            'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
            'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
            'paginasTopo' => (new Pagina())->listarPaginasTopo(),
            'gateway' => $this->gateway,
            'boleto_ativo' => $this->gateway->pay_c3,
            //'deposito_ativo' => $this->deposito->pay_status,
            'deposito_ativo' => 0,
            'desconto_boleto' => intval($gw->pay_fator_juros),
            'maxInstallments' => intval($gw->pay_c6),
            'paginasFooter' => (new Pagina())->listarPaginasFooter(),
            'faq' => (new Faq())->listaFooter(),
            'config' => $this->config,
            'social' => (new Config)->getRedesSociais(),
            'mapper' => ['config', 'social'],
        ];
        Tpl::view("tema.loja.checkout.pagamento.mercadopago.index", $data, 1);
    }

    public function viewPagarMe()
    {
        $total = $this->cart['info']['total_sem_desconto_frete'];
        $gw = self::gw();
        $qtde_parcelas = intval($gw->pay_c6);
        $qtde_parcelas_sem_juros = intval($gw->pay_c8);
        $this->cart['info']['parcelas'] = $qtde_parcelas;
        $parcelasCalc = self::installments($total, $qtde_parcelas, $qtde_parcelas_sem_juros);
        $parcelas =  $parcelasCalc['lista'];


        $data = [
            'categorias' => (new CategoriasProdutosFront())->listar(),
            'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
            'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
            'paginasTopo' => (new Pagina())->listarPaginasTopo(),
            'gateway' => $this->gateway,
            'boleto_ativo' => $this->gateway->pay_c3,
            //'deposito_ativo' => $this->deposito->pay_status,
            'deposito_ativo' => 0,
            'desconto_boleto' => intval($gw->pay_fator_juros),
            'maxInstallments' => intval($gw->pay_c6),
            'paginasFooter' => (new Pagina())->listarPaginasFooter(),
            'faq' => (new Faq())->listaFooter(),
            'config' => $this->config,
            'parcelas' => $parcelas,
            'social' => (new Config)->getRedesSociais(),
            'mapper' => ['config', 'social'],
        ];
        Tpl::view("tema.loja.checkout.pagamento.pagarme.index", $data);
    }

    public function viewPagSeguro()
    {
        $this->gateway = (new Factory('pay'))->find(1);
        $email = $this->gateway->pay_user;
        $token = $this->gateway->pay_key;
        $url = "https://ws.pagseguro.uol.com.br/v2/sessions?email=$email&token=$token"; // Produção
        // $url = "https://ws.sandbox.pagseguro.uol.com.br/v2/sessions?email=$email&token=$token"; // sandbox

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            $erro = curl_error($ch);
        }
        if (isset($erro) && !empty($erro) && (string)$result == "Unauthorized") {
            echo "Erro: " . $result . "<br>";
            print_r($erro);
            exit;
        }
        $sessionPagseguro = simplexml_load_string($result);
        if (!isset($sessionPagseguro->id)) {
            echo "Erro nos dados de integração PagSeguro.";
            exit;
        }

        $data = [
            'categorias' => (new CategoriasProdutosFront())->listar(),
            'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
            'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
            'paginasTopo' => (new Pagina())->listarPaginasTopo(),
            'gateway' => $this->gateway,
            'boleto_ativo' => $this->gateway->pay_c3,
            'deposito_ativo' => $this->deposito->pay_status,
            'desconto_boleto' => $this->descontoBoleto,
            'maxInstallments' => $this->config_pagamento->pay_c6,
            'sessionPagseguro' => $sessionPagseguro->id,
            'pagseguro_semjuros' => $this->gateway->pay_c1,
            'paginasFooter' => (new Pagina())->listarPaginasFooter(),
            'faq' => (new Faq())->listaFooter(),
            'config' => $this->config,
            'social' => (new Config)->getRedesSociais(),
            'mapper' => ['config', 'social'],
        ];
        Tpl::view("tema.loja.checkout.pagamento.pagseguro.index", $data, 1);
    }
    public function viewCielo()
    {
        $data = [
            'categorias' => (new CategoriasProdutosFront())->listar(),
            'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
            'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
            'paginasTopo' => (new Pagina())->listarPaginasTopo(),
            'gateway' => $this->gateway,
            'boleto_ativo' => $this->gateway->pay_c3,
            'deposito_ativo' => $this->deposito->pay_status,
            'desconto_boleto' => $this->descontoBoleto,
            'maxInstallments' => $this->config_pagamento->pay_c6,
            'pagseguro_semjuros' => $this->gateway->pay_c1,
            'paginasFooter' => (new Pagina())->listarPaginasFooter(),
            'faq' => (new Faq())->listaFooter(),
            'config' => $this->config,
            'social' => (new Config)->getRedesSociais(),
            'mapper' => ['config', 'social'],

        ];
        Tpl::view("tema.loja.checkout.pagamento.cielo.index", $data, 1);
    }

    public function viewDeposito()
    {
        $total = $this->cart['info']['total_sem_desconto_frete'];
        $qtde_parcelas = 1;
        $qtde_parcelas_sem_juros = 1;
        $this->cart['info']['parcelas'] = 1;
        //$parcelas = PagarMe::installments($total, $qtde_parcelas, $qtde_parcelas_sem_juros);
        //$parcelasCalc = self::installments($total, $qtde_parcelas, $qtde_parcelas_sem_juros);
        //$parcelas = $parcelasCalc['installments'];
        $parcelas = "";

        if (!$parcelas) {
            //throw new Exception("Parcelas indisponíveis");
        }
        $data = [
            'categorias' => (new CategoriasProdutosFront())->listar(),
            'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
            'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
            'paginasTopo' => (new Pagina())->listarPaginasTopo(),
            'gateway' => $this->gateway,
            'boleto_ativo' => 0,
            'deposito_ativo' => 1,
            'desconto_boleto' => $this->descontoBoleto,
            'maxInstallments' => 1,
            'paginasFooter' => (new Pagina())->listarPaginasFooter(),
            'faq' => (new Faq())->listaFooter(),
            'config' => $this->config,
            'parcelas' => $parcelas,
            'social' => (new Config)->getRedesSociais(),
            'mapper' => ['config', 'social'],
        ];
        Tpl::view("tema.loja.checkout.pagamento.deposito.index", $data);
    }

    public function finaliza_orcamento()
    {
        if (intval($_SESSION['__CLIENTE_ORCAMENTO__']->cliente_id) <= 0) {
            Http::redirect_to('/login-cliente/?error');
        }
        $this->totalProdutos = $this->cart['info']['subtotal'];
        $this->totalCompra = floatval(number_format($this->totalCompra, 2, '.', ''));
        $this->totalCompra = Math::money2Decimal($this->totalCompra);
        $frete = 0;
        // Insere o pedido no banco de dados 
        $with = [
            "pedido_cliente" => intval($_SESSION['__CLIENTE_ORCAMENTO__']->cliente_id),
            "pedido_total_produto" => $this->totalProdutos,
            "pedido_frete" => $frete,
            "pedido_total_frete" =>  Math::money2Decimal($this->totalProdutos),
            "pedido_status"  => 2,
            "pedido_tipo" => 2,
            "pedido_info" => "Orçamento"
        ];

        unset($_SESSION['frete']);
        unset($_SESSION['retirada']);


        $this->pedidoId = (new Factory('pedido'))->with($with)->save();
        if (intval($this->pedidoId) > 0) {
            // pedido ok, insere os itens 
            foreach ($this->cart['carrinho'] as $cart) {
                $prod = $cart['produto'];
                $with = [
                    "lista_pedido_produto" => $prod['produto_id'],
                    "lista_pedido_produto_titulo" => $prod['produto_titulo'],
                    "lista_pedido_preco" => Math::money2Decimal($prod['produto_preco']),
                    "lista_pedido_pedido" => $this->pedidoId,
                    "lista_pedido_qtde" => $prod['qtd'],
                    "lista_pedido_foto" => $prod['produto_imagens'][0]['foto_produto_img'],
                    "lista_pedido_codigo" => $prod['produto_ref'],
                ];
                $listaId = (new Factory('lista_pedido'))->with($with)->save();
                // Insere os atributos do item caso tenha
                if (isset($prod['atributos_selecionados']) && !empty($prod['atributos_selecionados']) && is_array($prod['atributos_selecionados']) && sizeof($prod['atributos_selecionados']) > 0) {
                    $with_lista_pedido_atributo = [];
                    foreach ($prod['atributos_selecionados'] as $k => $item_atributo_id) {
                        $with_lista_pedido_atributo[] = [
                            'attnome' => $prod['nomes_atributos'][$k]->atributo_nome,
                            'itemnome' => $prod['nomes_atributos_selecionados'][$k],
                            'lista' => $listaId,
                            'valor_adicional' => (isset($prod['valor_adicional']) && !empty($prod['valor_adicional'])) ? $prod['valor_adicional'] : '0.00'
                        ];
                    }
                    (new Factory('lista_pedido_atributo'))->with($with_lista_pedido_atributo)->save();
                }
            }
            //Enviando o email do orçamento para o admin e o cliente
            $pedido = (new Factory('pedido'))->find($this->pedidoId);
            $pedido->lista = (new Factory('lista_pedido'))
                ->select('lista_pedido_produto_titulo,lista_pedido_qtde')
                ->where("lista_pedido_pedido = $pedido->pedido_id ")
                ->get();

            $cliente = (new Factory('cliente'))->find($pedido->pedido_cliente);
            $cliente->cliente_nome_curto = explode(' ', $cliente->cliente_nome)[0];
            $dados = [
                'config' => (new Config)->get(),
                'pedido' => $pedido,
                'cliente' => $cliente,
                'mapper' => ['config', 'cliente', 'contato', 'pedido']
            ];
            Notificacao::admin_orcamento_realizado($dados);
            Notificacao::cliente_orcamento_realizado($dados);
            //Fim envio de email
            (new Carrinho)->clearCarrinho();
            unset($_SESSION['cupom']);
            unset($_SESSION['frete']);
            unset($_SESSION['retirada']);
            unset($_SESSION['__CLIENTE_ORCAMENTO__']);
            // REDIRECT PARA PAGINA DE SUCESSO (na pagina de detalhes do pedido, diferenciar informações quando for ORÇAMENTO ou VENDA NORMAL)
            Http::redirect_to("/atendimento/?orcamento_enviado");
        } else {
            (new Carrinho)->clearCarrinho();
            unset($_SESSION['cupom']);
            unset($_SESSION['frete']);
            unset($_SESSION['retirada']);
            unset($_SESSION['__CLIENTE_ORCAMENTO__']);
            Http::redirect_to("/carrinho/?error");
        }
    }

    public function payment()
    {
        $this->totalProdutos = $this->cart['info']['total'];
        $this->metodo = Req::post('metodo', 'string');
        $desconto = $this->cart['info']['desconto_total'];

        $total_boleto_frete = $this->cart['info']['total_desconto_frete'];
        $total_cartao_frete = $this->cart['info']['total_sem_desconto_frete'];

        $total_pix = $this->cart['info']['total_pix'];
        $total_cartao = $this->cart['info']['total_cartao'];

        $desconto_info =  '';


        //if (($this->metodo == 'boleto' || $this->metodo == 'pix') && intval($this->descontoBoleto) > 0) {
        if ($this->metodo == 'boleto' || $this->metodo == 'pix') {
            $this->totalFrete = $total_pix;
            $desconto_info  .=  $this->descontoBoleto . '%  Pix/Boleto ' . "<br>";
        }
        if ($this->metodo == 'cartao') {
            $this->totalFrete = $total_cartao;
        }

        if ($this->metodo == 'deposito') {
            $this->totalFrete = $total_pix;
            $this->totalParcelado = $this->totalFrete;
        }
        $this->totalCompra = $this->totalFrete;

        $frete_price = 0;
        $frete_name = 'Frete Grátis';
        $frete_rastreio  = 0;
        $frete_deadline = 0;
        $frete_height = 0;
        $frete_width = 0;
        $frete_length = 0;
        $frete_weight = 0;
        $frete_company = '';

        $frete_id = 0;
        if (isset($_SESSION['frete']) && isset($_SESSION['frete']['id'])) {
            $frete_price = $_SESSION['frete']['price'];
            $frete_name = $_SESSION['frete']['name'];
            $frete_id = $_SESSION['frete']['id'];
            $frete_rastreio  = (isset($_SESSION['frete']['rastreio'])) ? intval($_SESSION['frete']['rastreio']) : 0;
            $frete_deadline = (isset($_SESSION['frete']['deadline'])) ? intval($_SESSION['frete']['deadline']) : 0;
            $frete_company = (isset($_SESSION['frete']['company'])) ? $_SESSION['frete']['company'] : '';

            $frete_height = (isset($_SESSION['frete']['pack'])) ? $_SESSION['frete']['pack']['h'] : 0;
            $frete_width = (isset($_SESSION['frete']['pack'])) ? $_SESSION['frete']['pack']['w'] : 0;
            $frete_length = (isset($_SESSION['frete']['pack'])) ? $_SESSION['frete']['pack']['l'] : 0;
            $frete_weight = (isset($_SESSION['frete']['pack'])) ? $_SESSION['frete']['pack']['we'] : 0;
            $frete_ensurance = (isset($_SESSION['frete']['pack'])) ? $_SESSION['frete']['pack']['e'] : 0;
        }

        $cupom_use = false;
        if (isset($_SESSION['cupom']) && !empty($_SESSION['cupom']) && $_SESSION['cupom'] != "") {
            $cupom_use = true;
        }

        if ($this->metodo == 'cartao' && $cupom_use == false) {
            $desconto = 0;
        }

        $pedido_ip  = (new Browser)->get_ip();
        $pedido_ip_city = "";
        $geo = IpGeoLocationIO::location($pedido_ip);
        if ($geo && isset($geo->city)) {
            $pedido_ip_city = $geo->city;
        }
        $with = [
            "pedido_cliente" => intval(Session::client_node('uid')),
            "pedido_total_produto" => $this->totalProdutos,
            'pedido_total_parcelado' => $this->totalParcelado,
            "pedido_frete" => $frete_price,
            'pedido_servico_frete' => $frete_name,
            'pedido_empresa_rastreio' => $frete_rastreio,
            "pedido_total_frete" =>  $this->totalFrete,
            "pedido_status"  => 1,
            "pedido_cupom_info" => $desconto_info,
            "pedido_desconto" => $desconto,
            "pedido_ip" => $pedido_ip,
            "pedido_ip_city" => $pedido_ip_city,
        ];

        if (isset($_SESSION['frete']) &&  isset($_SESSION['frete']['endereco_id']) && !empty($_SESSION['frete']['endereco_id'])) {
            $with['pedido_frete'] =  $frete_price;
            $with['pedido_prazo'] = $frete_deadline;
            $with['pedido_servico_frete'] = $frete_name;
            $with['pedido_frete_id'] = $frete_id;
            $with['pedido_frete_height'] = $frete_height;
            $with['pedido_frete_width'] = $frete_width;
            $with['pedido_frete_length'] = $frete_length;
            $with['pedido_frete_weight'] = $frete_weight;
            $with['pedido_empresa_rastreio'] =  $frete_rastreio;
            $with['pedido_entrega'] = 1;
            $with['pedido_frete_company'] = $frete_company;
            $with['pedido_endereco'] = intval($_SESSION['frete']['endereco_id']);
        } else if (isset($_SESSION['retirada']['retirada_id']) && !empty($_SESSION['retirada']['retirada_id'])) {
            $with['pedido_frete'] = 0;
            $with['pedido_prazo'] = 0;
            $with['pedido_servico_frete'] =  $_SESSION['retirada']['retirada_local'];
            $with['pedido_frete_id'] =  0;
            $with['pedido_frete_height'] = 0;
            $with['pedido_frete_width'] = 0;
            $with['pedido_frete_length'] = 0;
            $with['pedido_frete_weight'] = 0;
            $with['pedido_entrega'] = 0;
            $with['pedido_endereco'] = intval($_SESSION['retirada']['retirada_id']);
        } else {
            unset($_SESSION['frete']);
            unset($_SESSION['retirada']);
            echo json_encode(['error' => 'Nenhuma opção de entrega / retirada foi escolhida', 'redirect' => Http::base() . "/checkout"]);
            exit;
        }
        // Caso tenha sido usado cupom, insere seus valores
        if ($cupom_use == true) {
            $with['pedido_cupom_desconto'] = intval($_SESSION['cupom']['cupom_desconto']) > 0 ? $_SESSION['cupom']['cupom_desconto'] . "%" : "R$ " . $_SESSION['cupom']['cupom_real'];
            $with['pedido_cupom_alfa'] = $_SESSION['cupom']['cupom_alfa'];
            $with['pedido_cupom_info'] .=  $with['pedido_cupom_desconto'] . ' cupom (' . $_SESSION['cupom']['cupom_alfa'] . ')';
        }

        if (intval(Session::client_node('uid')) <= 0) {
            Http::redirect_to('/login-cliente/?error');
        }


        $this->pedidoId = (new Factory('pedido'))->with($with)->save();


        if (intval($this->pedidoId) > 0) {
            // pedido ok, insere os itens 
            foreach ($this->cart['carrinho'] as $cart) {
                $prod = $cart['produto'];
                $prodQTDE = intval($prod['qtd']);
                $prodID = $prod['produto_id'];
                $with = [
                    "produto" => $prod['produto_id'],
                    "produto_titulo" => $prod['produto_titulo'],
                    "preco" => $prod['produto_preco'],
                    'codigo' => $prod['produto_ref'],
                    "pedido" => $this->pedidoId,
                    "qtde" => $prodQTDE,
                    "foto" => $prod['produto_imagens'][0]['foto_produto_img']
                ];
                if (isset($prod['arquivo_url']) && !empty($prod['arquivo_url'])) {
                    $ds = DIRECTORY_SEPARATOR;
                    $pathDelete = Path::base() . $ds . 'media' . $ds . 'temp' . $ds . $prod['arquivo_url'];
                    $pathNovo = Path::base() . $ds . 'media' . $ds . 'produto_arquivo' . $ds . $prod['arquivo_url'];
                    if (is_file($pathDelete)) {
                        //@system("chmod -R 777 $pathDelete");
                        //@system("chmod -R 777 $pathNovo");
                        copy($pathDelete, $pathNovo);
                        @unlink($pathDelete);
                        if (is_file($pathNovo)) {
                            $with['arquivo'] = $prod['arquivo_url'];
                        }
                    }
                }
                $listaId = (new Factory('lista_pedido'))->with($with)->save();
                // Insere os atributos do item caso tenha
                if (isset($prod['atributos_selecionados']) && !empty($prod['atributos_selecionados']) && is_array($prod['atributos_selecionados']) && sizeof($prod['atributos_selecionados']) > 0) {
                    $with_lista_pedido_atributo = [];
                    foreach ($prod['atributos_selecionados'] as $k => $item_atributo_id) {
                        $with_lista_pedido_atributo[] = [
                            'attnome' => $prod['nomes_atributos'][$k]->atributo_nome,
                            'itemnome' => $prod['nomes_atributos_selecionados'][$k],
                            'lista' => $listaId,
                            'valor_adicional' => (isset($prod['valor_adicional']) && !empty($prod['valor_adicional'])) ? $prod['valor_adicional'] : '0.00'
                        ];
                    }
                    (new Factory('lista_pedido_atributo'))->with($with_lista_pedido_atributo)->save();
                }
                // ------- lógica de estoque
                // Se o produto tiver atributos, da baixa apenas no estoque de atributos
                // Caso não tenha, da baixa no estoque do produto normal
                if (isset($prod['atributos_selecionados']) && !empty($prod['atributos_selecionados']) && is_array($prod['atributos_selecionados']) && sizeof($prod['atributos_selecionados']) > 0) {
                    $where = 'relacao_item_produto = ' . $prodID;
                    if (isset($prod['atributos_selecionados'][1])) {
                        // O último item de atributos_selecionados é o id do item mandante dos atributos, o restante são os pais
                        $item_mandante = $prod['atributos_selecionados'][sizeof($prod['atributos_selecionados']) - 1];
                        $itens_pai = $prod['atributos_selecionados'];
                        array_pop($itens_pai);
                        $itens_pai = implode('>', $itens_pai);
                        $where .= " AND relacao_item_item = $item_mandante AND relacao_item_relacao_pai = $itens_pai";
                    } else {
                        // o produto só tem um atributo, o item enviado é o mandante
                        $item_mandante = $prod['atributos_selecionados'][0];
                        $where .= " AND relacao_item_item = $item_mandante";
                    }
                    $increase = "UPDATE relacao_item SET relacao_item_qtd = relacao_item_qtd + $prodQTDE  WHERE " . $where;
                    $decrease = "UPDATE relacao_item SET relacao_item_qtd = relacao_item_qtd - $prodQTDE  WHERE " . $where;
                    //(new Factory('relacao_item'))->query("UPDATE relacao_item SET relacao_item_qtd = relacao_item_qtd - " . $prodQTDE . " WHERE " . $where);
                } else {
                    $with = ["id" => $prodID, "estoque" => intval($prod['produto_estoque']) - $prodQTDE];
                    $increase = "UPDATE produto SET produto_estoque = produto_estoque + $prodQTDE  WHERE produto_id = " . $prodID;
                    $decrease = "UPDATE produto SET produto_estoque = produto_estoque - $prodQTDE  WHERE produto_id = " . $prodID;
                    //(new Factory('produto'))->with($with)->save();
                }
                Estoque::queue($this->pedidoId, $increase, 1);
                Estoque::queue($this->pedidoId, $decrease, 0);
            }

            // Salva o questionário caso exista
            $respostas = Req::post('respostas');
            if (isset($respostas) && !empty($respostas) && is_array($respostas) && sizeof($respostas) > 0) {
                $with = [];
                foreach ($respostas as $r) {
                    $with[] = [
                        'pedido_id' => $this->pedidoId,
                        'campo_id' => $r['campo_checkout_id'],
                        'pergunta' => addslashes(strip_tags(trim($r['pergunta']))),
                        'resposta' => addslashes(strip_tags(trim($r['resposta']))),
                        'cliente_id' => intval(Session::client_node('uid')),
                    ];
                }
                (new Factory('campo_checkout_respostas'))->with($with)->save();
            }
            // pedido ok, lista ok, questionário ok, realizar checkout 
            // verifica qual o gateway ativo e chama seu método de pagamento
            if ($this->config_pagamento->pay_key == 'mercadoPago') {
                $this->paymentMercadoPago();
            } else if ($this->config_pagamento->pay_key == 'pagarMe') {
                $this->paymentPagarMe();
            } else if ($this->config_pagamento->pay_key == 'pagSeguro') {
                $this->paymentPagseguro();
            } else if ($this->config_pagamento->pay_key == 'Cielo') {
                $this->paymentCielo();
            } else if ($this->config_pagamento->pay_key == 'Deposito') {
                $this->paymentDeposito();
            } else {
                echo json_encode(['error' => 'meio de pagamento']);
            }
        } else {
            echo json_encode(['error' => 'Erro na inserção do pedido']);
        }
    }

    public function paymentCielo()
    {
        $this->gateway = (new Factory('pay'))->find(2);
        $pedido = (new Factory('pedido'))->find($this->pedidoId);
        require_once 'PaymentCielo.php';
        // Verifica qual o metodo de pagamento escolhido
        if ($this->metodo == 'cartao') {
            $valor_com_juros = floatval($_POST['card_parcela']) * floatval($_POST['valor_parcela']);
            // Pagamento Pagseguro via Cartão
            $payment = faturaCielo($this->gateway, $this->pedidoId, $valor_com_juros);
            $res = json_decode($payment);
            $pay = $res->Payment;
            if ($pay->Status != 1 && $pay->Status != 2 && $pay->Status != 3) {
                $with = [
                    'pedido_id' => $this->pedidoId,
                    'pedido_status' => 7,
                    "pedido_pay_meio" => "Crédito (Cielo)",
                    "pedido_info" => "cartao",
                    "pedido_total_parcelado" => $valor_com_juros,
                    "pedido_pay_gw" => 3,
                    'pedido_obs' => 'Pagamento não autorizado pela administradora do cartão!'
                ];
                (new Factory('pedido'))->with($with)->save();
                PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
            } else {
                $payId = $res->Payment->PaymentId;
                $with = [
                    'pedido_id' => $this->pedidoId,
                    'pedido_status' => $pay->Status,
                    'pedido_pay_code' => $payId,
                    "pedido_pay_meio" => "Crédito (Cielo)",
                    "pedido_info" => "cartao",
                    "pedido_pay_gw" => 3,
                    "pedido_total_parcelado" => $valor_com_juros,
                ];
                (new Factory('pedido'))->with($with)->save();
                PedidoStatus::notificar_cliente_pedido_realizado($pedido->pedido_id, $pedido->pedido_cliente);
            }
            PedidoStatus::notificar_admin($pedido->pedido_id, $pedido->pedido_cliente);
            if (isset($_SESSION['cupom']['cupom_id'])) {
                (new Factory('cupom'))->query("UPDATE cupom SET cupom_lote = (cupom_lote + 1) WHERE cupom_id = " . $_SESSION['cupom']['cupom_id']);
            }
            (new Carrinho)->clearCarrinho();
            unset($_SESSION['cupom']);
            unset($_SESSION['frete']);
            unset($_SESSION['retirada']);
            echo json_encode(['pedido_id' => $this->pedidoId]);
            exit;
        } else if ($this->metodo == 'boleto') {
            $payment = faturaCieloBoleto($this->gateway, $this->pedidoId, $this->totalCompra);
            $res = json_decode($payment);
            $pay = $res->Payment;
            if ($pay->Status != 1 && $pay->Status != 2 && $pay->Status != 3) {
                $with = [
                    'pedido_id' => $this->pedidoId,
                    'pedido_status' => 7,
                    "pedido_pay_meio" => "Boleto (Cielo)",
                    "pedido_info" => "boleto",
                    "pedido_total_parcelado" => $this->totalCompra,
                    "pedido_pay_gw" => 3,
                    'pedido_obs' => 'Não foi possível gerar o boleto!'
                ];
                (new Factory('pedido'))->with($with)->save();
                PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
            } else {
                $payId = $res->Payment->PaymentId;
                $barcode = isset($res->Payment->BarCodeNumber) ? $res->Payment->BarCodeNumber : "";
                $boletoUrl = isset($res->Payment->Url) ? $res->Payment->Url : "";
                $with = [
                    'pedido_id' => $this->pedidoId,
                    'pedido_status' => $pay->Status,
                    'pedido_pay_code' => $payId,
                    "pedido_pay_meio" => "Boleto (Cielo)",
                    "pedido_info" => "boleto",
                    "pedido_pay_gw" => 3,
                    "pedido_pay_url" => $boletoUrl,
                    "pedido_barcode" => $barcode,
                    "pedido_total_parcelado" => $this->totalCompra,
                ];
                (new Factory('pedido'))->with($with)->save();
            }
            PedidoStatus::notificar_cliente_pedido_realizado($pedido->pedido_id, $pedido->pedido_cliente);
            PedidoStatus::notificar_admin($pedido->pedido_id, $pedido->pedido_cliente);
            if (isset($_SESSION['cupom']['cupom_id'])) {
                (new Factory('cupom'))->query("UPDATE cupom SET cupom_lote = (cupom_lote + 1) WHERE cupom_id = " . $_SESSION['cupom']['cupom_id']);
            }
            (new Carrinho)->clearCarrinho();
            unset($_SESSION['cupom']);
            unset($_SESSION['frete']);
            unset($_SESSION['retirada']);
            echo json_encode(['pedido_id' => $this->pedidoId]);
            exit;
        } else if ($this->metodo == 'deposito') {
            // Pagamento MercadoPago via boleto
            $with = [
                "pedido_id" => $this->pedidoId,
                "pedido_pay_meio" => "Depósito (MercadoPago)",
                "pedido_info" => "deposito",
                "pedido_pay_gw" => 4,
                "pedido_total_parcelado" => floatval($this->totalCompra),
                "pedido_obs" => "Pagamento via depósito."
            ];
            (new Factory('pedido'))->with($with)->save();

            PedidoStatus::notificar_cliente_pedido_realizado($pedido->pedido_id, $pedido->pedido_cliente);
            PedidoStatus::notificar_admin($pedido->pedido_id, $pedido->pedido_cliente);
            if (isset($_SESSION['cupom']['cupom_id'])) {
                (new Factory('cupom'))->query("UPDATE cupom SET cupom_lote = (cupom_lote + 1) WHERE cupom_id = " . $_SESSION['cupom']['cupom_id']);
            }
            (new Carrinho)->clearCarrinho();
            unset($_SESSION['cupom']);
            unset($_SESSION['frete']);
            unset($_SESSION['retirada']);
            echo json_encode(['pedido_id' => $this->pedidoId]);
            exit;
        }
    }

    public function paymentPagseguro()
    {
        $this->gateway = (new Factory('pay'))->find(1);
        $pedido = (new Factory('pedido'))->find($this->pedidoId);
        require_once 'PaymentPagseguro.php';
        // Verifica qual o metodo de pagamento escolhido                
        if ($this->metodo == 'cartao') {
            $valor_com_juros = floatval($_POST['card_parcela']) * floatval($_POST['valor_parcela']);
            $payment = faturaPS($this->gateway, $this->pedidoId, $this->totalCompra);
            $result_info = $payment;
            $payment = simplexml_load_string($payment);
            if (isset($payment->error) || $result_info == 'Unauthorized') {
                $with = [
                    "pedido_id" => $this->pedidoId,
                    "pedido_status" => 7,
                    "pedido_pay_meio" => "Crédito (Pagseguro)",
                    "pedido_info" => "cartao",
                    "pedido_total_parcelado" => $valor_com_juros,
                    "pedido_obs" => "Pagamento não autorizado pela administradora do cartão!"
                ];
                (new Factory('pedido'))->with($with)->save();
                PedidoStatus::notificar_admin($pedido->pedido_id, $pedido->pedido_cliente);
                PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
            } else {
                $code = $payment->code;
                $pedidoURL = "https://pagseguro.uol.com.br/v2/checkout/payment.html?code=$code";
                $id_transacao = $payment->id;
                $with = [
                    "pedido_id" => $this->pedidoId,
                    "pedido_pay_code" => $id_transacao,
                    "pedido_status" => $payment->status,
                    "pedido_pay_meio" => "Crédito (Pagseguro)",
                    "pedido_info" => "cartao",
                    "pedido_total_parcelado" => $valor_com_juros,
                    "pedido_pay_url" => $pedidoURL,
                    "pedido_pay_gw" => 1
                ];
                (new Factory('pedido'))->with($with)->save();
                PedidoStatus::notificar_cliente_pedido_realizado($pedido->pedido_id, $pedido->pedido_cliente);
                PedidoStatus::notificar_cliente_pedido_aprovado($pedido->pedido_id, $pedido->pedido_cliente);
                PedidoStatus::notificar_admin($pedido->pedido_id, $pedido->pedido_cliente);
            }
            self::useCupom();
            (new Carrinho)->clearCarrinho();
            echo json_encode(['pedido_id' => $this->pedidoId]);
        } else if ($this->metodo == 'boleto') {
            // Pagamento MercadoPago via boleto
            $payment = faturaPSBoleto($this->gateway, $this->pedidoId, $this->totalCompra);
            // FALTANDO ajustar boleto indo com 1 real a mais       
            $result_info = $payment;
            $payment = simplexml_load_string($payment);
            if (isset($payment->error) || $result_info == 'Unauthorized') {
                $with = [
                    "pedido_id" => $this->pedidoId,
                    "pedido_status" => 7,
                    "pedido_pay_meio" => "Boleto (Pagseguro)",
                    "pedido_total_parcelado" => $this->totalCompra,
                    "pedido_info" => "boleto",
                    "pedido_obs" => "Não foi possível gerar o boleto!"
                ];
                (new Factory('pedido'))->with($with)->save();
                PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
            } else {
                $code = $payment->code;
                $pedidoURL = $payment->paymentLink;
                $id_transacao = $payment->id;
                $with = [
                    "pedido_id" => $this->pedidoId,
                    "pedido_pay_code" => $code,
                    "pedido_pay_meio" => "Boleto (Pagseguro)",
                    "pedido_info" => "boleto",
                    "pedido_total_parcelado" => $this->totalCompra,
                    "pedido_pay_url" => $pedidoURL,
                    "pedido_pay_gw" => 5
                ];
                (new Factory('pedido'))->with($with)->save();
                PedidoStatus::notificar_cliente_pedido_realizado($pedido->pedido_id, $pedido->pedido_cliente);
            }
            PedidoStatus::notificar_admin($pedido->pedido_id, $pedido->pedido_cliente);
            self::useCupom();
            (new Carrinho)->clearCarrinho();
            echo json_encode(['pedido_id' => $this->pedidoId]);
            exit;
        } else if ($this->metodo == 'deposito') {
            // Pagamento MercadoPago via dep
            $with = [
                "pedido_id" => $this->pedidoId,
                "pedido_pay_meio" => "Depósito (Pagseguro)",
                "pedido_info" => "deposito",
                "pedido_pay_gw" => 4,
                "pedido_total_parcelado" => floatval($this->totalCompra),
                "pedido_obs" => "Pagamento via depósito."
            ];
            (new Factory('pedido'))->with($with)->save();
            PedidoStatus::notificar_cliente_pedido_realizado($pedido->pedido_id, $pedido->pedido_cliente);
            PedidoStatus::notificar_admin($pedido->pedido_id, $pedido->pedido_cliente);
            (new Carrinho)->clearCarrinho();
            self::useCupom();
            echo json_encode(['pedido_id' => $this->pedidoId]);
        }
    }

    public function paymentMercadoPago()
    {
        $this->gateway = (new Factory('pay'))->find(6);
        $pedido = (new Factory('pedido'))->find($this->pedidoId);
        //echo json_encode($pedido);        exit;

        $parcelas = (isset($_POST['card_parcela'])) ? intval($_POST['card_parcela']) : 1;
        require_once 'PaymentMercadoPago.php';
        $this->totalCompra = $pedido->pedido_total_frete;
        if ($this->metodo == 'cartao') {
            $payment = faturaMP($this->gateway, $this->pedidoId, $this->totalCompra);
            if (isset($payment->error)) {
                $valor_com_juros = $this->totalCompra;
                $with = [
                    "pedido_id" => $this->pedidoId,
                    "pedido_status" => 7,
                    "pedido_parcelas" => $parcelas,
                    "pedido_pay_meio" => "Crédito (MercadoPago)",
                    "pedido_info" => "cartao",
                    "pedido_total_parcelado" => $valor_com_juros,
                    "pedido_obs" => "Pagamento não autorizado pela administradora do cartão!",
                    "pedido_pay_gw" => 1
                ];
                (new Factory('pedido'))->with($with)->save();
                try {
                    PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
                } catch (Exception $e) {
                    //echo $e->getMessage();
                }
                // (new Carrinho)->clearCarrinho();
            } else if (isset($payment->id)) {
                $id_transacao = $payment->id;
                $valor_com_juros = ($payment->transaction_details->total_paid_amount);
                $with = [
                    "pedido_id" => $this->pedidoId,
                    "pedido_pay_code" => $id_transacao,
                    "pedido_pay_meio" => "Crédito (MercadoPago)",
                    "pedido_info" => "cartao",
                    "pedido_parcelas" => $parcelas,
                    "pedido_total_parcelado" => $valor_com_juros,
                    "pedido_pay_gw" => 1
                ];
                (new Factory('pedido'))->with($with)->save();
                try {
                    PedidoStatus::notificar_cliente_pedido_realizado($pedido->pedido_id, $pedido->pedido_cliente);
                    PedidoStatus::notificar_cliente_pedido_aprovado($pedido->pedido_id, $pedido->pedido_cliente);
                } catch (Exception $e) {
                    //echo $e->getMessage();
                }
            } else {
                $with = [
                    "pedido_id" => $this->pedidoId,
                    "pedido_status" => 7,
                    "pedido_pay_meio" => "Crédito (MercadoPago)",
                    "pedido_info" => "cartao",
                    "pedido_parcelas" => $parcelas,
                    "pedido_obs" => "Erro na tentativa de realizar o pagamento.",
                    "pedido_pay_gw" => 1
                ];
                (new Factory('pedido'))->with($with)->save();
                try {
                    PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
                } catch (Exception $e) {
                    //echo $e->getMessage();
                }
            }
            try {
                PedidoStatus::notificar_admin($pedido->pedido_id, $pedido->pedido_cliente);
                self::useCupom();
                //(new Carrinho)->clearCarrinho();
            } catch (Exception $e) {
                //echo $e->getMessage();
            }
            echo json_encode(['pedido_id' => $this->pedidoId]);
        } else if ($this->metodo == 'boleto') {
            $payment = faturaMPBoleto($this->gateway, $this->pedidoId, $this->totalCompra);
            if (isset($payment->error)) {
                $valor_com_juros = ((isset($payment->transaction_details->total_paid_amount)) ? $payment->transaction_details->total_paid_amount : $payment->transaction_amount);
                $with = [
                    "pedido_id" => $this->pedidoId,
                    "pedido_status" => 7,
                    "pedido_pay_meio" => "Boleto (MercadoPago)",
                    "pedido_info" => "boleto",
                    "pedido_total_parcelado" => $valor_com_juros,
                    "pedido_obs" => "Não foi possível gerar o boleto.",
                    "pedido_pay_gw" => 1
                ];
                (new Factory('pedido'))->with($with)->save();
                try {
                    PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
                } catch (Exception $e) {
                    //echo $e->getMessage();
                }
            } else if (isset($payment->id)) {
                $id_transacao = $payment->id;
                $valor_com_juros = floatval($payment->transaction_details->total_paid_amount);
                $with = [
                    "pedido_id" => $this->pedidoId,
                    "pedido_pay_code" => $id_transacao,
                    "pedido_pay_meio" => "Boleto (MercadoPago)",
                    "pedido_total_parcelado" => $valor_com_juros,
                    "pedido_info" => "boleto",
                    "pedido_pay_gw" => 1,
                    "pedido_pay_url" => $payment->transaction_details->external_resource_url,
                    "pedido_barcode" => $payment->barcode->content, // código de barras em número
                ];
                (new Factory('pedido'))->with($with)->save();
            } else {
                $with = [
                    "pedido_id" => $this->pedidoId,
                    "pedido_status" => 7,
                    "pedido_info" => "boleto",
                    "pedido_pay_meio" => "Boleto (MercadoPago)",
                    "pedido_obs" => "Erro na tentativa de gerar o boleto."
                ];
                (new Factory('pedido'))->with($with)->save();
                try {
                    PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
                } catch (Exception $e) {
                    //echo $e->getMessage();
                }
            }
            try {
                PedidoStatus::notificar_cliente_pedido_realizado($pedido->pedido_id, $pedido->pedido_cliente);
                PedidoStatus::notificar_admin($pedido->pedido_id, $pedido->pedido_cliente);
                self::useCupom();
                (new Carrinho)->clearCarrinho();
            } catch (Exception $e) {
                //echo $e->getMessage();
            }
            echo json_encode(['pedido_id' => $this->pedidoId]);
        } else if ($this->metodo == 'deposito') {
            $this->paymentDeposito();
        } else if ($this->metodo == 'pix') {
            //pagamento via Pix MercadoPago
            $payment = faturaMPPix($this->gateway, $this->pedidoId, $this->totalCompra);
            if (is_object($payment) && isset($payment->result)) {
                if ($payment->result == 0) {
                    $with = [
                        "pedido_id" => $this->pedidoId,
                        "pedido_status" => 7,
                        "pedido_pay_meio" => "Pix (MercadoPago)",
                        "pedido_info" => "pix",
                        "pedido_total_parcelado" => ($this->totalCompra),
                        "pedido_obs" => "Não foi possível gerar o Pix. " . $payment->pay->message,
                        "pedido_pay_gw" => 1
                    ];
                    (new Factory('pedido'))->with($with)->save();
                    try {
                        PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
                    } catch (Exception $e) {
                        //echo $e->getMessage();
                    }
                } else if ($payment->result == 1) {
                    $with = [
                        "pedido_id" => $this->pedidoId,
                        "pedido_pay_code" => $payment->id,
                        "pedido_pay_meio" => "Pix (MercadoPago)",
                        "pedido_total_parcelado" => ($this->totalCompra),
                        "pedido_info" => "pix",
                        "pedido_pay_url" => $payment->url,
                        "pedido_pay_gw" => 1,
                        "pedido_pix_qr" => $payment->qr,
                        "pedido_pix_qr_img" => $payment->img, // tag img do QR Code
                    ];
                    (new Factory('pedido'))->with($with)->save();
                }
            } else {
                $with = [
                    "pedido_id" => $this->pedidoId,
                    "pedido_status" => 7,
                    "pedido_pay_meio" => "Pix (MercadoPago)",
                    "pedido_info" => "pix",
                    "pedido_total_parcelado" => ($this->totalCompra),
                    "pedido_obs" => "Erro ao gerar o Pix.",
                    "pedido_pay_gw" => 1
                ];
                (new Factory('pedido'))->with($with)->save();
                try {
                    PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
                } catch (Exception $e) {
                    //echo $e->getMessage();
                }
            }
            try {
                PedidoStatus::notificar_cliente_pedido_realizado($pedido->pedido_id, $pedido->pedido_cliente);
                PedidoStatus::notificar_admin($pedido->pedido_id, $pedido->pedido_cliente);
                self::useCupom();
                (new Carrinho)->clearCarrinho();
            } catch (Exception $e) {
                //echo $e->getMessage();
            }
            echo json_encode(['pedido_id' => $this->pedidoId]);
        }
    }

    public function paymentPagarMe()
    {
        if (!isset($this->pedidoId) || $this->pedidoId <= 0) {
            return false;
        }
        if ($this->metodo == 'deposito') {
            $this->paymentDeposito();
            return;
        }

        if ($this->metodo != 'cartao' && $this->metodo != 'pix') {
            return false;
        }

        $pedido = self::pedidoPayload($this->pedidoId);
        $itens = self::itemPayload($this->pedidoId);
        $pedido->itens = $itens;
        $pedido->description = $this->config->config_site_title;
        $payer = self::clientePayLoad();
        if ($this->metodo == 'cartao') {
            $this->totalParcelado = Req::post('parcelasTotal');
            $pedido->pedido_total_parcelado = $this->totalParcelado;
            $card = self::cardPayload();
            $payer->card = $card;
        }
        if ($payer && !empty($itens)) {
            $payload = PagarMe::doPayload($payer, $pedido, $this->metodo);
        }
        $payload['token'] = $this->gateway->pay_user;
        $payload['code'] = $this->pedidoId;
        $payment = PagarMe::payment($payload);
        if ($payment->erro == 0) {
            $status_code = PagarMe::status_code($payment->status);
            $tipo_transacao = PagarMe::transaction_type($payment->metodo);
            $with = [
                "pedido_id" => $this->pedidoId,
                "pedido_pay_code" => $payment->id,
                "pedido_pay_meio" => $tipo_transacao . " (PagarMe)",
                "pedido_total_parcelado" => $this->totalParcelado,
                "pedido_parcelas" => (isset($card->installments)) ? $card->installments : 0,
                "pedido_info" => "$tipo_transacao",
                "pedido_pay_gw" => 7,
                "pedido_status" => $status_code
            ];

            if ($tipo_transacao == 'Pix') {
                $with["pedido_total_parcelado"] = $this->totalCompra;
                $with["pedido_total_frete"] = $pedido->pedido_total_frete;

                if ($payment->status != 'failed') {
                    $with['pedido_pix_qr']     = $payment->transactions->qr_code;
                    $with['pedido_pay_url']    = $payment->transactions->qr_code_url;
                    $with['pedido_pix_qr_img'] = $payment->transactions->qr_code_url;
                } else {
                    $with['pedido_obs'] = 'Erro ao gerar o Pix.';
                }
            }
            (new Factory('pedido'))->with($with)->save();
            try {
                PedidoStatus::notificar_cliente_pedido_realizado($pedido->pedido_id, $pedido->pedido_cliente);
                // *** PedidoStatus::notificar_cliente_pedido_aprovado($pedido->pedido_id, $pedido->pedido_cliente);     
                //*** PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);     
                PedidoStatus::notificar_admin($pedido->pedido_id, $pedido->pedido_cliente);
                self::useCupom();
                (new Carrinho)->clearCarrinho();
            } catch (Exception $e) {
                //echo $e->getMessage();
            }
            echo json_encode(['pedido_id' => $this->pedidoId, 'valor' => $this->totalCompra]);
        } else {
            Estoque::devolve($this->pedidoId);
            try {
                echo json_encode(['error' => $payment->json]);
                PedidoStatus::error('Erro ao realizar pagamento', "$payment->json");
            } catch (Exception $e) {
                echo $e->getMessage();
            }
        }
    }

    public function paymentDeposito()
    {
        $this->gateway = (new Factory('pay'))->find(4);
        $pedido = (new Factory('pedido'))->find($this->pedidoId);
        if ($pedido->pedido_total_frete > $this->totalCompra) {
            $this->totalCompra = $pedido->pedido_total_frete;
        }
        $with = [
            "pedido_id" => $this->pedidoId,
            "pedido_pay_meio" => "Pix (Manual)",
            "pedido_info" => "deposito",
            "pedido_pay_gw" => 4,
            "pedido_total_parcelado" => $this->totalCompra,
            "pedido_obs" => "Pagamento via Pix / Depósito."
        ];
        (new Factory('pedido'))->with($with)->save();
        try {
            PedidoStatus::notificar_cliente_pedido_realizado($pedido->pedido_id, $pedido->pedido_cliente);
            PedidoStatus::notificar_admin($pedido->pedido_id, $pedido->pedido_cliente);
            self::useCupom();
            (new Carrinho)->clearCarrinho();
            echo json_encode(['pedido_id' => $this->pedidoId]);
        } catch (Exception $e) {
            //echo $e->getMessage();
        }
    }

    static public function clientePayLoad()
    {
        $cliente = (new Factory('cliente'))->find(Session::client_node('uid'));
        if (!isset($cliente->cliente_id)) {
            return false;
        }
        $endereco = null;
        if (isset($_SESSION['frete']['endereco_id']) && !empty($_SESSION['frete']['endereco_id'])) {
            $endereco = (new Factory('endereco_cliente'))->find($_SESSION['frete']['endereco_id']);
        } else {
            $endereco = (new Factory('endereco_cliente'))->find_by('endereco_cliente_cliente', Session::client_node('uid'));
        }
        $cli_zip = str_replace('-', '', $endereco->endereco_cliente_cep);
        $cliente_email = Session::client_node('umail');
        $cli_rua = $endereco->endereco_cliente_rua;
        $cli_num = $endereco->endereco_cliente_num;
        if (isset($cliente->cliente_telefone) && !empty($cliente->cliente_telefone)) {
            $cliente->telefone = preg_replace('/\W/', '', $cliente->cliente_telefone);
        } else {
            $cliente->telefone = preg_replace('/\W/', '', '');
        }
        $cliente->ddd = substr($cliente->telefone, 0, 2);
        $cliente->telefone = substr($cliente->telefone, 2, -1);
        $cli_doc_num = ($cliente->cliente_tipo == 1) ? $cliente->cliente_cpf : $cliente->cliente_cnpj;
        $cli_tipo_doc = ($cliente->cliente_tipo == 1) ? 'CPF' : 'CNPJ';

        $payer = new stdClass;
        $payer->name = $cliente->cliente_nome;
        $payer->email = $cliente_email;
        $payer->document = $cli_doc_num;
        $payer->document_type = $cli_tipo_doc;
        $payer->address = new stdClass;
        $payer->address->street = $cli_rua;
        $payer->address->number = $cli_num;
        $payer->address->neighborhood = $endereco->endereco_cliente_bairro;
        $payer->address->complement = $endereco->endereco_cliente_complemento;
        $payer->address->zip_code = $cli_zip;
        $payer->address->city = $endereco->endereco_cliente_cidade;
        $payer->address->state = $endereco->endereco_cliente_uf;
        $payer->address->country = 'BR';
        $payer->phone = new stdClass;
        $payer->phone->country_code = '55';
        $payer->phone->area_code = $cliente->ddd;
        $payer->phone->number = $cliente->telefone;

        return $payer;
    }

    static public function pedidoPayload($pedido_id)
    {
        $p = (new Factory('pedido'))->find($pedido_id);
        return $p;
    }

    static public function itemPayload($pedido_id)
    {
        $final = [];
        $lista = (new Factory('lista_pedido'))->where('lista_pedido_pedido = ' . $pedido_id)->get();
        if (isset($lista) && !empty($lista)) {
            foreach ($lista as $item) {
                $item->lista_pedido_preco = preg_replace('/\,/', '', $item->lista_pedido_preco);
                $titulo = substr($item->lista_pedido_produto_titulo, 0, 30);
                $itens = new stdClass;
                $itens->id = $item->lista_pedido_produto;
                $itens->title = ("$titulo");
                $itens->quantity = $item->lista_pedido_qtde;
                $itens->description = ("$item->lista_pedido_produto_titulo");
                $itens->category_id = 'Produtos';
                $itens->unit_price = $item->lista_pedido_preco;
                $final[] = $itens;
            }
        }
        return $final;
    }

    static public function cardPayload()
    {
        $installments = (isset($_POST['card_parcela'])) ?  intval($_POST['card_parcela']) : 1;
        $card = new stdClass;
        $card->installments = $installments;
        $card->holder_name = $_POST['cardholderName'];
        $card->number = $_POST['cardNumber'];
        $card->exp_month = $_POST['cardExpirationMonth'];
        $card->exp_year = $_POST['cardExpirationYear'];
        $card->cvc = $_POST['cardCVC'];
        $card->docNumber = $_POST['docNumberFake'];

        return $card;
    }
    static public function useCupom()
    {
        if (isset($_SESSION['cupom']['cupom_id'])) {
            (new Factory('cupom'))->query("UPDATE cupom SET cupom_lote = (cupom_lote + 1) WHERE cupom_id = " . $_SESSION['cupom']['cupom_id']);
            unset($_SESSION['cupom']);
        }
    }

    static public function clearPaySess()
    {
        //unset($_SESSION['frete']);
        //unset($_SESSION['retirada']);        
    }


    static public function gw()
    {
        try {
            $conf = (new Factory('pay'))->where('pay_name = "Config"')->get()[0];
            return $conf;
        } catch (Exception $e) {
            echo $e->getMessage();
        }
    }
    static public function installments($valorOriginal, $parcelas, $parcelasSemJuros)
    {

        $textoFullComSemJuros = false;
        if ($parcelasSemJuros >= $parcelas) {
            $textoFullComSemJuros = false;
        }
        $jurosMercadoPago = [
            //1 => 5.29,
            2 => 7.64,
            3 => 9.23,
            4 => 10.86,
            5 => 12.31,
            6 => 13.65,
            7 => 14.72,
            8 => 16.23,
            9 => 17.69,
            10 => 18.65,
            11 => 20.12,
            12 => 21.61
        ];

        $jurosPagarMe = [
            //1 => 5.29,
            2 => 8.31,
            3 => 9.48,
            4 => 10.65,
            5 => 11.82,
            6 => 12.99,
            7 => 15.18,
            8 => 16.35,
            9 => 17.52,
            10 => 18.69,
            11 => 19.86,
            12 => 21.03
        ];

        $jurosParcelas = $jurosMercadoPago;

        $output = '<div class="table-responsive">
            <table class="table table-striped table-bordered">
            <thead class="thead-light">
                <tr>
                    <th class="text-center">Parcelas</th>
                    <th class="text-right">Valor da Parcela</th>
                    <th class="text-right">Total</th>
                </tr>
            </thead>
            <tbody>';

        $parcelasSemJuros = (intval($parcelasSemJuros) <= 0) ? 1 : $parcelasSemJuros;


        $valorParcelaSemJuros = @number_format(($valorOriginal) / intval($parcelasSemJuros), 2, ',', '.');
        $valorUltimaParcelaComJuros = 0;
        $totalGeral = 0;
        $parcelasLista = [];

        for ($i = 1; $i <= $parcelas; $i++) {
            if ($i <= $parcelasSemJuros) {
                $valorParcela = $valorOriginal / $i;
                $total = $valorOriginal;
                $totalGeral = $total;
                $output .= "<tr>
                        <td class='text-center'>{$i}x</td>
                        <td class='text-right'>R$ " . number_format($valorParcela, 2, ',', '.') . " <small class='text-muted'>s/ juros</small></td>
                        <td class='text-right'>R$ " . number_format($total, 2, ',', '.') . "</td>
                    </tr>";
            } else {
                $juros = isset($jurosParcelas[$i]) ? $jurosParcelas[$i] / 100 : 0;
                $totalComJuros = $valorOriginal * (1 + $juros);
                $totalGeral = $totalComJuros;
                $valorParcela = $totalComJuros / $i;
                $valorUltimaParcelaComJuros = $valorParcela;
                $output .= "<tr>
                        <td class='text-center'>{$i}x</td>
                        <td class='text-right'>R$ " . number_format($valorParcela, 2, ',', '.') . " <small class='text-muted'>c/ juros</small></td>
                        <td class='text-right'>R$ " . number_format($totalComJuros, 2, ',', '.') . "</td>
                    </tr>";
            }
            $parcelasLista[$i] = (object) [
                'installment_amount' => number_format($valorParcela, 2, ',', '.'),
                'amount' => $totalGeral
            ];
        }

        $output .= '</tbody></table></div>';


        $parcs = [
            'valor_original' =>  number_format($valorOriginal, 2, ',', '.'),
            'valor_parc_sem_juros' => $valorParcelaSemJuros,
            'valor_ultima_parc_com_juros' => number_format($valorUltimaParcelaComJuros, 2, ',', '.'),
            'qtde_parc_total' => $parcelas,
            'qtde_parc_sem_juros' => $parcelasSemJuros,
            'texto_sem_juros' => "{$parcelasSemJuros}x de R$ $valorParcelaSemJuros s/ juros",
            'texto_com_parcs' => "{$parcelas}x de R$ " . number_format($valorUltimaParcelaComJuros, 2, ',', '.') . ' c/ juros',
            'texto_sem_com' => "{$parcelasSemJuros}x R$ $valorParcelaSemJuros s/ juros ou <br> {$parcelas}x R$ " . number_format($valorUltimaParcelaComJuros, 2, ',', '.') . ' c/ juros',
            'lista' => (object) $parcelasLista,
            'tabela_parcs' => $output
        ];
        if ($textoFullComSemJuros) {
            $parcs['texto_sem_juros'] = $parcs['texto_sem_com'];
        }
        return $parcs;
    }
}
