<?php

class Notificacao
{
    public function __construct()
    {
        (new Install)->check_tabelas_principais();
    }

    public function welcome()
    {
        echo "FLUXSHOP WEBHOOK";
    }

    public function pagseguro()
    {
        $pagseguro = (new Factory('pay'))->find(1);

        if (!isset($pagseguro) && empty($pagseguro)) {
            echo "Retorno Pagseguro não configurado!";
            exit;
        }

        $notificationCode = $_REQUEST['notificationCode'];
        $url = "https://ws.pagseguro.uol.com.br/v3/transactions/notifications/$notificationCode?email=$pagseguro->pay_user&token=$pagseguro->pay_key";

        if (!isset($_REQUEST['notificationCode'])) {
            echo 'Notificacao vazia';
            exit;
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            $erro = curl_error($ch);
            echo $erro;
        } else {
            $result = simplexml_load_string($result);

            $pedido_status = $result->status;
            $pedido_id = $result->reference;

            $with = [
                "pedido_id" => $pedido_id,
                "pedido_pay_situacao" => $pedido_status,
                "pedido_status" => $pedido_status,
            ];

            $pedido = (new Factory('pedido'))->find($pedido_id);

            //Enviando email pro cliente se o pedido foi aprovado ou cancelado
            if ($pedido_status == 3) {
                PedidoStatus::notificar_cliente_pedido_aprovado($pedido->pedido_id, $pedido->pedido_cliente);
            } else if ($pedido_status == 7) {
                PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
            }

            (new Factory('pedido'))->with($with)->save();
            echo "Pedido Atualizado!";
        }
    }

    public function cielo()
    {
        $cielo = (new Factory('pay'))->find(2);

        if (!isset($cielo) && empty($pagsegcielouro)) {
            echo "Retorno Pagseguro não configurado!";
            exit;
        }
        $payId = $_REQUEST['PaymentId'];
        $header = [
            "Content-Type: application/json",
            "MerchantId: $cielo->pay_user",
            "MerchantKey: $cielo->pay_key"
        ];

        if ($cielo->pay_pass == 1) {
            $url = 'https://apiquery.cieloecommerce.cielo.com.br/1/sales/' . $payId;
        } else {
            $url = 'https://apiquerysandbox.cieloecommerce.cielo.com.br/1/sales/' . $payId;
        }

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        $res = curl_exec($ch);
        if (curl_errno($ch)) {
            $erro = curl_error($ch);
        }
        $pay = (object)json_decode($res);

        $pedidoId = $pay->MerchantOrderId;
        $pedido = (new Factory('pedido'))->find($pedidoId);
        $pay = $pay->Payment;

        if ($pay->Status != 1 && $pay->Status != 2 && $pay->Status != 3) {

            $with = [
                'pedido_id' => $pedidoId,
                'pedido_status' => 7,
                "pedido_pay_meio" => "Cielo - Cartão de Crédito",
                "pedido_info" => "cartao",
                "pedido_pay_gw" => 3,
                'pedido_obs' => 'Pagamento não autorizado pela administradora do cartão!'
            ];

            PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
            (new Factory('pedido'))->with($with)->save();
        } else {
            $with = [
                'pedido_id' => $pedidoId,
                'pedido_status' => $pay->Status,
                "pedido_pay_meio" => "Cielo - Cartão de Crédito",
                "pedido_info" => "cartao",
                "pedido_pay_gw" => 3,
            ];

            PedidoStatus::notificar_cliente_pedido_aprovado($pedido->pedido_id, $pedido->pedido_cliente);
            (new Factory('pedido'))->with($with)->save();
        }
    }

    public function mercadopago()
    {
        // MERCADO PAGO        
        $_mpago = (new Factory('pay'))->find(6);
        $token = str_replace(' ', '', trim($_mpago->pay_user));
        $id = (isset($_GET['data_id']))  ?  intval($_GET['data_id']) :  intval($_GET['id']);
        $url = 'https://api.mercadopago.com/v1/payments/' . $id . '?access_token=' . $token;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            $erro = curl_error($ch);
        }
        $payment = json_decode($result);

        if (isset($_GET['teste'])) {
            Filter::pre($payment, 1);
        }

        if (isset($payment->status) && isset($payment->external_reference)) {
            $status = str_replace("'", '', $payment->status);
            $external_reference = $payment->external_reference;
            $pedido_id = intval($payment->external_reference);

            $pedido = (new Factory('pedido'))->find($external_reference);

            if ($status == 'pending' || $status == 'in_process') {
                die;
            }
            if ($status == 'rejected' || $status == 'cancelled' || $status == 'refunded') {
                $status_n = 7;
                $with = [
                    "pedido_id" => $external_reference,
                    "pedido_pay_situacao" => $status_n,
                    "pedido_status" => $status_n,
                ];
                (new Factory('pedido'))->with($with)->save();
                Estoque::devolve($pedido_id);
                PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
            }
            if ($status == 'approved') {
                $status_n = 3;
                $with = [
                    "pedido_id" => $external_reference,
                    "pedido_pay_situacao" => $status_n,
                    "pedido_status" => $status_n,
                ];

                (new Factory('pedido'))->with($with)->save();
                PedidoStatus::notificar_cliente_pedido_aprovado($pedido->pedido_id, $pedido->pedido_cliente);
            }
        }
    }

    public function pagarme()
    {
        $json = file_get_contents('php://input');
        $object = json_decode($json);
        $pedido_id = (isset($object->data->code)) ? $object->data->code : 0;
        $status = (isset($object->data->code)) ? $object->data->status : 0;
        $order = (isset($object->order->id)) ? $object->order->id : 0;
        $status_n = 1;
        if ($status == 'pending' || $status == 'in_process') {
            $status_n = 1;
        }
        if ($status == 'rejected' || $status == 'cancelled' || $status == 'refunded' || $status == 'failed') {
            $status_n = 7;
            Estoque::devolve($pedido_id);
        }
        if ($status == 'paid') {
            $status_n = 3;
        }
        //$this->atualiza_estoque($pedido_id);
        $pedido = (new Factory('pedido'))->find($pedido_id);
        if ($pedido->pedido_id > 0) {

            // ADD CAMADA EXTRA
            //if $order > 0 && $pedido->pedido_pay_code == "$order" 
            (new Factory('pedido'))->with([
                'pedido_id' => $pedido_id,
                'pedido_status' => $status_n,
                'pedido_obs_sys' => 'atualizado via webhook pagarme'
            ])->save();
        }
    }
    public function notificarErro($body)
    {
        // $m = new sendmail;
        // $n = array(
        //     'subject' => "Erro no retorno de dados",
        //     'body' => $body
        // );
        // $m->sender($n);
    }

    public function _money($val)
    {
        return @number_format($val, 2, ",", ".");
    }

    static function notificar_rastreio()
    {
        $pedido_id = Req::post('id', 'int');
        $pedido = (new Factory('pedido'))->find($pedido_id);
        $cliente = (new Factory('cliente'))->find($pedido->pedido_cliente);
        if ($pedido && $cliente) {
            $dados = [
                'config' => (new Config)->get(),
                'pedido' => $pedido,
                'cliente' => $cliente,
                'mapper' => ['pedido', 'cliente', 'config']
            ];

            $mensagem = Tpl::output('email.cliente-pedido-rastreio', $dados);

            $msg = [
                'assunto' => "Acompanhe a entrega de seu pedido",
                'nome' => $cliente->cliente_nome,
                'destinatario' => $cliente->cliente_email,
                'mensagem' => $mensagem,
            ];

            if (Sender::mail($msg)) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    static function admin_orcamento_realizado($data)
    {
        $msg = Tpl::output('email.admin-orcamento-realizado', $data);
        $dados = [
            'assunto' => "Orçamento Recebido",
            'nome' => $data['config']->config_site_title,
            'destinatario' => $data['config']->config_site_email,
            'mensagem' => $msg,
        ];

        Sender::mail($dados);
    }
    static function cliente_orcamento_realizado($data)
    {
        $msg = Tpl::output('email.cliente-orcamento-realizado', $data);
        $dados = [
            'assunto' => "Recebemos seu Orçamento",
            'nome' => $data['config']->config_site_title,
            'destinatario' => $data['cliente']->cliente_email,
            'mensagem' => $msg,
        ];

        Sender::mail($dados);
    }
}
/* end file */
