<?php

class Gateway
{

	public function __construct()
	{
		(new Install)->check_tabelas_principais();
		Sessao::check();
		if (ucfirst(Session::node('ulevel')) != '1') {
			Http::redirect_to('/admin/?error');
		}
	}

	public function indexAction()
	{

		$cielo = (new Factory('pay'))->where('pay_name = "Cielo"')->get()[0];
		$cielo = (object) [
			'cielo_id' => $cielo->pay_id,
			'cielo_name' => $cielo->pay_name,
			'cielo_key' => $cielo->pay_key,
			'cielo_user' => $cielo->pay_user,
			'cielo_pass' => $cielo->pay_pass,
			'cielo_retorno' => Http::base() . '/notificacao/cielo',
			'cielo_c7' => $cielo->pay_c7,
		];

		$pagseguro = (new Factory('pay'))->where('pay_name = "PagSeguro"')->get()[0];
		$pagseguro = (object) [
			'pagseguro_id' => $pagseguro->pay_id,
			'pagseguro_name' => $pagseguro->pay_name,
			'pagseguro_key' => $pagseguro->pay_key,
			'pagseguro_user' => $pagseguro->pay_user,
			'pagseguro_pass' => $pagseguro->pay_pass,
			'pagseguro_retorno' => Http::base() . '/notificacao/pagseguro',
			'pagseguro_fator_juros' => $pagseguro->pay_fator_juros,
			'pagseguro_c1' => $pagseguro->pay_c1,
			'pagseguro_c3' => $pagseguro->pay_c3,
			'pagseguro_c6' => $pagseguro->pay_c6,
			'pagseguro_c7' => $pagseguro->pay_c7,
			'pagseguro_c8' => $pagseguro->pay_c8,
		];

		$mercadopago = (new Factory('pay'))->where('pay_name = "MercadoPago"')->get()[0];
		$mercadopago = (object) [
			'mercadopago_id' => $mercadopago->pay_id,
			'mercadopago_name' => $mercadopago->pay_name,
			'mercadopago_key' => $mercadopago->pay_key,
			'mercadopago_user' => $mercadopago->pay_user,
			'mercadopago_pass' => $mercadopago->pay_pass,
			'mercadopago_retorno' => Http::base() . '/notificacao/mercadopago',
			'mercadopago_c1' => $mercadopago->pay_c1,
			'mercadopago_c2' => $mercadopago->pay_c2,
			'mercadopago_c3' => $mercadopago->pay_c3,
			'mercadopago_c6' => $mercadopago->pay_c6,
			'mercadopago_c7' => $mercadopago->pay_c7,
			'mercadopago_c8' => $mercadopago->pay_c8,
			'mercadopago_fator_juros' => $mercadopago->pay_fator_juros,
		];

		$pagarme = (new Factory('pay'))->where('pay_name = "PagarMe"')->get()[0];
		$pagarme = (object) [
			'pagarme_id' => $pagarme->pay_id,
			'pagarme_name' => $pagarme->pay_name,
			'pagarme_key' => $pagarme->pay_key,
			'pagarme_user' => $pagarme->pay_user,
			'pagarme_pass' => $pagarme->pay_pass,
			'pagarme_retorno' => Http::base() . '/notificacao/pagarme',
			'pagarme_c1' => $pagarme->pay_c1,
			'pagarme_c2' => $pagarme->pay_c2,
			'pagarme_c3' => $pagarme->pay_c3,
			'pagarme_c6' => $pagarme->pay_c6,
			'pagarme_c7' => $pagarme->pay_c7,
			'pagarme_c8' => $pagarme->pay_c8,
			'pagarme_fator_juros' => $pagarme->pay_fator_juros,
		];

		$deposito = (new Factory('pay'))->where('pay_name = "Deposito"')->get()[0];
		$deposito = (object) [
			'deposito_id' => $deposito->pay_id,
			'deposito_user' => $deposito->pay_user,
			'deposito_texto' => $deposito->pay_texto,
			'deposito_status' => $deposito->pay_status,
		];

		$configPay = (new Factory('pay'))->where('pay_name = "Config"')->get()[0];
		$configPay = (object) [
			'configPay_id' => $configPay->pay_id,
			'configPay_key' => $configPay->pay_key,
			'configPay_user' => $configPay->pay_user,
			'configPay_texto' => $configPay->pay_texto,
			'configPay_status' => $configPay->pay_status,
			'configPay_c1' => $configPay->pay_c1,
			'configPay_c2' => $configPay->pay_c2,
			'configPay_c3' => $configPay->pay_c3,
			'configPay_c6' => $configPay->pay_c6,
			'configPay_c7' => $configPay->pay_c7,
			'configPay_c8' => $configPay->pay_c8,
			'configPay_fator_juros' => $configPay->pay_fator_juros,
		];
		$data = [
			'config' => (new Config)->get(),
			'cielo' => $cielo,
			'configPay' => $configPay,
			'pagseguro' => $pagseguro,
			'pagarme' => $pagarme,
			'mercadopago' => $mercadopago,
			'deposito' => $deposito,
			'gateway' => ['gateway_ativo' => $configPay->configPay_key],
			'mapper' => ['config', 'configPay', 'cielo', 'pagarme', 'pagseguro', 'mercadopago', 'deposito', 'gateway'],
		];
		//Filter::pre($data);		exit;
		Tpl::view('admin.gateway.index', $data, 1);
	}

	public function gravar()
	{
		Sessao::perms('G');
		Req::drop('_wysihtml5_mode');
		unset($_POST['files']);
		// Req::drop_blank();
		if (isset($_POST['pay_id']) && !empty($_POST['pay_id'])) {
			//$_POST = Filter::parse_full($_POST);
			$_POST['pay_user'] = preg_replace('/\s+/', '', $_POST['pay_user']);
			$_POST['pay_key'] = preg_replace('/\s+/', '', $_POST['pay_key']);
			$escope = [
				'pay_user' => 'text',
				'pay_key' => 'text',
				'pay_c7' => 'int',
				'pay_c8' => 'int',
				'pay_c3' => 'int',
				'pay_pass' => 'int',
			];
			(new Factory('pay'))->with($_POST)->format($escope)->save();
			Http::redirect_to('/gateway/?success');
		} else {
			Http::redirect_to('/gateway/?error');
		}
	}

	public function gravarDefinicoes()
	{
		Sessao::perms('G');
		Req::drop('_wysihtml5_mode');
		if (isset($_POST['pay_key']) && !empty($_POST['pay_key'])) {
			$data = [
				'key' => Req::post('pay_key', 'string'),
				//'c1' => Req::post('pay_c1', 'int'),
				'id' => 5, // id do config do pay
			];
			//(new Factory('pay'))->with($data)->save();
			//$_POST = Filter::parse_full($_POST);
			//unset($_POST['pay_key']);

			$_POST['pay_id'] = 5;
			if (!isset($_POST['pay_fator_juros'])) {
				$_POST['pay_fator_juros'] = 0;
			} else {
				$_POST['pay_fator_juros'] = Math::money2Decimal($_POST['pay_fator_juros']);
			}
			$_POST['pay_c1'] = Math::money2Decimal($_POST['pay_c1']);

			(new Factory('pay'))->with($_POST)->save();
			echo 0;
		} else {
			echo -1;
		}
	}
}
