<?php

class Cliente
{
    public function __construct()
    {
        Sessao::check();
        (new Install)->check_tabelas_principais();
    }
    public function indexAction()
    {
        $data = [
            'config' => (new Config)->get(),
            'mapper' => ['config'],
        ];
        Tpl::view('admin.cliente.index', $data, 1);
    }

    public function lista()
    {
        $select = "
                cliente_id as id, cliente_nome, cliente_razao, cliente_email, cliente_telefone,cliente_tipo,
                endereco_cliente_cidade as cliente_cidade, endereco_cliente_uf as cliente_uf,
                cliente_status AS status,
                IF(cliente_status = 1, 'Ativo', 'Inativo') AS status_nome,
                IF(cliente_tipo = 1, cliente_cpf, cliente_cnpj) AS cliente_documento,
                IFNULL(cliente_nome,cliente_razao) as cliente_nome,
                CASE cliente_tipo
                    WHEN 1 THEN 'PF'
                    WHEN 2 THEN 'PJ'
                END as cliente_tipo_txt,
                CASE cliente_tipo
                    WHEN 1 THEN 'Pessoa Física'
                    WHEN 2 THEN 'Pessoa Jurídica'
                END as cliente_tipo_txt_full,
                DATE_FORMAT(cliente_nascimento,'%d/%m/%Y') as cliente_nascimento
        ";
        (new Factory('cliente'))
            ->select($select)
            ->join('endereco_cliente', 'endereco_cliente_cliente = cliente_id', 'LEFT')
            ->order('cliente_nome, cliente_razao ASC')
            ->get(1);
    }

    public function gravar()
    {
        if (isset($_POST['cliente_nome']) && !empty($_POST['cliente_nome'])) {
            Sessao::perms('G');
            Req::drop_blank();
            $_POST = Filter::parse_full($_POST);
            $base = http::base();
            $conf = (new Config)->get();
            $base = Http::base();
            $conf->url =  $base;
            $id = Req::post("cliente_id");
            $senha_email =  Req::post('cliente_password');
            $escope = ['cliente_nascimento' => 'date'];


            if (Req::post('cliente_password') != "") {
                Req::crypt('cliente_password');
            }
            $save = (new Factory('cliente'))->with($_POST)->format($escope)->save();

            //caso nao tenha id, quer dizer que é um novo cadastro
            if (empty($id)) {
                // Envio de EMAIL 
                // $email = Req::post('cliente_email');
                // $cliente = (new Factory('cliente'))
                //     ->select('cliente_id as id, cliente_nome as nome,cliente_email as email')
                //     ->find_by('cliente_email', $email);
                // $cliente->senha_email = $senha_email;
                // $cliente->url =  $base;
                // $me = [
                //     'config' => $conf,
                //     'conteudo' => $cliente,
                //     'contato' => (new Config)->getContato(),
                //     'mapper' => ['config', 'conteudo', 'contato'],
                // ];
                // $mensagem = Tpl::output("email.cadastro", $me);

                // $msg = [
                //     'assunto' => "Cadastro realizado com sucesso. - " . $conf->config_site_title,
                //     'nome' => $cliente->nome,
                //     'email' => $email,
                //     'mensagem' => $mensagem,
                // ];
                // Sender::mail($msg);
            }

            Http::back_on_false($save);
            Http::redirect_to('/cliente/?success');
        }
    }

    public function novo()
    {
        $data = [
            'config' => (new Config)->get(),
            'cliente' => (new Factory('cliente'))->map(),
            'mapper' => ['config', 'cliente'],
        ];
        Tpl::view('admin.cliente.form', $data, 1);
    }

    public function editar()
    {
        $id = Http::get_in_params('id', 'int');
        $escope = ['cliente_nascimento' => 'date'];
        $cli = (new Factory('cliente'))
            ->format($escope)->find($id->value);
        Http::back_on_false($cli);
        $data = [
            'config' => (new Config)->get(),
            'cliente' => $cli,

            'mapper' => ['config', 'cliente'],
        ];

        Tpl::view('admin.cliente.form', $data, 1);
    }

    public function remover()
    {
        Sessao::perms('G');
        $id = Req::post('id', 'int');
        if ($id > 0) {
            (new Factory('cliente'))->drop($id);
            echo 1;
        } else {
            echo -1;
        }
    }

    public function checa_cpf()
    {
        $cpf = Req::post('cpf', 'string');

        if (isset($cpf) && !empty($cpf)) {
            $resp = (new Factory('cliente'))->select('cliente_cpf')
                ->where("cliente_cpf = '$cpf' ")->limit(1)->get();
            if ($resp) {
                echo -1;
                exit;
            } else {
                echo 1;
                exit;
            }
        } else {
            echo 0;
            exit;
        }
    }

    public function checa_cnpj()
    {
        $cnpj = Req::post('cnpj', 'string');
        if (isset($cnpj) && !empty($cnpj)) {
            $resp = (new Factory('cliente'))->select('cliente_cnpj')->find_by('cliente_cnpj', $cnpj);
            if ($resp) {
                echo -1;
                exit;
            } else {
                echo 1;
                exit;
            }
        } else {
            echo 0;
            exit;
        }
    }

    public function checa_email()
    {
        $email = Req::post('email', 'string');
        if (isset($email) && !empty($email)) {
            $resp = (new Factory('cliente'))->select('cliente_email')->find_by('cliente_email', $email);
            if ($resp) {
                echo -1;
                exit;
            } else {
                echo 1;
                exit;
            }
        } else {
            echo 0;
            exit;
        }
    }

    public function get_json()
    {
        (new Factory('cliente'))
            ->select('*, IFNULL(cliente_nome,cliente_razao) as cliente_nome')
            ->where('cliente_status = 1')
            ->order('cliente_nome ASC')->get(1, true);
    }

    public function altera_status()
    {
        Sessao::perms('G', 1);
        $id = Req::post('id', 'int');

        if ($id > 0) {
            $status = Req::post('status', null);
            $status == 1 ? $status = 0 : $status = 1;
            $data = [
                'id' => $id,
                'status' => $status,
            ];

            (new Factory('cliente'))->with($data)->save();
        } else {
            echo -1;
        }
    }
}
