<?php

/**
 * Classe responsável por renderizar produtos referente a alguma busca (por categorias, por marcas etc)
 */
class TelasPesquisa
{
    public function __construct()
    {
        (new Install)->check_tabelas_principais();
    }
    public function indexAction()
    {
        $params = Http::get_all_params();
        if (is_array($params)) {
            if ($params[0] == 'busca-categoria') {
                if (isset($params[1]) && !empty($params[1]) && isset($params[3]) && !empty($params[3])) {
                    $this->categoria($params[1], $params[3]);
                } else {
                    $this->categoria($params[1]);
                }
            } else if ($params[0] == 'busca-marca') {
                if (isset($params[1]) && !empty($params[1])) {
                    $this->marca($params[1]);
                } else {
                    Http::redirect(Http::base());
                }
            } else {
                Http::redirect(Http::base());
            }
        } else {
            Http::redirect(Http::base());
        }
    }

    public function remove_mask_money($str = '')
    {
        return str_replace(',', '.', implode('', explode('.', $str)));
    }

    public function valor()
    {
        $min = $this->remove_mask_money(Req::post('valor_minimo'));
        $max = $this->remove_mask_money(Req::post('valor_maximo'));

        $cat = Req::post('categoria_url');
        $sub = Req::post('subcategoria_url');
        $marca = Req::post('marca_url');

        if (isset($cat) && !empty($cat)) {
            if (isset($sub) && !empty($sub)) {
                $this->categoria($cat, $sub, $min, $max);
            } else {
                $this->categoria($cat, null, $min, $max);
            }
        } else if (isset($marca) && !empty($marca)) {
            $this->marca($marca, $min, $max);
        }
    }
    public function categoria($cat = null, $sub = null, $min = null, $max = null)
    {
        if ($cat != null) {
            $prod = [];
            $categoria = (new Factory('categoria_produto'))->find_by('categoria_produto_url', $cat);
            if ($categoria) {
                $categoria->categoria_produto_nome = ucfirst(mb_strtolower($categoria->categoria_produto_nome, 'UTF-8'));
            }
            $where = "produto_status = 1";
            if (floatval($min) > 0) {
                $where .= " AND (produto_preco - produto_desconto) >= '$min'";
            }
            if (floatval($max) > 0) {
                $where .= " AND (produto_preco - produto_desconto) <= '$max'";
            }

            $card = (new Factory('config_card'))->get()[0];
            if ($sub == null) {
                // todos os produtos desta categoria                
                $where .= " AND categoria_produto_url = '$cat'";
                $prod = (new Factory('produto'))
                    ->select('produto_id, 
                produto_oferta,
                produto_url, 
                produto_estoque, 
                produto_titulo, 
                produto_preco AS produto_preco_original, 
                (produto_preco - produto_desconto) AS produto_preco, 
                produto_desconto, 
                categoria_produto_id,
                IF(
                (SELECT COUNT(*) FROM relacao_atributo WHERE relacao_atributo_produto = produto_id) > 0,
                (SELECT MAX(relacao_item_qtd) FROM relacao_item WHERE relacao_item_produto = produto_id),
                produto_estoque
                ) AS produto_estoque,                                
                foto1.foto_produto_img as produto_foto, foto2.foto_produto_img as produto_foto_hover,
                ifnull(nullif(foto2.foto_produto_img, ""), "") AS produto_foto_hover
                ')
                    ->join('foto_produto as foto1', 'foto1.foto_produto_produto = produto_id AND foto1.foto_produto_pos = 1', 'LEFT')
                    ->join('foto_produto as foto2', 'foto2.foto_produto_produto = produto_id AND (foto2.foto_produto_pos = 2 OR foto2.foto_produto_id > foto1.foto_produto_id )', 'LEFT')
                    ->join('vinculo_categoria_produto', "vinculo_categoria_produto_produto = produto_id")
                    ->join('categoria_produto', "vinculo_categoria_produto_categoria = categoria_produto_id")
                    //->join("subcategoria_produto", "vinculo_categoria_produto_subcategoria = subcategoria_produto_id")
                    ->where($where)
                    ->group_by('produto_id')
                    ->get();
            } else {

                $where .= " AND categoria_produto_url = '$cat' AND subcategoria_produto_url = '$sub'";
                // todos os produtos dessa sub
                $prod = (new Factory('produto'))
                    ->select('produto_id, 
            produto_oferta,
            produto_url, 
            categoria_produto_url,
            subcategoria_produto_url,
            produto_estoque, 
            produto_titulo, 
            produto_preco AS produto_preco_original, 
            (produto_preco - produto_desconto) AS produto_preco, 
            produto_desconto, 
            IF(
            (SELECT COUNT(*) FROM relacao_atributo WHERE relacao_atributo_produto = produto_id) > 0,
            (SELECT MAX(relacao_item_qtd) FROM relacao_item WHERE relacao_item_produto = produto_id),
            produto_estoque
            ) AS produto_estoque,
            foto1.foto_produto_img as produto_foto, foto2.foto_produto_img as produto_foto_hover,
            ifnull(nullif(foto2.foto_produto_img, ""), "") AS produto_foto_hover
            ')
                    ->join('foto_produto as foto1', 'foto1.foto_produto_produto = produto_id AND foto1.foto_produto_pos = 1', 'LEFT')
                    ->join('foto_produto as foto2', 'foto2.foto_produto_produto = produto_id AND (foto2.foto_produto_pos = 2 OR foto2.foto_produto_id > foto1.foto_produto_id )', 'LEFT')
                    /*
                    ->join('categoria_produto', "categoria_produto_url = '$cat'")
                    ->join('subcategoria_produto', "subcategoria_produto_url = '$sub'")
                    ->join("vinculo_categoria_produto", "vinculo_categoria_produto_subcategoria = subcategoria_produto_id AND vinculo_categoria_produto_produto = produto_id")
                    */
                    ->join('vinculo_categoria_produto', "vinculo_categoria_produto_produto = produto_id")
                    ->join('categoria_produto', "vinculo_categoria_produto_categoria = categoria_produto_id")
                    ->join("subcategoria_produto", "vinculo_categoria_produto_subcategoria = subcategoria_produto_id")
                    ->where($where)
                    ->group_by('produto_id')
                    ->get();

                $subcategoria = str_replace('-', ' ', $sub);
            }

            if (isset($_GET['d'])) {
                Filter::pre($prod);
                echo "$cat - $sub";
                exit;
            }

            if (is_array($prod) && sizeof($prod) > 0) {
                $config_payment = (new Factory('pay'))->where('pay_name = "Config"')->get()[0];
                foreach ($prod as $k => $v) {
                    $preco = $prod[$k]->produto_preco;
                    $prod[$k]->produto_preco = Filter::moeda($prod[$k]->produto_preco);
                    $prod[$k]->produto_preco_original = Filter::moeda($prod[$k]->produto_preco_original);
                    $prod[$k]->produto_preco_desc_boleto = intval($config_payment->pay_fator_juros) > 0 ? Filter::moeda($preco - (($preco / 100) * ($config_payment->pay_fator_juros))) : '0,00';
                    $prod[$k]->desc_boleto = intval($config_payment->pay_fator_juros);
                    $prod[$k]->qtd_parcelas = intval($config_payment->pay_c6);
                    $prod[$k]->produto_preco_parc =  Filter::moeda($preco / $prod[$k]->qtd_parcelas);
                    if ($prod[$k]->produto_foto == "")
                        $prod[$k]->produto_foto = 'nopic.png';
                }
            }
            $data = [
                'categorias' => (new CategoriasProdutosFront())->listar(),
                'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
                'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
                'paginasTopo' => (new Pagina())->listarPaginasTopo(),
                'produtos' => $prod,
                'categoria' => $categoria,
                'marcas' => (new SlideFront())->listarMarcas(),
                'paginasFooter' => (new Pagina())->listarPaginasFooter(),
                'faq' => (new Faq())->listaFooter(),
                'config' => (new Config)->get(),
                'social' => (new Config)->getRedesSociais(),
                'cat' => $cat,
                'sub' => $sub,
                'min' => $min,
                'max' => $max,
                'card' => $card,
                'mapper' => ['config', 'social', 'card'],
            ];
            if (isset($subcategoria) && !empty($subcategoria)) {
                $data['subcategoria'] = $subcategoria;
            }
            Tpl::view("tema.loja.busca.index", $data, 1);
        } else {
            Http::redirect(Http::base());
        }
    }

    public function marca($marca = null, $min = null, $max = null)
    {
        $prod = [];
        $m = str_replace('-', ' ', $marca);
        if ($marca != null) {
            // todos os produtos desta marca
            $where = "produto_status = 1 AND marca_url = '" . $marca . "'";
            if (floatval($min) > 0) {
                $where .= " AND (produto_preco - produto_desconto) >= '$min'";
            }
            if (floatval($max) > 0) {
                $where .= " AND (produto_preco - produto_desconto) <= '$max'";
            }
            $card = (new Factory('config_card'))->get()[0];
            $prod = (new Factory('produto'))
                ->select('produto_id, 
            produto_oferta,
            produto_url, 
            produto_estoque, 
            produto_titulo, 
            produto_preco AS produto_preco_original, 
            (produto_preco - produto_desconto) AS produto_preco, 
            produto_desconto, 
            IF(
            (SELECT COUNT(*) FROM relacao_atributo WHERE relacao_atributo_produto = produto_id) > 0,
            (SELECT MIN(relacao_item_qtd) FROM relacao_item WHERE relacao_item_produto = produto_id),
            produto_estoque
            ) AS produto_estoque,                                
            foto1.foto_produto_img as produto_foto, foto2.foto_produto_img as produto_foto_hover,
            ifnull(nullif(foto2.foto_produto_img, ""), "") AS produto_foto_hover
            ')
                ->join('foto_produto as foto1', 'foto1.foto_produto_produto = produto_id AND foto1.foto_produto_pos = 1', 'LEFT')
                ->join('foto_produto as foto2', 'foto2.foto_produto_produto = produto_id AND (foto2.foto_produto_pos = 2 OR foto2.foto_produto_id > foto1.foto_produto_id )', 'LEFT')
                ->join('marca', 'produto_marca = marca_id')
                ->where($where)
                ->group_by('produto_id')
                ->get();
        }

        if (is_array($prod) && sizeof($prod) > 0) {
            $config_payment = (new Factory('pay'))->where('pay_name = "Config"')->get()[0];
            foreach ($prod as $k => $v) {
                $preco = $prod[$k]->produto_preco;
                $prod[$k]->produto_preco = Filter::moeda($prod[$k]->produto_preco);
                $prod[$k]->produto_preco_original = Filter::moeda($prod[$k]->produto_preco_original);
                $prod[$k]->produto_preco_desc_boleto = intval($config_payment->pay_fator_juros) > 0 ? Filter::moeda($preco - (($preco / 100) * ($config_payment->pay_fator_juros))) : '0,00';

                $prod[$k]->desc_boleto = intval($config_payment->pay_fator_juros);
                $prod[$k]->qtd_parcelas = intval($config_payment->pay_c6);
                $prod[$k]->produto_preco_parc =  Filter::moeda($preco / $prod[$k]->qtd_parcelas);
                if ($prod[$k]->produto_foto == "")
                    $prod[$k]->produto_foto = 'nopic.png';
            }
        }
        $data = [
            'categorias' => (new CategoriasProdutosFront())->listar(),
            'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
            'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
            'paginasTopo' => (new Pagina())->listarPaginasTopo(),
            'produtos' => $prod,
            'marca' => $m,
            'marca_url' => $marca,
            'marcas' => (new SlideFront())->listarMarcas(),
            'paginasFooter' => (new Pagina())->listarPaginasFooter(),
            'faq' => (new Faq())->listaFooter(),
            'card' => $card,
            'config' => (new Config)->get(),
            'social' => (new Config)->getRedesSociais(),
            'min' => $min,
            'max' => $max,
            'mapper' => ['config', 'social', 'card'],
        ];
        Tpl::view("tema.loja.busca.index", $data, 1);
    }
}
