<?php

class Relatorios
{

    public function __construct()
    {
        Sessao::check();
    }

    // Captura os anos em que existem registros de vendas
    public function getYears() {
        (new Factory('pedido'))
            ->select('YEAR(pedido_created) AS pedido_ano')
            ->group_by('pedido_ano')
            ->order("pedido_ano DESC")
            ->get(1);
    }

    public function vendasByYear() {
        $ano = Req::post('ano', 'int');

        if($ano > 0)
            (new Factory('pedido'))
                ->select('COUNT(*) AS pedido_qtd, MONTH(pedido_created) AS pedido_mes')
                ->group_by('pedido_mes')
                ->where('YEAR(pedido_created) = ' . $ano)
                ->get(1);
    }

    public function listar_produtos() {
        $data = [
            'config' => (new Config)->get(),
            
            'mapper' => ['config']
        ];
        Tpl::view('admin.relatorios.produtos.index', $data, 1);
    }
    

}
