<?php

class PedidoStatus
{
    public function __construct()
    {
        (new Install)->check_tabelas_principais();
    }

    public function indexAction()
    {
        //$d = (new PedidoFront)->get_pedidos_mail_data(18, 1);
        //Filter::pre($d);
    }
    static function notificar_admin($pedido_id, $cliente_id)
    {
        $pedido = (new PedidoFront)->get_pedidos_mail_data($pedido_id, $cliente_id);
        $cliente = (new Factory('cliente'))->find($cliente_id);
        $conf = (new Config)->get();
        $destinatario = $conf->config_site_email;
        $dados = [
            'cliente' => $cliente,
            'pedido' => $pedido,
            'config' => $conf,
            'contato' => (new Config)->getContato(),
            'mapper' => ['config', 'cliente', 'pedido', 'contato'],
        ];
        $mensagem = Tpl::output('email.admin-pedido-realizado', $dados);
        $msg = [
            'assunto' => "Novo pedido realizado na loja: pedido Nº $pedido_id",
            'destinatario' => $destinatario,
            //'destinatario' => $admin_emails[0],
            //'copia' => $admin_emails,
            'mensagem' => $mensagem,
        ];
        Sender::mail($msg);
    }

    static function notificar_cliente_pedido_realizado($pedido_id, $cliente_id)
    {
        $pedido = (new PedidoFront)->get_pedidos_mail_data($pedido_id, $cliente_id);
        $cliente = (new Factory('cliente'))->find($cliente_id);
        $cliente->cliente_nome_curto = explode(' ', $cliente->cliente_nome)[0];
        $dados = [
            'cliente' => $cliente,
            'pedido' => $pedido,
            'config' => (new Config)->get(),
            'contato' => (new Config)->getContato(),
            'mapper' => ['config', 'cliente', 'pedido', 'contato'],
        ];
        $mensagem = Tpl::output('email.cliente-pedido-realizado', $dados);
        $msg = [
            'assunto' => "Confirmação de pedido: recebemos seu pedido Nº $pedido_id",
            'nome' => $cliente->cliente_nome,
            'destinatario' => $cliente->cliente_email,
            'mensagem' => $mensagem,
        ];
        Sender::mail($msg);
    }

    static function notificar_cliente_pedido_cancelado($pedido_id, $cliente_id)
    {
        $pedido = (new PedidoFront)->get_pedidos_mail_data($pedido_id, $cliente_id);
        $cliente = (new Factory('cliente'))->find($cliente_id);
        $dados = [
            'cliente' => $cliente,
            'pedido' => $pedido,
            'config' => (new Config)->get(),
            'contato' => (new Config)->getContato(),
            'mapper' => ['config', 'cliente', 'pedido', 'contato'],
        ];
        $mensagem = Tpl::output('email.cliente-pedido-cancelado', $dados);
        $msg = [
            'assunto' => "Atualização do seu pedido Nº $pedido_id",
            'nome' => $cliente->cliente_nome,
            'destinatario' => $cliente->cliente_email,
            'mensagem' => $mensagem,
        ];
        Sender::mail($msg);
    }

    static function notificar_cliente_pedido_aprovado($pedido_id, $cliente_id)
    {
        $pedido = (new Factory('pedido'))->find($pedido_id);
        $cliente = (new Factory('cliente'))->find($cliente_id);
        $dados = [
            'cliente' => $cliente,
            'pedido' => $pedido,
            'config' => (new Config)->get(),
            'contato' => (new Config)->getContato(),
            'mapper' => ['config', 'cliente', 'pedido', 'contato'],
        ];
        $mensagem = Tpl::output('email.cliente-pedido-aprovado', $dados);
        $msg = [
            'assunto' => "Atualização do seu pedido Nº $pedido_id",
            'nome' => $cliente->cliente_nome,
            'destinatario' => $cliente->cliente_email,
            'mensagem' => $mensagem,
        ];
        Sender::mail($msg);
    }
}
/* end file */
