<?php

class Pedido
{

    public function __construct()
    {
        Sessao::check();
        (new Install)->check_tabelas_principais();
    }

    public function indexAction()
    {
        $data = [
            'config' => (new Config)->get(),
            'integracao' => ['integracao' =>  Bling::modulo_status()],
            'mapper' => ['config', 'integracao']
        ];
        Tpl::view('admin.pedido.index', $data, 1);
    }

    public function visualizar()
    {
        $id = Http::get_in_params('id', 'int');
        if (isset($id->value) && $id->value > 0) {
            $id = $id->value;
            $data = [
                'config' => (new Config)->get(),

                'pedido_id' => ['pedido_id' => $id],
                'mapper' => ['config', 'pedido_id']
            ];
            Tpl::view('admin.pedido.visualizar', $data, 1);
        } else {
            Http::redirect_to('/pedidos/?error');
        }
    }

    public function alteraStatus()
    {
        $id = Req::post('id', 'int');
        $status = Req::post('status', 'int');

        if ($id > 0 && $status > 0) {

            $pedido = (new Factory('pedido'))->find($id);

            $with = [
                'pedido_id' => $id,
                'pedido_status' => $status,
                'pedido_updated' => date("Y-m-d H:i:s")
            ];

            (new Factory('pedido'))->with($with)->save();

            //Enviando email pro cliente se o pedido(loja padrão não orçamento) foi aprovado ou cancelado
            if ($pedido->pedido_tipo == 1) {
                if ($status == 3) {
                    PedidoStatus::notificar_cliente_pedido_aprovado($pedido->pedido_id, $pedido->pedido_cliente);
                } else if ($status == 7) {
                    PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
                }
            }

            echo json_encode(['msg' => 'Status alterado com sucesso']);
        } else {
            echo json_encode(['error' => 'Id ou status mal formatado']);
        }
    }

    public function inserir_codigo_rastreio()
    {
        $id = Req::post('id', 'int');
        $pedido_codigo_rastreio = Req::post('pedido_codigo_rastreio', 'string');

        if ($id > 0) {

            $pedido = (new Factory('pedido'))->find($id);

            $with = [
                'pedido_id' => $id,
                'pedido_codigo_rastreio' => $pedido_codigo_rastreio,
            ];

            (new Factory('pedido'))->with($with)->save();
            if ($pedido_codigo_rastreio) {
                Notificacao::notificar_rastreio();
            }
            echo json_encode(['msg' => 'Código de rastreio cadastrado com sucesso']);
            exit;
        } else {
            echo json_encode(['error' => 'Erro ao inserir o código de rastreio']);
            exit;
        }
    }

    public function getPedido()
    {
        $id = Req::post('id', 'int');
        if ($id > 0) {
            $res = (new Factory('pedido'))
                ->select("*,pedido_comprovante, pedido_status,pedido_cliente, pedido_pay_meio, pedido_endereco, pedido_total_frete, pedido_total_produto, pedido_total_parcelado, pedido_prazo, pedido_cupom_desconto, DATE_FORMAT(pedido_created, '%d/%m/%Y') AS pedido_data, pedido_tipo,pedido_codigo_rastreio,pedido_entrega,pedido_empresa_rastreio,
                pedido_nf_num,pedido_nf_num_id,pedido_nf_chave,pedido_nf_serie,
                CASE pedido_status
                WHEN 1 THEN 'Aguardando Pagamento'
                WHEN 2 THEN 'Em análise'
                WHEN 3 THEN 'Aprovado'
                WHEN 4 THEN 'Disponível'
                WHEN 5 THEN 'Em disputa'
                WHEN 6 THEN 'Devolvido'
                WHEN 7 THEN 'Cancelado'            
                END AS pedido_status_nome,
            CASE pedido_status
                WHEN 1 THEN 'warning'
                WHEN 2 THEN 'info'
                WHEN 3 THEN 'success'
                WHEN 4 THEN 'success'
                WHEN 5 THEN 'warning'
                WHEN 6 THEN 'danger'
                WHEN 7 THEN 'danger'            
            END AS pedido_status_badge,
            DATE_FORMAT(pedido_updated, '%d/%m/%Y às %H:%i:%s') AS pedido_atualizacao,
            DATE_FORMAT(DATE_ADD(pedido_created, interval pedido_prazo day), '%d/%m/%Y') AS pedido_data_entrega
            
            ")
                ->where("pedido_id = " . $id)
                ->get();

            if (isset($res) && !empty($res) && is_array($res) && sizeof($res) > 0) {
                $res = $res[0];
                $res->pedido_frete  = Math::moeda($res->pedido_frete);
                if (isset($res->pedido_cliente) && intval($res->pedido_cliente) > 0) {

                    // teve frete, busca o endereçeo co cliente
                    $result = (new Factory('cliente'))->find($res->pedido_cliente);
                    if (isset($result) && $result) {
                        $result->cliente_whatsapp = ($result->cliente_celular) ? Filter::parse_numeric($result->cliente_celular) : '';
                        $res->pedido_cliente_info = $result;
                    }
                }
                if (isset($res->pedido_prazo) && intval($res->pedido_prazo) > 0) {
                    // teve frete, busca o endereçeo co cliente
                    $result = (new Factory('endereco_cliente'))
                        ->select('endereco_cliente_id, endereco_cliente_cep, endereco_cliente_rua, endereco_cliente_uf, endereco_cliente_num, endereco_cliente_complemento, endereco_cliente_cidade, endereco_cliente_titulo')
                        ->where('endereco_cliente_id = ' . $res->pedido_endereco)
                        ->get();
                    if (isset($result[0])) {
                        $res->pedido_endereco_cliente = $result[0];
                    }
                } else if (isset($res->pedido_endereco) && intval($res->pedido_endereco) > 0) {
                    // não teve frete, busca endereçeo de retyirada
                    $result = (new Factory('retirada'))
                        ->select('retirada_local, retirada_horario, retirada_rua, retirada_num, retirada_complemento, retirada_bairro, retirada_cidade, retirada_uf, retirada_cep, retirada_telefone')
                        ->where('retirada_id = ' . $res->pedido_endereco)
                        ->get();
                    if (isset($result[0])) {
                        $res->retirada = $result[0];
                    }
                }
                $lista = (new Factory('lista_pedido'))
                    ->select('lista_pedido_id, lista_pedido_produto_titulo, lista_pedido_preco, lista_pedido_qtde, lista_pedido_foto, lista_pedido_arquivo')
                    ->where('lista_pedido_pedido = ' . $id)
                    ->get();
                if (isset($lista) && !empty($lista) && is_array($lista) && sizeof($lista) > 0) {
                    $res->lista = $lista;

                    //procura pelos atributos dos produtos
                    foreach ($res->lista as $l) {
                        $att = (new  Factory('lista_pedido_atributo'))
                            ->where('lista_pedido_atributo_lista = ' . $l->lista_pedido_id)
                            ->get();
                        if (isset($att[0]) && !empty($att[0])) {
                            $l->atributos = $att;
                        }
                    }
                    echo json_encode($res);
                }
            } else {
                echo json_encode(['error' => 'Nenhum pedido encontrado']);
            }
        } else {
            echo json_encode(['error' => 'Id não informado ou inválido']);
        }
    }

    public function listar()
    {
        (new Factory('pedido'))
            ->select("cliente_nome, pedido_id, pedido_total_parcelado, pedido_info, pedido_total_produto,pedido_tipo, pedido_nf_num_id, pedido_nf_chave,pedido_status AS pedido_status_num, pedido_nf_status,
            CASE pedido_status
            WHEN 1 THEN 'Aguardando Pagamento'
            WHEN 2 THEN 'Em análise'
            WHEN 3 THEN 'Aprovado'
            WHEN 4 THEN 'Disponível'
            WHEN 5 THEN 'Em disputa'
            WHEN 6 THEN 'Devolvido'
            WHEN 7 THEN 'Cancelado'            
       END AS pedido_status,
            DATE_FORMAT(pedido_created, '%d/%m/%Y às %H:%i:%s') AS pedido_data
            ")
            ->join('cliente', 'cliente_id = pedido_cliente')
            ->order('pedido_id DESC')
            ->get(1);
    }

    public function remover()
    {
        $id = Req::post('id', 'int');
        if ($id > 0) {
            $lista  = (new Factory('lista_pedido'))->where('lista_pedido_pedido = ' . $id)->get();
            if (isset($lista[0])) {
                foreach ($lista as $l) {
                    $sql = "DELETE FROM lista_pedido_atributo WHERE lista_pedido_atributo_lista = $l->lista_pedido_id";
                    echo $sql;
                    (new Factory('lista_pedido_atributo'))->query($sql);
                    (new Factory('lista_pedido'))->drop($l->lista_pedido_id);
                }
            }
            (new Factory('pedido'))->drop($id);
            echo '1';
        } else {
            echo '0';
        }
    }

    public function imprimirPedido()
    {
        $pedido_id = Http::get_in_params('pedido-imprimir-admin', 'int');
        if (isset($pedido_id->value) && intval($pedido_id->value) > 0) {
            $pedido_id = $pedido_id->value;
            $res = (new Factory('pedido'))
                ->select('pedido_id')
                ->where("pedido_id = " . $pedido_id)
                ->get();
            if (isset($res) && !empty($res) && is_array($res) && sizeof($res) > 0) {
                $data = [
                    'config' => (new Config)->get(),
                    'pedido_id' => $pedido_id,
                    'mapper' => ['config', 'social'],

                ];
                Tpl::view("admin.pedido.print", $data);
            }
        }
    }

    public function getPedidoDetalhes()
    {
        $id = Req::post('id', 'int');

        if ($id > 0) {
            $res = (new Factory('pedido'))
                ->select("*,pedido_comprovante, pedido_pay_url, pedido_barcode, pedido_obs, pedido_info, pedido_status, pedido_pay_meio, pedido_endereco, pedido_total_frete, pedido_total_produto, pedido_frete, pedido_total_parcelado, pedido_prazo, pedido_cupom_desconto, DATE_FORMAT(pedido_created, '%d/%m/%Y') AS pedido_data, pedido_tipo, 
            CASE pedido_status
                WHEN 1 THEN 'Aguardando Pagamento'
                WHEN 2 THEN 'Em análise'
                WHEN 3 THEN 'Aprovado'
                WHEN 4 THEN 'Disponível'
                WHEN 5 THEN 'Em disputa'
                WHEN 6 THEN 'Devolvido'
                WHEN 7 THEN 'Cancelado'            
                END AS pedido_status_nome,
            CASE pedido_status
                WHEN 1 THEN 'warning'
                WHEN 2 THEN 'info'
                WHEN 3 THEN 'success'
                WHEN 4 THEN 'success'
                WHEN 5 THEN 'warning'
                WHEN 6 THEN 'danger'
                WHEN 7 THEN 'danger'            
            END AS pedido_status_badge,
            DATE_FORMAT(pedido_updated, '%d/%m/%Y às %H:%i:%s') AS pedido_atualizacao,
            DATE_FORMAT(DATE_ADD(pedido_created, interval pedido_prazo day), '%d/%m/%Y') AS pedido_data_entrega,
            cliente_nome, cliente_telefone, cliente_email
            ")
                ->join("cliente", 'cliente_id = pedido_cliente')
                ->where("pedido_id = " . $id)
                ->get();
            if (isset($res) && !empty($res) && is_array($res) && sizeof($res) > 0) {
                $res = $res[0];
                $res->pedido_frete  = Math::moeda($res->pedido_frete);
                if (isset($res->pedido_prazo) && intval($res->pedido_prazo) > 0) {
                    // teve frete, busca o endereçeo co cliente
                    $result = (new Factory('endereco_cliente'))
                        ->select('endereco_cliente_id, endereco_cliente_cep, endereco_cliente_rua, endereco_cliente_uf, endereco_cliente_num, endereco_cliente_complemento, endereco_cliente_cidade, endereco_cliente_titulo')
                        ->where('endereco_cliente_id = ' . $res->pedido_endereco)
                        ->get();
                    if (isset($result[0])) {
                        $res->pedido_endereco_cliente = $result[0];
                    }
                } else {
                    // não teve frete, busca endereçeo de retyirada
                    $result = (new Factory('retirada'))
                        ->select('retirada_local, retirada_horario, retirada_rua, retirada_num, retirada_complemento, retirada_bairro, retirada_cidade, retirada_uf, retirada_cep, retirada_telefone')
                        ->where('retirada_id = ' . $res->pedido_endereco)
                        ->get();
                    if (isset($result[0])) {
                        $res->retirada = $result[0];
                    }
                }
                $lista = (new Factory('lista_pedido'))
                    ->select('lista_pedido_id, lista_pedido_produto_titulo, lista_pedido_preco, lista_pedido_qtde, lista_pedido_foto')
                    ->where('lista_pedido_pedido = ' . $id)
                    ->get();
                if (isset($lista) && !empty($lista) && is_array($lista) && sizeof($lista) > 0) {
                    $res->lista = $lista;

                    //procura pelos atributos dos produtos
                    foreach ($res->lista as $l) {
                        $att = (new  Factory('lista_pedido_atributo'))
                            ->where('lista_pedido_atributo_lista = ' . $l->lista_pedido_id)
                            ->get();
                        if (isset($att[0]) && !empty($att[0])) {
                            $l->atributos = $att;
                        }
                    }
                    echo json_encode($res);
                }
            } else {
                echo json_encode(['error' => 'Nenhum pedido encontrado']);
            }
        } else {
            echo json_encode(['error' => 'Id não informado ou inválido']);
        }
    }


    public function criar_nfe()
    {
        $pedido_id = Http::get_in_params('id', 'int');
        $pedido_id = (isset($pedido_id->value) && intval($pedido_id->value) > 0) ? $pedido_id->value : 0;
        if ($pedido_id > !0) {
            exit;
            Http::redirect_to('/pedido/?error');
        }

        $pedido = (new Factory('pedido')
        )->select('*')
            ->where("pedido_id = $pedido_id")
            ->get();

        $pedido = (isset($pedido[0]) && !empty($pedido[0])) ? $pedido[0] : 0;

        $cliente = (new Factory('cliente'))->select('*')
            ->join('endereco_cliente', 'endereco_cliente_cliente = cliente_id', 'LEFT')
            ->group_by('cliente_id')
            ->where("cliente_id = $pedido->pedido_cliente")
            ->get();

        $cliente = (isset($cliente[0]) && !empty($cliente[0])) ? $cliente[0] : 0;

        $produtos = (new Factory('lista_pedido')
        )->select('*')
            ->join('produto', 'produto_id = lista_pedido_produto')
            ->where("lista_pedido_pedido = $pedido_id")
            ->get();

        $produtos = (isset($produtos[0]) && !empty($produtos[0])) ? $produtos : 0;

        if ($pedido && $cliente && $produtos) {
            $data = [
                'pedido' => $pedido,
                'cliente' => $cliente,
                'produtos' => $produtos,
            ];

            Nfe::gerar_nfe($data);
        } else {
            Http::redirect_to('/pedido/?error');
        }
    }

    public function enviar_nfe()
    {
        $pedido_id = Http::get_in_params('id', 'int');
        $pedido_id = (isset($pedido_id->value) && intval($pedido_id->value) > 0) ? $pedido_id->value : 0;

        $nfe_id = Http::get_in_params('nfe_id', 'int');
        $nfe_id = (isset($nfe_id->value) && intval($nfe_id->value) > 0) ? $nfe_id->value : 0;

        if ($pedido_id > 0 && $nfe_id) {
            Nfe::enviar_nfe([
                'pedido_id' => $pedido_id,
                'nfe_id' => $nfe_id,
            ]);
        } else {
            Http::redirect_to('/pedido/?error');
        }
    }

    public function criar_enviar_nfe()
    {
        $pedido_id = Http::get_in_params('id', 'int');
        $pedido_id = (isset($pedido_id->value) && intval($pedido_id->value) > 0) ? $pedido_id->value : 0;
        if ($pedido_id > !0) {
            Http::redirect_to('/pedido/?error');
        }

        $pedido = (new Factory('pedido')
        )->select('*')
            ->where("pedido_id = $pedido_id")
            ->get();
        $pedido = (isset($pedido[0]) && !empty($pedido[0])) ? $pedido[0] : 0;

        if ($pedido) {
            $cliente = (new Factory('cliente'))->select('*')
                ->join('endereco_cliente', 'endereco_cliente_cliente = cliente_id', 'LEFT')
                ->group_by('cliente_id')
                ->where("cliente_id = $pedido->pedido_cliente")
                ->get();

            $cliente = (isset($cliente[0]) && !empty($cliente[0])) ? $cliente[0] : 0;

            $produtos = (new Factory('lista_pedido')
            )->select('*')
                ->join('produto', 'produto_id = lista_pedido_produto')
                ->where("lista_pedido_pedido = $pedido_id")
                ->get();

            $produtos = (isset($produtos[0]) && !empty($produtos[0])) ? $produtos : 0;

            if ($cliente && $produtos) {
                $data = [
                    'pedido' => $pedido,
                    'cliente' => $cliente,
                    'produtos' => $produtos,
                ];

                Nfe::gerar_enviar_nfe($data);
            } else {
                Http::redirect_to('/pedido/?error');
            }
        } else {
            Http::redirect_to('/pedido/?error_pedido_invalido');
        }
    }
}
