<?php

use Payment\PagarMe;

@session_start();

class PagamentoFront
{
    public $config_pagamento = null;
    public $config = null;
    public $gateway = null;
    // atributos de compra
    public $cart = null;
    public $totalProdutos = 0;
    public $totalComCupom = 0;
    public $totalCompra = 0;
    public $pedidoId = null;
    public $descontoBoleto = null;
    public $deposito = null;
    //public $configPayment = null;
    public $metodo = null;

    public function __construct()
    {
        (new Install)->check_tabelas_principais();
        $this->config = (new Config)->get();
        $this->config_pagamento = (new Factory('pay'))->where('pay_name = "Config"')->get()[0]; // recebe o gateway ativo  
        $this->deposito = (new Factory('pay'))->find(3); // Informações de Depósito
        //$this->configPayment = (new Factory('pay'))->where('pay_key == "config"')->get()[0];

        $this->descontoBoleto = intval($this->config_pagamento->pay_fator_juros);
        $this->cart = (new Carrinho)->getCarrinho(1);
        if (!isset($this->cart) && empty($this->cart)) {
            echo json_encode(['error' => 'Nenhum produto no carrinho', 'redirect' => Http::base() . '/carrinho']);
            exit;
        }
    }

    public function indexAction()
    {
        if ($this->config_pagamento->pay_key == 'mercadoPago') {
            $this->gateway = (new Factory('pay'))->find(6);
            $this->viewMercadoPago();
        }

        if ($this->config_pagamento->pay_key == 'pagarMe') {
            $this->gateway = (new Factory('pay'))->find_by('pay_key', 'pagarMe');
            $this->viewPagarMe();
        }

        if ($this->config_pagamento->pay_key == 'pagseguro') {
            $this->gateway = (new Factory('pay'))->find(1);
            $this->viewPagseguro();
        }
        if ($this->config_pagamento->pay_key == 'cielo') {
            $this->gateway = (new Factory('pay'))->find(2);
            $this->viewCielo();
        }
    }

    public function viewData()
    {
        $data = [
            'categorias' => (new CategoriasProdutosFront())->listar(),
            'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
            'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
            'paginasTopo' => (new Pagina())->listarPaginasTopo(),
            'gateway' => $this->gateway,
            'boleto_ativo' => $this->gateway->pay_c3,
            'deposito_ativo' => $this->deposito->pay_status,
            'desconto_boleto' => $this->descontoBoleto,
            'maxInstallments' => $this->config_pagamento->pay_c6,
            'paginasFooter' => (new Pagina())->listarPaginasFooter(),
            'faq' => (new Faq())->listaFooter(),
            'config' => $this->config,
            'social' => (new Config)->getRedesSociais(),
            'mapper' => ['config', 'social'],
        ];
        return $data;
    }

    public function viewMercadoPago()
    {
        $data = [
            'categorias' => (new CategoriasProdutosFront())->listar(),
            'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
            'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
            'paginasTopo' => (new Pagina())->listarPaginasTopo(),
            'gateway' => $this->gateway,
            'boleto_ativo' => $this->gateway->pay_c3,
            'deposito_ativo' => $this->deposito->pay_status,
            'desconto_boleto' => $this->descontoBoleto,
            'maxInstallments' => $this->config_pagamento->pay_c6,
            'paginasFooter' => (new Pagina())->listarPaginasFooter(),
            'faq' => (new Faq())->listaFooter(),
            'config' => $this->config,
            'social' => (new Config)->getRedesSociais(),
            'mapper' => ['config', 'social'],
        ];
        Tpl::view("tema.loja.checkout.pagamento.mercadopago.index", $data, 1);
    }

    public function viewPagarMe()
    {

        $total = $this->cart['info']['subtotal'];
        $qtde_parcelas = $this->config_pagamento->pay_c6;
        //Filter::pre($this->cart);        exit;

        $parcelas = PagarMe::installments($total, $qtde_parcelas, 1);

        //Filter::pre($parcelas);        exit;
        $data = [
            'categorias' => (new CategoriasProdutosFront())->listar(),
            'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
            'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
            'paginasTopo' => (new Pagina())->listarPaginasTopo(),
            'gateway' => $this->gateway,
            'boleto_ativo' => $this->gateway->pay_c3,
            'deposito_ativo' => $this->deposito->pay_status,
            'desconto_boleto' => $this->descontoBoleto,
            'maxInstallments' => $this->config_pagamento->pay_c6,
            'paginasFooter' => (new Pagina())->listarPaginasFooter(),
            'faq' => (new Faq())->listaFooter(),
            'config' => $this->config,
            'parcelas' => $parcelas,
            'social' => (new Config)->getRedesSociais(),
            'mapper' => ['config', 'social'],
        ];
        Tpl::view("tema.loja.checkout.pagamento.pagarme.index", $data);
    }


    public function viewPagSeguro()
    {
        $this->gateway = (new Factory('pay'))->find(1);
        $email = $this->gateway->pay_user;
        $token = $this->gateway->pay_key;
        $url = "https://ws.pagseguro.uol.com.br/v2/sessions?email=$email&token=$token"; // Produção
        // $url = "https://ws.sandbox.pagseguro.uol.com.br/v2/sessions?email=$email&token=$token"; // sandbox

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            $erro = curl_error($ch);
        }
        if (isset($erro) && !empty($erro) && (string)$result == "Unauthorized") {
            echo "Erro: " . $result . "<br>";
            print_r($erro);
            exit;
        }
        $sessionPagseguro = simplexml_load_string($result);
        if (!isset($sessionPagseguro->id)) {
            echo "Erro nos dados de integração PagSeguro.";
            exit;
        }

        $data = [
            'categorias' => (new CategoriasProdutosFront())->listar(),
            'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
            'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
            'paginasTopo' => (new Pagina())->listarPaginasTopo(),
            'gateway' => $this->gateway,
            'boleto_ativo' => $this->gateway->pay_c3,
            'deposito_ativo' => $this->deposito->pay_status,
            'desconto_boleto' => $this->descontoBoleto,
            'maxInstallments' => $this->config_pagamento->pay_c6,
            'sessionPagseguro' => $sessionPagseguro->id,
            'pagseguro_semjuros' => $this->gateway->pay_c1,
            'paginasFooter' => (new Pagina())->listarPaginasFooter(),
            'faq' => (new Faq())->listaFooter(),
            'config' => $this->config,
            'social' => (new Config)->getRedesSociais(),
            'mapper' => ['config', 'social'],
        ];
        Tpl::view("tema.loja.checkout.pagamento.pagseguro.index", $data, 1);
    }
    public function viewCielo()
    {
        $data = [
            'categorias' => (new CategoriasProdutosFront())->listar(),
            'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
            'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
            'paginasTopo' => (new Pagina())->listarPaginasTopo(),
            'gateway' => $this->gateway,
            'boleto_ativo' => $this->gateway->pay_c3,
            'deposito_ativo' => $this->deposito->pay_status,
            'desconto_boleto' => $this->descontoBoleto,
            'maxInstallments' => $this->config_pagamento->pay_c6,
            'pagseguro_semjuros' => $this->gateway->pay_c1,
            'paginasFooter' => (new Pagina())->listarPaginasFooter(),
            'faq' => (new Faq())->listaFooter(),
            'config' => $this->config,
            'social' => (new Config)->getRedesSociais(),
            'mapper' => ['config', 'social'],

        ];
        Tpl::view("tema.loja.checkout.pagamento.cielo.index", $data, 1);
    }

    public function finaliza_orcamento()
    {
        $this->totalProdutos = $this->cart['info']['subtotal'];

        // Setando os valores de compra do pedido
        if (isset($_SESSION['cupom']) && !empty($_SESSION['cupom']) && $_SESSION['cupom'] != "") {
            $cupom = $_SESSION['cupom'];
            if (intval($cupom['cupom_desconto']) > 0) {
                // desconto percentual
                if (isset($_SESSION['frete']) && isset($_SESSION['frete']['endereco_id']) && !empty($_SESSION['frete']['endereco_id'])) {
                    // tem frete setado
                    $this->totalCompra = doubleval(($this->totalProdutos - ($this->totalProdutos * ($cupom['cupom_desconto'] / 100))) + $_SESSION['frete']['price']);
                } else {
                    $this->totalCompra = doubleval($this->totalProdutos - ($this->totalProdutos * ($cupom['cupom_desconto'] / 100)));
                }
            } else {
                // desconto em real
                if (isset($_SESSION['frete']) && isset($_SESSION['frete']['endereco_id']) && !empty($_SESSION['frete']['endereco_id'])) {
                    // tem frete setado
                    $this->totalCompra = doubleval($this->totalProdutos - $cupom['cupom_real']);
                    if ($this->totalCompra < 0) {
                        $this->totalCompra = doubleval($_SESSION['frete']['price']);
                    } else {
                        $this->totalCompra += doubleval($_SESSION['frete']['price']);
                    }
                } else {
                    $this->totalCompra = doubleval($this->totalProdutos - $cupom['cupom_real']);
                    if ($this->totalCompra < 0) {
                        $this->totalCompra = 0;
                    }
                }
            }
        } else {
            // total sem desconto de cupom
            if (isset($_SESSION['frete']) && isset($_SESSION['frete']['endereco_id']) && !empty($_SESSION['frete']['endereco_id'])) {
                // tem frete setado                
                $this->totalCompra = doubleval($this->totalProdutos + $_SESSION['frete']['price']);
            } else {
                $this->totalCompra = doubleval($this->totalProdutos);
            }
        }
        $this->totalCompra = floatval(number_format($this->totalCompra, 2, '.', ''));

        $frete = (isset($_SESSION['frete']) &&  isset($_SESSION['frete']['price'])) ? $_SESSION['frete']['price'] : '0';
        // Insere o pedido no banco de dados 
        $with = [
            "pedido_cliente" => intval($_SESSION['__CLIENTE_ORCAMENTO__']->cliente_id),
            "pedido_total_produto" => $this->totalProdutos,
            "pedido_frete" => $frete,
            "pedido_total_frete" =>  doubleval($this->totalProdutos + $frete),
            "pedido_status"  => 2,
            "pedido_tipo" => 2,
            "pedido_info" => "Orçamento"
        ];
        // Caso tenha frete no pedido, insere seus valores
        if (isset($_SESSION['frete']) &&  isset($_SESSION['frete']['endereco_id']) && !empty($_SESSION['frete']['endereco_id'])) {
            $with['pedido_frete'] = 1;
            $with['pedido_prazo'] = intval($_SESSION['frete']['deadline']);
            $with['pedido_entrega'] = 1;
            $with['pedido_endereco'] = intval($_SESSION['frete']['endereco_id']);
        } else if (isset($_SESSION['retirada']['retirada_id']) && !empty($_SESSION['retirada']['retirada_id'])) {
            $with['pedido_frete'] = 0;
            $with['pedido_prazo'] = 0;
            $with['pedido_entrega'] = 0;
            $with['pedido_endereco'] = intval($_SESSION['retirada']['retirada_id']);
        } else {
            unset($_SESSION['frete']);
            unset($_SESSION['retirada']);
            /*echo json_encode(['error' => 'Nenhuma opção de entrega / retirada foi escolhida', 'redirect' => Http::base() . "/checkout"]);
            exit;*/
        }

        // Caso tenha sido usado cupom, insere seus valores
        if (isset($_SESSION['cupom']) && !empty($_SESSION['cupom']) && $_SESSION['cupom'] != "") {
            $with['pedido_cupom_desconto'] = intval($_SESSION['cupom']['cupom_desconto']) > 0 ? $_SESSION['cupom']['cupom_desconto'] . " %" : "R$ " . $_SESSION['cupom']['cupom_real'];
            $with['pedido_cupom_alfa'] = $_SESSION['cupom']['cupom_alfa'];
        }

        $this->pedidoId = (new Factory('pedido'))->with($with)->save();
        if (intval($this->pedidoId) > 0) {

            // pedido ok, insere os itens 
            foreach ($this->cart['carrinho'] as $cart) {
                $prod = $cart['produto'];
                $with = [
                    "lista_pedido_produto" => $prod['produto_id'],
                    "lista_pedido_produto_titulo" => $prod['produto_titulo'],
                    "lista_pedido_preco" => $prod['produto_preco'],
                    "lista_pedido_pedido" => $this->pedidoId,
                    "lista_pedido_qtde" => $prod['qtd'],
                    "lista_pedido_foto" => $prod['produto_imagens'][0]['foto_produto_img']
                ];
                $listaId = (new Factory('lista_pedido'))->with($with)->save();
                // Insere os atributos do item caso tenha
                if (isset($prod['atributos_selecionados']) && !empty($prod['atributos_selecionados']) && is_array($prod['atributos_selecionados']) && sizeof($prod['atributos_selecionados']) > 0) {
                    $with_lista_pedido_atributo = [];
                    foreach ($prod['atributos_selecionados'] as $k => $item_atributo_id) {
                        $with_lista_pedido_atributo[] = [
                            'attnome' => $prod['nomes_atributos'][$k]->atributo_nome,
                            'itemnome' => $prod['nomes_atributos_selecionados'][$k],
                            'lista' => $listaId,
                            'valor_adicional' => (isset($prod['valor_adicional']) && !empty($prod['valor_adicional'])) ? $prod['valor_adicional'] : '0.00'
                        ];
                    }
                    (new Factory('lista_pedido_atributo'))->with($with_lista_pedido_atributo)->save();
                }

                // Remove qtd do produto
                $with = [
                    "produto_id" => $prod['produto_id'],
                    "produto_estoque" => intval($prod['produto_estoque'] - $prod['qtd'])
                ];
                //(new Factory('produto'))->with($with)->save();

            }
            //Enviando o email do orçamento para o admin e o cliente
            $pedido = (new Factory('pedido'))->find($this->pedidoId);
            $pedido->lista = (new Factory('lista_pedido'))
                ->select('lista_pedido_produto_titulo,lista_pedido_qtde')
                ->where("lista_pedido_pedido = $pedido->pedido_id ")
                ->get();

            $cliente = (new Factory('cliente'))->find($pedido->pedido_cliente);
            $cliente->cliente_nome_curto = explode(' ', $cliente->cliente_nome)[0];
            $dados = [
                'config' => (new Config)->get(),
                'pedido' => $pedido,
                'cliente' => $cliente,
                'mapper' => ['config', 'cliente', 'contato', 'pedido']
            ];
            Notificacao::admin_orcamento_realizado($dados);
            Notificacao::cliente_orcamento_realizado($dados);
            //Fim envio de email
            (new Carrinho)->clearCarrinho();
            unset($_SESSION['cupom']);
            unset($_SESSION['frete']);
            unset($_SESSION['retirada']);
            unset($_SESSION['__CLIENTE_ORCAMENTO__']);
            // REDIRECT PARA PAGINA DE SUCESSO (na pagina de detalhes do pedido, diferenciar informações quando for ORÇAMENTO ou VENDA NORMAL)
            Http::redirect_to("/atendimento/?orcamento_enviado");
        } else {
            (new Carrinho)->clearCarrinho();
            unset($_SESSION['cupom']);
            unset($_SESSION['frete']);
            unset($_SESSION['retirada']);
            unset($_SESSION['__CLIENTE_ORCAMENTO__']);
            Http::redirect_to("/carrinho/?error");
        }
    }

    public function payment()
    {
        $this->totalProdutos = $this->cart['info']['subtotal'];
        if (isset($_SESSION['cupom']) && !empty($_SESSION['cupom']) && $_SESSION['cupom'] != "") {
            $cupom = $_SESSION['cupom'];
            if (intval($cupom['cupom_desconto']) > 0) {
                if (isset($_SESSION['frete']) &&  isset($_SESSION['frete']['endereco_id']) && !empty($_SESSION['frete']['endereco_id'])) {
                    $this->totalCompra = doubleval(($this->totalProdutos - ($this->totalProdutos * ($cupom['cupom_desconto'] / 100))) + $_SESSION['frete']['price']);
                } else {
                    $this->totalCompra = doubleval($this->totalProdutos - ($this->totalProdutos * ($cupom['cupom_desconto'] / 100)));
                }
            } else {
                // desconto em real
                if (isset($_SESSION['frete']) &&  isset($_SESSION['frete']['endereco_id']) && !empty($_SESSION['frete']['endereco_id'])) {
                    // tem frete setado
                    $this->totalCompra = doubleval($this->totalProdutos - $cupom['cupom_real']);
                    if ($this->totalCompra < 0) {
                        $this->totalCompra = doubleval($_SESSION['frete']['price']);
                    } else {
                        $this->totalCompra += doubleval($_SESSION['frete']['price']);
                    }
                } else {
                    $this->totalCompra = doubleval($this->totalProdutos - $cupom['cupom_real']);
                    if ($this->totalCompra < 0) {
                        $this->totalCompra = 0;
                    }
                }
            }
        } else {
            if (isset($_SESSION['frete']) && isset($_SESSION['frete']['endereco_id']) && !empty($_SESSION['frete']['endereco_id'])) {
                $this->totalCompra = doubleval($this->totalProdutos + $_SESSION['frete']['price']);
            } else {
                $this->totalCompra = doubleval($this->totalProdutos);
            }
        }
        // Verifica se o pedido foi feito pra boleto, se sim, verifica se tem desconto e aplica
        $this->metodo = Req::post('metodo', 'string');
        $desconto = 0;
        if (($this->metodo == 'boleto' || $this->metodo == 'pix') && intval($this->descontoBoleto) > 0) {
            $desconto = ($this->totalCompra * ($this->descontoBoleto / 100));
            $this->totalCompra = floatval($this->totalCompra - ($this->totalCompra * ($this->descontoBoleto / 100)));
        }
        $this->totalCompra = floatval(number_format($this->totalCompra, 2, '.', ''));

        $frete_price = 0;
        $frete_name = '';
        $frete_rastreio  = 0;
        $frete_deadline = 0;
        if (isset($_SESSION['frete'])) {
            $frete_price = $_SESSION['frete']['price'];
            $frete_name = $_SESSION['frete']['name'];
            $frete_rastreio  = (isset($_SESSION['frete']['rastreio'])) ? intval($_SESSION['frete']['rastreio']) : 0;
            $frete_deadline = (isset($_SESSION['frete']['deadline'])) ? intval($_SESSION['frete']['deadline']) : 0;
        }
        $with = [
            "pedido_cliente" => intval(Session::client_node('uid')),
            "pedido_total_produto" => $this->totalProdutos,
            "pedido_frete" => $frete_price,
            'pedido_servico_frete' => $frete_name,
            'pedido_empresa_rastreio' => $frete_rastreio,
            "pedido_total_frete" =>  doubleval($this->totalProdutos + $frete_price),
            "pedido_status"  => 1,
            "pedido_cupom_info" => ' ' . Math::moeda($desconto)
        ];

        if (isset($_SESSION['frete']) &&  isset($_SESSION['frete']['endereco_id']) && !empty($_SESSION['frete']['endereco_id'])) {
            $with['pedido_frete'] =  $frete_price;
            $with['pedido_prazo'] = $frete_deadline;
            $with['pedido_servico_frete'] = $frete_name;
            $with['pedido_empresa_rastreio'] =  $frete_rastreio;
            $with['pedido_entrega'] = 1;
            $with['pedido_endereco'] = intval($_SESSION['frete']['endereco_id']);
        } else if (isset($_SESSION['retirada']['retirada_id']) && !empty($_SESSION['retirada']['retirada_id'])) {
            $with['pedido_frete'] = 0;
            $with['pedido_prazo'] = 0;
            $with['pedido_servico_frete'] =  '';
            $with['pedido_entrega'] = 0;
            $with['pedido_endereco'] = intval($_SESSION['retirada']['retirada_id']);
        } else {
            unset($_SESSION['frete']);
            unset($_SESSION['retirada']);
            echo json_encode(['error' => 'Nenhuma opção de entrega / retirada foi escolhida', 'redirect' => Http::base() . "/checkout"]);
            exit;
        }
        // Caso tenha sido usado cupom, insere seus valores
        if (isset($_SESSION['cupom']) && !empty($_SESSION['cupom']) && $_SESSION['cupom'] != "") {
            $with['pedido_cupom_desconto'] = intval($_SESSION['cupom']['cupom_desconto']) > 0 ? $_SESSION['cupom']['cupom_desconto'] . " %" : "R$ " . $_SESSION['cupom']['cupom_real'];
            $with['pedido_cupom_alfa'] = $_SESSION['cupom']['cupom_alfa'];
            $with['pedido_cupom_info'] .=   ' ' . $with['pedido_cupom_alfa'];
        }


        $this->pedidoId = (new Factory('pedido'))->with($with)->save();
        if (intval($this->pedidoId) > 0) {
            // pedido ok, insere os itens 
            foreach ($this->cart['carrinho'] as $cart) {
                $prod = $cart['produto'];
                $with = [
                    "produto" => $prod['produto_id'],
                    "produto_titulo" => $prod['produto_titulo'],
                    "preco" => $prod['produto_preco'],
                    "pedido" => $this->pedidoId,
                    "qtde" => $prod['qtd'],
                    "foto" => $prod['produto_imagens'][0]['foto_produto_img']
                ];
                if (isset($prod['arquivo_url']) && !empty($prod['arquivo_url'])) {
                    $ds = DIRECTORY_SEPARATOR;
                    $pathDelete = Path::base() . $ds . 'media' . $ds . 'temp' . $ds . $prod['arquivo_url'];
                    $pathNovo = Path::base() . $ds . 'media' . $ds . 'produto_arquivo' . $ds . $prod['arquivo_url'];
                    if (is_file($pathDelete)) {
                        //@system("chmod -R 777 $pathDelete");
                        //@system("chmod -R 777 $pathNovo");
                        copy($pathDelete, $pathNovo);
                        @unlink($pathDelete);
                        if (is_file($pathNovo)) {
                            $with['arquivo'] = $prod['arquivo_url'];
                        }
                    }
                }
                $listaId = (new Factory('lista_pedido'))->with($with)->save();
                // Insere os atributos do item caso tenha
                if (isset($prod['atributos_selecionados']) && !empty($prod['atributos_selecionados']) && is_array($prod['atributos_selecionados']) && sizeof($prod['atributos_selecionados']) > 0) {
                    $with_lista_pedido_atributo = [];
                    foreach ($prod['atributos_selecionados'] as $k => $item_atributo_id) {
                        $with_lista_pedido_atributo[] = [
                            'attnome' => $prod['nomes_atributos'][$k]->atributo_nome,
                            'itemnome' => $prod['nomes_atributos_selecionados'][$k],
                            'lista' => $listaId,
                            'valor_adicional' => (isset($prod['valor_adicional']) && !empty($prod['valor_adicional'])) ? $prod['valor_adicional'] : '0.00'
                        ];
                    }
                    (new Factory('lista_pedido_atributo'))->with($with_lista_pedido_atributo)->save();
                }
                // ------- lógica de estoque
                // Se o produto tiver atributos, da baixa apenas no estoque de atributos
                // Caso não tenha, da baixa no estoque do produto normal
                if (isset($prod['atributos_selecionados']) && !empty($prod['atributos_selecionados']) && is_array($prod['atributos_selecionados']) && sizeof($prod['atributos_selecionados']) > 0) {
                    $where = 'relacao_item_produto = ' . $prod['produto_id'];
                    if (isset($prod['atributos_selecionados'][1])) {
                        // O último item de atributos_selecionados é o id do item mandante dos atributos, o restante são os pais
                        $item_mandante = $prod['atributos_selecionados'][sizeof($prod['atributos_selecionados']) - 1];
                        $itens_pai = $prod['atributos_selecionados'];
                        array_pop($itens_pai);
                        $itens_pai = implode('>', $itens_pai);
                        $where .= " AND relacao_item_item = $item_mandante AND relacao_item_relacao_pai = '$itens_pai'";
                    } else {
                        // o produto só tem um atributo, o item enviado é o mandante
                        $item_mandante = $prod['atributos_selecionados'][0];
                        $where .= " AND relacao_item_item = $item_mandante";
                    }

                    (new Factory('relacao_item'))->query("UPDATE relacao_item SET relacao_item_qtd = relacao_item_qtd - " . $prod['qtd'] . " WHERE " . $where);
                } else {
                    $with = [
                        "id" => $prod['produto_id'],
                        "estoque" => intval($prod['produto_estoque'] - $prod['qtd'])
                    ];
                    (new Factory('produto'))->with($with)->save();
                }
            }
            // Salva o questionário caso exista
            $respostas = Req::post('respostas');
            if (isset($respostas) && !empty($respostas) && is_array($respostas) && sizeof($respostas) > 0) {
                $with = [];
                foreach ($respostas as $r) {
                    $with[] = [
                        'pedido_id' => $this->pedidoId,
                        'campo_id' => $r['campo_checkout_id'],
                        'pergunta' => addslashes(strip_tags(trim($r['pergunta']))),
                        'resposta' => addslashes(strip_tags(trim($r['resposta']))),
                        'cliente_id' => intval(Session::client_node('uid')),
                    ];
                }
                (new Factory('campo_checkout_respostas'))->with($with)->save();
            }
            // pedido ok, lista ok, questionário ok, realizar checkout 
            // verifica qual o gateway ativo e chama seu método de pagamento
            if ($this->config_pagamento->pay_key == 'mercadoPago') {
                $this->paymentMercadoPago();
            } else if ($this->config_pagamento->pay_key == 'pagarMe') {
                $this->paymentPagarMe();
            } else if ($this->config_pagamento->pay_key == 'pagseguro') {
                $this->paymentPagseguro();
            } else if ($this->config_pagamento->pay_key == 'cielo') {
                $this->paymentCielo();
            }
        } else {
            echo json_encode(['error' => 'Erro na inserção do pedido']);
        }
    }

    public function paymentCielo()
    {
        $this->gateway = (new Factory('pay'))->find(2);
        $pedido = (new Factory('pedido'))->find($this->pedidoId);
        require_once 'PaymentCielo.php';
        // Verifica qual o metodo de pagamento escolhido
        if ($this->metodo == 'cartao') {
            $valor_com_juros = floatval($_POST['card_parcela']) * floatval($_POST['valor_parcela']);
            // Pagamento Pagseguro via Cartão
            $payment = faturaCielo($this->gateway, $this->pedidoId, $valor_com_juros);
            $res = json_decode($payment);
            $pay = $res->Payment;
            if ($pay->Status != 1 && $pay->Status != 2 && $pay->Status != 3) {
                $with = [
                    'pedido_id' => $this->pedidoId,
                    'pedido_status' => 7,
                    "pedido_pay_meio" => "Cielo - Cartão de Crédito",
                    "pedido_info" => "cartao",
                    "pedido_total_parcelado" => $valor_com_juros,
                    "pedido_pay_gw" => 3,
                    'pedido_obs' => 'Pagamento não autorizado pela administradora do cartão!'
                ];
                (new Factory('pedido'))->with($with)->save();
                PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
            } else {
                $payId = $res->Payment->PaymentId;
                $with = [
                    'pedido_id' => $this->pedidoId,
                    'pedido_status' => $pay->Status,
                    'pedido_pay_code' => $payId,
                    "pedido_pay_meio" => "Cielo - Cartão de Crédito",
                    "pedido_info" => "cartao",
                    "pedido_pay_gw" => 3,
                    "pedido_total_parcelado" => $valor_com_juros,
                ];
                (new Factory('pedido'))->with($with)->save();
                PedidoStatus::notificar_cliente_pedido_realizado($pedido->pedido_id, $pedido->pedido_cliente);
            }
            PedidoStatus::notificar_admin($pedido->pedido_id, $pedido->pedido_cliente);
            if (isset($_SESSION['cupom']['cupom_id'])) {
                (new Factory('cupom'))->query("UPDATE cupom SET cupom_lote = (cupom_lote + 1) WHERE cupom_id = " . $_SESSION['cupom']['cupom_id']);
            }
            (new Carrinho)->clearCarrinho();
            unset($_SESSION['cupom']);
            unset($_SESSION['frete']);
            unset($_SESSION['retirada']);
            echo json_encode(['pedido_id' => $this->pedidoId]);
            exit;
        } else if ($this->metodo == 'boleto') {
            $payment = faturaCieloBoleto($this->gateway, $this->pedidoId, $this->totalCompra);
            $res = json_decode($payment);
            $pay = $res->Payment;
            if ($pay->Status != 1 && $pay->Status != 2 && $pay->Status != 3) {
                $with = [
                    'pedido_id' => $this->pedidoId,
                    'pedido_status' => 7,
                    "pedido_pay_meio" => "Cielo - Boleto",
                    "pedido_info" => "boleto",
                    "pedido_total_parcelado" => $this->totalCompra,
                    "pedido_pay_gw" => 3,
                    'pedido_obs' => 'Não foi possível gerar o boleto!'
                ];
                (new Factory('pedido'))->with($with)->save();
                PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
            } else {
                $payId = $res->Payment->PaymentId;
                $barcode = isset($res->Payment->BarCodeNumber) ? $res->Payment->BarCodeNumber : "";
                $boletoUrl = isset($res->Payment->Url) ? $res->Payment->Url : "";
                $with = [
                    'pedido_id' => $this->pedidoId,
                    'pedido_status' => $pay->Status,
                    'pedido_pay_code' => $payId,
                    "pedido_pay_meio" => "Cielo - Boleto",
                    "pedido_info" => "boleto",
                    "pedido_pay_gw" => 3,
                    "pedido_pay_url" => $boletoUrl,
                    "pedido_barcode" => $barcode,
                    "pedido_total_parcelado" => $this->totalCompra,
                ];
                (new Factory('pedido'))->with($with)->save();
            }
            PedidoStatus::notificar_cliente_pedido_realizado($pedido->pedido_id, $pedido->pedido_cliente);
            PedidoStatus::notificar_admin($pedido->pedido_id, $pedido->pedido_cliente);
            if (isset($_SESSION['cupom']['cupom_id'])) {
                (new Factory('cupom'))->query("UPDATE cupom SET cupom_lote = (cupom_lote + 1) WHERE cupom_id = " . $_SESSION['cupom']['cupom_id']);
            }
            (new Carrinho)->clearCarrinho();
            unset($_SESSION['cupom']);
            unset($_SESSION['frete']);
            unset($_SESSION['retirada']);
            echo json_encode(['pedido_id' => $this->pedidoId]);
            exit;
        } else if ($this->metodo == 'deposito') {
            // Pagamento MercadoPago via boleto
            $with = [
                "pedido_id" => $this->pedidoId,
                "pedido_pay_meio" => "Depósito",
                "pedido_info" => "deposito",
                "pedido_pay_gw" => 4,
                "pedido_total_parcelado" => floatval($this->totalCompra),
                "pedido_obs" => "Pagamento via depósito."
            ];
            (new Factory('pedido'))->with($with)->save();

            PedidoStatus::notificar_cliente_pedido_realizado($pedido->pedido_id, $pedido->pedido_cliente);
            PedidoStatus::notificar_admin($pedido->pedido_id, $pedido->pedido_cliente);
            if (isset($_SESSION['cupom']['cupom_id'])) {
                (new Factory('cupom'))->query("UPDATE cupom SET cupom_lote = (cupom_lote + 1) WHERE cupom_id = " . $_SESSION['cupom']['cupom_id']);
            }
            (new Carrinho)->clearCarrinho();
            unset($_SESSION['cupom']);
            unset($_SESSION['frete']);
            unset($_SESSION['retirada']);
            echo json_encode(['pedido_id' => $this->pedidoId]);
            exit;
        }
    }

    public function paymentPagseguro()
    {
        $this->gateway = (new Factory('pay'))->find(1);
        $pedido = (new Factory('pedido'))->find($this->pedidoId);
        require_once 'PaymentPagseguro.php';
        // Verifica qual o metodo de pagamento escolhido                
        if ($this->metodo == 'cartao') {
            $valor_com_juros = floatval($_POST['card_parcela']) * floatval($_POST['valor_parcela']);
            $payment = faturaPS($this->gateway, $this->pedidoId, $this->totalCompra);
            $result_info = $payment;
            $payment = simplexml_load_string($payment);
            if (isset($payment->error) || $result_info == 'Unauthorized') {
                $with = [
                    "pedido_id" => $this->pedidoId,
                    "pedido_status" => 7,
                    "pedido_pay_meio" => "Pagseguro - Cartão de Crédito",
                    "pedido_info" => "cartao",
                    "pedido_total_parcelado" => $valor_com_juros,
                    "pedido_obs" => "Pagamento não autorizado pela administradora do cartão!"
                ];
                (new Factory('pedido'))->with($with)->save();
                PedidoStatus::notificar_admin($pedido->pedido_id, $pedido->pedido_cliente);
                PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
            } else {
                $code = $payment->code;
                $pedidoURL = "https://pagseguro.uol.com.br/v2/checkout/payment.html?code=$code";
                $id_transacao = $payment->id;
                $with = [
                    "pedido_id" => $this->pedidoId,
                    "pedido_pay_code" => $id_transacao,
                    "pedido_status" => $payment->status,
                    "pedido_pay_meio" => "Pagseguro - Cartão de Crédito",
                    "pedido_info" => "cartao",
                    "pedido_total_parcelado" => $valor_com_juros,
                    "pedido_pay_url" => $pedidoURL,
                    "pedido_pay_gw" => 1
                ];
                (new Factory('pedido'))->with($with)->save();
                PedidoStatus::notificar_cliente_pedido_realizado($pedido->pedido_id, $pedido->pedido_cliente);
                PedidoStatus::notificar_cliente_pedido_aprovado($pedido->pedido_id, $pedido->pedido_cliente);
                PedidoStatus::notificar_admin($pedido->pedido_id, $pedido->pedido_cliente);
            }
            self::useCupom();
            (new Carrinho)->clearCarrinho();
            echo json_encode(['pedido_id' => $this->pedidoId]);
        } else if ($this->metodo == 'boleto') {
            // Pagamento MercadoPago via boleto
            $payment = faturaPSBoleto($this->gateway, $this->pedidoId, $this->totalCompra);
            // FALTANDO ajustar boleto indo com 1 real a mais       
            $result_info = $payment;
            $payment = simplexml_load_string($payment);
            if (isset($payment->error) || $result_info == 'Unauthorized') {
                $with = [
                    "pedido_id" => $this->pedidoId,
                    "pedido_status" => 7,
                    "pedido_pay_meio" => "Pagseguro - Boleto",
                    "pedido_total_parcelado" => $this->totalCompra,
                    "pedido_info" => "boleto",
                    "pedido_obs" => "Não foi possível gerar o boleto!"
                ];
                (new Factory('pedido'))->with($with)->save();
                PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
            } else {
                $code = $payment->code;
                $pedidoURL = $payment->paymentLink;
                $id_transacao = $payment->id;
                $with = [
                    "pedido_id" => $this->pedidoId,
                    "pedido_pay_code" => $code,
                    "pedido_pay_meio" => "Pagseguro - Boleto",
                    "pedido_info" => "boleto",
                    "pedido_total_parcelado" => $this->totalCompra,
                    "pedido_pay_url" => $pedidoURL,
                    "pedido_pay_gw" => 5
                ];
                (new Factory('pedido'))->with($with)->save();
                PedidoStatus::notificar_cliente_pedido_realizado($pedido->pedido_id, $pedido->pedido_cliente);
            }
            PedidoStatus::notificar_admin($pedido->pedido_id, $pedido->pedido_cliente);
            self::useCupom();
            (new Carrinho)->clearCarrinho();
            echo json_encode(['pedido_id' => $this->pedidoId]);
            exit;
        } else if ($this->metodo == 'deposito') {
            // Pagamento MercadoPago via dep
            $with = [
                "pedido_id" => $this->pedidoId,
                "pedido_pay_meio" => "Depósito",
                "pedido_info" => "deposito",
                "pedido_pay_gw" => 4,
                "pedido_total_parcelado" => floatval($this->totalCompra),
                "pedido_obs" => "Pagamento via depósito."
            ];
            (new Factory('pedido'))->with($with)->save();
            PedidoStatus::notificar_cliente_pedido_realizado($pedido->pedido_id, $pedido->pedido_cliente);
            PedidoStatus::notificar_admin($pedido->pedido_id, $pedido->pedido_cliente);
            (new Carrinho)->clearCarrinho();
            self::useCupom();
            echo json_encode(['pedido_id' => $this->pedidoId]);
        }
    }

    public function paymentMercadoPago()
    {
        $this->gateway = (new Factory('pay'))->find(6);
        $pedido = (new Factory('pedido'))->find($this->pedidoId);
        require_once 'PaymentMercadoPago.php';
        if ($this->metodo == 'cartao') {
            $payment = faturaMP($this->gateway, $this->pedidoId, $this->totalCompra);
            if (isset($payment->error)) {
                $valor_com_juros = floatval(isset($payment->transaction_details->total_paid_amount) ? $payment->transaction_details->total_paid_amount : $payment->transaction_amount);
                $with = [
                    "pedido_id" => $this->pedidoId,
                    "pedido_status" => 7,
                    "pedido_pay_meio" => "MercadoPago - Cartão de Crédito",
                    "pedido_info" => "cartao",
                    "pedido_total_parcelado" => $valor_com_juros,
                    "pedido_obs" => "Pagamento não autorizado pela administradora do cartão!"
                ];
                (new Factory('pedido'))->with($with)->save();
                PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
            } else if (isset($payment->id)) {
                $id_transacao = $payment->id;
                $valor_com_juros = floatval($payment->transaction_details->total_paid_amount);
                $with = [
                    "pedido_id" => $this->pedidoId,
                    "pedido_pay_code" => $id_transacao,
                    "pedido_pay_meio" => "MercadoPago - Cartão de Crédito",
                    "pedido_info" => "cartao",
                    "pedido_total_parcelado" => $valor_com_juros,
                    "pedido_pay_gw" => 1
                ];
                (new Factory('pedido'))->with($with)->save();
                PedidoStatus::notificar_cliente_pedido_realizado($pedido->pedido_id, $pedido->pedido_cliente);
                PedidoStatus::notificar_cliente_pedido_aprovado($pedido->pedido_id, $pedido->pedido_cliente);
            } else {
                $with = [
                    "pedido_id" => $this->pedidoId,
                    "pedido_status" => 7,
                    "pedido_pay_meio" => "MercadoPago - Cartão de Crédito",
                    "pedido_info" => "cartao",
                    "pedido_obs" => "Erro na tentativa de realizar o pagamento."
                ];
                (new Factory('pedido'))->with($with)->save();
                PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
            }
            PedidoStatus::notificar_admin($pedido->pedido_id, $pedido->pedido_cliente);
            self::useCupom();
            (new Carrinho)->clearCarrinho();
            echo json_encode(['pedido_id' => $this->pedidoId]);
        } else if ($this->metodo == 'boleto') {
            $payment = faturaMPBoleto($this->gateway, $this->pedidoId, $this->totalCompra);
            if (isset($payment->error)) {
                //Filter::pre($payment);
                $valor_com_juros = floatval((isset($payment->transaction_details->total_paid_amount)) ? $payment->transaction_details->total_paid_amount : $payment->transaction_amount);
                $with = [
                    "pedido_id" => $this->pedidoId,
                    "pedido_status" => 7,
                    "pedido_pay_meio" => "MercadoPago - Boleto",
                    "pedido_info" => "boleto",
                    "pedido_total_parcelado" => $valor_com_juros,
                    "pedido_obs" => "Não foi possível gerar o boleto."
                ];
                (new Factory('pedido'))->with($with)->save();
                PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
            } else if (isset($payment->id)) {
                $id_transacao = $payment->id;
                $valor_com_juros = floatval($payment->transaction_details->total_paid_amount);
                $with = [
                    "pedido_id" => $this->pedidoId,
                    "pedido_pay_code" => $id_transacao,
                    "pedido_pay_meio" => "MercadoPago - Boleto",
                    "pedido_total_parcelado" => $valor_com_juros,
                    "pedido_info" => "boleto",
                    "pedido_pay_gw" => 1,
                    "pedido_pay_url" => $payment->transaction_details->external_resource_url,
                    "pedido_barcode" => $payment->barcode->content, // código de barras em número
                ];
                (new Factory('pedido'))->with($with)->save();
            } else {
                $with = [
                    "pedido_id" => $this->pedidoId,
                    "pedido_status" => 7,
                    "pedido_info" => "boleto",
                    "pedido_pay_meio" => "MercadoPago - Boleto",
                    "pedido_obs" => "Erro na tentativa de gerar o boleto."
                ];
                (new Factory('pedido'))->with($with)->save();
                PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
            }
            PedidoStatus::notificar_cliente_pedido_realizado($pedido->pedido_id, $pedido->pedido_cliente);
            PedidoStatus::notificar_admin($pedido->pedido_id, $pedido->pedido_cliente);
            self::useCupom();
            (new Carrinho)->clearCarrinho();
            echo json_encode(['pedido_id' => $this->pedidoId]);
        } else if ($this->metodo == 'deposito') {
            // Pagamento MercadoPago via deposito
            $with = [
                "pedido_id" => $this->pedidoId,
                "pedido_pay_meio" => "Depósito",
                "pedido_info" => "deposito",
                "pedido_pay_gw" => 4,
                "pedido_total_parcelado" => floatval($this->totalCompra),
                "pedido_obs" => "Pagamento via depósito."
            ];
            (new Factory('pedido'))->with($with)->save();
            PedidoStatus::notificar_cliente_pedido_realizado($pedido->pedido_id, $pedido->pedido_cliente);
            PedidoStatus::notificar_admin($pedido->pedido_id, $pedido->pedido_cliente);
            self::useCupom();
            (new Carrinho)->clearCarrinho();
            echo json_encode(['pedido_id' => $this->pedidoId]);
        } else if ($this->metodo == 'pix') {
            //pagamento via Pix MercadoPago
            $payment = faturaMPPix($this->gateway, $this->pedidoId, $this->totalCompra);
            if (is_object($payment) && isset($payment->result)) {
                if ($payment->result == 0) {
                    $with = [
                        "pedido_id" => $this->pedidoId,
                        "pedido_status" => 7,
                        "pedido_pay_meio" => "MercadoPago - Pix",
                        "pedido_info" => "pix",
                        "pedido_total_parcelado" => floatval($this->totalCompra),
                        "pedido_obs" => "Não foi possível gerar o Pix."
                    ];
                    (new Factory('pedido'))->with($with)->save();
                    PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
                } else if ($payment->result == 1) {
                    $with = [
                        "pedido_id" => $this->pedidoId,
                        "pedido_pay_code" => $payment->id,
                        "pedido_pay_meio" => "MercadoPago - Pix",
                        "pedido_total_parcelado" => floatval($this->totalCompra),
                        "pedido_info" => "pix",
                        "pedido_pay_url" => $payment->url,
                        "pedido_pay_gw" => 1,
                        "pedido_pix_qr" => $payment->qr,
                        "pedido_pix_qr_img" => $payment->img, // tag img do QR Code
                    ];
                    (new Factory('pedido'))->with($with)->save();
                }
            } else {
                $with = [
                    "pedido_id" => $this->pedidoId,
                    "pedido_status" => 7,
                    "pedido_pay_meio" => "MercadoPago - Pix",
                    "pedido_info" => "pix",
                    "pedido_total_parcelado" => floatval($this->totalCompra),
                    "pedido_obs" => "Erro ao gerar o Pix."
                ];
                (new Factory('pedido'))->with($with)->save();
                PedidoStatus::notificar_cliente_pedido_cancelado($pedido->pedido_id, $pedido->pedido_cliente);
            }
            PedidoStatus::notificar_cliente_pedido_realizado($pedido->pedido_id, $pedido->pedido_cliente);
            PedidoStatus::notificar_admin($pedido->pedido_id, $pedido->pedido_cliente);
            self::useCupom();
            (new Carrinho)->clearCarrinho();
            echo json_encode(['pedido_id' => $this->pedidoId]);
        }
    }

    public function paymentPagarMe()
    {
    }

    static public function useCupom()
    {
        if (isset($_SESSION['cupom']['cupom_id'])) {
            (new Factory('cupom'))->query("UPDATE cupom SET cupom_lote = (cupom_lote + 1) WHERE cupom_id = " . $_SESSION['cupom']['cupom_id']);
            unset($_SESSION['cupom']);
        }
    }

    static public function clearPaySess()
    {
        //unset($_SESSION['frete']);
        //unset($_SESSION['retirada']);        
    }
}
