<?php

class FaqAdmin
{

    public function __construct()
    {
        Sessao::check();
        (new Install)->check_tabelas_principais();
    }

    public function indexAction()
    {
        $data = [
            'config' => (new Config)->get(),
            
            'mapper' => ['config','modulos']
        ];
        Tpl::view('admin.faq.index', $data, 1);
    }

    public function categoria()
    {
        $data = [
            'config' => (new Config)->get(),
            
            'mapper' => ['config','modulos']
        ];
        Tpl::view('admin.faq.categoria', $data, 1);
    }

    public function lista()
    {
        (new Factory('faq'))
            ->select("faq_id, faq_titulo, faq_categoria, categoria_faq_nome")
            ->join('categoria_faq', 'categoria_faq_id = faq_categoria', 'LEFT')
            ->order('faq_id DESC')
            ->get(1);
    }

    public function lista_categoria()
    {
        (new Factory('categoria_faq'))
            ->select("categoria_faq_id, categoria_faq_nome")
            ->order('categoria_faq_pos ASC')
            ->get(1);
    }

    public function gravar_categoria()
    {
        if(isset($_POST['categoria_faq_nome']) && !empty($_POST['categoria_faq_nome'])) {
            $_POST = Filter::parse_full($_POST);
            Sessao::perms('G');
            $_POST['categoria_faq_url'] = Filter::slug($_POST['categoria_faq_nome']);
            Req::drop_blank();
            $format = ['categoria_faq_nome' => 'text', 'categoria_faq_url' => 'text'];
            (new Factory('categoria_faq'))->with($_POST)->format($format)->save();
            
            if (Req::get('return')) {
                Http::redirect_to("/" . Req::get('return'));
            } else {
                Http::redirect_to("/faq-categoria/?success");
            }
        }
        
    }

    public function gravar()
    {
        if(isset($_POST['faq_titulo']) && !empty($_POST['faq_titulo'])) {
            Sessao::perms('G');
            Req::drop('_wysihtml5_mode');
            Req::drop_blank();
            $_POST = Filter::parse_full($_POST);
            if (isset($_POST['faq_titulo'])) {
                $_POST['faq_url'] = Filter::slug($_POST['faq_titulo']);
            }
            $faq = (new Factory('faq'))->with($_POST)->save();
            if ($faq > 0) {
                Http::redirect_to('/faq-lista/?success');
            } else {
                Http::redirect_to('/faq-lista/?error');
            }
        }
      
    }

    public function editar()
    {
        $id = Http::get_in_params('id', 'int');
        if (isset($id->value) && $id->value > 0) {
            $id = $id->value;
            $escope = [
                'faq_texto' => 'text',
            ];
            $faq = (new Factory('faq'))
                ->format($escope)->find($id);
            if (!empty($faq)) {
                $data = [
                    'faq' => $faq,
                    'config' => (new Config)->get(),
                    
                    'mapper' => ['config', 'faq','modulos']
                ];
                Tpl::view('admin.faq.form', $data, 1);
            } else {
                Http::redirect_to('/faq-lista/');
            }
        } else {
            Http::redirect_to('/faq-lista/');
        }
    }

    public function novo()
    {
        $faq = (new Factory('faq'))->map();
        $data = [
            'faq' => $faq,
            'config' => (new Config)->get(),
            
            'mapper' => ['config', 'faq','modulos']
        ];
        Tpl::view('admin.faq.form', $data);
    }

    public function remover()
    {
        Sessao::perms('G');
        $id = Req::post('id', 'int');
        if ($id > 0) {
            (new Factory('faq'))->drop($id);
            echo 1;
        } else {
            echo -1;
        }
    }

    public function remover_categoria()
    {
        Sessao::perms('G');
        $id = Req::post('id', 'int');
        if ($id > 0) {
            (new Factory('categoria_faq'))->drop($id);
            echo 1;
        } else {
            echo -1;
        }
    }


    public function ordenar(){
        $faqs = json_decode(Req::post('diff'));
        $db_faq = (new Factory('categoria_faq'));
         foreach ($faqs as $faq){
             $id = explode('-', $faq->node->_prevClass);
             if(intval($id[2]) > 0 && isset($id[2])){
                 $data = [
                     'id' => $id[2],
                     'pos' => $faq->newPosition,
                 ];
                 
                 $db_faq->with($data)->save();
             }
         }
     }

}