<?php

class Faq
{
    public function __construct()
    {
        (new Install())->check();
        (new Install)->check_tabelas_principais();
    }

    public function indexAction()
    {
        $config = (new Config)->get();

        $faq = (new Factory('faq'))
            ->select('faq_id, faq_url, faq_titulo, faq_texto')
            ->get();

        if(!isset($faq[0])) {
            Http::redirect_to('/');
        }

        $data = [
            // Menu Superior
            'categorias' => (new CategoriasProdutosFront())->listar(),
            'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
            'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
            'paginasTopo' => (new Pagina())->listarPaginasTopo(),
            // Footer
            'paginasFooter' => (new Pagina())->listarPaginasFooter(),
            'faq' => (new Faq())->listaFooter(),
            'fullFaq' => $faq,
            // Principal
            'config' => $config,
            'social' => (new Config)->getRedesSociais(),
            'mapper' => ['config', 'social', 'params_embed_google'],
        ];


        Tpl::view("tema.loja.faq.index", $data, 1);
    }

    public function listaCategoriasAndFaqs()
    {
        $cat = (new Factory('categoria_faq'))
            ->select('categoria_faq_id, categoria_faq_nome, categoria_faq_url, categoria_faq_pos')
            ->where('categoria_faq_id IN (SELECT pagina_categoria FROM pagina WHERE pagina_status = 1)')
            ->get();
        if (isset($cat[0])) {
            foreach ($cat as $k => $v) {
                $pag = (new Factory('faq'))
                    ->select('faq_id, faq_url, faq_titulo')
                    ->where('faq_categoria = ' . $cat[$k]->categoria_faq_id)
                    ->get();

                if (isset($pag[0]))
                    $cat[$k]->paginas = $pag;
                else
                    unset($cat[$k]);
            }
        }
        return $cat;
    }

    public function listaFooter()
    {
        return (new Factory('faq'))
            ->select('faq_id, faq_url, faq_titulo, faq_texto')
            ->limit(3)
            ->get();
    }

    public function ver()
    {

        $cat = Http::get_param(1, 'string');
        $nome = Http::get_param(2, 'string');

        if (!empty($cat) && !empty($nome)) {
            $pagina = (new Factory('pagina'))->select('pagina_id, pagina_titulo,pagina_desc,pagina_keywords, pagina_texto, pagina_capa, categoria_faq_nome, categoria_pagina_url')
                ->join('categoria_pagina', 'categoria_pagina_id = pagina_categoria')
                ->where("pagina_url = '$nome' AND categoria_pagina_url = '$cat' ")
                ->limit(1)
                ->get();
            $pagina = !empty($pagina[0]) ? $pagina[0] : '';
            $data = [
                'categorias' => (new CategoriasProdutosFront())->listar(),
                'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
                'paginasTopo' => (new Pagina())->listarPaginasTopo(),
                // Footer
                'paginasFooter' => (new Pagina())->listarPaginasFooter(),
                'faq' => (new Faq())->listaFooter(),
                // Principal
                'config' => (new Config)->get(),
                'social' => (new Config)->getRedesSociais(),
                'pagina' => $pagina,
                'mapper' => ['config', 'pagina']
            ];
            Tpl::view("tema.loja.pagina.index", $data, 1);
        } else {
            Http::redirect_to('/');
        }
    }
}
