<?php

class Cupom
{

    public function __construct()
    {
        Sessao::check();
        (new Install)->check_tabelas_principais();
    }

    public function indexAction()
    {
        $data = [
            'config' => (new Config)->get(),
            
            'mapper' => ['config']
        ];
        Tpl::view('admin.cupom.index', $data, 1);
    }


    public function novo()
    {
        $data = [
            'config' => (new Config)->get(),
            
            'cupom' => (new Factory('cupom'))->map(),
            'mapper' => ['config', 'cupom']
        ];
        Tpl::view('admin.cupom.form', $data, 1);
    }

    public function editar()
    {
        $id = Http::get_in_params('id', 'int');
        if (isset($id->value) && $id->value > 0) {
            $id = $id->value;
            $cupom = (new Factory('cupom'))->find($id);
            if ($cupom) {
                $data = [
                    'config' => (new Config)->get(),
                    
                    'cupom' => $cupom,
                    'mapper' => ['config', 'cupom']
                ];
                Tpl::view('admin.cupom.form', $data, 1);
            } else {
                Http::redirect_to('/cupom/?error');
            }
        } else {
            Http::redirect_to('/cupom/?error');
        }
    }

    public function listar()
    {
        (new Factory('cupom'))
            ->select('*, IF(NOW() > cupom_validade,"bg-usado","bg-nope") as cupom_valido,IF(NOW() > cupom_validade," (expirado)","") as cupom_estatus, DATE_FORMAT(cupom_validade, "%d/%m/%Y") AS cupom_validadef' )
            ->get(1);
    }

    public function gravar()
    {
        if (isset($_POST['cupom_alfa']) && !empty($_POST['cupom_alfa'])) {
            $_POST = Filter::parse_full($_POST);

            if (isset($_POST['cupom_real']) && !empty($_POST['cupom_real'])) {
                $_POST['cupom_desconto'] = '0';
            }

            if (isset($_POST['cupom_desconto']) && !empty($_POST['cupom_desconto']) && $_POST['cupom_desconto'] >= 0) {

                $_POST['cupom_real'] = '';
                if ($_POST['cupom_desconto'] > 100)
                    $_POST['cupom_desconto'] = 100;
            }


            (new Factory('cupom'))->with($_POST)->save();
            Http::redirect_to('/cupom/?success');
        }
    }

    public function remover()
    {
        $id = Req::post('id', 'int');
        if ($id > 0) {
            (new Factory('cupom'))->drop($id);
            echo '1';
        } else {
            echo '0';
        }
    }
}
