<?php

class Configuracao
{

	public function __construct()
	{
		(new Install)->check_tabelas_principais();
		Sessao::check();
		Sessao::perms('G');
		if (ucfirst(Session::node('ulevel')) != '1') {
			Http::redirect_to('/admin/?error');
		}
	}

	public function indexAction()
	{
		$data = [
			'config' => (new Config)->get(),
			'mapper' => ['config'],
		];
		Tpl::view('admin.config.config', $data, 1);
	}

	public function loja()
	{
		$data = [
			'config' => (new Config)->get(),
			'mapper' => ['config'],
		];
		Tpl::view('admin.config.site', $data, 1);
	}

	public function logo()
	{
		$data = [
			'config' => (new Config)->get(),
			'mapper' => ['config'],
		];
		Tpl::view('admin.config.logo', $data, 1);
	}

	public function email()
	{
		$data = [
			'config' => (new Config)->get(),
			'smtp' => (new Config)->getSmtp(),
			'mapper' => ['config', 'smtp'],
		];
		Tpl::view('admin.config.email', $data, 1);
	}

	public function contato()
	{
		$data = [
			'config' => (new Config)->get(),
			'contato' => (new Config)->getContato(),
			'mapper' => ['config', 'contato'],
		];
		Tpl::view('admin.config.contato', $data, 1);
	}

	public function rede()
	{
		$data = [
			'config' => (new Config)->get(),
			'rede' => (new Config)->getRedesSociais(),
			'mapper' => ['config', 'rede'],
		];
		Tpl::view('admin.config.rede', $data, 1);
	}

	public function layout()
	{
		$cores = (new Factory('config_cores'))->get();
		$data = [
			'config' => (new Config)->get(),
			'cores' => $cores,
			'mapper' => ['config'],
		];
		Tpl::view('admin.config.layout', $data, 1);
	}


	public function card()
	{
		$card = (new Factory('config_card'))->get()[0];
		$prod = self::card_get_prod();
		$color = self::card_get_colors();
		$data = [
			'config' => (new Config)->get(),
			'card' => $card,
			'prod' => $prod,
			'card_colors' => ['card_colors' => $color],
			'mapper' => ['config', 'card', 'card_colors', 'prod'],
		];
		Tpl::view('admin.config.produto-card', $data);
	}

	public function card_reload()
	{
		$card = (new Factory('config_card'))->get()[0];
		$prod = self::card_get_prod();
		$color = self::card_get_colors();
		$data = [
			'config' => (new Config)->get(),
			'card' => $card,
			'prod' => $prod,
			'card_colors' => ['card_colors' => $color],
			'mapper' => ['config', 'card', 'card_colors', 'prod'],
		];
		echo Tpl::output('admin.config.produto-card-reload', $data);
	}

	public function gravar_card()
	{
		$_POST['config_card_id'] = 1;
		$_POST['config_card_border_size'] =
			implode('px ', $_POST['config_card_border_size']) . 'px';
		$with = $_POST;
		(new Factory('config_card'))->with($with)->save();
		Filter::pre(($_POST));
	}


	static  public function card_get_prod()
	{
		$prod = (new Factory('produto'))
			->select('
                produto_id, (SELECT COUNT(*) FROM relacao_atributo WHERE relacao_atributo_produto = produto_id) AS produto_qtd_atributos, produto_oferta, produto_url, produto_estoque, produto_titulo, produto_preco AS produto_preco_original, (produto_preco - produto_desconto) AS produto_preco, produto_desconto, 
				 produto_largura, produto_altura, produto_comprimento, produto_tamanho, produto_peso, produto_calcula_frete, produto_arquivo,
                IF(
                    (SELECT COUNT(*) FROM relacao_atributo WHERE relacao_atributo_produto = produto_id) > 0,
                    (SELECT MAX(relacao_item_qtd) FROM relacao_item WHERE relacao_item_produto = produto_id),
                    produto_estoque
                ) AS produto_estoque,
				foto1.foto_produto_img as produto_foto, foto2.foto_produto_img as produto_foto_hover,
				ifnull(nullif(foto2.foto_produto_img, ""), "") AS produto_foto_hover
            ')
			->join('foto_produto as foto1', 'foto1.foto_produto_produto = produto_id AND foto1.foto_produto_pos = 1', 'LEFT')
			->join('foto_produto as foto2', 'foto2.foto_produto_produto = produto_id AND (foto2.foto_produto_pos = 2 OR foto2.foto_produto_id > foto1.foto_produto_id )', 'LEFT')
			->where('produto_estoque >= 1 AND produto_status = 1 AND produto_destaque = 1')
			->order('produto_id DESC LIMIT 1')
			->get();

		if (isset($prod[0])) {
			$config_payment = (new Factory('pay'))->where('pay_name = "Config"')->get()[0];
			foreach ($prod as $k => $v) {
				$prod[$k]->produto_estoque = 1;
				$preco = $prod[$k]->produto_preco;
				$prod[$k]->produto_preco = Filter::moeda($prod[$k]->produto_preco);
				$prod[$k]->produto_preco_original = Filter::moeda($prod[$k]->produto_preco_original);
				$prod[$k]->produto_preco_desc_boleto = intval($config_payment->pay_fator_juros) > 0 ? Filter::moeda($preco - (($preco / 100) * ($config_payment->pay_fator_juros))) : '0,00';
				$prod[$k]->desc_boleto = intval($config_payment->pay_fator_juros);
				$prod[$k]->qtd_parcelas = intval($config_payment->pay_c6);
				$prod[$k]->produto_preco_parc = Filter::moeda($preco / $prod[$k]->qtd_parcelas);
				if ($prod[$k]->produto_foto == "") {
					$prod[$k]->produto_foto = 'nopic.png';
				}
			}
			return $prod;
		}
	}


	static  public function card_get_colors()
	{
		$card = (new Factory('config_card'))->find(1);
		$style = "
            .product-card {
				position: relative;
				padding: {$card->config_card_padding}px !important;
				background-color: {$card->config_card_bg_color} !important;
				border-width: {$card->config_card_border_size} !important;  
				border-color: {$card->config_card_border_color} !important;
				border-style: solid;
				color: {$card->config_card_text_pri_color} !important;
				font-size: {$card->config_card_text_pri_size}px !important;
				/*text-align: {$card->config_card_text_pri_align} !important;*/
            }
            .product-card:hover {
                border-width: {$card->config_card_border_size} !important;  
                border-color: {$card->config_card_border_color_hover} !important;  
                border-style: solid;
                -webkit-transition: all 0.4s ease-in-out;
                -moz-transition: all 0.4s ease-in-out;
                -o-transition: all 0.4s ease-in-out;
                -ms-transition: all 0.4s ease-in-out;
                transition: all 0.4s ease-in-out;
                box-shadow:0 0 0 0px {$card->config_card_border_color_hover} inset;  
            }
            .product-card{
				color: {$card->config_card_text_pri_color} !important;
				/*font-size: {$card->config_card_text_pri_size}px !important;*/
				/*text-align: {$card->config_card_text_pri_align} !important;*/
				line-height: normal !important;
            }
            .product-title {
				color: {$card->config_card_text_pri_color} !important;
				font-size: {$card->config_card_text_pri_size}px !important;
				text-align: {$card->config_card_text_pri_align} !important;
				font-weight: {$card->config_card_text_pri_bold} !important;
				line-height: normal !important;
				display: block;
            }
            .product-title-indisponivel{
				color: {$card->config_card_text_sec_color} !important;
				font-size: {$card->config_card_text_pri_size} !important;
				text-align: {$card->config_card_text_pri_align} !important;
				line-height: normal !important;    
            }
			.product-card .product-thumb {
					background-color: white;
			}
            .product-card .product-thumbs {
         	   height: {$card->config_card_img_elm_height}px !important;
			   
            }
            .product-card .product-thumb img {
				width: {$card->config_card_img_width} !important;    
				height: {$card->config_card_img_height}px !important;
				object-fit: cover ;
				max-width: 100%;
				-moz-transition: all 0.3s;
				-webkit-transition: all 0.3s;
				transition: all 0.3s;  
				background-color: white;
            }
			.product-card .product-thumb .foto-hover{
				visibility: hidden;
				opacity: 0;
				position:absolute;
				top:0;
				left:0;
				background-color: white;
				width: 100%;
            }
            .product-card .product-thumb:hover .foto-hover{
				visibility: visible;
				opacity: 1;
            }
            .product-card .product-card-body {
				height: {$card->config_card_desc_elm_height}px !important;
				padding: {$card->config_card_body_padding}px !important;
            }
            .product-card .product-card-text-price {
				font-size: {$card->config_card_text_price_size}px !important;
				color: {$card->config_card_text_price_color} !important;
				text-align: {$card->config_card_text_price_align} !important;
				font-weight: {$card->config_card_text_price_bold} !important;
				display: block;
            }

            .product-card .product-card-disc {
				color: {$card->config_card_text_desconto_color} !important;
				font-size: {$card->config_card_text_desconto_size}px !important;
				text-align: {$card->config_card_text_desconto_align} !important;
				font-weight: {$card->config_card_text_desconto_bold} !important;
				display: block;
            }
            .product-card .product-card-percent {
				color: {$card->config_card_text_percent_color} !important;
				font-size: {$card->config_card_text_percent_size}px !important;
				text-align: {$card->config_card_text_percent_align} !important;
				font-weight: {$card->config_card_text_percent_bold} !important;
				display: block;
            }
            .product-card .product-card-parc {
				font-size: {$card->config_card_text_parc_size}px !important;
				color: {$card->config_card_text_parc_color} !important;
				text-align: {$card->config_card_text_parc_align} !important;
				font-weight: {$card->config_card_text_parc_bold} !important;				
				display: block;
            }
            .product-card button {
				color: {$card->config_card_btn_text_color} !important;
				background-color: {$card->config_card_btn_bg_color} !important;
            }
            .product-card button:hover {
				color: {$card->config_card_btn_text_color_hover} !important;
				background-color: {$card->config_card_btn_bg_color_hover} !important;
            }                                        
            .product-card .btn-primary, .product-card .bg-primary {
                background-color: {$card->config_card_btn_bg_color} !important;
                border: 1px solid {$card->config_card_btn_text_color} !important;
                color: {$card->config_card_btn_text_color} !important;
            }
            .product-card .btn-primary:hover {
                color: {$card->config_card_btn_text_color_hover} !important;
                border: 1px solid {$card->config_card_btn_text_color_hover} !important;
                background-color: {$card->config_card_btn_bg_color_hover} !important;
            }
            .product-card-text-line{
                display: block;
                text-decoration: line-through; 
                color: {$card->config_card_text_line_color} !important;
                font-size: {$card->config_card_text_line_size}px !important;
                font-weight: {$card->config_card_text_line_bold} !important;
                text-align: $card->config_card_text_line_align !important;
            }
            .product-card-btns{
                position: relative;
                padding-bottom: 5px;
                text-align: right;
            }
            .product-card .product-card-btns a{
            /*padding:6px 12px;*/
            visibility: hidden;
            opacity: 0;
            right:0;
            text-align: center;
            }
            .product-card:hover .product-card-btns a{
            visibility: visible;
            opacity: 1;
            }
            .tooltip-inner {
                max-width: 200px;
                padding: 3px 8px;
                color:  {$card->config_card_tooltip_text_color} !important;
                text-align: center;
                text-decoration: none;
                background-color: {$card->config_card_tooltip_bg_color}  !important;
                -webkit-border-radius: 4px;
                -moz-border-radius: 4px;
                border-radius: 4px;
            }
            .tooltip .arrow {
                border-top-color: {$card->config_card_tooltip_bg_color}  !important;
                position: absolute;
                display: block;
                width: 0.8rem;
                height: 0.4rem;
            }
            .bs-tooltip-auto[x-placement^=bottom] .arrow::before, .bs-tooltip-bottom .arrow::before {
                border-bottom-color: {$card->config_card_tooltip_bg_color}  !important;
            }
            .bs-tooltip-auto[x-placement^=top] .arrow::before, .bs-tooltip-top .arrow::before {
                border-top-color: {$card->config_card_tooltip_bg_color}  !important;
            }
            .bs-tooltip-auto[x-placement^=left] .arrow::before, .bs-tooltip-left .arrow::before {
                border-left-color: {$card->config_card_tooltip_bg_color}  !important;
            }
            .bs-tooltip-auto[x-placement^=right] .arrow::before, .bs-tooltip-right .arrow::before {
                border-right-color: {$card->config_card_tooltip_bg_color}  !important;
            }
            .tooltip .arrow::before {
                position: absolute;
                content: '';
                border-color: transparent;
                border-style: solid;
            }
            .shadow-custom {                
                -webkit-box-shadow: 0px 3px 0px 0px {$card->config_card_shadow_bg_color};
                -moz-box-shadow: 0px 3px 0px 0px {$card->config_card_shadow_bg_color};
                box-shadow: 0px 3px 0px 0px {$card->config_card_shadow_bg_color};
                margin-bottom: 0.36rem !important;
            }
        ";
		return preg_replace('/\s+/', ' ', $style);
	}


	public function gravar()
	{
		if (isset($_POST['config_id']) && !empty($_POST['config_id']) && intval($_POST['config_id']) > 0) {
			$return = Http::get_in_params('return');
			$_POST = Filter::parse_full($_POST);

			if (isset($_FILES['icon_whats']) && !empty($_FILES['icon_whats']) && intval($_FILES['icon_whats']['error']) == 0) {
				$this->upload_icon_whats($_FILES['icon_whats']);
			}

			if (isset($return->value)) {
				$return = $return->value;
				(new Factory('config'))->with($_POST)->save();
				Http::redirect_to("/configuracao/$return/?success");
			}
		}
	}

	public function upload_icon_whats($file)
	{
		if (isset($file) && !empty($file)) {
			$media = Media::img_upload($file, 'site');
			if (isset($media->url)) {
				$_POST['config_site_icon_whats'] = $media->url;
			}
		}
	}

	public function gravarSmtp()
	{
		if (isset($_POST['smtp_id']) && !empty($_POST['smtp_id'])) {
			$_POST = Filter::parse_full($_POST);
			$return = Http::get_in_params('return');
			if (isset($return->value)) {
				$return = $return->value;
				if (Req::is_empty('smtp_pass')) {
					Req::drop('smtp_pass');
				}
				(new Factory('smtp'))->with($_POST)->save();
				$status = (Sender::__runtest()) ? 'email-enviado' : 'email-nao-enviado';
				Http::redirect_to("/configuracao/$return/?$status");
			}
		}
	}

	public function altera_cor()
	{
		if (isset($_POST['config_tema_color'])) {
			$_POST = Filter::parse_full($_POST);

			$data = [
				'id' => 1,
				'config_tema_color' => $_POST['config_tema_color'],
			];
			(new Factory('config'))->with($data)->save();
			echo true;
		}
	}

	public function gravarContato()
	{
		if (isset($_POST['contato_id']) && !empty($_POST['contato_id'])) {
			//$_POST = Filter::parse_full($_POST);
			$return = Http::get_in_params('return');
			if (isset($return->value)) {
				$return = $return->value;
				(new Factory('contato'))->with($_POST)->save();
				Http::redirect_to("/configuracao/$return/?success");
			}
		}
	}

	public function gravarRede()
	{
		if (isset($_POST['redesSociais_id']) && !empty($_POST['redesSociais_id'])) {
			//$_POST = Filter::parse_full($_POST);
			$return = Http::get_in_params('return');
			if (isset($return->value)) {
				$return = $return->value;
				(new Factory('redesSociais'))->with($_POST)->save();
				Http::redirect_to("/configuracao/$return/?success");
			}
		}
	}

	public function logo_upload()
	{
		if (!empty($_FILES['logo']['name'])) {
			$file = $_FILES['logo'];
			$img = Media::upload($file, 'site', 'img');

			if (is_object($img)) {
				/*REMOVE ATUAL LOGO */
				$current = (new Factory('config'))->find(1);
				$current_logo = Path::base() . "/media/site/$current->config_site_logo";
				if (file_exists($current_logo)) {
					@unlink($current_logo);
				}
				/*END REMOVE ATUAL LOGO */
				/*ATUALIZA LOGO*/
				$logo = ['site_logo' => $img->url, 'id' => 1];
				(new Factory('config'))->with($logo)->save();
			}
		};
		Http::redirect_to("/configuracao/logo/?success");
	}

	public function favicon_upload()
	{
		if (!empty($_FILES['favicon']['name'])) {
			$file = $_FILES['favicon'];
			$img = Media::upload($file, 'site', 'img');

			if (is_object($img)) {
				/*REMOVE ATUAL LOGO */
				$current = (new Factory('config'))->find(1);
				$current_logo = Path::base() . "/media/site/$current->config_site_favicon";
				if (file_exists($current_logo)) {
					@unlink($current_logo);
				}
				/*END REMOVE ATUAL LOGO */
				/*ATUALIZA LOGO*/
				$logo = ['site_favicon' => $img->url, 'id' => 1];
				(new Factory('config'))->with($logo)->save();
			}
		};

		if (!empty($_FILES['favicon']['name'])) {
			$file = $_FILES['favicon'];
			$img = Media::upload($file, 'site', 'img');
		};

		Http::redirect_to("/configuracao/logo/?success");
	}


	public function login_upload()
	{
		if (!empty($_FILES['login'])) {
			$file = $_FILES['login'];
			$img = Media::upload($file, 'site', 'img');
			if (is_object($img)) {
				/*REMOVE ATUAL LOGO */
				$current = (new Factory('config'))->find(1);
				$current_login = Path::base() . "/media/site/$current->config_site_loginscreen";
				if (file_exists($current_login)) {
					@unlink($current_login);
				}
				/*END REMOVE ATUAL LOGO */
				/*ATUALIZA LOGO*/
				$screen = ['site_loginscreen' => $img->url, 'id' => 1];
				(new Factory('config'))->with($screen)->save();
			}
		}
		Http::redirect_to("/configuracao/logo/?success");
	}

	public function gravar_modo()
	{
		$config_id = Req::post('config_id', 'int');
		$config_site_modo = Req::post('config_site_modo', 'int');

		if ($config_id > 0 && $config_site_modo > 0) {
			$with = [
				'id' => $config_id,
				'site_modo' => $config_site_modo,
			];
			(new Factory('config'))->with($with)->save();
			Http::redirect_to('/configuracao/?success');
		} else {
			Http::redirect_to('/configuracao/?error');
		}
	}

	public function gravar_layout()
	{
		$config_id = Req::post('config_id', 'int');
		$config_site_layout = Req::post('config_site_layout', 'int');
		$config_site_layout_altura_logo = Req::post('config_site_layout_altura_logo', 'int');
		$config_site_layout_largura_logo = Req::post('config_site_layout_largura_logo', 'int');

		if ($config_id > 0 && $config_site_layout > 0) {
			$with = [
				'id' => $config_id,
				'site_layout' => $config_site_layout,
				'site_layout_altura_logo' => $config_site_layout_altura_logo,
				'site_layout_largura_logo' => $config_site_layout_largura_logo,
			];
			(new Factory('config'))->with($with)->save();
			Http::redirect_to('/configuracao/layout/?success');
		} else {
			Http::redirect_to('/configuracao/layout/?error');
		}
	}


	public function gravar_cores()
	{
		foreach ($_POST['config_cores_id'] as $k => $v) {
			$id = $_POST['config_cores_id'][$k];
			$local = $_POST['config_cores_local'][$k];
			$fundo = $_POST['config_cores_fundo'][$k];
			$texto = $_POST['config_cores_texto'][$k];
			$hover_fundo = $_POST['config_cores_hover_fundo'][$k];
			$hover_texto = $_POST['config_cores_hover_texto'][$k];

			$with = [
				'id' => $id,
				'local' => $local,
				'fundo' => $fundo,
				'texto' => $texto,
				'hover_fundo' => $hover_fundo,
				'hover_texto' => $hover_texto,
			];
			(new Factory('config_cores'))->with($with)->save();
		}
		Http::redirect_to("/configuracao/layout/?success");
	}

	public function slide_config()
	{
		$slide_altura_imagens = Req::post('slide_altura_imagens');
		$slide_preenchimento_imagens = Req::post('slide_preenchimento_imagens');
		$multiplo_altura_imagens = Req::post('multiplo_altura_imagens');
		$multiplo_preenchimento_imagens = Req::post('multiplo_preenchimento_imagens');

		$config_id = 1;
		$config_slide_comum_config = $slide_altura_imagens;
		if (!empty($slide_preenchimento_imagens)) {
			$config_slide_comum_config .= $slide_preenchimento_imagens;
		}

		$config_slide_multiplo_config = $multiplo_altura_imagens;
		if (!empty($multiplo_preenchimento_imagens)) {
			$config_slide_multiplo_config .= $multiplo_preenchimento_imagens;
		}

		$with = [
			'id' => $config_id,
			'slide_comum_config' => $config_slide_comum_config,
			'slide_multiplo_config' => $config_slide_multiplo_config,
		];
		(new Factory('config'))->with($with)->save();
		Http::redirect_to('/slide/?success');
	}

	public function gravar_rodape()
	{
		$dados = Filter::parse_full($_POST);
		$dados['config_id'] = 1;
		(new Factory('config'))->with($dados)->save();
		Http::redirect_to('/configuracao/layout/?success');
	}
}
