<?php

class ClienteFront
{
    public function __construct()
    {
        @session_start();
        (new Install)->check();
        (new Install)->check_tabelas_principais();
    }

    public function login()
    {

        $email = Req::post('email', 'string');
        $senha = Req::post('senha', 'string');

        if (isset($email) && !empty($email) && isset($senha) && !empty($senha)) {
            $senha = Parser::crypt($senha);

            $cliente = (new Factory('cliente'))->select("cliente_id, cliente_nome, cliente_email")->where("cliente_email = '$email' && cliente_password = '$senha'")->get();

            if (isset($cliente[0]) && !empty($cliente[0])) {
                $cliente = $cliente[0];

                Session::init();
                Session::client_node('uid', $cliente->cliente_id);
                Session::client_node('unome', $cliente->cliente_nome);
                Session::client_node('umail', $cliente->cliente_email);
                if (isset($_SESSION['ultimo_produto_visto']) && !empty($_SESSION['ultimo_produto_visto'])) {
                    $url = '/produto/' . $_SESSION['ultimo_produto_visto']['produto_url'];
                    unset($_SESSION['ultimo_produto_visto']);
                    Http::redirect_to($url);
                } else if (isset($_SESSION['produto_detalhes_logar']) && !empty($_SESSION['produto_detalhes_logar'])) {
                    $url = '/pedido-detalhes/' . $_SESSION['produto_detalhes_logar'];
                    unset($_SESSION['produto_detalhes_logar']);
                    Http::redirect_to($url);
                } else {
                    Http::redirect_to('/area-cliente');
                }
            } else {
                Http::redirect_to('/login-cliente/?inexistente');
            }
        }
    }
    public function auth_orcamento()
    {
        $cliente = null;
        $cliente_nome = Req::post('cliente_nome', 'string');
        $cliente_email = Req::post('cliente_email', 'string');;
        $cliente_celular = Req::post('cliente_celular', 'string');

        if (empty($_POST)) {
            Http::redirect_to(Http::base());
        }
        if (!$cliente_nome || !$cliente_email || !$cliente_celular) {
            Http::redirect_to('/');
        }

        $cliente = (new Factory('cliente'))
            ->where("cliente_email = '$cliente_email' OR cliente_celular = '$cliente_celular' OR cliente_telefone = '$cliente_celular' LIMIT 1")
            ->get();

        $cliente = (isset($cliente[0])) ? $cliente[0] : null;

        if (!$cliente) {
            $cliente = (new Factory('cliente'))->with([
                'cliente_nome' => $cliente_nome,
                'cliente_email' => $cliente_email,
                'cliente_celular' => $cliente_celular,
            ])->save();
            $cliente = (new Factory('cliente'))->find($cliente);
        }

        if ($cliente) {
            $_SESSION['__CLIENTE_ORCAMENTO__'] = (object)[
                'cliente_id' => $cliente->cliente_id,
                'cliente_nome' => $cliente->cliente_nome,
                'cliente_email' => $cliente->cliente_email,
                'cliente_celular' => $cliente->cliente_celular,
            ];
            Http::redirect_to('/Checkout/');
        } else {
            Http::redirect_to('/login-cliente/?error');
        }
    }
    public static function logout()
    {
        if (isset($_SESSION['clientNode'])) {
            unset($_SESSION['clientNode']);
        }
        Http::redirect_to('/login-cliente');
    }

    static function sessionValidator()
    {
        if ((!isset($_SESSION['clientNode']) && empty($_SESSION['clientNode'])) || !Session::check()) {
            self::logout();
        }
    }

    public function viewLogin()
    {
        $produto_id = Http::get_in_params('produto');
        if (isset($produto_id->value) && $produto_id->value > 0) {
            Favorito::set_produto_sessao($produto_id->value);
        }
        //Filter::pre($_SESSION);exit;
        $data = [
            // Menu Superior
            'categorias' => (new CategoriasProdutosFront())->listar(),
            'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
            'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
            'paginasTopo' => (new Pagina())->listarPaginasTopo(),
            // Footer
            'paginasFooter' => (new Pagina())->listarPaginasFooter(),
            'faq' => (new Faq())->listaFooter(),
            // Principal
            'config' => (new Config)->get(),
            'social' => (new Config)->getRedesSociais(),
            'mapper' => ['config', 'social'],
        ];
        if ($data['config']->config_site_modo == 2) {
            Tpl::view("tema.loja.cliente.login-orcamento", $data, 1);
        } else {
            Tpl::view("tema.loja.cliente.login", $data, 1);
        }
    }

    public function indexAction()
    {
        self::sessionValidator();
        // Validação para saber se o cliente fez o login através do checkout
        if (isset($_SESSION['cliente_checkout_redirect']) && !empty($_SESSION['cliente_checkout_redirect'])) {
            unset($_SESSION['cliente_checkout_redirect']);
            Http::redirect_to('/checkout');
        }

        $data = [
            // Menu Superior
            'categorias' => (new CategoriasProdutosFront())->listar(),
            'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
            'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
            'paginasTopo' => (new Pagina())->listarPaginasTopo(),
            // Footer
            'paginasFooter' => (new Pagina())->listarPaginasFooter(),
            'faq' => (new Faq())->listaFooter(),
            // Principal
            'config' => (new Config)->get(),
            'social' => (new Config)->getRedesSociais(),
            'mapper' => ['config', 'social'],
        ];


        Tpl::view("tema.loja.cliente.area", $data, 1);
    }

    public function getCliente()
    {
        $id = intval(Session::client_node('uid'));
        if (isset($id) && !empty($id) && $id > 0) {
            echo (new Factory('cliente'))
                ->select('*, DATE_FORMAT(cliente_nascimento,"%Y-%m-%d") as cliente_nascimento')
                ->find($id, 1);
        } else {
            $this->logout();
        }
    }

    public function gravar()
    {
        if (isset($_POST['cliente_nome']) && !empty($_POST['cliente_nome'])) {
            Req::drop_blank();
            $base = http::base();
            $conf = (new Config)->get();
            $base = Http::base();
            $conf->url =  $base;
            $_POST = Filter::parse_full($_POST);

            if (Req::post('cliente_password') != "") {
                Req::crypt('cliente_password');
            }

            $cliente_id = Req::post('cliente_id', 'int');
            if ($cliente_id  <= 0) {
                $verify = (new Factory('cliente'))->select('cliente_id')->where('cliente_email = "' . $_POST['cliente_email'] . '"')->get();
                if (isset($verify) && !empty($verify)) {
                    Http::redirect_to('/login-cliente/?existente');
                }
            }

            if (strlen(preg_replace('/\D/', '', Req::post('cliente_cpf'))) > 11) {
                Req::post('cliente_cnpj', null, Req::post('cliente_cpf'));
                Req::drop('cliente_cpf');
                Req::post('cliente_tipo', null, 2);
                Req::post('cliente_contato', null, Req::post('cliente_nome'));
                //Filter::pre($_POST);exit;
            }
            $save = (new Factory('cliente'))->with($_POST)->save();

            if (intval($save) > 0) {
                Session::init();
                Session::client_node('uid', $save);
                Session::client_node('unome', $_POST['cliente_nome']);
                Session::client_node('umail', $_POST['cliente_email']);

                Http::redirect_to('/area-cliente/?success');
            }
        }
    }

    public function remover()
    {
        Sessao::perms('G', 1);
        $id = Req::post('id', 'int');
        if ($id > 0) {
            (new Factory('cliente'))->drop($id);
            echo 1;
        } else {
            echo -1;
        }
    }

    public function checa_cpf()
    {
        $cpf = Req::post('cpf', 'string');

        if (isset($cpf) && !empty($cpf)) {
            $resp = (new Factory('cliente'))->select('cliente_cpf')
                ->where("cliente_cpf = '$cpf' ")->limit(1)->get();
            if ($resp) {
                echo -1;
                exit;
            } else {
                echo 1;
                exit;
            }
        } else {
            echo 0;
            exit;
        }
    }

    public function checa_cnpj()
    {
        $cnpj = Req::post('cnpj', 'string');
        if (isset($cnpj) && !empty($cnpj)) {
            $resp = (new Factory('cliente'))->select('cliente_cnpj')->find_by('cliente_cnpj', $cnpj);
            if ($resp) {
                echo -1;
                exit;
            } else {
                echo 1;
                exit;
            }
        } else {
            echo 0;
            exit;
        }
    }

    public function checa_email()
    {
        $email = Req::post('email', 'string');
        if (isset($email) && !empty($email)) {
            $resp = (new Factory('cliente'))->select('cliente_email')->find_by('cliente_email', $email);
            if ($resp) {
                echo -1;
                exit;
            } else {
                echo 1;
                exit;
            }
        } else {
            echo 0;
            exit;
        }
    }

    public function get_json()
    {
        (new Factory('cliente'))
            ->select('*, IFNULL(cliente_nome,cliente_razao) as cliente_nome')
            ->where('cliente_status = 1')
            ->order('cliente_nome ASC')->get(1, true);
    }

    public function altera_status()
    {
        Sessao::perms('G', 1);
        $id = Req::post('id', 'int');

        if ($id > 0) {
            $status = Req::post('status', null);
            $status == 1 ? $status = 0 : $status = 1;
            $data = [
                'id' => $id,
                'status' => $status,
            ];

            (new Factory('cliente'))->with($data)->save();
        } else {
            echo -1;
        }
    }


    // Endereços

    public function viewNovoEndereco()
    {
        $id = intval(Session::client_node('uid'));
        if ($id > 0) {
            $data = [
                'categorias' => (new CategoriasProdutosFront())->listar(),
                'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
                'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
                'paginasTopo' => (new Pagina())->listarPaginasTopo(),

                'cliente_id' => ['endereco_cliente_cliente' => $id],
                'endereco' => (new Factory('endereco_cliente'))->map(),
                'paginasFooter' => (new Pagina())->listarPaginasFooter(),
                'faq' => (new Faq())->listaFooter(),
                // Principal
                'config' => (new Config)->get(),
                'social' => (new Config)->getRedesSociais(),
                'mapper' => ['config', 'endereco']
            ];
            Tpl::view('tema.loja.cliente.endereco', $data, 1);
        } else {
            Http::redirect_to('/area-cliente/?error');
        }
    }

    public function viewEditarEndereco()
    {
        $id = Http::get_in_params('id', 'int');
        if (isset($id->value) && !empty($id->value) && intval($id->value) > 0) {
            $id = $id->value;
            $end = (new Factory('endereco_cliente'))->where('endereco_cliente_cliente = ' . Session::client_node('uid') . ' AND endereco_cliente_id = ' . $id)->get();
            if (isset($end[0])) {
                $end = $end[0];
                $data = [
                    'categorias' => (new CategoriasProdutosFront())->listar(),
                    'destaques' => (new CategoriasProdutosFront())->listaSubcategoriasDestaque(),
                    'slideSuperior' => (new SlideFront())->listarSlidePrincipal(),
                    'paginasTopo' => (new Pagina())->listarPaginasTopo(),
                    'endereco' => $end,
                    'cliente_id' => ['cliente_id' => $end->endereco_cliente_cliente],
                    'paginasFooter' => (new Pagina())->listarPaginasFooter(),
                    'faq' => (new Faq())->listaFooter(),
                    // Principal
                    'config' => (new Config)->get(),
                    'social' => (new Config)->getRedesSociais(),
                    'mapper' => ['config', 'social'],
                    'mapper' => ['config', 'endereco']
                ];
                Tpl::view('tema.loja.cliente.endereco', $data, 1);
            } else {
                Http::redirect_to('/area-cliente/?error');
            }
        } else {
            Http::redirect_to('/area-cliente/?error');
        }
    }
    public function listarEndereco()
    {
        $id = intval(Session::client_node('uid'));
        if (isset($id) && !empty($id) && $id > 0) {
            (new Factory('endereco_cliente'))
                ->where('endereco_cliente_cliente = ' . $id)
                ->get(1);
        }
    }

    public function listarEnderecoById()
    {
        $endereco_id = Req::post('endereco_id', 'int');
        if ($endereco_id > 0) {
            (new Factory('endereco_cliente'))
                ->where('endereco_cliente_id = ' . $endereco_id)
                ->get(1);
        }
    }

    public function gravarEndereco()
    {
        if (isset($_POST['endereco_cliente_titulo']) && !empty($_POST['endereco_cliente_titulo'])) {
            $_POST = Filter::parse_full($_POST);

            // VERIFICA SE EXISTE UM ENDEREÇO, CASO NÃO EXISTA, CADASTRA COMO CORRESPONDENCIA

            $res = (new Factory('endereco_cliente'))->where('endereco_cliente_cliente = ' . Session::client_node('uid') . ' AND endereco_cliente_tipo = 1')->get();

            if (!$res) {
                $_POST['endereco_cliente_tipo'] = '1';
            }

            $_POST['endereco_cliente_cliente'] = Session::client_node('uid');

            // Filter::pre($_POST);EXIT;
            (new Factory('endereco_cliente'))->with($_POST)->save();

            if (isset($_SESSION['cliente_frete_redirect']) && !empty($_SESSION['cliente_frete_redirect'])) {
                unset($_SESSION['cliente_frete_redirect']);
                Http::redirect_to('/checkout/?success');;
            }
            Http::redirect_to('/area-cliente/?success');
        }
    }

    public function removerEndereco()
    {
        $id = Req::post('id', 'int');
        if ($id > 0) {
            (new Factory('endereco_cliente'))->drop($id);
            echo '1';
        } else {
            echo '0';
        }
    }

    static public function notificar_boas_vindas($cliente_id = 4)
    {
        $cliente = (new Factory('cliente'))->find($cliente_id);
        $conf = (new Config)->get();
        $destinatario = $conf->config_site_email;
        $dados = [
            'cliente' => $cliente,
            'config' => $conf,
            'contato' => (new Config)->getContato(),
            'mapper' => ['config', 'cliente', 'contato'],
        ];
        $mensagem = Tpl::output('email.cliente-boas-vindas', $dados);
        $msg = [
            'assunto' => "Olá $cliente->cliente_nome, seja bem-vindo(a) à $conf->config_site_title!",
            'destinatario' => "$cliente->cliente_email",
            'copia' => ["$destinatario"],
            'mensagem' => $mensagem,
        ];
        Sender::mail($msg);
    }



    public function listaPedidos()
    {
        $cliente_id = intval(Session::client_node('uid'));

        if (isset($cliente_id) && !empty($cliente_id) && $cliente_id > 0) {
            (new Factory('pedido'))
                ->select("pedido_id, pedido_total_parcelado,
                    CASE pedido_status
                        WHEN 1 THEN 'Aguardando Pagamento'
                        WHEN 2 THEN 'Em análise'
                        WHEN 3 THEN 'Aprovado'
                        WHEN 4 THEN 'Disponível'
                        WHEN 5 THEN 'Em disputa'
                        WHEN 6 THEN 'Devolvido'
                        WHEN 7 THEN 'Cancelado'            
                    END AS pedido_status,
                    CASE pedido_status
                        WHEN 1 THEN 'warning'
                        WHEN 2 THEN 'info'
                        WHEN 3 THEN 'success'
                        WHEN 4 THEN 'success'
                        WHEN 5 THEN 'warning'
                        WHEN 6 THEN 'danger'
                        WHEN 7 THEN 'danger'            
                    END AS pedido_status_badge,
                    DATE_FORMAT(pedido_created, '%d/%m/%Y às %h:%i:%s') AS pedido_data,
                    lista_pedido_produto_titulo, lista_pedido_foto, pedido_endereco,pedido_entrega,pedido_codigo_rastreio, pedido_empresa_rastreio           
                ")
                ->join('cliente', 'cliente_id = pedido_cliente')
                ->join('lista_pedido', 'lista_pedido_pedido = pedido_id')
                ->where('pedido_cliente = ' . $cliente_id)
                ->order('pedido_id DESC')
                ->group_by('pedido_id')
                ->get(1);
        }
    }

    public function listarRetirada()
    {
        (new Factory('retirada'))
            ->get(1);
    }
}
