<?php

class CamposExtras
{

    public function __construct()
    {
        (new Install)->check_tabelas_principais();
    }


    public function indexAction()
    {
        $data = [
            'config' => (new Config)->get(),
            'mapper' => ['config']
        ];
        Tpl::view('admin.pedido.campos', $data, 1);
    }
    public function listar_produtos()
    {
        echo json_encode([
            'produtos' => (new Factory('produto'))
                ->select("produto_id, produto_titulo")
                ->get()
        ]);
    }

    public function listar_produtos_nao_vinculados()
    {
        $campo = Req::post('campo_checkout_id', 'int');

        if ($campo > 0) {
            echo json_encode([
                'produtos' => (new Factory('produto'))
                    ->select("produto_id, produto_titulo")
                    ->where("produto_id NOT IN (SELECT campo_checkout_produto_produto FROM campo_checkout_produto WHERE campo_checkout_produto_campo = $campo)")
                    ->group_by("produto_id")
                    ->get()
            ]);
        } else {
            echo json_encode(['error' => 'Campo não informado.']);
        }
    }

    public function listar_produtos_vinculados()
    {
        $campo = Req::post('campo_checkout_id', 'int');

        if ($campo > 0) {
            echo json_encode([
                'produtos' => (new Factory('produto'))
                    ->select("produto_id, produto_titulo")
                    ->where("produto_id IN (SELECT campo_checkout_produto_produto FROM campo_checkout_produto WHERE campo_checkout_produto_campo = $campo)")
                    ->group_by("produto_id")
                    ->get()
            ]);
        } else {
            echo json_encode(['error' => 'Campo não informado.']);
        }
    }

    public function listar_campos()
    {
        echo json_encode([
            'campos' => (new Factory('campo_checkout'))
                ->select("campo_checkout_id, campo_checkout_nome, (SELECT COUNT(*) FROM campo_checkout_produto WHERE campo_checkout_produto_campo = campo_checkout_id) AS campo_checkout_produtos_vinculados")
                ->get()
        ]);
    }

    public function gravar_campo()
    {

        $id_campo = Req::post('campo_checkout_id', 'int');
        $nome = Req::post('campo_checkout_nome', 'string');
        $produtos = Req::post('produtos');
        if (!empty($nome)) {
            $with = [
                'nome' => $nome
            ];

            if ($id_campo > 0) {
                $with['id'] = $id_campo;
                (new Factory('campo_checkout'))->with($with)->save();
            } else {
                $id_campo = (new Factory('campo_checkout'))->with($with)->save();
            }

            // Vincular produtos que vão ter esses campos
            if (is_array($produtos) && sizeof($produtos) > 0) {
                $db_campo_produto = new Factory('campo_checkout_produto');
                foreach ($produtos as $k) {
                    $db_campo_produto->with(['campo' => $id_campo, 'produto' => $k])->save();
                }
            }
            Http::redirect_to('/campos/?success');
        } else {
            Http::redirect_to('/campos/?error');
        }
    }

    public function remove_produto_atrelado()
    {
        $campo_id = Req::post('campo_id', 'int');
        $produto_id = Req::post('produto_id', 'int');

        if ($campo_id > 0 && $produto_id > 0) {
            (new Factory('campo_checkout_produto'))
                ->where("campo_checkout_produto_campo = $campo_id AND campo_checkout_produto_produto = $produto_id")
                ->drop();
            echo json_encode(['msg' => 'Vínculo removido com sucesso']);
        } else {
            echo json_encode(['error' => 'Valores inválidos']);
        }
    }

    public function remove_campo()
    {
        $campo_id = Req::post('campo_id', 'int');

        if ($campo_id > 0) {
            (new Factory('campo_checkout_produto'))
                ->where("campo_checkout_produto_campo = $campo_id")
                ->drop();
            (new Factory('campo_checkout'))
                ->drop($campo_id);
            echo json_encode(['msg' => 'Vínculo removido com sucesso']);
        } else {
            echo json_encode(['error' => 'Valores inválidos']);
        }
    }

    // FRONT

    // Percorre os produtos no carrinho pra pegar os campos extras que cada produto possúi
    public function get_campos_extras()
    {
        $cart = (new Carrinho)->getCarrinho(1);
        // Filter::pre($cart, 1);

        if (isset($cart['carrinho']) && !empty($cart['carrinho']) && is_array($cart['carrinho']) && sizeof($cart['carrinho']) > 0) {
            $cart = $cart['carrinho'];

            $produtos_id = [];

            foreach ($cart as $k) {
                $produtos_id[] = $k['produto']['produto_id'];
            }

            $produtos_id = implode(',', $produtos_id);
            $campos = (new Factory('campo_checkout'))
                ->select("campo_checkout_id, campo_checkout_nome")
                ->join("campo_checkout_produto", "campo_checkout_produto_campo = campo_checkout_id")
                ->where("campo_checkout_produto_produto IN ($produtos_id)")
                ->group_by("campo_checkout_id")
                ->get();
            echo json_encode(['status' => 200, 'campos' => $campos]);
        } else {
            echo json_encode(['status' => 404, 'campos' => []]);
        }
    }

    // metodo usado em visualizar o pedido
    public function lista_questionario() {
        $id = Req::post('pedido_id', 'int');

        if($id > 0) {
            $respostas = (new Factory('campo_checkout_respostas'))
                ->select("campo_checkout_respostas_pergunta, campo_checkout_respostas_resposta")
                ->where("campo_checkout_respostas_pedido_id = $id")
                ->get();
            if(isset($respostas[0])) {
                echo json_encode(['status' => 200, 'respostas' => $respostas]);    
            } else {
                echo json_encode(['status' => 404]);    
            }
        } else {
            echo json_encode(['status' => 401]);
        }
    }
}
