<?php
// Script para corrigir problemas de compatibilidade com PHP 8.1
$directory = __DIR__;

// Função para corrigir acessos de array sem aspas
function fixArrayAccess($content) {
    // Corrigir $_GET[key] para $_GET['key'] com verificação isset
    $patterns = [
        // Padrão: $_GET[key] == "value"
        '/\$_GET\[([a-zA-Z_][a-zA-Z0-9_]*)\](\s*==\s*["\'][^"\']+["\'])/' => 'isset($_GET[\'$1\']) && $_GET[\'$1\']$2',
        // Padrão: antiSQL($_GET[key])
        '/antiSQL\(\$_GET\[([a-zA-Z_][a-zA-Z0-9_]*)\]\)/' => 'isset($_GET[\'$1\']) && antiSQL($_GET[\'$1\'])',
        // Padrão geral: $_GET[key]
        '/\$_GET\[([a-zA-Z_][a-zA-Z0-9_]*)\]/' => '$_GET[\'$1\']',
        // Padrão: $_SESSION[key]
        '/\$_SESSION\[([a-zA-Z_][a-zA-Z0-9_]*)\]/' => '$_SESSION[\'$1\']',
        // Padrão: $_POST[key]
        '/\$_POST\[([a-zA-Z_][a-zA-Z0-9_]*)\]/' => '$_POST[\'$1\']',
        // Corrigir tags PHP curtas
        '/<\? /' => '<?php ',
        '/<\?([^p])/' => '<?php $1',
    ];
    
    foreach ($patterns as $pattern => $replacement) {
        $content = preg_replace($pattern, $replacement, $content);
    }
    
    return $content;
}

// Função para corrigir arquivo específico
function fixFile($filePath) {
    if (!file_exists($filePath)) {
        echo "Arquivo não encontrado: $filePath\n";
        return false;
    }
    
    $content = file_get_contents($filePath);
    $originalContent = $content;
    
    // Aplicar correções
    $content = fixArrayAccess($content);
    
    // Verificar se houve mudanças
    if ($content !== $originalContent) {
        if (file_put_contents($filePath, $content)) {
            echo "Arquivo corrigido: $filePath\n";
            return true;
        } else {
            echo "Erro ao escrever arquivo: $filePath\n";
            return false;
        }
    } else {
        echo "Nenhuma correção necessária: $filePath\n";
        return true;
    }
}

// Lista de arquivos para corrigir
$filesToFix = [
    'admin/includes/avisos.php',
    'admin/agenda.php',
    'admin/blog.php',
    'admin/configuracoes.php',
    'admin/equipe.php',
    'admin/fotos.php',
    'admin/index.php',
    'admin/login.php',
    'admin/missao.php',
    'admin/musicas.php',
    'admin/paginas.php',
    'admin/slider.php',
    'admin/usuarios.php',
    'admin/videos.php'
];

echo "Iniciando correções para compatibilidade com PHP 8.1...\n\n";

$successCount = 0;
$totalFiles = count($filesToFix);

foreach ($filesToFix as $file) {
    $fullPath = $directory . '/' . $file;
    if (fixFile($fullPath)) {
        $successCount++;
    }
}

echo "\n=== RESULTADO ===\n";
echo "Arquivos processados: $totalFiles\n";
echo "Sucessos: $successCount\n";
echo "Falhas: " . ($totalFiles - $successCount) . "\n";
echo "\nCorreções concluídas!\n";
?>