<?php

// Script para corrigir tags PHP curtas para compatibilidade com PHP 8.1
// Este script deve ser executado uma vez para migrar o código

function corrigir_tags_php($arquivo) {
    $conteudo = file_get_contents($arquivo);
    $conteudo_original = $conteudo;
    
    // Corrigir tags PHP curtas para tags completas
    // Não corrigir <?= (echo tags) pois essas continuam funcionando
    $conteudo = preg_replace('/^<\?\s+/', '<?php ', $conteudo);
    $conteudo = preg_replace('/^<\?\n/', "<?php\n", $conteudo);
    $conteudo = preg_replace('/\n<\?\s+/', "\n<?php ", $conteudo);
    
    // Salvar apenas se houve mudanças
    if ($conteudo !== $conteudo_original) {
        file_put_contents($arquivo, $conteudo);
        echo "Corrigido: $arquivo\n";
        return true;
    }
    
    return false;
}

// Função para percorrer diretórios recursivamente
function corrigir_diretorio($diretorio) {
    $arquivos_corrigidos = 0;
    $iterator = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($diretorio)
    );
    
    foreach ($iterator as $arquivo) {
        if ($arquivo->isFile() && $arquivo->getExtension() === 'php') {
            $path = $arquivo->getPathname();
            
            // Pular backups e arquivos específicos
            if (strpos($path, '_backup') !== false || 
                strpos($path, 'corrigir_php.php') !== false) {
                continue;
            }
            
            if (corrigir_tags_php($path)) {
                $arquivos_corrigidos++;
            }
        }
    }
    
    return $arquivos_corrigidos;
}

echo "Iniciando correção de tags PHP...\n";

// Corrigir pasta admin
$corrigidos_admin = corrigir_diretorio('e:/wamp64/www/kubonet/admin');
echo "Arquivos corrigidos na pasta admin: $corrigidos_admin\n";

// Corrigir pasta raiz (pular admin para não duplicar)
$corrigidos_raiz = 0;
$arquivos_raiz = glob('e:/wamp64/www/kubonet/*.php');
foreach ($arquivos_raiz as $arquivo) {
    if (corrigir_tags_php($arquivo)) {
        $corrigidos_raiz++;
    }
}
echo "Arquivos corrigidos na pasta raiz: $corrigidos_raiz\n";

// Corrigir pastas CSS
$corrigidos_css = corrigir_diretorio('e:/wamp64/www/kubonet/css');
echo "Arquivos corrigidos na pasta css: $corrigidos_css\n";

// Corrigir pastas includes
$corrigidos_includes = corrigir_diretorio('e:/wamp64/www/kubonet/includes');
echo "Arquivos corrigidos na pasta includes: $corrigidos_includes\n";

echo "\nCorreção completa!\n";
echo "Total de arquivos corrigidos: " . ($corrigidos_admin + $corrigidos_raiz + $corrigidos_css + $corrigidos_includes) . "\n";
?>