# Script para corrigir arrays indefinidos em arquivos PHP para compatibilidade com PHP 8.1
$adminPath = "e:\wamp64\www\kubonet\admin"

# Lista dos arquivos PHP principais do admin
$files = @(
    "agenda.php",
    "blog.php", 
    "fotos.php",
    "missao.php",
    "musicas.php",
    "parceiros.php",
    "portfolio.php",
    "slider.php",
    "videos.php",
    "usuarios.php",
    "planos.php"
)

foreach ($file in $files) {
    $filePath = Join-Path $adminPath $file
    if (Test-Path $filePath) {
        Write-Host "Processando: $file"
        
        # Ler o conteúdo do arquivo
        $content = Get-Content $filePath -Raw -Encoding UTF8
        
        # Aplicar correções comuns para arrays indefinidos
        $content = $content -replace '\$_GET\[''(\w+)''\]', '$_GET[''$1''] ?? '''''
        $content = $content -replace '\$_POST\[''(\w+)''\]', '$_POST[''$1''] ?? '''''
        $content = $content -replace 'antiSQL\(\$_GET\[''(\w+)''\] \?\? ''''\'\)', 'antiSQL($_GET[''$1''] ?? '''')'
        $content = $content -replace 'antiSQL\(\$_POST\[''(\w+)''\] \?\? ''''\'\)', 'antiSQL($_POST[''$1''] ?? '''')'
        
        # Salvar as alterações
        Set-Content $filePath $content -Encoding UTF8 -NoNewline
        Write-Host "✓ Corrigido: $file"
    } else {
        Write-Host "⚠ Arquivo não encontrado: $file"
    }
}

Write-Host "`nCorreções aplicadas com sucesso!"